<?php
/**
 * Piwik - Open source web analytics
 *
 * @link http://piwik.org
 * @license http://www.gnu.org/licenses/gpl-3.0.html Gpl v3 or later
 * @version $Id:$
 *
 * @package Piwik_CASLogin
 */

/**
 * Class that implements an authentication mechanism via CAS (Central Authentication Services)
 *
 * @package Piwik_CASLogin
 */
class Piwik_CASLogin_Auth implements Piwik_Auth
{
	protected $login = null;
	protected $token_auth = null;

	public function getName()
	{
		return 'CASLogin';
	}

	public function authenticate()
	{
		$user = '';
		$rootLogin = Zend_Registry::get('config')->superuser->login;

		$additionalSuperUsers = array();
		//$oAdditionalSuperUsers = Zend_Registry::get('config')->caslogin->additionalsuperusers;
		//if(is_object($oAdditionalSuperUsers)) {
		//	$additionalSuperUsers = $oAdditionalSuperUsers->toArray();
		//}

		// Commenté pour Envole : le include path /usr/share/php contient déjà un lien vers la libraire CAS
		//require_once PIWIK_INCLUDE_PATH . '/plugins/CASLogin/CAS/CAS.php';

		// initialize phpCAS
		// Chargement du cas eole
		require_once('CAS-1.3.1/eoleCAS.php');
		require_once('configCAS/cas.inc.php');

		// What happens here: in some piwik functionality, some additional API-style calls are
		// made from a controller action, where the authenticate() method will be called *again*.
		// This happens for instance when an admin changes some permissions in Settings->Users.
		// The first authenticate() is from the page, and the second is due to an API call.
		// This checks if there was already a phpcas instance already initialized, otherwize
		// eolephpCAS::client() would fail.
		global $PHPCAS_CLIENT;


		if (__CAS_DEBUG){
			EolephpCAS::setDebug('/var/log/posh/phpCAS-piwik.log');
		}

        /**
         * Hook permettant de lancer le cron sans passer par cas
         */
        if(!isset($_SERVER['REMOTE_ADDR']) OR $_SERVER['REMOTE_ADDR'] == $_SERVER['SERVER_ADDR'])
        {
            if(isset($_GET['token_auth'])){
                $this->setTokenAuth($_GET['token_auth']);
                return new Piwik_Auth_Result(Piwik_Auth_Result::SUCCESS_SUPERUSER_AUTH_CODE, 'admin', $this->token_auth);
            }

            return new Piwik_Auth_Result(Piwik_Auth_Result::SUCCESS, 'anonymous', NULL );
        }


		if(!is_object($PHPCAS_CLIENT)) {
			eolephpCAS::client(__CAS_VERSION, __CAS_SERVER, __CAS_PORT, '', false);

		}

		// no SSL validation for the CAS server
		eolephpCAS::setNoCasServerValidation();

		// Handle single signout requests from CAS server
		//eolephpCAS::handleLogoutRequests();
		eolephpCAS::EoleLogoutRequests(false);

		// force CAS authentication only if it has been requested by action argument
		$action = Piwik::getAction();

		$auth = eolephpCAS::checkAuthentication();
		if(!$auth) {
			if($action == 'redirectToCAS') {
				eolephpCAS::forceAuthentication();
			}

			if($action != 'login' && Piwik::getModule() != 'CoreUpdater') {
				Piwik::redirectToModule('CASLogin', 'login');
				return;
			} elseif($action == 'redirectToCAS') {
				eolephpCAS::forceAuthentication();
			} else {
				return new Piwik_Auth_Result( Piwik_Auth_Result::FAILURE, $user, NULL );
			}
		}

		// Additional Attributes
		// For future retrieval of attributes; they _might_ be of some use, but are highly
		// dependable on a specific installation. CAS|piwik hackers can do some magic
		// here with SAML attributes etc.
		/*
		foreach (eolephpCAS::getAttributes() as $key => $value) {
			// syslog(LOG_DEBUG, "attribute: $key - ". print_r($value, true));
		}
		 */
        $PHPCAS_CLIENT=new StdClass();
		$user_details = eolephpCAS::getDetails();

		$user_group=array();
		@$user_alias=$user_details['infos']['displayName'][0];
		@$typeadmin=$user_details['infos']['typeadmin'][0];
		@$user_group=$user_details['infos']['user_groups'];
		if(is_array($user_group)) {
			$fggroupadmin=in_array("administratifs",$user_group);
			$fggroupprofe=in_array("professeurs",$user_group);
		}

		if (isset($_SESSION['phpCAS']) && isset($_SESSION['phpCAS']['user'])) {
			$user = $_SESSION['phpCAS']['user'];
		}

		if($user) {
			if(is_array($user_group)) {
				$this->_populateDb($user,$fggroupadmin,$fggroupprofe);
				$login = $user;
            }
            $login = Zend_Registry::get('db')->fetchOne(
					'SELECT login FROM '.Piwik_Common::prefixTable('user').' WHERE login = ?',
					array($user)
			);

            $token = Zend_Registry::get('db')->fetchOne(
					'SELECT token_auth FROM '.Piwik_Common::prefixTable('user').' WHERE login = ?',
					array($user)
                );

			if($user == $rootLogin || in_array($user, $additionalSuperUsers)) {
				// Root / Admin login
				return new Piwik_Auth_Result(Piwik_Auth_Result::SUCCESS_SUPERUSER_AUTH_CODE, $user, $token);
			}

			if($login == $user)
			{
				return new Piwik_Auth_Result(Piwik_Auth_Result::SUCCESS, $login, $token);
			}
		}

		return new Piwik_Auth_Result( Piwik_Auth_Result::FAILURE, $user, NULL );
	}

	public function setLogin($login)
	{
		$this->login = $login;
	}

    public function setTokenAuth($token_auth)
	{
		$this->token_auth = $token_auth;
	}

	/**
	 * This method is used to inject user into Piwik's tables.
	 * @todo Alias could be the 'cn' returned from CAS attributes.
	 */
	private function _populateDb($user,$fggroupadmin,$fggroupprofe)
	{
		$result = null;
		$dummy = md5('abcd1234');
		$fgadduser = false;

		if ($this->_helper_userExists($user)) {
			$this->_helper_updateUser($user, $dummy, '', $user);
		} else {
			$this->_helper_addUser($user, $dummy, '', $user);
			$fgadduser=true;
		}

		// Rattachement de l'utilisateur au site
		if($user!='admin'&&($fggroupadmin||$fggroupprofe)) {
			$db = Zend_Registry::get('db');
			$count = Zend_Registry::get('db')->fetchOne("SELECT count(*) FROM ".Piwik_Common::prefixTable("access")." WHERE login = ? AND idsite=1", $user);
			if($count==0||$count==""||is_null($count)) {
				$db->insert( Piwik_Common::prefixTable("access"), array('login' => $user,'idsite' => 1,'access' => 'view'));
			}
		}

		if($fgadduser) {
			Piwik::redirectToModule('CASLogin', 'login');
			return;
		}
	}


	///// The following methods are taken from Piwik's UserManager, but in order to inject data into piwik's user and access tables, we need
	///// to make sure we don't wreck things. The UserManager API uses authenticate() to check if we're eligable to look this up,
	///// soi we can't use it - we need superuser permissions anyway.
	//
	///// Warning - these methods are of course under Piwik's license.
	private function _helper_userExists($name)
	{
		$count = Zend_Registry::get('db')->fetchOne("SELECT count(*)
									FROM ".Piwik_Common::prefixTable("user"). "
									WHERE login = ?", $name);
		return $count > 0;
	}

	private function _helper_updateUser( $userLogin, $password = false, $email = false, $alias = false )
	{
		$db = Zend_Registry::get('db');
		$db->update( Piwik_Common::prefixTable("user"),array('alias' => $alias),"login = '$userLogin'");
	}

	private function _helper_addUser( $userLogin, $password, $email, $alias = false )
	{

		$token_auth = Piwik_UsersManager_API::getTokenAuth($userLogin, $password);

		$db = Zend_Registry::get('db');

		$db->insert( Piwik_Common::prefixTable("user"), array(
									'login' => $userLogin,
									'password' => $password,
									'alias' => $alias,
									'email' => $email,
									'token_auth' => $token_auth,
									)
		);
	}

}

