<?php
/**
 * Piwik - Open source web analytics
 *
 * @link http://piwik.org
 * @license http://www.gnu.org/licenses/gpl-3.0.html GPL v3 or later
 *
 * @category Piwik_Plugins
 * @package Piwik_ExamplePlugin
 */

/**
 *
 * @package Piwik_ProfiledVisits
 */
class Piwik_ProfiledVisits_Controller extends Piwik_Controller
{
    /**
     * This method's output will be available through :
     * index.php?module=ProfiledVisits&action=index
     */
    public function index()
    {
        echo "hello world";
    }


    function getProfiledVisits()
    {
        $idSite = Piwik_Common::getRequestVar('idSite');
        $date = Piwik_Common::getRequestVar('date');
        $period = Piwik_Common::getRequestVar('period');
        
        $view = Piwik_ViewDataTable::factory('graphPie');
        
        $view->init($this->pluginName, __FUNCTION__, 'ProfiledVisits.getProfiledVisits');
                
        $view->setColumnsToDisplay(array('label','nb_visits'));
        $view->setColumnTranslation('label', 'Profil utilisateur');
        $view->disableRowEvolution();
        $view->disableSearchBox();
        $view->disableTagCloud();
        return $this->renderView($view);
        
    }

    function getApplisGlobal()
    {
        $idSite = Piwik_Common::getRequestVar('idSite');
        $date = Piwik_Common::getRequestVar('date');
        $period = Piwik_Common::getRequestVar('period');
        
        $view = Piwik_ViewDataTable::factory('graphPie');
        
        $view->init($this->pluginName, __FUNCTION__, 'ProfiledVisits.getApplisGlobal');
                
        $view->setColumnsToDisplay(array('label','nb_visits'));
        $view->setColumnTranslation('label', 'Applications');
        $view->disableRowEvolution();
        $view->disableSearchBox();
        $view->setLimit(20);
        $view->setReportTitle('Applications les plus utilisées');
        $view->disableTagCloud();
        $view->setExcludeLowPopulation('nb_visits',1);
        $view->addRelatedReport('ProfiledVisits', 'getApplisEleves', 'Applications utilisées par les élèves');
        $view->addRelatedReport('ProfiledVisits', 'getApplisProfesseurs', 'Applications utilisées par les enseignants');
        return $this->renderView($view);
    }

    function getApplisEleves()
    {
        $idSite = Piwik_Common::getRequestVar('idSite');
        $date = Piwik_Common::getRequestVar('date');
        $period = Piwik_Common::getRequestVar('period');
        
        $view = Piwik_ViewDataTable::factory('graphPie');
        
        $view->init($this->pluginName, __FUNCTION__, 'ProfiledVisits.getApplisEleves');
                
        $view->setColumnsToDisplay(array('label','nb_visits'));
        $view->setColumnTranslation('label', 'Applications utilisées par les élèves');
        $view->disableRowEvolution();
        $view->disableSearchBox();
        $view->setExcludeLowPopulation('nb_visits',1);
        $view->setReportTitle('Applications utilisées par les élèves');
        $view->setLimit(10);
        $view->disableTagCloud();
        return $this->renderView($view);
    }

    function getApplisProfesseurs()
        {
        $idSite = Piwik_Common::getRequestVar('idSite');
        $date = Piwik_Common::getRequestVar('date');
        $period = Piwik_Common::getRequestVar('period');
        
        $view = Piwik_ViewDataTable::factory('graphPie');
        
        $view->init($this->pluginName, __FUNCTION__, 'ProfiledVisits.getApplisProfesseurs');
                
        $view->setColumnsToDisplay(array('label','nb_visits'));
        $view->setColumnTranslation('label', 'Applications utilisées par les professeurs');
        $view->disableRowEvolution();
        $view->disableSearchBox();
        $view->setExcludeLowPopulation('nb_visits',1);
        $view->setReportTitle('Applications utilisées par les professeurs');
        $view->setLimit(10);
        $view->disableTagCloud();
        return $this->renderView($view);
    }
}