<?php
namespace Piwik\Plugins\ServerStats\Reports;

use Piwik\Piwik;
use Piwik\Plugin\Report;
use Piwik\Plugin\ViewDataTable;
use Piwik\Plugins\Actions\Columns\ExitPageUrl;
use Piwik\Report\ReportWidgetFactory;
use Piwik\Widget\WidgetsList;
use Piwik\View;

class GetTypeEtab extends Base
{
    protected function init()
    {
        parent::init();

        $this->name             = Piwik::translate('ServerStats_TypeEtab');
        $this->dimension        = null;
        $this->documentation    = Piwik::translate('');
        $this->order            = 1;
        $this->metrics          = array('nb_etabs');
        $this->widgetTitle      = 'Type d\'établissement';
    }

    public function configureWidgets(WidgetsList $widgetsList, ReportWidgetFactory $factory)
    {
        $widget = $factory->createWidget();
        $widgetsList->addWidgetConfig($widget);
    } 
        
    public function configureView(ViewDataTable $view)
    {
        $view->config->addTranslations(array('label' => 'Type d\'établissement', 'nb_etabs' => 'Nombre'));
        $view->config->columns_to_display = array_merge(array('label'), $this->metrics);
    }

    public function getRelatedReports()
    {
         return array();
    }
}
