<?php
namespace Piwik\Plugins\LoginCas;

use Piwik\AuthResult;
use Piwik\Common;
use Piwik\Db;
use Piwik\Piwik;
use Piwik\Plugins\UsersManager\API as userManager;
use Piwik\Session;
use Piwik\Plugins\UsersManager\Model;
use Piwik\Plugins\UsersManager\UserAccessFilter;
use Piwik\Access;
use Piwik\Auth\Password;

class Auth implements \Piwik\Auth
{
	protected $login = null;
	protected $token_auth = null;
	private static $phpcas_client_called = false;

	public function getName()
	{
		return 'LoginCas';
	}

	public function authenticate()
	{
        // No CAS for API Module
		if(Piwik::getModule() =="API") {
            $user=$this->getLogin();
			$code = AuthResult::SUCCESS_SUPERUSER_AUTH_CODE;
			return new AuthResult($code, $user, NULL );
		}

		// Make sure Piwik session is started.
		Session::start();

		// Initialize phpCAS
		require_once('CAS-1.3.1/eoleCAS.php');
		require_once('configCAS/cas.inc.php');

        if (__CAS_DEBUG) {
           \EolephpCAS::setDebug('/var/log/phpcas/phpcas-piwik.log');
        }       

		if (!self::$phpcas_client_called) {
			\eolephpCAS::client(__CAS_VERSION, __CAS_SERVER, __CAS_PORT, __CAS_FOLDER, false);
		}

		\eolephpCAS::setNoCasServerValidation();
		\eolephpCAS::EoleLogoutRequests(false);

		$auth = \eolephpCAS::checkAuthentication();
		if(!$auth) {
			\eolephpCAS::forceAuthentication();
		}

        $login = \eolephpCAS::getUser();
		$details = \eolephpCAS::getDetails();
        if(!isset($details["infos"])&&isset($details["attributes"])) $details["infos"]=$details["attributes"];

		$groups=array();
		@$groups=$details['infos']['user_groups'];
		if(is_array($groups)) {
			$fggroupadmin=in_array("administratifs",$groups);
			$fggroupprofe=in_array("professeurs",$groups);
		}

        $db_user = Db::fetchRow('SELECT login, superuser_access FROM '.Common::prefixTable('user').' WHERE login = ?', array($login));
        if($fggroupadmin||$db_user['superuser_access']||$login=="admin") $issuperuser = true;
        else if($fggroupprofe) $issuperuser=true;

        if($issuperuser||$isuser) {
            $this->setLogin($login);
            $code = ($issuperuser?AuthResult::SUCCESS_SUPERUSER_AUTH_CODE:AuthResult::SUCCESS);
            return new AuthResult($code, $login, NULL);
        }

		return new AuthResult( AuthResult::FAILURE, $login, NULL );
	}

	public function setLogin($login)
	{
		$this->login = $login;
	}
    public function getLogin() {
		Session::start();
        if (isset($_SESSION['phpCAS']) && isset($_SESSION['phpCAS']['user']))
            return $_SESSION['phpCAS']['user'];
        else
            return false;
    }

    public function setTokenAuth($token_auth)
	{
		$this->token_auth = $token_auth;
	}
    public function getTokenAuthSecret() {
        return $this->token_auth;
    }

    public function setPassword($password) {}
    public function setPasswordHash($passwordHash) {}
}

