function $(v_s) {
    return document.getElementById(v_s);
}

$p={
	changeId: function(v_id,v_newId)
	{
		var l_obj = $(v_id);
		if (l_obj)
            l_obj.id = v_newId;
	},
	img: function(v_file,v_w,v_h,v_alt,v_cl,v_id,v_style)
	{
		if (v_file == '-') return '';
		//if (v_file == indef || v_file == '') v_file='s.gif';
		var l_width = v_w ? ' width="'+v_w+'"'
                          : '';
		var l_height = v_h ? ' height="'+v_h+'"'
                           : '';
		if (v_alt==indef) v_alt = '';
		if (v_cl==indef) v_cl = '.';
		if (v_id==indef)
        {
            v_id = '';
        }
        else {
            v_id = ' id="'+v_id+'"';
        }

		if (v_file == indef || v_file == '')
		{
				var l_s = '<div'
					+ l_width
					+ l_height
					+ ' class="'
					+ v_cl+'"'
					+ ' style="width: '+v_w+'px;height: '+v_h+'px;display: inline;padding: 0 '+v_w+'px '+v_h+'px 0;margin: 0px;font-size: 0px;"'
					+ v_id+'></div>';

				return l_s;
		}
		else
		{
			//if (v_file.substr(0,4)!='http'  || v_file.substr(0,2)!='..')
		    if ( !v_file.match(/^(http|\.\.)/)) 
			{
				v_file = pfolder+'../images/'+v_file;
			}
					
			return '<img src="'
					+ v_file
					+ '" alt="'+$p.string.removeCot(v_alt)+'"'
					+ l_width
					+ l_height
					+ ' class="'
					+ v_cl+'"' 
					+ ' style="'+v_style+'"'
					+ v_id+' />';
		}
	},
	get: function(v_id)
    {
        return $(v_id);
    },
	print: function(v_id,v_s,v_add)
	{
		var l_obj = $(v_id);
		if (v_add != indef && v_add == "bottom")
            v_s = l_obj.innerHTML + v_s;
		if (v_add != indef && v_add == "top")
            v_s = v_s + l_obj.innerHTML;
		if (l_obj != null)
		{
			l_obj.empty();
			l_obj.set('html',v_s);
		}
	},
	getPos: function(v_node,v_ref,v_parentRef)
	{
		var l_ret = 0;
		while(v_node != null && (v_parentRef == indef || v_node != v_parentRef))
		{
			l_ret += v_node["offset"+v_ref];
			v_node = v_node.offsetParent;
		}
		return l_ret;
	},
	show: function(v_id,v_disp)
	{
		var l_obj = $(v_id);
		if (l_obj != null)
		{
			//exceptions
			if (v_disp == 'table-cell' && $p.navigator.IE)
                v_disp = 'block';
	
			l_obj.style.display = v_disp;
		}
	},
	isShown: function(v_id)
	{
		var l_obj = $(v_id);
		if (l_obj)
		{
			return (l_obj.style.display == 'block' ? true : false);
		}
		else return false;
	},
	min: function(v1,v2)
	{
		return Math.min(v1,v2);
	},
	max: function(v1,v2)
	{
		return Math.max(v1,v2);
	},
	setHeight: function(v_id,v_h)
	{
		var l_obj = $(v_id);
		if (l_obj != null)
			l_obj.setStyle("height",v_h+"px");
	},
	setWidth: function(v_id,v_w)
	{
		var l_obj = $(v_id);
		if (l_obj != null)
			l_obj.setStyle('width',v_w+"px");
	},
	setClass: function(v_id,v_class)
	{
		var l_obj = $(v_id);
		if (l_obj)
            l_obj.className = v_class;
	}
}
$p.array={
	find:function(v_arr,v_searched)
	{
		for (var i=0;i<v_arr.length;i++)
		{
			if (v_arr[i]==v_searched) return true;
		}
		return false;
	}	
}
$p.string={
	removeTags:function(v_s)
	{
		return v_s.replace(/<\/?[^>]+(>|$)/g, "");
	},
	correctEncoding:function(v_s)
	{
		var l_s=v_s.replace(/\&amp;/g,"&");
		l_s=l_s.replace(/\&#38;/g,"&");
		l_s=l_s.replace(/\&#39;/g,"'");
		l_s=l_s.replace(/\&quot;/g,"'");
		l_s=l_s.replace(/\&apos;/g,"'");
		return l_s;
	},
	escapeAndSign: function(v_s)
	{
		return v_s.replace(/\&/g,'&amp;');
	},
	trim: function(v_s)
	{
		if (v_s == indef) v_s = '';
		return v_s.replace(/^[\t\s\n\r]+/g,'').replace(/[\t\s\n\r]+$/g,'');
	},
    removeEOL: function (v_s) {
        return v_s.replace(/[\n\r]+/g,' ');
    },
	esc: function(v_s)
	{
		return window.encodeURIComponent ? encodeURIComponent(v_s) : escape(v_s);
	},
	unesc: function(v_s)
	{
		return window.decodeURIComponent ? decodeURIComponent(unescape(v_s).replace(/%/g,'%25')) : unescape(v_s);
	},
	uc:function(v_s)
	{
		return v_s.toUpperCase();
	},
	lc:function(v_s){
		return v_s.toLowerCase();
	},
	formatForSearch: function(v_s)
	{
		v_s=$p.string.lc(v_s);
		v_s=v_s.trim();
		v_s=$p.string.removeAccents(v_s);
		v_s=v_s.replace(/\+/gi,",");
		v_s=v_s.replace(/;/gi,",");
		v_s=v_s.replace(/"/gi," ");
		v_s=v_s.replace(/\./gi," ");
		v_s=v_s.replace(/'/gi," ");
		v_s=v_s.replace(/, /gi,",");
		v_s=v_s.replace(/  /gi," ");
		return v_s;
	},
	removeAccents:function(v_s)
	{
		v_s=v_s.replace(/[àâä]/gi,"a");
		v_s=v_s.replace(/[éèêë]/gi,"e");
		v_s=v_s.replace(/[îï]/gi,"i");
		v_s=v_s.replace(/[ôö]/gi,"o");
		v_s=v_s.replace(/[ùûü]/gi,"u");
		v_s=v_s.replace(/[ç]/gi,"c");
		return v_s;
	},
	removeCot:function(v_s,v_coteType)
	{
		if (v_coteType==indef) v_coteType='both';
		if (v_coteType=='simple' || v_coteType=='both') v_s = v_s.replace(/'/g,"");
		if (v_coteType=='double' || v_coteType=='both') v_s = v_s.replace(/"/g,"");
		return v_s;
	},
	doubleToSimpleCot:function(v_s)
	{
		return v_s.replace(/"/g,"'");
	},
    replaceSpleQuot: function (v_s)
	{
        return v_s.replace(/'/g,"&#39");
    },
	replaceAmpersand: function (v_s)
	{
		return v_s.replace(/&/g,"%26");
    },
    replacePlus: function (v_s)
	{
        return v_s.replace(/\+/g,"%2B");
    },
    replaceEqual: function (v_s)
	{
        return v_s.replace(/\=/g,"%3D");
    },
    SimpleEncoding: function (v_s) {
        v_s = $p.string.replaceAmpersand(v_s);
        v_s = $p.string.replacePlus(v_s);
        v_s = $p.string.replaceEqual(v_s);
        return v_s;
    },
	trunk:function(v_s,v_length,v_rangeForPoint,v_functionForMore)
	{
		var l_s=v_s.substr(0,v_length);

		if (v_rangeForPoint!=indef)
		{
			var endPos = (l_s.indexOf('.',(v_length-v_rangeForPoint))) + 1; //get position of (.) starting from maxLength
			if (endPos!="") l_s=l_s.substr(0,endPos); //use shorter description
		}

		if (v_s.length>v_length)
		{
			l_s=l_s
				+(v_functionForMore==indef
					? ' ...'
					: ' <a href="#" onclick=\''+v_functionForMore+'\'>'+lg('readMore')+'...</a>'
				);
		}
		return l_s;
	},
	getVar:function(v_s,v_var,datatype)
	{
        var l_ret="";
        if (datatype && datatype=='int') {
            l_ret=0;
        }
        if ( typeof(v_s) =='object') {
            return '';
        }
		var reg = new RegExp("&(?!amp;)", "g");
        var l_items=v_s.split(reg);
        for (var i=0;i<l_items.length;i++)
        {
           // var l_arr=l_items[i].split("=");
			var l_arr0 = l_items[i].substr(0,l_items[i].indexOf("="));
			var l_arr1 = l_items[i].substr(l_items[i].indexOf("=")+1,l_items[i].length);
            if (l_arr0==v_var) {
				if (__ENCRYPT_USERPREF) {
					l_arr1 = decodeURIComponent(l_arr1.replace(/\+/g, '%20'))
				}
                l_ret=$p.string.unesc(l_arr1);
            }
        }
        return l_ret;
	},
	supVar:function(v_s,v_var)
	{
        if ( typeof(v_s) =='object') {
            return '';
        }    
		var l_items=v_s.split("&");
		for (var i=0;i<l_items.length;i++)
		{
			var l_arr=l_items[i].split("=");
			if (l_arr[0]==v_var) {
				l_items.splice(i,1);
			}
		}
		return l_items.join("&");
	},
	htmlToText:function(v_s)
	{
		v_s=v_s.replace(/\&amp;/g,"&").replace(/\&lt;/g,"<").replace(/&gt;/g,">").replace(/\&nbsp;/g," ").replace(/<BR>/g,"\r\n").replace(/<br>/g,"\r\n").replace(/<BR \/>/g,"\r\n").replace(/<br \/>/g,"\r\n");
		return v_s;
	}
}
$p.navigator={
	IE:(document.all)?1:0,
	SAF:navigator.userAgent.indexOf("Safari")>=0,
	NS:navigator.userAgent.indexOf('Netscape')>0,
	OP:navigator.userAgent.indexOf('Opera')>0,
	FF:navigator.userAgent.indexOf('Firefox')>0,
}


$p.app = {

    wait:function(v_id)
	{
		if ($(v_id) != null)
			($(v_id)).set('html',$p.img("ico_waiting.gif",16,16));
	}
    
}

//===============================================================================================================
//					OTHER OBJECTS MANAGEMENT
//===============================================================================================================

//Old functions (compatibility
function _gel(v_id) {return $p.get(v_id);}
function navPrint(v_id,v_s,v_add){$p.print(v_id,v_s,v_add);}
function getPos(v_node,v_ref){return $p.getPos(v_node,v_ref);}
function _trim(v_s){return $p.string.trim(v_s);}
function inArray(v_arr,v_searched){return $p.array.find(v_arr,v_searched);}
function MyMooToolsDebug(){}
function _gelstn(v_t){return $$(v_t);}
function navClass(v_id,v_class){return $p.setClass(v_id,v_class);}
function navShow(v_id,v_disp){return $p.show(v_id,v_disp);}
function navIsShown(v_id){return $p.isShown(v_id);}
function navWait(v_id){return $p.app.wait(v_id);}
function _esc(v_s){return $p.string.esc(v_s);}
function _unesc(v_s){return $p.string.unesc(v_s);}
function _uc(v_s){return $p.string.uc(v_s);}
function _lc(v_s){return $p.string.lc(v_s);}
function _min(v1,v2){return $p.min(v1,v2);}
function _max(v1,v2){return $p.max(v1,v2);}
function navId(v_id,v_newId){return $p.changeId(v_id,v_newId);}
function navHeight(v_id,v_h){return $p.setHeight(v_id,v_h);}
function navWidth(v_id,v_w){return $p.setWidth(v_id,v_w);}
function img(v_file,v_w,v_h,v_alt,v_cl,v_id){return $p.img(v_file,v_w,v_h,v_alt,v_cl,v_id);}
function p_img(v_file,v_w,v_h,v_alt,v_cl,v_id){return;}
var p_nav={IE:$p.navigator.IE,noinclusion:function(){return $p.navigator.noinclusion();},changeTitle:function(v_title){return $p.navigator.changeTitle(v_title);}}
var p_popup={show:function(v_content,v_width,v_height,v_title,v_closeBtn){return $p.app.popup.show(v_content,v_width,v_height,v_title,v_closeBtn);}}
function formatSearch(v_s){return $p.string.formatForSearch(v_s);}
function getVar(v_s,v_var){return $p.string.getVar(v_s,v_var);}
function correctCharEncoding(v_s){return $p.string.correctEncoding(v_s);}
function removeTags(v_s){return $p.string.removeTags(v_s);}
function _hesc(v_s){return $p.string.htmlToText(v_s);}