<?php
$folder="";
$not_access=0;
$isScript=false;
$isPortal=false;
$pagename="portal/mod_password.php";

/**
 * Procédure de changement de mot de passe
 */
function changePWD($passwd_old,$passwd_new,$passwd_confirm)
    {
    global $success;

    if($passwd_old=='' || $passwd_new=='') $output = "Des champs sont restés vides.<br/>Opération abandonnée.";
    elseif($passwd_new!=$passwd_confirm) $output = "Les nouveaux mots de passes sont différents.<br/>Opération abandonnée.";
    elseif(strlen($passwd_new) < __SMB_MIN_PASSWORD_LENGTH) $output = "Votre mot de passe doit comporter au moins ".__SMB_MIN_PASSWORD_LENGTH." caractères.<br/>Opération abandonnée.";
    else
        {
        include('libs/ldap.php');
        include('libs/ldappasswd.php');
        require_once('configCAS/ldap.inc.php');

        $config = array
            (
            'host' => __LDAP_HOST,
            'port' => __LDAP_PORT,
            //'basedn' => __LDAP_PEOPLE_OU . ',' . __LDAP_BASE_DN_EXTENSION . ',' . __LDAP_BASE_DN,
            'basedn' => __LDAP_BASE_DN,
            'branches' => array(__LDAP_ELEVE_BRANCHE, __LDAP_PERS_BRANCHE, __LDAP_RESP_BRANCHE)
            );

        $connexion_ldap = new LDAP($config);

        //authenfication
        if($connexion_ldap->authentification(LOGIN,stripslashes($passwd_old)))
            {
            //recupere le DN de l'utilisateur connecte
            $dnuser = $connexion_ldap->donneDN();

            //creation du chiffrage
            mt_srand( (double) microtime() * 1000000 );
            $salt = mhash_keygen_s2k( MHASH_SHA1, $passwd_new, substr( pack( "h*", md5( mt_rand() ) ), 0, 8 ), 4 );
            $new_value = "{SSHA}".base64_encode( mhash( MHASH_SHA1, $passwd_new.$salt ).$salt );

            //modification de son userPassword
            $modif['userPassword'] = $new_value;

            $passHash = new smbHash();

            //modification de son sambaLMPassword
            $modif['sambaLMPassword'] = $passHash->lmhash($passwd_new);

            //modification de son sambaNTPassword
            $modif['sambaNTPassword'] = $passHash->nthash($passwd_new);

            if($connexion_ldap->modifierDonneesUtilisateur($dnuser,$modif,LOGIN,stripslashes($passwd_old)))
                {
                $output = "Votre mot de passe a été modifié avec succès.";
                $success = true;
                }
            else $output = "La modification de votre mot de passe a échoué.<br/>Opération abandonnée.";
            }
        else $output = "L'authentification avec votre ancien mot de passe a échoué.<br/>Opération abandonnée.";
        }
    return $output;
    }

/**
 * Récupération du login utilisateur
 */
include_once('includes.php');
define("LOGIN",$_SESSION['username']);

/**
 * Traitement
 */
if(isset($_POST["passwd_old"]) && isset($_POST["passwd_new"]) && isset($_POST["passwd_confirm"]))
    {
    $success = false;
    $output = changePWD($_POST["passwd_old"],$_POST["passwd_new"],$_POST["passwd_confirm"]);
    $head = '
    <style type="text/css">
        div#d_pwd {text-align: center;}
        .rouge {color:red;}
        .vert {color:green;}
    </style>
    ';
    $body = '<div id="d_pwd" class="'.($success ? "vert" : "rouge").'">';
    $body .= '<p>'.$output.'</p>';
    if(!$success) $body .= '<p><input type="button" value="Réessayer" onclick="window.location.href=\''.$_SERVER["PHP_SELF"].'\'"/></p>';
    $body .= '</div>';
    }
else
    {
    $head = '
    <style type="text/css">
        div#d_pwd {text-align: left;}
        div#d_pwd table td {font-size: 12.8px; font-weight: normal; padding: 5px;}
        .rouge {color:red;}
        .vert {color:green;}
    </style>
    <script language="javascript" type="text/javascript">
        function verifForm(form)
            {
            var test1 = verif("old");
            var test2 = verif("new");
            var test3 = test2 ? verifPwds() : false;

            if(test1 && test2 && test3) form.submit();
            else alert("Le formulaire est invalide.\nVeuillez corriger les problèmes avant de l\'envoyer à nouveau.");
            return false;
            }

        function verif(type)
            {
            var pwd = document.getElementById("passwd_"+type).value;
            var message = document.getElementById("message_"+type);
            if(pwd=="")
                {
                message.className = "rouge";
                message.innerHTML = "Vide";
                return false;
                }
            else
                {
                message.className = "vert";
                message.innerHTML = "OK";
                return true;
                }
            }

        function verifPwds()
            {
            var new_pwd = document.getElementById("passwd_new").value;
            var confirm_pwd = document.getElementById("passwd_confirm").value;
            var message = document.getElementById("message_confirm");
            if(confirm_pwd=="")
                {
                message.className = "rouge";
                message.innerHTML = "Vide";
                return false;
                }
            else if(new_pwd!=confirm_pwd)
                {
                message.className = "rouge";
                message.innerHTML = "Mots de passe différents";
                return false;
                }
            else
                {
                message.className = "vert";
                message.innerHTML = "Mots de passe identiques";
                return true;
                }
            }

        window.onload = function()
            {
            var old_pwd = document.getElementById("passwd_old");
            old_pwd.value = "";
            var new_pwd = document.getElementById("passwd_new");
            var confirm_pwd = document.getElementById("passwd_confirm");
            old_pwd.onkeyup = function() {verif("old");};
            new_pwd.onkeyup = function() {verif("new");};
            confirm_pwd.onkeyup = verifPwds;
            }
    </script>
    ';
    $body = '
        <div id="d_pwd">
        <form name="changepass" onsubmit="return verifForm(this);" method="post" action="">
        <table>
        <tr>
        <td>Mot de passe actuel :</td>
        <td><input type="password" size="25" name="passwd_old" id="passwd_old" tabindex="1" /></td>
        <td><div id="message_old">&nbsp;</div></td>
        </tr>
        <tr>
        <td>Nouveau mot de passe :</td>
        <td><input type="password" size="25"  autocomplete="off" name="passwd_new" id="passwd_new" tabindex="2" /></td>
        <td><div id="message_new">&nbsp;</div></td>
        </tr>
        <tr>
        <td>Confirmer le mot de passe :</td>
        <td><input type="password" size="25" autocomplete="off" name="passwd_confirm" id="passwd_confirm" tabindex="3" /></td>
        <td><div id="message_confirm">&nbsp;</div></td>
        </tr>
        <tr>
        <td colspan="2" style="text-align: center;"><input type="submit" value="Changer de mot de passe" tabindex="4" /></td>
        <td></td>
        </tr>
        </table>
        </form>
        </div>
    ';
    }

/**
 * Affichage
 */
?>
<!DOCTYPE html PUBLIC "-//W3C//DTD XHTML 1.0 Strict//EN" "http://www.w3.org/TR/xhtml1/DTD/xhtml1-strict.dtd">
<html xmlns="http://www.w3.org/1999/xhtml" xml:lang="fr" lang="fr">
<head>
    <title>Changement de mot de passe</title>
    <meta http-equiv="Content-Type" content="text/html; charset=utf-8" />
    <meta http-equiv="Content-Language" content="fr" />
    <link rel="stylesheet" type="text/css" href="../../../styles/main.css?v=1.0.0" />
    <?php echo $head; ?>
</head>
<body>
    <?php echo $body; ?>
</body>
</html>
