<?php
# ******************************************* LICENCE******************************************* 
/*
	Copyright (c) PORTANEO.

	This file is part of POSH (Portaneo Open Source Homepage) http://sourceforge.net/projects/posh/.

	POSH is free software: you can redistribute it and/or modify
	it under the terms of the GNU General Public License as published by
	the Free Software Foundation, either version 3 of the License, or
	(at your option) any later version

	POSH is distributed in the hope that it will be useful,
	but WITHOUT ANY WARRANTY; without even the implied warranty of
	MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
	GNU General Public License for more details.

	You should have received a copy of the GNU General Public License
	along with Posh.  If not, see <http://www.gnu.org/licenses/>.
*/
# ********************************************************************************** 
# POSH Users management - Apply user modifications
#
# !! be careful, this file must be saved under uft8 format, and display an e accentuated here : é
# ********************************************************************************** 
require_once('../includes/mail.inc.php');
require_once('../includes/refreshcache.inc.php');
require_once('../l10n/'.__LANG.'/admin.lang.php');
require_once('../includes/xml.inc.php');
require_once('../includes/admin_tools.php');
require_once('../includes/log.inc.php');
require_once('../includes/misc.inc.php');
$file=new xmlFile();

$file->header("usermod_add");

launch_hook('admin_scr_rootdirectory_modify');

if (!isset($userid)) {
    $userid=isset($_POST["user"]) ? $_POST["user"] : 0 ;
}
if ( isset( $_POST["username"] ) ) {
    $user       = $_POST["username"];
}
if ( isset( $_POST["email"] ) ) {
    $email       = $_POST["email"];
}
if (  isset($_POST["pass"])) {
    $password   = $_POST["pass"];
}
if (isset($_POST["long_name"])) {
    $long_name = $_POST["long_name"];
}
$force_user_change_password = 0;
if( isset($_POST["forcechgpass"]) ) {
	if($_POST["forcechgpass"]=="true") {
		$force_user_change_password = 1;
	}
}


// check username
if ( preg_match('/'.$user.'/',$password) && __CONNECTION_SECURITY_LEVEL>=2 ){
    $errormsg=lg("msgLoginInPass");
	echo "<error><![CDATA[".$errormsg."]]></error>";
    $file->status(0);
    $file->footer();
    exit();
}
// check long name
if ( preg_match('/'.$long_name.'/',$password) && __CONNECTION_SECURITY_LEVEL>=2 ){
    $errormsg=lg("msgNameInPass");
    echo "<error><![CDATA[".$errormsg."]]></error>";
    $file->status(0);
    $file->footer();
    exit();
}
// check email
if ( preg_match('/'.$email.'/',$password) && __CONNECTION_SECURITY_LEVEL>=2 ){
    $errormsg=lg("msgUsrInPass");
    echo "<error><![CDATA[".$errormsg."]]></error>";
    $file->status(0);
    $file->footer();
    exit();
}
$errormsg = isMixPassword($password);
if( !empty($errormsg) ) {
	$file->status(0);
	echo "<error><![CDATA[".$errormsg."]]></error>";
	$file->footer();
	exit();
}

$key        = md5($user.$password);
$nbSpecificFields = 0;

if (isset($_POST["nbSpecificFields"]))	{ 
    $nbSpecificFields=$_POST["nbSpecificFields"]; 
}

$userType = $_POST["usertype"];
$userActive = (isset($_POST['active']) ? $_POST['active'] : '1');
if ($userActive == '0')
    $userType = ($userType == 'A' ? 'B' : 'J');

$expiration_date = $_POST['expdate'];
if ($expiration_date == '') $expiration_date = 0;
if ($expiration_date != 0)
{
	$month = substr($expiration_date,0,2);
	$day = substr($expiration_date,3,2);
	$year = substr($expiration_date,6,4);
	$expiration_date = mktime(0,0,0,$month,$day,$year);
}

// userid=0 => new user
if ($userid == 0)
{
	//control that the account does not already exists
	$DB->getResults($users_controlExistingAccount,$DB->noHTML($user));
	$row = $DB->fetch(0);
	if ($row['nb']>0)   {
        $errormsg=lg("alreadyMember");
		$file->error($errormsg);
        $file->status(0);
        $file->footer();
        exit();
	}

	//add the new user
	$DB->execute($users_addNew2,$DB->quote($user),
								$DB->quote($email),
								$DB->quote($_POST["long_name"]),
                                $DB->quote($userType),
								$expiration_date,
                                $DB->quote($password),
                                $DB->quote($key),
                                $DB->quote($_POST["lang"]),
								$DB->escape($force_user_change_password)
								);
	// new user_id
	$userid = $DB->getId();
	// save user password in history table
	$DB->execute($scr_insertPortalPass,
							$DB->escape($userid),
							$DB->quote($password));
	//add to log
	$DB->execute($users_logUserAdd,$userid);
	
	$userArr = array();
	$userArr['id'] = $userid;
	$userArr['password'] = $password;
	launch_hook('admin_create_user_after_creation',$userArr);
	
	//specific criterias for the user
	if ($nbSpecificFields != 0)   {
		for ($i = 1;$i <= $nbSpecificFields;$i++)
		{
			$parameters = "";
			$id = $_POST["uniq_id".$i];
			if (isset($_POST["userinfo".$i]))   {
                if (is_array($_POST["userinfo".$i]))    {
                    if(count($_POST["userinfo".$i]) == 1 && preg_match('/;/',$_POST["userinfo".$i][0])) {
                        $parameters = str_replace(";", ",", $_POST["userinfo".$i][0]);
                    }
                    else {
                        for ($j = 0;$j < count($_POST["userinfo".$i]);$j++)
                        {	
                            if ($j == 0)	$parameters = $_POST["userinfo".$i][$j];
                            else	$parameters .= ",".$_POST["userinfo".$i][$j];
                        }	
                    }
                }	
                else    {
                    if ($_POST["userinfo".$i]!="")	$parameters=$_POST["userinfo".$i];
                }
			}					
			//sql query to add	
			$DB->execute($users_addUserInfos,$DB->escape($userid),$DB->escape($id),$DB->quote($parameters));
		}
	}
	
	
	//add the defaults public pages in profile table  
	//see includes/users_tools.php and function addPageToNewUser
			
	//group pages
	$cpt = 0;	
	$groupArr = array();
	array_push($groupArr,0);
	
	while (isset($_POST["group".$cpt]))
	{
		$groupId = $_POST["group".$cpt];
		// add selected group
		if (!in_array($_POST["group".$cpt], $groupArr))
			array_push($groupArr, $groupId);
			
		// add parents groups
		while ($groupId != 0)
		{
			$DB->getResults($users_getGroupParent, $groupId);
			$row = $DB->fetch(0);
			$groupId = $row['parent_id'];
			
			if ($groupId != 0)
				array_push($groupArr, $groupId);
			
			$DB->freeResults();
		}
		
		$cpt++;
	}
	
	// Add pages for all groups (and parent groups) of the user
	foreach ($groupArr AS $groupId)
	{
		$DB->getResults($users_getPublicAndGroupPages,$DB->escape($groupId));
		while ($row = $DB->fetch(0))
		{		
			$DB->execute($user_addProfilePages,
								$DB->escape($userid),
								$DB->quote($row['name']),
								$DB->escape($row['nbcol']),
								$DB->escape($row['style']),
								$DB->quote($row['controls']),
								$DB->quote($row['showtype']),
								$DB->escape($row['seq']),
								$DB->quote($row['icon']),
								$DB->quote($row['modulealign']),
								$DB->quote($row['type']),
								$DB->quote($row['param']),
								$DB->escape($row['id']),
								$DB->escape($row['removable']),
								$DB->escape($row['showwidgetbar'])
						 );			
			$profid=$DB->getId();
			//must check the modules
			$temp_id=$row['id'];
			if ($row['type']==1)    {
				$DB2->getResults($page_getPagesModule,$temp_id);
				while ($rows = $DB2->fetch(0))
				{
                    $DB2->execute($modules_addNewMod,
                                            $DB2->escape($rows['item_id']),
                                            $DB2->escape($rows['posx']),
                                            $DB2->escape($rows['posy']),
                                            $DB2->escape($rows['posj']),
                                            $DB2->escape($rows['x']),
                                            $DB2->escape($rows['y']),
                                            $DB2->quote($rows['variables']),
                                            $DB2->escape($rows['uniq']),
                                            $DB2->escape($rows['blocked']),
                                            $DB2->escape($rows['minimized']),
											$DB2->escape($userid),
											$DB2->escape($temp_id)   
                                );           
                                         
				}
				$DB2->freeResults();
			}
		}
		$DB->freeResults();
	}
	launch_hook('admin_create_user',$userid);

	
	//if the user created is an admin
	if ($_POST["usertype"] == 'A')    {
        //get pages from admin which create other admin 
        $listpages = getAdminPages(array( 'db' => $DB, 'user_id' => $_SESSION['user_id'] ));
		//Tabs the admin can access
		if (isset($_POST['admTabs']))   {
			$tabList=explode(',',$_POST['admTabs']);          
			for ($i=0;$i<count($tabList);$i++)
			{
                $pageid = $tabList[$i];
                //can create page only if creator has right on pages
                if (  $listpages[$pageid] ) {
                    $DB->execute($users_addAdmTabMap,$DB2->escape($userid),$DB2->escape($pageid));
                }
			}
		}
	}

	$log=new log();
	$log->addLog($DB,'User creation (NAME:'.$user.';ID:'.$userid.')');
}
//user update
else 
{
	 //modify the user information
	 if ($user!="" && $password!="" && $password!="xxxxxxxx") {
		$DB->execute($users_updateWithPass2,
                            $DB->quote($user),
							$DB->quote($email),
                            $DB->quote($_POST["long_name"]),
                            $DB->quote($userType),
                            $DB->quote($password),
                            $DB->quote($key),
                            $DB->quote($_POST["lang"]),
							$expiration_date,
							$DB->escape($force_user_change_password),
                            $DB->escape($userid)
                        );
		// save user password in history table
		$DB->execute($scr_insertPortalPass,
								$DB->escape($userid),
								$DB->quote($password));
     }
     else { 
		$DB->execute($users_updateWithoutPass2,
                                $DB->quote($user),
								$DB->quote($email),
                                $DB->quote($_POST["long_name"]),
                                $DB->quote($userType),
                                $DB->quote($_POST["lang"]),
								$expiration_date,
								$DB->escape($force_user_change_password),
                                $DB->escape($userid)
                    );
     }

	// change portals languages
	$DB->execute($users_updatePortalsLanguage,$DB->quote($_POST["lang"]),$DB->escape($userid));

	//update the user specifics infos
	if ($nbSpecificFields!=0) {
		for ($i=1;$i<=$nbSpecificFields;$i++)
		{
			$parameters="";
			$id = $_POST["uniq_id".$i];
			//if it's a checkbox (array)
			if (isset($_POST["userinfo".$i])) {
                if (is_array($_POST["userinfo".$i])) {
                    for ($j=0;$j<count($_POST["userinfo".$i]);$j++)
                    {	
                        if ($j==0) { $parameters = $_POST["userinfo".$i][$j]; }
                        else { $parameters .= ",".$_POST["userinfo".$i][$j];  }
                    }
                }	
                else    {
                    if ($_POST["userinfo".$i]!="")	{ $parameters=$_POST["userinfo".$i]; }
                }
			}					
			//sql query to add	or update
            $DB->getResults($users_getSpecificCriteria,$DB->escape($userid),$DB->escape($id));
            if ($DB->nbResults()>0) {   
                $DB->execute($users_updateUserInfos,$DB->quote($parameters),$DB->escape($userid),$DB->escape($id));	 
            }
            else {  
                $DB->execute($users_addUserInfos,$DB->escape($userid),$DB->escape($id),$DB->quote($parameters));  
            }
		}
	}
	
    //Delete the users pages for the groups he's been suppressed
    $user_group_id = array ();
    $user_pages_id = array ();
    $user_newgroup_id = array ();
    $cpt = 0;
	
    // get new groups
    while (isset($_POST["group".$cpt]))
	{
		$groupId = $_POST["group".$cpt];
		// add selected group
		if (!in_array($groupId, $user_newgroup_id))
			array_push($user_newgroup_id, $groupId);
			
		// add parents groups
		while ($groupId != 0)
		{
			$DB->getResults($users_getGroupParent, $groupId);
			$row = $DB->fetch(0);
			$groupId = $row['parent_id'];
			
			if ($groupId != 0)
				array_push($user_newgroup_id, $groupId);
			
			$DB->freeResults();
		}
		
		// get parent groups
        $cpt++;
    }
    
    // get old group mapping
    $DB->getResults($users_getUserGroup,$DB->escape($userid));
    while ($row = $DB->fetch(0))
	{
       array_push ($user_group_id, $row['id']);
    }
    $DB->freeResults();
    
    //compare the two tabs on delete the user pages if not in the group anymore
    for ($i=0;$i<count($user_group_id);$i++) {
        if (!in_array($user_group_id[$i],$user_newgroup_id)) {
            $DB->getResults($pages_getGroupPages,$DB->escape($user_group_id[$i]));
            while ($row = $DB->fetch(0)) {
                array_push ($user_pages_id, $row['id']);
            }
            $DB->freeResults();
            
            for ($j=0;$j<count($user_pages_id);$j++)
            {
                //delete all modules
                $DB->execute($users_deleteProfileModules,$DB->escape($user_pages_id[$j]));
                //delete in profile
                $DB->execute($users_deleteToUpdateTabs,$DB->escape($user_pages_id[$j]),$DB->escape($userid));
            }
        }
    }
        
	//group page
	foreach ($user_newgroup_id AS $groupId)
	{
		$DB->getResults($users_getPublicAndGroupPages,$DB->escape($groupId));
		while ($row = $DB->fetch(0))
		{	
			$profid = 0;
			
			// Check that the page doesn't already exist
			$DB2->getResults($users_getExistingPageForUser,$DB2->escape($userid),$row['id']);
			
			if ($DB2->nbResults()==0)
			{
				$DB->execute($user_addProfilePages,
										$DB->escape($userid),
										$DB->quote($row['name']),
										$DB->escape($row['nbcol']),
										$DB->escape($row['style']),
										$DB->quote($row['controls']),
										$DB->quote($row['showtype']),
										$DB->escape($row['seq']),
										$DB->quote($row['icon']),
										$DB->quote($row['modulealign']),
										$DB->quote($row['type']),
										$DB->quote($row['param']),
										$DB->escape($row['id']),
										$DB->escape($row['removable']),
										$DB->escape($row['showwidgetbar'])
							  );			
				$profid=$DB->getId();
				//must check the modules
				$temp_id=$row['id'];
			}
			$DB2->freeResults();
			
			if ($row['type'] == 1 && $profid != 0) {
				$DB2->getResults($page_getPagesModule,$temp_id);
				while ($rows = $DB2->fetch(0))
				{
                     $DB2->execute($modules_addNewMod,
                                $DB2->escape($rows['item_id']),
                                $DB2->escape($rows['posx']),
                                $DB2->escape($rows['posy']),
                                $DB2->escape($rows['posj']),
                                $DB2->escape($rows['x']),
                                $DB2->escape($rows['y']),
                                $DB2->quote($rows['variables']),
                                $DB2->escape($rows['uniq']),
                                $DB2->escape($rows['blocked']),
                                $DB2->escape($rows['minimized']),
                                $DB2->escape($userid),
                                $DB2->escape($temp_id)   
                    );     
				}
				$DB2->freeResults();
			}
		}
		$DB->freeResults();
	}
	
    //tabs are not editable for the big root admins - admin own account
    if ($_SESSION['general_admin']==1 && $DB->escape($userid) != $_SESSION['user_id'])  {
    	//delete the previous tabs
    	$DB->execute($users_deleteAdmTabMap,$DB->escape($userid));
    	//update the admin tabs
    	if (isset($_POST['admTabs']))
		{
    		$tabList=explode(',',$_POST['admTabs']);
    		for ($i=0;$i<sizeof($tabList);$i++)
    		{
    			$DB->execute($users_addAdmTabMap,$DB2->escape($userid),$DB2->escape($tabList[$i]));
    		}
    	}
    }
	$log=new log();
	$log->addLog($DB,'User changes (NAME:'.$user.';ID:'.$userid.')');
	launch_hook('admin_modify_user',$userid);
}


//remove user from all groups and add user in the groups selected
$i=0;

if ($_POST["usertype"] == 'I')
{
    $DB->execute($user_removeFromGroup,$DB->escape($userid));
    launch_hook('admin_set_user_removeallgroups',$userid);
    while (isset($_POST["group".$i]))
    {
    	$DB->execute($users_addInGroup,$DB->escape($userid),$DB->escape($_POST["group".$i]));
    	launch_hook('admin_set_user_group',$userid,$_POST["group".$i]);

    	$i++;
    }
}
else if ($_POST["usertype"] == 'A') {
    $DB->execute($admin_removeFromGroup,$DB->escape($userid));
	$DB->execute($user_removeFromGroup,$DB->escape($userid));
    launch_hook('admin_set_user_removeallgroups',$userid);
	while (isset($_POST["group".$i]))
	{
		// map all groups for admi in adm_group_map
		$DB->execute($admin_addInGroupMap,$DB->escape($userid),$DB->escape($_POST["group".$i]));
		// map all groups for admin in user_group_map !! keep this since adm_group_map should be removed in posh 2.3
		$DB->execute($users_addInGroup,$DB->escape($userid),$DB->escape($_POST["group".$i]));
        launch_hook('admin_set_user_group',$userid,$_POST["group".$i]);
		$i++;
	}
}

//notification
if (isset($_POST["notify"]) && strcmp($DB->escape($_POST["notify"]),"true")==0) {
	if ($password=="xxxxxxxx") {
		//Generate a new password
		$str = "0123456789abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ";
		$password="";
		srand((double)microtime()*1000000);
		for($i=0;$i<10;$i++) $password.= $str[rand()%62]; 
		
		// update password
		$DB->setUtf8();
		$DB->execute($users_updatePassword,$DB->quote(md5($password)),$DB->escape($userid));
	}
	
	//add unsubscribe to the message
	$unsubscribeLink = __LOCALFOLDER.'portal/login.php?id='.$userid.'&md5='.$key;
	$unsubscribe = lg('accountUnsubscribe').lg('lblClickHere').' : '.$unsubscribeLink;
		
    //get more information about place holder in includes/mail.inc.php lib    
    //tab with all the php values to include into the mail 
    $placeholder_value = array($email, $password, __APPNAME, __LOCALFOLDER, $unsubscribe,$long_name);
    //tab with all the pseudoCode tags
    $placeholder_keys = array("%email", "%password", "%site", "%link","%unsubscribe","%username");
	$lang=$_POST['lang'];
	$DB->getResults($config_getNotification,$DB->quote($_POST["lang"]),'validInscription',$long_name);
    
	$row = $DB->fetch(0);
    $notif_subject=stripslashes($row["subject"]);
    $notif_message=stripslashes($row["message"]);
    $notif_sender=$row["sender"];
    $notif_copy=$row["copy"];
	
	$DB->freeResults();
		
	$s_mail = new mail();
	$s_mail->addSender($notif_sender);
	$s_mail->addSubject($notif_subject,$placeholder_value,$placeholder_keys);
	$s_mail->addMessage($notif_message,$placeholder_value,$placeholder_keys);
	$s_mail->configArray($notif_copy,'1');
	$s_mail->configArray($email,'2');
    if(!$s_mail->sendMail())    {
        error_log( "error in user add modify send notfication : "  . $s_mail->errorlog );
        echo "<error><![CDATA[",$s_mail->errorlog,"]]></error>";
        $file->status(0);
        $file->footer();
		exit();
	}   
}

$DB->close();
$DB2->close();
$file->status(1);
echo "<userid>$userid</userid>";
$file->footer();
?>