>1.0.0;

CREATE TABLE adm_config (
  parameter varchar(64) NOT NULL,
  value text NOT NULL,
  datatype char(3) NOT NULL,
  desttype char(1) NOT NULL,
  CONSTRAINT pk_adm_config PRIMARY KEY CLUSTERED (parameter)
);
INSERT INTO adm_config VALUES ('theme', 'default', 'str', 'J');
INSERT INTO adm_config VALUES ('themeNb', '1', 'int', 'J');
INSERT INTO adm_config VALUES ('maxModNb', '15', 'int', 'J');
INSERT INTO adm_config VALUES ('footer', 'powered by portaneo', 'str', 'J');
INSERT INTO adm_config VALUES ('USERMODULE', 'I', 'str', 'P');
INSERT INTO adm_config VALUES ('userModuleJs', 'I', 'str', 'J');
INSERT INTO adm_config VALUES ('dimension', '{"seq":"0","name":"Widgets -fr","id":2,"lg":"fr"},{"seq":"0","name":"Widget -en","id":3,"lg":"en"}', 'arr', 'J');
INSERT INTO adm_config VALUES ('option', '{"fct":"p_addContent.menu()","label":lg("lblAddContent"),"img":"ico_menu_add.gif","comment":lg("lblAddContent2"),"anonymous":true,"connected":true},{"fct":"p_edit.menu()","label":lg("lblPersonalize"),"img":"ico_menu_tools.gif","comment":lg("lblPersonalize"),"anonymous":true,"connected":true},{"fct":"showSave()","label":"<B>"+lg("lblSave")+"</B>","img":"ico_menu_disk.gif","comment":lg("lblSavePage"),"anonymous":true,"connected":false}', 'arr', 'J');
INSERT INTO adm_config VALUES ('apname', '', 'str', 'J');
INSERT INTO adm_config VALUES ('useArchive', 'false', 'int', 'J');
INSERT INTO adm_config VALUES ('rssinfo', '', 'str', 'J');
INSERT INTO adm_config VALUES ('useGroup', 'true', 'int', 'J');
INSERT INTO adm_config VALUES ('useGSearch', 'false', 'int', 'J');
INSERT INTO adm_config VALUES ('useList', 'false', 'int', 'J');
INSERT INTO adm_config VALUES ('USEMAGIC', 'true', 'int','P');
INSERT INTO adm_config VALUES ('SERVER', '', 'str', 'P');
INSERT INTO adm_config VALUES ('LOGIN', '', 'str', 'P');
INSERT INTO adm_config VALUES ('PASS', '', 'str', 'P');
INSERT INTO adm_config VALUES ('DB', '', 'str', 'P');
INSERT INTO adm_config VALUES ('LOCALFOLDER', '', 'str', 'P');
INSERT INTO adm_config VALUES ('SUPPORTEMAIL', '', 'str', 'P');
INSERT INTO adm_config VALUES ('KEY', '', 'str', 'P');
INSERT INTO adm_config VALUES ('APPNAME', '', 'str', 'P');
INSERT INTO adm_config VALUES ('AVLANGS', '"en","fr"', 'arr', 'P');
INSERT INTO adm_config VALUES ('FRIENDEMAIL', '', 'str', 'P');
INSERT INTO adm_config VALUES ('useSharing', 'false', 'int', 'J');
INSERT INTO adm_config VALUES ('useNotation', 'false', 'int', 'J');
INSERT INTO adm_config VALUES ('useContact', 'false', 'int', 'J');
INSERT INTO adm_config VALUES ('headlinks', '{"fct":"openHelp()","label":lg("lblHelp"),"img":"-","comment":lg("lblFirstUsage"),"anonymous":true,"connected":false},{"fct":"link(\\"index.php?lang=en\\")","label":"EN","img":"-","comment":"English","anonymous":true,"connected":false},{"fct":"link(\\"index.php?lang=fr\\")","label":"FR","img":"-","comment":"Fran&ccedil;ais","anonymous":true,"connected":false},{"fct":"p_banner.option.show()","label":lg("lblShowOpt"),"img":"-","comment":"","anonymous":false,"connected":true}', 'arr', 'J');
INSERT INTO adm_config VALUES ('useNewsletter', 'false', 'int', 'J');
INSERT INTO adm_config VALUES ('useConditions', 'false', 'int', 'J');
INSERT INTO adm_config VALUES ('conditionComment', '', 'str', 'J');
INSERT INTO adm_config VALUES ('nbicons', '40', 'int', 'J');
INSERT INTO adm_config VALUES ('ARCHIVE', 'false', 'int', 'P');
CREATE TABLE adm_tabs (
  id tinyint IDENTITY(1,1) NOT NULL,
  name varchar(30) NOT NULL,
  label varchar(30) NOT NULL,
  type tinyint NOT NULL,
  param varchar(60) NOT NULL,
  CONSTRAINT pk_adm_tabs PRIMARY KEY CLUSTERED  (id)
);
SET IDENTITY_INSERT adm_tabs ON;
INSERT INTO adm_tabs( id , name , label , type , param ) VALUES (1,'modulestab', 'Modules', 4, 'modules.php');
INSERT INTO adm_tabs( id , name , label , type , param ) VALUES (2,'userstab', 'Utilisateurs', 4, 'users.php');
INSERT INTO adm_tabs( id , name , label , type , param ) VALUES (3,'pagestab', 'Pages', 4, 'pages.php');
INSERT INTO adm_tabs( id , name , label , type , param ) VALUES (4,'configstab', 'Configuration', 4, 'config.php');
SET IDENTITY_INSERT adm_tabs OFF;
CREATE TABLE dir_cat_item (
  item_id int NOT NULL ,
  category_id smallint NOT NULL ,
  first char(1) NOT NULL
);
CREATE CLUSTERED INDEX indcl_dir_cat_item ON dir_cat_item (item_id);
CREATE TABLE dir_cat_properties (
  category_id smallint NOT NULL ,
  seq char(1) NOT NULL
);
CREATE CLUSTERED INDEX indcl_dir_cat_properties ON dir_cat_properties (category_id);
INSERT INTO dir_cat_properties (category_id,seq) VALUES (2,0);
INSERT INTO dir_cat_properties (category_id,seq) VALUES (3,1);
CREATE TABLE dir_category (
  id smallint IDENTITY(5000,1) NOT NULL,
  name varchar(60) NOT NULL ,
  parent_id smallint NOT NULL ,
  typ char(1) NOT NULL,
  path varchar(255) NULL,
  quantity smallint NOT NULL ,
  updated char(1) NOT NULL default 'Y',
  lang char(2) DEFAULT 'fr' NOT NULL,
  CONSTRAINT pk_dir_category PRIMARY KEY CLUSTERED  (id)
);
SET IDENTITY_INSERT dir_category ON;
INSERT INTO dir_category (id,name,parent_id,typ,path,quantity,updated,lang) VALUES(2,'Widgets -fr',0,'O','',1,'Y','fr');
INSERT INTO dir_category (id,name,parent_id,typ,path,quantity,updated,lang) VALUES(3,'Widgets -en',0,'O','',1,'Y','en');
SET IDENTITY_INSERT dir_category OFF;
CREATE TABLE dir_item (
  id int IDENTITY(10000,1) NOT NULL,
  url varchar(150) NOT NULL ,
  defvar varchar(150) NULL,
  name varchar(30) NOT NULL ,
  description varchar(250) NULL,
  typ char(1) NULL ,
  status char(1) NULL ,
  format char(1) NOT NULL default 'I',
  height SMALLINT NULL ,
  minwidth SMALLINT NOT NULL default '280',
  sizable char(1) NOT NULL default '1',
  website varchar(50) ,
  editor_id int NULL ,
  nbvariables TINYINT NULL ,
  creation_date date NOT NULL default '0000-00-00',
  lastmodif_date date NOT NULL default '0000-00-00',
  notation TINYINT NULL ,
  voter_nb SMALLINT NULL ,
  updated char(1) NOT NULL default 'Y',
  nbusers SMALLINT NULL ,
  sorting SMALLINT NULL ,
  lang varchar(5) NOT NULL default 'en',
  CONSTRAINT pk_dir_item PRIMARY KEY CLUSTERED  (id)
);
CREATE TABLE app_notation (
  item_id int NOT NULL ,
  caract1 TINYINT NOT NULL ,
  caract2 TINYINT NOT NULL ,
  caract3 TINYINT NOT NULL ,
  used char(1) NOT NULL default 'N'
);
CREATE CLUSTERED INDEX indcl_app_notation ON app_notation (item_id);
CREATE TABLE module (
  item_id int NOT NULL ,
  user_id INT NOT NULL ,
  profile_id INT NOT NULL ,
  posx TINYINT NULL ,
  posy TINYINT NULL ,
  posj TINYINT NULL ,
  typ char(1) NOT NULL default 'D',
  variables varchar(250) ,
  uniq SMALLINT NOT NULL default '1'
);
CREATE CLUSTERED INDEX indcl_module ON module (item_id, user_id, profile_id);
CREATE TABLE pages (
  id SMALLINT IDENTITY(1,1) NOT NULL,
  name varchar(30) NOT NULL ,
  description text NULL,
  position char(1) NULL ,
  type char(1) NULL ,
  param varchar(150) NULL ,
  seq TINYINT NULL ,
  nbcol TINYINT NOT NULL default '3',
  showtype TINYINT NULL ,
  npnb TINYINT NOT NULL default '15',
  CONSTRAINT pk_pages PRIMARY KEY CLUSTERED  (id)
);
CREATE TABLE pages_module (
  item_id int NOT NULL ,
  page_id SMALLINT NOT NULL ,
  posx TINYINT NULL ,
  posy TINYINT NULL ,
  posj TINYINT NULL ,
  variables varchar(250) ,
  uniq SMALLINT NOT NULL default '1'
);
CREATE CLUSTERED INDEX indcl_pages_module ON pages_module (item_id);
CREATE TABLE portals (
  id int IDENTITY(1,1) NOT NULL,
  name varchar(40) NOT NULL ,
  description varchar(200) ,
  status char(1) NOT NULL default 'N',
  author INT NOT NULL ,
  nbcol char(1) NOT NULL default '3',
  style TINYINT NOT NULL default '1',
  position char(1) NOT NULL ,
  CONSTRAINT pk_portals PRIMARY KEY CLUSTERED  (id)
);
CREATE TABLE portals_category (
  portal_id int NOT NULL ,
  category_id SMALLINT NOT NULL 
);
CREATE CLUSTERED INDEX indcl_portals_category ON portals_category (portal_id);
CREATE TABLE portals_module (
  portal_id int NOT NULL ,
  item_id int NOT NULL ,
  posx TINYINT NOT NULL ,
  posy TINYINT NOT NULL ,
  posj TINYINT NOT NULL ,
  variables varchar(250) NOT NULL
);
CREATE CLUSTERED INDEX indcl_portals_module ON portals_module (portal_id);
CREATE TABLE profile (
  user_id INT NOT NULL ,
  id TINYINT NOT NULL ,
  name varchar(14) NOT NULL ,
  width TINYINT NOT NULL default '1',
  height TINYINT NOT NULL default '1',
  lang varchar(5) NOT NULL default 'fr',
  def char(1) NOT NULL default 'N',
  style TINYINT NOT NULL default '1',
  refresh TINYINT NULL ,
  pass varchar(16) ,
  creation_date date NOT NULL default '0000-00-00',
  modif_date date NOT NULL default '0000-00-00',
  md5pass varchar(32) NULL ,
  menu char(1) NOT NULL default 'o',
  cacheurl varchar(36) NULL ,
  controls char(1) NOT NULL default 'Y',
  advise char(1) NOT NULL default 'Y',
  showtype char(1) NULL ,
  nbnews TINYINT NOT NULL default '20',
  seq TINYINT NULL
);
CREATE CLUSTERED INDEX indcl_profile ON profile (user_id);
CREATE TABLE ref_pages_mode (
  id TINYINT NOT NULL ,
  label varchar(30) NOT NULL ,
  CONSTRAINT pk_ref_pages_mode PRIMARY KEY CLUSTERED  (id)
);
INSERT INTO ref_pages_mode VALUES (1, 'Anonymous');
INSERT INTO ref_pages_mode VALUES (2, 'Connected');
INSERT INTO ref_pages_mode VALUES (3, 'Anonymous & connected');
CREATE TABLE ref_pages_type (
  id TINYINT NOT NULL ,
  label varchar(30) NOT NULL ,
  CONSTRAINT pk_ref_pages_type PRIMARY KEY CLUSTERED  (id)
);
INSERT INTO ref_pages_type VALUES (1, 'personalizable portal');
INSERT INTO ref_pages_type VALUES (2, 'HTML page');
INSERT INTO ref_pages_type VALUES (3, 'javascript function');
INSERT INTO ref_pages_type VALUES (4, 'Redirection');
CREATE TABLE search_index (
  kw_id int NOT NULL ,
  item_id int NOT NULL ,
  weight TINYINT NOT NULL
);
CREATE CLUSTERED INDEX indcl_search_index ON search_index (kw_id);
CREATE TABLE search_keyword (
  id int IDENTITY(1,1) NOT NULL,
  label varchar(30) NOT NULL ,
  CONSTRAINT pk_search_keyword PRIMARY KEY CLUSTERED  (id)
);
CREATE INDEX indcl_searchkeyword_id ON search_keyword (id);
CREATE TABLE temp_category (
  category_id SMALLINT NOT NULL ,
  quantity SMALLINT NOT NULL ,
  gener1 SMALLINT ,
  gener2 SMALLINT ,
  gener3 SMALLINT ,
  gener4 SMALLINT ,
  pass char(1) NOT NULL
);
CREATE CLUSTERED INDEX indcl_temp_category ON temp_category (category_id);
CREATE TABLE temp_dir_cat_item (
  item_id int NOT NULL ,
  category_id SMALLINT NOT NULL ,
  first char(1) NOT NULL
);
CREATE CLUSTERED INDEX indcl_temp_dir_cat_item ON temp_dir_cat_item (item_id);
CREATE TABLE temp_dir_item (
  id int IDENTITY(1,1) NOT NULL,
  defvar varchar(150) ,
  url varchar(150) NOT NULL ,
  logo varchar(150) NULL ,
  name varchar(30) NOT NULL ,
  description varchar(250) ,
  keyword varchar(200) ,
  typ char(1) NULL ,
  status char(1) NULL ,
  format char(1) NOT NULL default 'I',
  height SMALLINT NULL ,
  minwidth SMALLINT NOT NULL default '280',
  sizable char(1) NOT NULL default '1',
  website varchar(50) ,
  editor_id int NULL ,
  nbvariables TINYINT NULL ,
  creation_date date NOT NULL default '0000-00-00',
  lastmodif_date date NOT NULL default '0000-00-00',
  notation TINYINT NULL ,
  voter_nb SMALLINT NULL ,
  updated char(1) NOT NULL default 'Y',
  nbusers SMALLINT NULL ,
  sorting SMALLINT NULL ,
  lang varchar(5) NOT NULL default 'en',
  CONSTRAINT pk_temp_dir_item PRIMARY KEY CLUSTERED  (id)
);
CREATE TABLE users (
  id INT IDENTITY(1,1) NOT NULL,
  username varchar(64) NOT NULL ,
  pass VARCHAR(100) NOT NULL,
  long_name varchar(100) ,
  typ char(1) NOT NULL ,
  lastconnect_date DATETIME NOT NULL default '0000-00-00 00:00:00',
  md5pass varchar(32) NOT NULL ,
  md5user varchar(32) ,
  lang varchar(5) NOT NULL default 'fr',
  CONSTRAINT pk_users PRIMARY KEY CLUSTERED  (id)
);
CREATE INDEX indcl_users ON users (username);
CREATE TABLE users_alert (
  email varchar(64) NOT NULL ,
  keyword varchar(32) NOT NULL
);
CREATE CLUSTERED INDEX indcl_users_alert ON users_alert (email);
CREATE TABLE users_articles (
  id INT IDENTITY(1,1) NOT NULL,
  user_id int NOT NULL ,
  title varchar(100) NOT NULL ,
  link varchar(150) NOT NULL ,
  CONSTRAINT pk_users_articles PRIMARY KEY CLUSTERED  (id)
);
CREATE TABLE users_favorites (
  user_id int NOT NULL ,
  profile_id TINYINT NOT NULL ,
  number SMALLINT NOT NULL ,
  name varchar(30) NOT NULL ,
  url varchar(200) NOT NULL
);
ALTER TABLE users_favorites ADD link_id INT IDENTITY (1,1) NOT NULL
CONSTRAINT pk_users_favorites PRIMARY KEY CLUSTERED;
CREATE TABLE users_friends (
  user_id int NOT NULL ,
  email varchar(64) NOT NULL
);
CREATE CLUSTERED INDEX indcl_users_friends ON users_friends (user_id);
CREATE TABLE users_group (
  id SMALLINT IDENTITY(1,1) NOT NULL,
  name varchar(64) NOT NULL ,
  parent_id SMALLINT NOT NULL ,
  CONSTRAINT pk_users_group PRIMARY KEY CLUSTERED  (id)
);
CREATE TABLE users_group_map (
  user_id INT NOT NULL ,
  group_id SMALLINT NOT NULL
);
CREATE CLUSTERED INDEX indcl_users_group_map ON users_group_map (user_id);
CREATE TABLE users_notes (
  user_id int NOT NULL ,
  profile_id TINYINT NOT NULL ,
  number SMALLINT NOT NULL ,
  notes text
);
CREATE TABLE users_tasks (
  user_id int NOT NULL ,
  profile_id TINYINT NOT NULL ,
  number SMALLINT NOT NULL ,
  name varchar(50) NOT NULL ,
  comments VARCHAR( 250 ) NOT NULL
);
ALTER TABLE users_tasks ADD task_id INT IDENTITY(1,1) NOT NULL  
CONSTRAINT pk_users_tasks PRIMARY KEY;

>1.0.1;

INSERT INTO adm_config VALUES ('barcolnb', '7', 'int', 'J');
INSERT INTO adm_config VALUES ('POSHVERSION', '1.0.1', 'str', 'P');
ALTER TABLE users ALTER COLUMN pass VARCHAR(100) NULL;
ALTER TABLE module ADD blocked TINYINT NULL ;
ALTER TABLE pages_module ADD blocked TINYINT  NULL ;
ALTER TABLE portals_module ADD blocked TINYINT  NULL ;

>1.1.0;

INSERT INTO adm_config VALUES ('showHomeBar', '1', 'int', 'J');
ALTER TABLE users_notes ALTER COLUMN profile_id TINYINT;
ALTER TABLE users_notes ALTER COLUMN number SMALLINT ;
ALTER TABLE users_notes ADD id INT IDENTITY(1,1) NOT NULL 
CONSTRAINT pk_users_notes PRIMARY KEY CLUSTERED;
UPDATE module 
SET module.variables = module.variables + '¬eid=' + users_notes.id 
FROM module
INNER JOIN users_notes ON module.user_id=users_notes.user_id AND module.profile_id=users_notes.profile_id
WHERE module.item_id=84 AND users_notes.number=module.uniq
CREATE TABLE users_favorites_id (id INT IDENTITY(1,1) NOT NULL ,status CHAR(1) NULL,temp VARCHAR( 30 ) NOT NULL ,
CONSTRAINT pk_users_favorites_id PRIMARY KEY CLUSTERED ( id ) );
INSERT INTO users_favorites_id(status,temp) SELECT 'A',cast(user_id AS VARCHAR(10)) + '_' + cast(profile_id AS VARCHAR(10)) +  '_' +  cast(number AS VARCHAR(10)) FROM users_favorites GROUP BY user_id, profile_id, number;
ALTER TABLE users_favorites ADD id INT NULL;
ALTER TABLE users_favorites_id DROP COLUMN temp;
CREATE TABLE users_tasks_id (id INT IDENTITY(1,1) NOT NULL ,status CHAR(1) NULL,temp VARCHAR( 30 ) NOT NULL ,
CONSTRAINT pk_users_tasks_id PRIMARY KEY CLUSTERED ( id ) );
INSERT INTO users_tasks_id(status,temp) SELECT 'A', cast(user_id AS VARCHAR(10)) + '_' + cast(profile_id AS VARCHAR(10)) + '_' + cast(number AS VARCHAR(10)) FROM users_tasks GROUP BY user_id, profile_id, number;
ALTER TABLE users_tasks ADD id INT NULL ;
ALTER TABLE users_tasks_id DROP COLUMN temp ;
INSERT INTO adm_config VALUES ('txtnote', 'You can change this default note text in the admin panel, in the general configuration.', 'str', 'J');
INSERT INTO adm_config VALUES ('menuposition', 'v', 'str', 'J');
UPDATE adm_config SET value='' WHERE parameter='option';
UPDATE adm_config SET value='{"fct":"openHelp()","label":lg("lblHelp"),"img":"-","comment":lg("lblFirstUsage"),"anonymous":true,"connected":false},{"fct":"p_addContent.menu()","label":lg("lblAddContent"),"img":"ico_menu_add.gif","comment":lg("lblAddContent2"),"anonymous":true,"connected":true},{"fct":"p_edit.menu()","label":lg("lblPersonalize"),"img":"ico_menu_tools.gif","comment":lg("lblPersonalize"),"anonymous":true,"connected":true},{"fct":"showSave()","label":"<B>"+lg("lblSave")+"</B>","img":"ico_menu_disk.gif","comment":lg("lblSavePage"),"anonymous":true,"connected":false},{"fct":"link(\\"index.php?lang=en\\")","label":"EN","img":"-","comment":"English","anonymous":true,"connected":false},{"fct":"link(\\"index.php?lang=fr\\")","label":"FR","img":"-","comment":"Français","anonymous":true,"connected":false},{"fct":"goIndex()","label":lg("lblArchive2"),"img":"-","comment":"","anonymous":false,"connected":true}' WHERE parameter='headlinks';
ALTER TABLE users_tasks ADD done CHAR( 1 ) DEFAULT 'N' NOT NULL ;
CREATE TABLE users_calendar_id (id INT IDENTITY(1,1) NOT NULL ,status CHAR( 1 ) NOT NULL ,
CONSTRAINT pk_users_calendar_id PRIMARY KEY CLUSTERED ( id ) );
CREATE TABLE users_calendar (cal_id INT IDENTITY(1,1) NOT NULL ,id INT NOT NULL ,title VARCHAR( 64 ) NOT NULL ,date DATE NOT NULL ,time VARCHAR( 5 ) NOT NULL ,ampm CHAR( 1 ),
CONSTRAINT pk_users_calendar PRIMARY KEY CLUSTERED ( cal_id ) );
INSERT INTO adm_config VALUES ('rssrefreshdelay', '60', 'int', 'J');
ALTER TABLE module ADD minimized TINYINT NULL ;
ALTER TABLE pages_module ADD minimized TINYINT NULL ;
ALTER TABLE portals_module ADD minimized TINYINT NULL ;
INSERT INTO adm_config VALUES ('debugmode', 'false', 'int', 'J');
INSERT INTO adm_config VALUES ('defaultmode', 'anonymous', 'str', 'P');
UPDATE adm_config SET desttype='A' WHERE parameter='useGroup';
ALTER TABLE pages ADD group_id SMALLINT NULL;
CREATE TABLE log (action TINYINT NOT NULL ,pubdate DATE NOT NULL ,param1 VARCHAR( 250 ) NULL ,param2 VARCHAR( 250 ) NULL ,param3 VARCHAR( 250 ) NULL );
CREATE CLUSTERED INDEX indcl_log ON log (action);
CREATE TABLE stats_processing_log (action TINYINT  NOT NULL ,pubdate DATE NOT NULL ,param1 VARCHAR( 250 ) NULL ,param2 VARCHAR( 250 ) NULL );
CREATE CLUSTERED INDEX indcl_stats_processing_log ON stats_processing_log (action);
CREATE TABLE stats_final (action TINYINT NOT NULL ,treatdate DATE NOT NULL ,result1 VARCHAR( 250 ) NULL ,result2 VARCHAR( 250 ) NULL );
CREATE CLUSTERED INDEX indcl_stats_final ON stats_final (action);
SET IDENTITY_INSERT adm_tabs ON;
INSERT INTO adm_tabs ( id , name , label , type , param ) VALUES (6, 'statstab', 'Statistics', '4', 'stats.php');
SET IDENTITY_INSERT adm_tabs OFF;
CREATE TABLE dir_rss (id int IDENTITY(1,1) NOT NULL ,url VARCHAR( 200 ) NOT NULL ,icon TINYINT NOT NULL ,
CONSTRAINT pk_dir_rss PRIMARY KEY CLUSTERED ( id ));
CREATE INDEX indcl_dir_rss_url ON dir_rss (url);
INSERT INTO adm_config VALUES ('showicon', 'true', 'int', 'J');
INSERT INTO adm_config VALUES ('useproxy', 'false', 'int', 'A');
INSERT INTO adm_config VALUES ('PROXYSERVER', '', 'str', 'P');
INSERT INTO adm_config VALUES ('PROXYPORT', '', 'str', 'P');
INSERT INTO adm_config VALUES ('PROXYCONNECTION', '', 'str', 'P');

>1.2.0;

INSERT INTO adm_config VALUES ('proxypacfile', '', 'str', 'A');
CREATE TABLE users_mail_providers (provider_ext varchar(32) NOT NULL ,provider varchar(16) NOT NULL ,webmail varchar(64) NOT NULL ,serveur varchar(32) NOT NULL ,port varchar(5) NOT NULL ,protocole varchar(32) NOT NULL ,extension varchar(30) NOT NULL ,
CONSTRAINT pk_users_mail_providers PRIMARY KEY CLUSTERED  (provider_ext)) ;
INSERT INTO users_mail_providers VALUES ('wanadoo.fr', 'WANADOO', 'http://www.wanadoo.fr', 'pop.wanadoo.fr', '110', '/pop3/notls', '');
INSERT INTO users_mail_providers VALUES ('laposte.net', 'LA POSTE', 'http://www.laposte.net', 'pop.laposte.net', '110', '/pop3/notls', '');
INSERT INTO users_mail_providers VALUES ('club-internet.fr', 'CLUB INTERNET', 'http://flashmail.club-internet.fr', 'pop3.club-internet.fr', '110', '/pop3/notls', '');
INSERT INTO users_mail_providers VALUES ('free.fr', 'FREE', 'http://www.free.fr', 'pop.free.fr', '110', '/pop3/notls', '');
INSERT INTO users_mail_providers VALUES ('freesurf.fr', 'FREESURF', 'http://www.freesurf.fr', 'pop.freesurf.fr', '110', '/pop3/notls', '');
INSERT INTO users_mail_providers VALUES ('netcourrier.com', 'NETCOURRIER', 'http://www.netcourrier.com', 'mail.netcourrier.com', '110', '/pop3/notls', '');
INSERT INTO users_mail_providers VALUES ('neuf.fr', 'NEUF', 'http://webmail.neuf.fr', 'pop.neuf.fr', '110', '/pop3/notls', '');
INSERT INTO users_mail_providers VALUES ('tiscali.fr', 'TISCALI', 'http://login.aliceadsl.fr', 'pop.tiscali.fr', '110', '/pop3/notls', '');
INSERT INTO users_mail_providers VALUES ('yahoo.fr', 'YAHOO', 'http://www.yahoo.fr', 'pop.mail.yahoo.fr', '110', '/pop3/notls', '');
INSERT INTO users_mail_providers VALUES ('tele2.fr', 'TELE2', 'http://www.tele2.fr', 'pop.tele2.fr', '110', '/pop3/notls', '');
INSERT INTO users_mail_providers VALUES ('aol.fr', 'AOL', 'http://aolmail.aol.fr', 'imap.fr.aol.com', '143', '/notls', '');
INSERT INTO users_mail_providers VALUES ('9online.fr', '9 ONLINE', 'http://webmail.neuf.fr', 'pop.9online.fr', '110', '/pop3/notls', '');
INSERT INTO users_mail_providers VALUES ('cegetel.net', 'CEGETEL', 'http://www.cegetel.net', 'pop.cegetel.net', '110', '/pop3/notls', '');
INSERT INTO users_mail_providers VALUES ('gmail.com', 'GMAIL', 'http://www.gmail.com', 'pop.gmail.com', '110', '/pop3/notls', '@gmail.com');
INSERT INTO users_mail_providers VALUES ('ifrance.com', 'IFRANCE', 'http://web.ifrance.com', 'pop.ifrance.com', '110', '/pop3/notls', '');
INSERT INTO users_mail_providers VALUES ('magic.fr', 'MAGIC.FR', 'http://webmail.magic.fr', 'pop2.magic.fr', '110', '/pop3/notls', '');
INSERT INTO users_mail_providers VALUES ('noos.fr', 'NOOS', 'http://webmail.noos.fr', 'pop.noos.fr', '110', '/pop3/notls', '');
INSERT INTO users_mail_providers VALUES ('orange.fr', 'ORANGE', 'http://www.orange.fr', 'pop.orange.fr', '110', '/pop3/notls', '');
CREATE TABLE users_mail (id int IDENTITY(1,1) NOT NULL,user_id int NOT NULL,provider varchar(16) ,webmail varchar(64) ,serveur varchar(32) ,port varchar(5) ,protocole varchar(32) ,username varchar(64) ,pass varchar(32) ,
CONSTRAINT pk_users_mail PRIMARY KEY CLUSTERED (id)) ;
ALTER TABLE profile ADD usereader CHAR( 1 ) DEFAULT '1' NOT NULL;
ALTER TABLE profile ALTER COLUMN name VARCHAR( 30 ) NOT NULL;
UPDATE adm_config SET value='false' WHERE parameter='USEMAGIC';
INSERT INTO adm_config ( parameter , value , datatype , desttype ) VALUES ('useoverview', 'true', 'int', 'J');
INSERT INTO adm_config ( parameter , value , datatype , desttype ) VALUES ('allowredactor', 'false', 'int', 'A');
ALTER TABLE dir_item ALTER COLUMN url VARCHAR( 150 ) NOT NULL;

>1.2.3;

UPDATE users_mail_providers SET protocole = '/pop3' WHERE provider_ext = 'orange.fr';
UPDATE users_mail_providers SET serveur = 'pop.orange.fr',protocole = '/pop3' WHERE provider_ext = 'wanadoo.fr';
CREATE TABLE adm_plugins (name VARCHAR( 60 ) NOT NULL ,link TEXT NOT NULL ,dependency VARCHAR( 60 ) NOT NULL ,status CHAR( 1 ) DEFAULT 'O' NOT NULL );
CREATE CLUSTERED INDEX indcl_adm_plugins ON adm_plugins (name);
ALTER TABLE profile ADD icon VARCHAR( 150 ) ;
INSERT INTO adm_config ( parameter , value , datatype , desttype ) VALUES ('usereader', 'true', 'int', 'J');
INSERT INTO adm_config ( parameter , value , datatype , desttype ) VALUES ('showtabicon', 'true', 'int', 'J');
UPDATE adm_config SET desttype = 'A' WHERE parameter = 'LOCALFOLDER';
INSERT INTO adm_config (parameter,value,datatype,desttype) VALUES ('displayrssdesc','true','int','J');
UPDATE adm_config SET value='60' WHERE parameter='nbicons';
ALTER TABLE temp_dir_item ADD keywords VARCHAR( 250 ) NULL ;
SET IDENTITY_INSERT adm_tabs ON;
INSERT INTO adm_tabs (id, name , label , type , param ) VALUES (7, 'comtab', 'Communication', '4', 'communication.php');
SET IDENTITY_INSERT adm_tabs OFF;
INSERT INTO adm_config ( parameter , value , datatype , desttype ) VALUES ('bartype', '0', 'int', 'A');
INSERT INTO adm_config ( parameter , value , datatype , desttype ) VALUES ('bartexthtml', '', 'str', 'J');

>1.3.0;

ALTER TABLE adm_plugins ADD CONSTRAINT pk_adm_plugins PRIMARY KEY ( name ) ;
UPDATE adm_plugins SET dependency='no';
INSERT INTO adm_config ( parameter , value , datatype , desttype ) VALUES ('accountType', 'mail', 'str', 'A');
CREATE TABLE contact_sentitems (id int IDENTITY(1,1) NOT NULL,sender VARCHAR( 60 ) NOT NULL ,subject VARCHAR( 60 ) NOT NULL ,message TEXT NOT NULL ,receiver TEXT NOT NULL ,sentdate DATE NOT NULL ,status CHAR( 1 ) DEFAULT 'S' NOT NULL ,
CONSTRAINT pk_contact_sentitems PRIMARY KEY CLUSTERED ( id ));
UPDATE users_mail_providers SET port = '995',protocole = '/pop3/ssl' WHERE provider_ext = 'gmail.com';
CREATE TABLE adm_themes (name VARCHAR( 60 ) NOT NULL ,seq TINYINT NOT NULL);
CREATE CLUSTERED INDEX indcl_adm_themes ON adm_themes (name);
INSERT INTO adm_themes ( name , seq ) VALUES ('black', '1');
INSERT INTO adm_themes ( name , seq ) VALUES ('classic_blue', '2');
INSERT INTO adm_config ( parameter , value , datatype , desttype ) VALUES ('barclosing', 'false', 'int', 'J');
ALTER TABLE temp_dir_item ADD usereader TINYINT DEFAULT '1' NOT NULL;
ALTER TABLE temp_dir_item ADD autorefresh TINYINT NULL ;
ALTER TABLE dir_item ADD usereader TINYINT DEFAULT '1' NOT NULL;
ALTER TABLE dir_item ADD autorefresh TINYINT NULL ;
UPDATE dir_item SET autorefresh=1 WHERE id=350;
ALTER TABLE users_calendar ADD comments VARCHAR( 250 ) NULL;
ALTER TABLE users_calendar ADD endtime VARCHAR( 5 ) NULL;

>1.3.1;

ALTER TABLE users_favorites DROP COLUMN user_id;
ALTER TABLE users_favorites DROP COLUMN profile_id;
ALTER TABLE users_favorites DROP COLUMN number ;
ALTER TABLE users_favorites_id ADD user_id INT;
ALTER TABLE users_tasks DROP COLUMN user_id;
ALTER TABLE users_tasks DROP COLUMN profile_id;
ALTER TABLE users_tasks DROP COLUMN number ;
ALTER TABLE users_tasks_id ADD user_id INT;
ALTER TABLE users_calendar_id ADD user_id INT;
ALTER TABLE users_favorites ADD tags VARCHAR( 100 ) ;

ALTER TABLE adm_tabs ALTER COLUMN param VARCHAR( 150 ) NOT NULL;
CREATE TABLE adm_tabs_fct (tabname VARCHAR( 30 ) NOT NULL ,fctname VARCHAR( 30 ) NOT NULL ,label VARCHAR( 100 ) NOT NULL ,link VARCHAR( 150 ) NOT NULL ,description TEXT NOT NULL);
CREATE CLUSTERED INDEX indcl_adm_tabs_fct ON adm_tabs_fct (tabname);
INSERT INTO adm_tabs_fct ( tabname , fctname , label , link , description ) VALUES ('comtab', 'infobar', 'informationBar', 'admin/communication_infobar.php', 'informationBarTxt');
INSERT INTO adm_tabs_fct ( tabname , fctname , label , link , description ) VALUES ('comtab', 'emailing', 'emailing', 'admin/communication_emailing.php', 'emailingTxt');
INSERT INTO adm_tabs_fct ( tabname , fctname , label , link , description ) VALUES ('statstab', 'statistics', 'appStats', 'admin/stats_compute.php', 'appStats');
INSERT INTO adm_tabs_fct ( tabname , fctname , label , link , description ) VALUES ('configstab', 'generalsettings', 'appGeneralConfiguration', 'admin/config_general.php', 'appGeneralConfigurationTxt');
INSERT INTO adm_tabs_fct ( tabname , fctname , label , link , description ) VALUES ('configstab', 'themes', 'appThemeConfiguration', 'admin/config_theme.php', 'appThemeConfigurationTxt');
INSERT INTO adm_tabs_fct ( tabname , fctname , label , link , description ) VALUES ('configstab', 'plugins', 'appPluginsConfiguration', 'admin/config_plugins.php', 'appPluginsConfigurationTxt');
INSERT INTO adm_tabs_fct ( tabname , fctname , label , link , description ) VALUES ('pagestab', 'tabs', 'tabMgmt', 'admin/pages_tabs.php', 'tabMgmtTxt2');
INSERT INTO adm_tabs_fct ( tabname , fctname , label , link , description ) VALUES ('userstab', 'usersmgmt', 'userMgmt', 'admin/users_mgmt.php', 'userMgmt');
INSERT INTO adm_tabs_fct ( tabname , fctname , label , link , description ) VALUES ('modulestab', 'modulesmgmt', 'modMgmt', 'admin/modules_mgmt.php', 'modMgmt');
UPDATE adm_tabs SET param = 'admin/modules.php' WHERE name='modulestab' ;
UPDATE adm_tabs SET param = 'admin/users.php' WHERE name='userstab' ;
UPDATE adm_tabs SET param = 'admin/pages.php' WHERE name='pagestab' ;
UPDATE adm_tabs SET param = 'admin/config.php' WHERE name='configstab' ;
UPDATE adm_tabs SET param = 'admin/stats.php' WHERE name='statstab' ;
UPDATE adm_tabs SET param = 'admin/communication.php' WHERE name='comtab' ;

ALTER TABLE dir_item ALTER COLUMN defvar VARCHAR( 230 ) NULL ;

UPDATE adm_config SET value='80' WHERE parameter='nbicons';
CREATE TABLE adm_log (id int IDENTITY(1,1)NOT NULL ,log VARCHAR( 250 ) NOT NULL ,logdate DATE NOT NULL ,typ CHAR( 1 ) DEFAULT 'O' NOT NULL ,
CONSTRAINT pk_adm_log PRIMARY KEY CLUSTERED ( id ) );

>1.3.2;

INSERT INTO adm_config ( parameter , value , datatype , desttype ) VALUES ('columnchange', 'true', 'int', 'J');
INSERT INTO adm_config ( parameter , value , datatype , desttype ) VALUES ('ctrlhiding', 'true', 'int', 'J');
INSERT INTO adm_config ( parameter , value , datatype , desttype ) VALUES ('doubleprotection', 'true', 'int', 'J');
INSERT INTO adm_config ( parameter , value , datatype , desttype ) VALUES ('alloweditmenu', 'true', 'int', 'J');
INSERT INTO adm_config ( parameter , value , datatype , desttype ) VALUES ('allowaddmenu', 'true', 'int', 'J');
UPDATE adm_config SET value = REPLACE (cast(value as varchar(1000)),'{"fct":"p_addContent.menu()","label":lg("lblAddContent"),"img":"ico_menu_add.gif","comment":lg("lblAddContent2"),"anonymous":true,"connected":true},','') WHERE parameter = 'headlinks';
UPDATE adm_config SET value = REPLACE (cast(value as varchar(1000)),'{"fct":"p_edit.menu()","label":lg("lblPersonalize"),"img":"ico_menu_tools.gif","comment":lg("lblPersonalize"),"anonymous":true,"connected":true},','') WHERE parameter = 'headlinks';
INSERT INTO adm_config ( parameter , value , datatype , desttype ) VALUES ('showrsscell', 'true', 'int', 'J');
INSERT INTO adm_config ( parameter , value , datatype , desttype ) VALUES ('showModuleSearch', 'true', 'int', 'J');
INSERT INTO adm_config ( parameter , value , datatype , desttype ) VALUES ('showModuleExpl', 'true', 'int', 'J');
INSERT INTO adm_config ( parameter , value , datatype , desttype ) VALUES ('portaldirtype', 'group', 'str', 'A');

>1.4.0;

ALTER TABLE profile ADD loadonstart TINYINT NULL ;
INSERT INTO adm_tabs_fct ( tabname , fctname , label , link , description ) VALUES ('configstab', 'featuresaccess', 'featuresAccess', 'admin/config_features.php', 'featuresAccessTxt');
CREATE TABLE adm_headlinks (id TINYINT NOT NULL ,label VARCHAR( 60 ) NOT NULL ,comment VARCHAR( 150 ) NOT NULL ,clss VARCHAR( 30 ) NOT NULL ,images VARCHAR( 60 ) NOT NULL ,fct VARCHAR( 100 ) NOT NULL ,status CHAR( 1 ) NOT NULL ,seq TINYINT NOT NULL );
CREATE CLUSTERED INDEX indcl_adm_headlinks ON adm_headlinks (id);
ALTER TABLE adm_headlinks ADD anonymous TINYINT NULL;
ALTER TABLE adm_headlinks ADD connected TINYINT NULL;
ALTER TABLE adm_headlinks ADD admin TINYINT NULL ;
INSERT INTO adm_headlinks VALUES (1, 'lblHelp', 'lblFirstUsage', '', '', 'openHelp()', 'O', 0, 1, 0, 0);
INSERT INTO adm_headlinks VALUES (2, 'lblAddContent', 'lblAddContent2', 'b', 'ico_menu_add.gif', 'p_addContent.menu()', 'O', 0, 1, 1, 0);
INSERT INTO adm_headlinks VALUES (3, 'lblArchive2', '', '', '', 'goIndex()', 'O', 0, 0, 1, 0);
INSERT INTO adm_headlinks VALUES (4, 'lblPersonalize', 'optionsOfThisPage', '', '', 'p_edit.menu()', 'O', 0, 1, 1, 0);
INSERT INTO adm_headlinks VALUES (5, 'lblSave', 'lblSavePage', 'b', 'ico_menu_disk.gif', 'showSave()', 'O', 0, 1, 0, 0);
INSERT INTO adm_headlinks VALUES (6, 'lblConnect', 'lblConnect', 'b', '', 'return connectBox()', 'O', 0, 1, 0, 0);
INSERT INTO adm_headlinks VALUES (7, 'lblDisconnect', 'lblDisconnect', 'b', '', 'logout()', 'O', 0, 0, 1, 1);
INSERT INTO adm_config ( parameter , value , datatype , desttype ) VALUES ('blockedModulePreventPageRemoval', 'true', 'int', 'J');
ALTER TABLE pages ADD style TINYINT DEFAULT '1' NOT NULL ;
ALTER TABLE users ADD description TEXT NULL;
ALTER TABLE users ADD picture VARCHAR( 200 ) NULL ;
UPDATE adm_tabs_fct SET description = 'appStatsTxt' WHERE label = 'appStats';
INSERT INTO adm_config ( parameter , value , datatype , desttype ) VALUES ('enterprise', 'false', 'int', 'A');

CREATE TABLE feed_articles (id INT IDENTITY(1,1) NOT NULL ,feed_id int NOT NULL ,title VARCHAR( 100 ) NOT NULL ,link TEXT NOT NULL ,description TEXT NOT NULL ,image VARCHAR( 255 ) NOT NULL ,video VARCHAR( 255 ) NOT NULL ,audio VARCHAR( 255 ) NOT NULL ,pubdate VARCHAR( 40 ) NOT NULL ,uniqid VARCHAR( 255 ) NOT NULL ,
CONSTRAINT pk_feed_articles PRIMARY KEY CLUSTERED ( id ) );
CREATE TABLE feed_articles_read (article_id INT NOT NULL ,user_id int NOT NULL ,status TINYINT NOT NULL);
CREATE CLUSTERED INDEX indcl_feed_articles_read ON feed_articles_read (article_id);
INSERT INTO adm_config ( parameter , value , datatype , desttype ) VALUES ('registerfeeds', 'true', 'int', 'A');
ALTER TABLE dir_rss ADD lastloadedid VARCHAR( 255 ) NULL ;
ALTER TABLE dir_rss ADD lastloadedtime DATETIME NULL ;
ALTER TABLE adm_tabs ADD CONSTRAINT uniq_tab_name UNIQUE ( name );
ALTER TABLE adm_tabs_fct ADD CONSTRAINT uniq_fct_name UNIQUE ( fctname ) ;
ALTER TABLE dir_rss ADD title VARCHAR( 100 ) NULL;
ALTER TABLE dir_rss ADD auth VARCHAR( 64 );
ALTER TABLE temp_dir_item ALTER COLUMN typ CHAR( 1 );
ALTER TABLE temp_dir_item ALTER COLUMN status CHAR( 1 );
ALTER TABLE temp_dir_item ALTER COLUMN format CHAR( 1 );
ALTER TABLE temp_dir_item ALTER COLUMN sizable CHAR( 1 );
ALTER TABLE temp_dir_item ALTER COLUMN updated CHAR( 1 );
ALTER TABLE temp_dir_item ALTER COLUMN keywords VARCHAR( 250 );
ALTER TABLE dir_rss ALTER COLUMN title VARCHAR( 100 );
ALTER TABLE dir_rss ALTER COLUMN auth VARCHAR( 64 );
ALTER TABLE dir_rss ALTER COLUMN lastloadedid VARCHAR( 255 );

> 1.4.1;

ALTER TABLE adm_headlinks ADD CONSTRAINT uniq_admheadlinks UNIQUE ( id , label , anonymous , connected , admin );
ALTER TABLE adm_headlinks ALTER COLUMN images VARCHAR( 100 );

> 1.4.2;

UPDATE adm_config SET value=REPLACE(cast(value as varchar(1000)),'français','fran&ccedil;ais') WHERE parameter='headlinks';
ALTER TABLE module ADD x SMALLINT NULL;
ALTER TABLE module ADD y SMALLINT NULL ;
ALTER TABLE pages_module ADD x SMALLINT NULL;
ALTER TABLE pages_module ADD y SMALLINT NULL ;
ALTER TABLE portals_module ADD x SMALLINT NULL;
ALTER TABLE portals_module ADD y SMALLINT NULL ;
INSERT INTO adm_config ( parameter , value , datatype , desttype ) VALUES ('moduleAlign', 'true', 'int', 'J');
INSERT INTO adm_config ( parameter , value , datatype , desttype ) VALUES ('moduleAlignDefault', 'true', 'int', 'J');
ALTER TABLE profile ADD modulealign CHAR( 1 ) DEFAULT 'Y' NOT NULL ;
ALTER TABLE pages ADD modulealign CHAR( 1 ) DEFAULT 'Y' NOT NULL ;
ALTER TABLE portals ADD modulealign CHAR( 1 ) DEFAULT 'Y' NOT NULL ;
ALTER TABLE feed_articles ALTER COLUMN link TEXT;
ALTER TABLE users_favorites_id ALTER COLUMN status CHAR( 1 ) ;
ALTER TABLE users_tasks_id ALTER COLUMN status CHAR( 1 ) ;
ALTER TABLE users_calendar ALTER COLUMN comments VARCHAR( 250 );
ALTER TABLE users_calendar ALTER COLUMN time VARCHAR( 5 );
ALTER TABLE users_calendar ALTER COLUMN ampm CHAR( 1 );
ALTER TABLE users_calendar ALTER COLUMN endtime VARCHAR( 5 );

INSERT INTO adm_config VALUES ('homeDivs', '', 'arr', 'J');
UPDATE adm_config SET desttype = 'A' WHERE parameter = 'POSHVERSION';
INSERT INTO adm_config VALUES ('application', 'P.O.S.H', 'str', 'A');
ALTER TABLE users ADD stat VARCHAR( 200 );
UPDATE dir_item SET minwidth = '320' WHERE id =295 ;

> 1.4.3;

ALTER TABLE dir_category ADD secured TINYINT NULL ;
CREATE TABLE users_group_category_map (group_id SMALLINT NOT NULL ,category_id SMALLINT NOT NULL);
CREATE CLUSTERED INDEX indcl_users_group_category_map ON users_group_category_map (group_id);
ALTER TABLE profile ADD type CHAR( 1 ) NOT NULL DEFAULT '1';
ALTER TABLE profile ADD param VARCHAR( 150 );

INSERT INTO adm_config VALUES ('loadlatestpageonstart', 'true', 'int', 'J');
UPDATE adm_headlinks SET id=id+1 WHERE label='lblSave';
INSERT INTO adm_headlinks (id,label,comment,clss,images,fct,status,seq,anonymous,connected,admin) SELECT id-1,'lblHelp','','','','p_help.open()','O',0,1,1,0 FROM adm_headlinks WHERE label='lblSave';
UPDATE adm_config SET desttype='A' WHERE parameter='SUPPORTEMAIL';
ALTER TABLE dir_item ALTER COLUMN url VARCHAR( 250 );
ALTER TABLE temp_dir_item ALTER COLUMN url VARCHAR( 250 );

> 1.4.4;

ALTER TABLE users ADD extra VARCHAR( 250 ) ;
INSERT INTO adm_config VALUES ('template', 'default', 'str', 'A');
UPDATE adm_config SET value = REPLACE(cast(value as varchar(1000)),'jsprof','p_tabs.selId') WHERE  parameter = 'option';
INSERT INTO adm_config VALUES ('maxPageNb', '30', 'int', 'J');
ALTER TABLE search_keyword ADD label_simplified VARCHAR( 30 );
UPDATE search_keyword SET label_simplified=label;
CREATE INDEX indcl_search_keyword ON search_keyword (label_simplified);

> 1.5.2;

INSERT INTO adm_config VALUES ('refreshFeedsDelai', '1800', 'int', 'A');
INSERT INTO adm_config VALUES ('feedsAutoLoading', 'false', 'int', 'A');
CREATE TABLE widget_addressbook (add_id INT IDENTITY(1,1) NOT NULL,id INT NOT NULL ,firstname varchar(30) NOT NULL ,lastname varchar(30) NOT NULL ,email varchar(60) NOT NULL ,company varchar(60) NOT NULL ,func varchar(30) NOT NULL ,phone1 varchar(30) NOT NULL ,phone2 varchar(30) NOT NULL ,other varchar(150) NOT NULL ,tags varchar(100) ,
CONSTRAINT pk_widget_addressbook PRIMARY KEY CLUSTERED  (add_id))  ;
CREATE TABLE widget_addressbook_id (id INT IDENTITY(1,1) NOT NULL,user_id INT ,status char(1) ,
CONSTRAINT pk_widget_addressbook_id PRIMARY KEY CLUSTERED  (id))  ;
ALTER TABLE feed_articles_read ADD CONSTRAINT pk_feed_articles_read PRIMARY KEY ( article_id , user_id );
INSERT INTO adm_tabs_fct ( tabname , fctname , label , link , description ) VALUES ('configstab', 'langtab', 'langSelection', 'admin/config_lang.php', 'langSelectionTxt');

> 1.5.3;

ALTER TABLE module ADD CONSTRAINT module_unique UNIQUE ( user_id , profile_id , uniq ) ;

> 1.5.4;

ALTER TABLE pages ADD controls CHAR( 1 ) DEFAULT 'Y';
ALTER TABLE dir_cat_item ALTER COLUMN first CHAR( 1 );
ALTER TABLE feed_articles ALTER COLUMN image VARCHAR( 255 );
ALTER TABLE feed_articles ALTER COLUMN video VARCHAR( 255 );
ALTER TABLE feed_articles ALTER COLUMN audio VARCHAR( 255 );
ALTER TABLE feed_articles ALTER COLUMN pubdate VARCHAR( 40 );
ALTER TABLE feed_articles ALTER COLUMN uniqid VARCHAR( 255 ) ;
ALTER TABLE profile ALTER COLUMN cacheurl VARCHAR( 36 );
ALTER TABLE profile ALTER COLUMN param VARCHAR( 150 ) ;
ALTER TABLE temp_category ALTER COLUMN pass CHAR( 1 )  ;
ALTER TABLE temp_dir_cat_item ALTER COLUMN first CHAR( 1 );
ALTER TABLE temp_dir_item ALTER COLUMN keywords VARCHAR( 250 ) ;
ALTER TABLE users ALTER COLUMN description TEXT;
ALTER TABLE users ALTER COLUMN picture VARCHAR( 200 );
ALTER TABLE users ALTER COLUMN stat VARCHAR( 200 ) ;
ALTER TABLE users_calendar ALTER COLUMN comments VARCHAR( 250 );
ALTER TABLE users_calendar ALTER COLUMN time VARCHAR( 5 ) ;
ALTER TABLE users_tasks ALTER COLUMN comments VARCHAR( 250 ) ;
ALTER TABLE widget_addressbook ALTER COLUMN firstname VARCHAR( 30 );
ALTER TABLE widget_addressbook ALTER COLUMN lastname VARCHAR( 30 );
ALTER TABLE widget_addressbook ALTER COLUMN email VARCHAR( 60 );
ALTER TABLE widget_addressbook ALTER COLUMN company VARCHAR( 60 );
ALTER TABLE widget_addressbook ALTER COLUMN func VARCHAR( 30 );
ALTER TABLE widget_addressbook ALTER COLUMN phone1 VARCHAR( 30 );
ALTER TABLE widget_addressbook ALTER COLUMN phone2 VARCHAR( 30 );
ALTER TABLE widget_addressbook ALTER COLUMN other VARCHAR( 150 ) ;

> 2.0.0;

UPDATE adm_config SET desttype = 'A' WHERE parameter = 'AVLANGS';
INSERT INTO adm_config VALUES ('NOTIFICATIONEMAIL', '', 'str', 'P');
INSERT INTO adm_tabs_fct ( tabname , fctname , label , link , description ) VALUES ('configstab', 'notifications', 'appNotificationConfiguration', 'admin/config_notifications.php', 'appNotificationConfigurationTxt');
CREATE TABLE adm_mail (id INT IDENTITY(1,1) NOT NULL,libelle varchar(20) NOT NULL ,lang varchar(2) NOT NULL ,subject varchar(100) NOT NULL ,message text NOT NULL,sender varchar(60) ,copy varchar(200) ,
CONSTRAINT pk_adm_mail PRIMARY KEY CLUSTERED  (id));
SET IDENTITY_INSERT adm_mail ON;
INSERT INTO adm_mail(id,libelle,lang,subject,message,sender,copy) VALUES (1, 'validInscription', 'fr', 'Validation de votre inscription sur %site', 'Bonjour,\r\n\r\nFélicitation pour la création de votre compte.\r\nVoici vos informations personnelles de connection :\r\nemail: %email\r\nPassword: %password\r\n\r\nCes paramètres vous donneront accès à votre compte.\r\n\r\nCordialement\r\n%site\r\n%link\r\n\r\n%unsuscribe', NULL, NULL);
INSERT INTO adm_mail(id,libelle,lang,subject,message,sender,copy) VALUES (2, 'validInscription', 'en', 'Confirmation of your subscription of %site', 'Hello,\r\n\r\nCongratulations for creating your brand new account. \r\nHere is your personal connection information :\r\nemail: %email\r\nPassword: %password\r\n\r\nThese parameters will give you access to your account.\r\n\r\nBest regards\r\n%site\r\n%link\r\n\r\n%unsuscribe', NULL, NULL);
INSERT INTO adm_mail(id,libelle,lang,subject,message,sender,copy) VALUES (3, 'validWidget', 'fr', 'Validation de votre widget sur %site', 'Bonjour,\r\n\r\nFélicitation, votre widget "%description" a été validé par un administrateur.\r\nVous pouvez l''utiliser dès à présent dans votre portail.\r\n\r\nCordialement\r\n%site\r\n%link\r\n\r\n%unsuscribe', NULL, NULL);
INSERT INTO adm_mail(id,libelle,lang,subject,message,sender,copy) VALUES (4, 'validWidget', 'en', 'Validation of your widget on %site', 'Hello,\r\n\r\nCongratulations, your widget %description has been validated by an administrator. \r\nFrom now on, you can use it in your portal.\r\n\r\nSee you soon,\r\n%site\r\n%link', NULL, NULL);
INSERT INTO adm_mail(id,libelle,lang,subject,message,sender,copy) VALUES (5, 'getPassword', 'fr', 'Mot de passe mit a jour sur %site', 'Bonjour,\r\n\r\nSuite à votre demande, nous avons réinitialisé votre mot de passe. \r\n\r\nVoici vos identifiants:\r\nmail : %email\r\npassword : %password\r\n\r\nCordialement,\r\n%site\r\n%link\r\n\r\n\r\n%unsuscribe', NULL, NULL);
INSERT INTO adm_mail(id,libelle,lang,subject,message,sender,copy) VALUES (6, 'getPassword', 'en', 'Password updated on %site', 'Hello,\r\n\r\nYour password has been reset as requested. Here is your new account informations :\r\n\r\nemail:%email\r\npassword:%password\r\n\r\nSee you soon,\r\n%site\r\n%link\r\n\r\n%unsuscribe', NULL, NULL);
SET IDENTITY_INSERT adm_mail OFF;
ALTER TABLE dir_rss ADD proxy VARCHAR( 50 );
ALTER TABLE dir_rss ADD lastaccess DATE;
DELETE FROM adm_headlinks WHERE label IN ('lblHelp','lblAddContent','lblArchive2','lblPersonalize','lblSave','lblConnect','lblDisconnect','lblHelp');
ALTER TABLE adm_headlinks ADD uniq_id VARCHAR( 30 ) NULL;
ALTER TABLE adm_headlinks ADD type VARCHAR( 30 ) DEFAULT 'link' NOT NULL ;
INSERT INTO adm_headlinks (id,uniq_id,type,label,comment,clss,images,fct,status,seq,anonymous,connected,admin) VALUES (1,'lab_hello','label','lblHello','','','','','O',1,0,1,1);
INSERT INTO adm_headlinks (id,uniq_id,type,label,comment,clss,images,fct,status,seq,anonymous,connected,admin) VALUES (2,'link_name','link','%username%','','','','p_network.myprofile()','O',2,0,1,1);
INSERT INTO adm_headlinks (id,uniq_id,type,label,comment,clss,images,fct,status,seq,anonymous,connected,admin) VALUES (3,'lab_par1','label','(','','','','','O',3,0,1,1);
INSERT INTO adm_headlinks (id,uniq_id,type,label,comment,clss,images,fct,status,seq,anonymous,connected,admin) VALUES (4,'link_logout','link','lblDisconnect','lblDisconnect','','','$p.app.logout()','O',4,0,1,1);
INSERT INTO adm_headlinks (id,uniq_id,type,label,comment,clss,images,fct,status,seq,anonymous,connected,admin) VALUES (5,'lab_par2','label',')','','','','','O',5,0,1,1);
INSERT INTO adm_headlinks (id,uniq_id,type,label,comment,clss,images,fct,status,seq,anonymous,connected,admin) VALUES (6,'lab_sep1','label','|','','','','','O',6,0,1,0);
INSERT INTO adm_headlinks (id,uniq_id,type,label,comment,clss,images,fct,status,seq,anonymous,connected,admin) VALUES (7,'link_menu','link','menu','menu','b','ico_menu.gif','$p.app.menu.open()','O',7,1,1,0);
INSERT INTO adm_headlinks (id,uniq_id,type,label,comment,clss,images,fct,status,seq,anonymous,connected,admin) VALUES (8,'lab_sep3','label','|','','','','','O',8,1,0,0);
INSERT INTO adm_headlinks (id,uniq_id,type,label,comment,clss,images,fct,status,seq,anonymous,connected,admin) VALUES (9,'link_save','link','lblSave','lblSavePage','b','ico_menu_disk.gif','$p.app.connection.saveMenu()','O',9,1,0,0);
INSERT INTO adm_headlinks (id,uniq_id,type,label,comment,clss,images,fct,status,seq,anonymous,connected,admin) VALUES (10,'lab_sep4','label','|','','','','','O',10,1,0,0);
INSERT INTO adm_headlinks (id,uniq_id,type,label,comment,clss,images,fct,status,seq,anonymous,connected,admin) VALUES (11,'link_login','link','lblConnect','lblConnect','b','','$p.app.connection.menu()','O',11,1,0,0);
ALTER TABLE users ALTER COLUMN description TEXT;
ALTER TABLE users ALTER COLUMN picture VARCHAR( 200 );
ALTER TABLE users ALTER COLUMN stat VARCHAR( 200 ) ;
ALTER TABLE dir_item ALTER COLUMN name VARCHAR( 50 ) ;
ALTER TABLE dir_rss ALTER COLUMN lastloadedid VARCHAR( 255 );
ALTER TABLE dir_rss ALTER COLUMN lastloadedtime DATETIME;
ALTER TABLE dir_rss ALTER COLUMN proxy VARCHAR( 50 );
ALTER TABLE dir_rss ALTER COLUMN lastaccess DATE;
CREATE TABLE applications (id SMALLINT IDENTITY(1,1) NOT NULL,title VARCHAR( 60 ) NOT NULL ,description TEXT NOT NULL ,creation_date DATE NOT NULL ,icon VARCHAR( 150 ) NOT NULL ,action VARCHAR( 150 ) NOT NULL ,
CONSTRAINT pk_applications PRIMARY KEY CLUSTERED ( id ) );
CREATE TABLE applications_groups_map (application_id int NOT NULL ,group_id SMALLINT NOT NULL ,
CONSTRAINT pk_applications_groups_map PRIMARY KEY CLUSTERED ( application_id , group_id ) );
SET IDENTITY_INSERT adm_tabs ON;
INSERT INTO adm_tabs ( id , name , label , type , param ) VALUES ('5', 'applicationtab', 'applications', '4', 'admin/applications.php');
SET IDENTITY_INSERT adm_tabs OFF;
INSERT INTO adm_tabs_fct ( tabname , fctname , label , link , description ) VALUES ('applicationtab', 'applicationsaccess', 'applicationsAccess', 'admin/application_management.php', '');
ALTER TABLE pages ADD icon VARCHAR( 100 ) ;
ALTER TABLE dir_cat_item ALTER COLUMN first CHAR( 1 );
ALTER TABLE feed_articles ALTER COLUMN image VARCHAR( 255 );
ALTER TABLE feed_articles ALTER COLUMN video VARCHAR( 255 );
ALTER TABLE feed_articles ALTER COLUMN audio VARCHAR( 255 );
ALTER TABLE feed_articles ALTER COLUMN pubdate VARCHAR( 40 );
ALTER TABLE feed_articles ALTER COLUMN uniqid VARCHAR( 255 ) ;
ALTER TABLE profile ALTER COLUMN cacheurl VARCHAR( 36 );
ALTER TABLE profile ALTER COLUMN param VARCHAR( 150 ) ;
ALTER TABLE temp_category ALTER COLUMN pass CHAR( 1 )  ;
ALTER TABLE temp_dir_cat_item ALTER COLUMN first CHAR( 1 );
ALTER TABLE temp_dir_item ALTER COLUMN keywords VARCHAR( 250 ) ;
ALTER TABLE users ALTER COLUMN description TEXT;
ALTER TABLE users ALTER COLUMN picture VARCHAR( 200 );
ALTER TABLE users ALTER COLUMN stat VARCHAR( 200 ) ;
ALTER TABLE users_calendar ALTER COLUMN comments VARCHAR( 250 );
ALTER TABLE users_calendar ALTER COLUMN time VARCHAR( 5 ) ;
ALTER TABLE users_tasks ALTER COLUMN comments VARCHAR( 250 ) ;
ALTER TABLE widget_addressbook ALTER COLUMN firstname VARCHAR( 30 );
ALTER TABLE widget_addressbook ALTER COLUMN lastname VARCHAR( 30 );
ALTER TABLE widget_addressbook ALTER COLUMN email VARCHAR( 60 );
ALTER TABLE widget_addressbook ALTER COLUMN company VARCHAR( 60 );
ALTER TABLE widget_addressbook ALTER COLUMN func VARCHAR( 30 );
ALTER TABLE widget_addressbook ALTER COLUMN phone1 VARCHAR( 30 );
ALTER TABLE widget_addressbook ALTER COLUMN phone2 VARCHAR( 30 );
ALTER TABLE widget_addressbook ALTER COLUMN other VARCHAR( 150 ) ;
ALTER TABLE module ADD old_id TINYINT ;
ALTER TABLE profile ADD old_id TINYINT ;
UPDATE profile SET old_id=id;
UPDATE module SET old_id=profile_id;
ALTER TABLE profile DROP COLUMN id ;
ALTER TABLE profile ADD id INT IDENTITY(1,1) NOT NULL 
CONSTRAINT pk_profile PRIMARY KEY;
ALTER TABLE module DROP CONSTRAINT module_unique ;
CREATE INDEX indcl_module2 ON module (profile_id, uniq);
INSERT INTO adm_config (parameter,value,datatype,desttype) VALUES ('menuDefaultStatus','1','int','J');
UPDATE adm_config SET value='2' WHERE parameter='loadlatestpageonstart';
INSERT INTO adm_tabs_fct VALUES ('userstab', 'usersinfos', 'userInfos', 'admin/users_infos_config.php', 'userInfos');
CREATE TABLE adm_userinfo ( id INT IDENTITY(1,1) NOT NULL, label varchar(100) NOT NULL , type varchar(50) NOT NULL , options varchar(200) , mandatory TINYINT NOT NULL , editable TINYINT NOT NULL , "public" TINYINT NOT NULL , 
CONSTRAINT pk_adm_userinfo PRIMARY KEY CLUSTERED  (id)) ;
CREATE TABLE users_info ( user_id INT NOT NULL , info_id INT NOT NULL , parameters text, ispublic TINYINT NOT NULL , 
CONSTRAINT pk_users_info PRIMARY KEY CLUSTERED  (user_id,info_id) ) ;
INSERT INTO adm_config ( parameter , value , datatype , desttype ) VALUES ('useChat', 'false', 'int', 'J');
CREATE TABLE widget_html (id INT IDENTITY(1,1) NOT NULL,user_id int NOT NULL ,content text ,
CONSTRAINT pk_widget_html PRIMARY KEY CLUSTERED  (id)) ;
ALTER TABLE users ADD activity CHAR( 1 ) DEFAULT 'x' NOT NULL ;
INSERT INTO adm_config (parameter ,value ,datatype ,desttype) VALUES ('addPagePermission', 'true', 'int', 'J');
INSERT INTO adm_config (parameter ,value ,datatype ,desttype) VALUES ('displayAllLanguageModules', 'true', 'int', 'J');
INSERT INTO adm_config (parameter ,value ,datatype ,desttype) VALUES ('userChangePermission', 'true', 'int', 'J');
INSERT INTO adm_config (parameter ,value ,datatype ,desttype) VALUES ('passwordChangePermission', 'true', 'int', 'J');
INSERT INTO adm_config (parameter ,value ,datatype ,desttype) VALUES ('showModuleRefresh', 'true', 'int', 'J');
INSERT INTO adm_config (parameter ,value ,datatype ,desttype) VALUES ('showModuleClose', 'true', 'int', 'J');
INSERT INTO adm_config (parameter ,value ,datatype ,desttype) VALUES ('showModuleConfigure', 'true', 'int', 'J');
INSERT INTO adm_config (parameter ,value ,datatype ,desttype) VALUES ('showModuleMinimize', 'true', 'int', 'J');
INSERT INTO adm_config (parameter ,value ,datatype ,desttype) VALUES ('showModuleTitle', 'true', 'int', 'J');
ALTER TABLE module ADD feed_id int ;
ALTER TABLE feed_articles ADD source VARCHAR( 255 ) NULL ;
INSERT INTO adm_config ( parameter , value , datatype , desttype ) VALUES ('getNbArticleOfArchive', 'true', 'int', 'P');
INSERT INTO adm_config ( parameter , value , datatype , desttype ) VALUES ('usePrivateModules', 'true', 'int', 'J');
INSERT INTO adm_config ( parameter , value , datatype , desttype ) VALUES ('useRssDelete', 'false', 'int', 'J');
INSERT INTO adm_config ( parameter , value , datatype , desttype ) VALUES ('displayrsssource', 'false', 'int', 'J');
INSERT INTO adm_config ( parameter , value , datatype , desttype ) VALUES ('displayrssimages', '2', 'int', 'J');
UPDATE adm_config SET value = '1' WHERE parameter = 'displayrssdesc' ;
CREATE TABLE adm_tabs_map ( user_id INT NOT NULL , tab_id TINYINT NOT NULL , 
CONSTRAINT pk_adm_tabs_map PRIMARY KEY CLUSTERED  (user_id,tab_id) ) ;
UPDATE adm_config SET value='0' WHERE parameter='showHomeBar';
ALTER TABLE profile ADD status TINYINT;
ALTER TABLE profile ADD page_id TINYINT ;
INSERT INTO adm_config ( parameter , value , datatype , desttype ) VALUES ('rand', 'abc', 'str', 'P');
INSERT INTO adm_config VALUES ('displayThemeSelector', 'true', 'int', 'J');
INSERT INTO adm_config VALUES ('displayPublicPages', 'true', 'int', 'J');
ALTER TABLE dir_cat_item ADD CONSTRAINT pk_dir_cat_item PRIMARY KEY ( item_id , category_id );
CREATE INDEX indcl_search_index2 ON search_index (kw_id);
CREATE INDEX indcl_search_index_itemid ON search_index (item_id);
CREATE INDEX indcl_users_group_category_map_groupid ON users_group_category_map (group_id);
CREATE INDEX indcl_users_group_category_map_categoryid ON users_group_category_map (category_id);
CREATE INDEX indcl_users_group_map_userid ON users_group_map (user_id);
CREATE INDEX indcl_users_group_map_groupid ON users_group_map (group_id);
ALTER TABLE users ADD keywords VARCHAR( 255 ) ;
INSERT INTO adm_config VALUES ('tabType', 'navigator', 'str', 'J');
UPDATE dir_item SET name = 'RSS',description = '' WHERE id =86;
ALTER TABLE feed_articles ADD loaddate DATE ;
INSERT INTO adm_tabs_map (user_id, tab_id) SELECT users.id,adm_tabs.id FROM users,adm_tabs WHERE users.typ='A';

> 2.0.1;

DELETE FROM adm_tabs_map;
INSERT INTO adm_tabs_map (user_id, tab_id) SELECT users.id,adm_tabs.id FROM users,adm_tabs WHERE users.typ='A';
UPDATE adm_config SET value='false' WHERE parameter='getNbArticleOfArchive';
CREATE INDEX indcl_dir_item_status ON dir_item (status);
INSERT INTO adm_config ( parameter , value , datatype , desttype ) VALUES ('themeList', '"default"', 'arr', 'J');
UPDATE adm_config SET value = REPLACE(cast(value as varchar(1000)),'p_tabs.selId','$p.app.tabs.selId') WHERE  parameter = 'option';

> 2.0.2;

INSERT INTO adm_config ( parameter , value , datatype , desttype ) VALUES ('displayOnlyPublicPagesForTheUser', 'true', 'int', 'A');
CREATE TABLE translation ( id INT IDENTITY(1,1) NOT NULL,  label varchar(255) NOT NULL,  message text,  lang varchar(2) NOT NULL,  status VARCHAR(30) default 'translation',  translation_status VARCHAR(30) default 'pending',typefile INT NOT NULL, usage_label INT NOT NULL, modifier VARCHAR(30) , last_updated INT ,
CONSTRAINT pk_translation PRIMARY KEY CLUSTERED  (id),  CONSTRAINT un_label_lang_usage UNIQUE (label,lang,usage_label));
CREATE INDEX indcl_translation_label ON translation (label);
CREATE TABLE app_contact (  dest_id INT IDENTITY(1,1) NOT NULL,  user_id INT NOT NULL,  email varchar(255) NOT NULL,   texte text ,   modifdate datetime ,    name varchar(255) ,    titre varchar(255) ,  statut varchar(255) , 
CONSTRAINT pk_app_contact PRIMARY KEY CLUSTERED  (dest_id));
UPDATE adm_config SET datatype='int' WHERE parameter='useRssDelete';
UPDATE adm_config SET datatype='int' WHERE parameter='displayrsssource';
INSERT INTO adm_config ( parameter , value , datatype , desttype ) VALUES ('showTabOptions', 'true', 'int', 'J');
INSERT INTO adm_config ( parameter , value , datatype , desttype ) VALUES ('moveWidgetsInTabs', 'true', 'int', 'J');
INSERT INTO adm_mail(libelle,lang,subject,message) VALUES ( 'emailConfirmation', 'fr', 'Confirmation de votre inscription sur %site', 'Bonjour,\r\n\r\nNous avons bien enregistré vos paramètres personnels mais votre compte n`est pas encore activé.\r\nPour valider votre compte, veuillez cliquer sur le lien suivant : %linkportal/login.php?id=%id&chk=%key\r\n\r\nMerci et à bientôt sur %site.\r\n%link\r\n\r\n%unsuscribe');
INSERT INTO adm_mail(libelle,lang,subject,message) VALUES ( 'emailConfirmation', 'en', 'Confirmation of your subscription on %site', 'Hello,\r\n\r\nWe have take in account your personal parameters but your account is not yet validated.\r\nTo validate your account, please click on the following link : %linkportal/login.php?id=%id&chk=%key\r\n\r\nSee you soon on %site.\r\n%link\r\n\r\n%unsuscribe');

> 2.0.3;

UPDATE adm_headlinks SET images='' WHERE uniq_id = 'link_menu';
CREATE TABLE users_control (login varchar(60) NOT NULL, ip varchar(11) NOT NULL, date datetime NOT NULL, number_of_try tinyint NOT NULL DEFAULT 0, 
CONSTRAINT pk_users_control PRIMARY KEY CLUSTERED  (login,ip,date));
INSERT INTO adm_config ( parameter , value , datatype , desttype ) VALUES ('numberOfTry','0','int','P');
INSERT INTO adm_config ( parameter , value , datatype , desttype ) VALUES ('connectionDateRange','3600','int','P');
INSERT INTO adm_config ( parameter , value , datatype , desttype ) VALUES ('captcha','false','int','A');
CREATE TABLE captcha_codes (id varchar(60) NOT NULL, code varchar(11) NOT NULL, 
CONSTRAINT pk_captcha_codes PRIMARY KEY CLUSTERED  (id));

> 2.0.4;

INSERT INTO adm_mail(libelle,lang,subject,message) VALUES ( 'getNewPassword', 'fr','Obtenir un nouveau mot de passe sur %site', 'Bonjour,\r\n\r\nSuite à votre demande, nous vous envoyons ce lien pour réinitialiser votre mot de passe.\r\n%setnewpwd\r\n\r\nCordialement\r\n%link\n%site\r\n\r\n%unsuscribe');
INSERT INTO adm_mail(libelle,lang,subject,message) VALUES ( 'getNewPassword', 'en','Get a new password on %site', 'Hello,\r\n\r\nFollowing your request\r\n\r\nWe send you this link to change your password.\r\n\r\n%setnewpwd\r\n\r\nBest regards\n%link\r\n%site\r\n\r\n%unsuscribe');
INSERT INTO adm_mail(libelle,lang,subject,message) VALUES ( 'getNewPassword', 'de','Get a new password on %site', 'Hello,\r\n\r\nFollowing your request\r\n\r\nWe send you this link to change your password.\r\n\r\n%setnewpwd\r\n\r\nBest regards\n%link\r\n%site\r\n\r\n%unsuscribe');
INSERT INTO adm_mail(libelle,lang,subject,message) VALUES ( 'getNewPassword', 'es','Get a new password on %site', 'Hello,\r\n\r\nFollowing your request\r\n\r\nWe send you this link to change your password.\r\n\r\n%setnewpwd\r\n\r\nBest regards\n%link\r\n%site\r\n\r\n%unsuscribe');
INSERT INTO adm_mail(libelle,lang,subject,message) VALUES ( 'getNewPassword', 'it','Get a new password on %site', 'Hello,\r\n\r\nFollowing your request\r\n\r\nWe send you this link to change your password.\r\n\r\n%setnewpwd\r\n\r\nBest regards\n%link\r\n%site\r\n\r\n%unsuscribe');
INSERT INTO adm_config VALUES ('MD5KEY', '', 'str', 'A');
ALTER TABLE module ALTER COLUMN variables TEXT NULL ;
INSERT INTO adm_config (parameter,value,datatype,desttype) VALUES ('SESSION','myhomepage','str','P');
UPDATE adm_config SET desttype='P' WHERE parameter='MD5KEY';

> 2.0.5;

INSERT INTO adm_config (parameter,value,datatype,desttype) VALUES ('tabsCanBeRenamed','true','int','J');
INSERT INTO adm_config (parameter ,value ,datatype ,desttype ) VALUES ('widgetTitleUpdatable', 'true', 'int', 'J');
UPDATE adm_config SET value='false' WHERE parameter='showicon';

> 2.1.0a1;

DELETE FROM adm_config WHERE parameter='MD5KEY';
ALTER TABLE adm_config ADD category VARCHAR( 20 );
UPDATE adm_config SET category = 'yourApplication' WHERE parameter IN ('APPNAME','IPADD','LOCALFOLDER','USERMODULE');
UPDATE adm_config SET category = 'dbConnection' WHERE parameter IN ('server','login','db','useproxy','proxyserver','proxyport','proxypacfile');
UPDATE adm_config SET category = 'adminInterface' WHERE parameter IN ('usegroup');
UPDATE adm_config SET category = 'thePortals' WHERE parameter IN ('loadlatestpageonstart','defaultmode','menuDefaultStatus','accounttype','menuposition','moduleAlignDefault','maxPageNb','showHomeBar','blockedModulePreventPageRemoval','addPagePermission','footer','useconditions','passwordChangePermission','debugmode','numberOfTry','userChangePermission','captcha','connectionDateRange');
UPDATE adm_config SET category = 'theFeeds' WHERE parameter IN ('displayrssdesc','displayrsssource','displayrssimages');
UPDATE adm_config SET category = 'theModules' WHERE parameter IN ('showicon','useoverview','maxModNb','txtnote','rssrefreshdelay','displayAllLanguageModules','showModuleClose','showModuleRefresh','showModuleConfigure','showModuleMinimize','showModuleTitle');
UPDATE adm_config SET category = 'emailSending' WHERE parameter IN ('supportemail','notificationemail','friendemail');
UPDATE adm_config SET desttype='A' WHERE parameter='NOTIFICATIONEMAIL';
UPDATE adm_config SET desttype='A' WHERE parameter='APPNAME';
UPDATE adm_config SET desttype='A' WHERE parameter='defaultmode';
CREATE TABLE adm_group_map (user_id INT NOT NULL ,group_id INT NOT NULL , CONSTRAINT users_group2 UNIQUE(user_id,group_id));
CREATE CLUSTERED INDEX indcl_adm_group_map2 ON adm_group_map (user_id, group_id);
CREATE INDEX indcl_adm_group_map_userid ON adm_group_map (user_id);
ALTER TABLE users ADD statdate DATE;
ALTER TABLE module ADD shared VARCHAR( 33 ) ;
ALTER TABLE profile ADD shared VARCHAR( 16 );
UPDATE adm_config SET desttype = 'A' WHERE parameter = 'usereader' ;
UPDATE adm_headlinks SET fct='$p.network.myprofile()' WHERE fct='p_network.myprofile()';
UPDATE adm_headlinks SET comment='Search' WHERE comment='search';
INSERT INTO adm_config (parameter,value,datatype,desttype) VALUES ('displayRssDate','true','int','J');
INSERT INTO adm_config (parameter ,value ,datatype ,desttype ) VALUES ('useNetwork', 'false', 'int', 'J');
INSERT INTO adm_config (parameter ,value ,datatype ,desttype ) VALUES ('useNotebook', 'false', 'int', 'J');
ALTER TABLE adm_headlinks ADD position VARCHAR( 10 ) DEFAULT 'right' NOT NULL ;
UPDATE adm_headlinks SET seq=38,position='left' WHERE uniq_id='lab_sep3';
UPDATE adm_headlinks SET label='menu',comment='menu',seq=40,position='left',clss='' WHERE uniq_id='link_menu';
INSERT INTO adm_headlinks ( id , uniq_id , type , label , comment , clss , images , fct , status , seq , anonymous , connected , admin , position ) VALUES ('0', 'link_widgets', 'link', 'lblAddContent', 'lblAddContent', '', 'ico_menu_add.gif', '$p.app.menu.widget.open()', 'O', '9', '1', '1', '0', 'left'), ('0', 'lab_sep10', 'label', '|', '', '', '', '', 'O', '10', '1', '1', '0', 'left');
CREATE TABLE dir_item_external (item_id INT NOT NULL,source text NOT NULL, xmlmodule text NOT NULL,  url varchar(255) NOT NULL,  last_updated datetime NOT NULL,  status VARCHAR(30) NOT NULL,  CONSTRAINT item_id UNIQUE (item_id) );
CREATE INDEX indcl_dir_item_external_itemid ON dir_item_external (item_id);
CREATE TABLE dir_item_external_language (item_id INT NOT NULL,lang varchar(3) NOT NULL,   url varchar(255) NOT NULL,source text NOT NULL,last_updated datetime NOT NULL);
CREATE CLUSTERED INDEX indcl_dir_item_external_language2 ON dir_item_external_language (item_id, lang);
INSERT INTO adm_config (parameter ,value ,datatype ,desttype ) VALUES ('uploadMaxFileSize', '30000000', 'int', 'P');
INSERT INTO adm_config (parameter ,value ,datatype ,desttype ) VALUES ('uploadAllowedExtensions', '.pdf,.doc,.txt,.jpg,.png,.bmp,.gif,.xls,.ppt,.pps,.odt,.rtf', 'str', 'P');
UPDATE adm_tabs SET type=5;
SET IDENTITY_INSERT adm_tabs ON;
INSERT INTO adm_tabs( id , name , label , type , param ) VALUES (8, 'supporttab', 'Support', 5, 'admin/support.php');
SET IDENTITY_INSERT adm_tabs OFF;
INSERT INTO adm_tabs_fct ( tabname , fctname , label , link , description ) VALUES ('supporttab', 'support', 'supportMgmt', 'admin/support_main.php', 'supportMgmtTxt');
INSERT INTO adm_tabs_fct ( tabname , fctname , label , link , description ) VALUES ('statstab', 'modulestats', 'moduleStats', 'admin/stats_modules.php', 'moduleStatsTxt');
ALTER TABLE pages ADD removable TINYINT NOT NULL default '1';
ALTER TABLE profile ADD removable TINYINT NOT NULL default '1';
UPDATE pages SET removable='1' WHERE id=1;
INSERT INTO adm_config (parameter ,value ,datatype ,desttype ) VALUES ('restrictOnExistingTags', 'false', 'int', 'J');
ALTER TABLE dir_item ADD views VARCHAR(255);
ALTER TABLE temp_dir_item ADD views VARCHAR(255);
ALTER TABLE dir_item_external ADD "view" VARCHAR(255);
ALTER TABLE dir_item_external ADD CONSTRAINT uniq_item_view UNIQUE (item_id,"view");
CREATE TABLE temp_dir_item_external (item_id INT IDENTITY(1,1) NOT NULL, source text NOT NULL, xmlmodule text NOT NULL, url varchar(255) NOT NULL, last_updated datetime NOT NULL, status VARCHAR(30) NOT NULL, "view" varchar(255) , CONSTRAINT un_item_view UNIQUE (item_id,"view"))  ;
CREATE CLUSTERED INDEX indcl_temp_dir_item_external_itemid ON temp_dir_item_external (item_id);
ALTER TABLE module ADD currentview VARCHAR(255);
UPDATE adm_headlinks SET seq=seq+1 WHERE seq>2;
INSERT INTO adm_headlinks ( id , uniq_id , type , label , comment , clss , images , fct , status , seq , anonymous , connected , admin , position ) VALUES ('20', 'span_availability', 'label', '', '', '', '', '', 'O', '3', '0', '1', '0', 'right');
ALTER TABLE dir_rss ADD iconid VARCHAR( 100 );
UPDATE adm_mail SET message = 'Bonjour,\r\n\r\nFélicitation pour la création de votre compte.\r\nVoici vos informations personnelles de connection :\r\nemail: %email\r\nPassword: %password\r\n\r\nCes paramètres vous donneront accès à votre compte.\r\n\r\nCordialement\r\n%site\r\n%link\r\n\r\n%unsubscribe' WHERE id = 1;
UPDATE adm_mail SET message = 'Hello,\r\n\r\nCongratulations for creating your brand new account. \r\nHere is your personal connection information :\r\nemail: %email\r\nPassword: %password\r\n\r\nThese parameters will give you access to your account.\r\n\r\nBest regards\r\n%site\r\n%link\r\n\r\n%unsubscribe' WHERE id = 2;
UPDATE adm_mail SET message = 'Bonjour,\r\n\r\nFélicitation, votre widget "%description" a été validé par un administrateur.\r\nVous pouvez l''utiliser dès à présent dans votre portail.\r\n\r\nCordialement\r\n%site\r\n%link\r\n\r\n%unsubscribe' WHERE id = 3;
UPDATE adm_mail SET message = 'Hello,\r\n\r\nCongratulations, your widget %description has been validated by an administrator. \r\nFrom now on, you can use it in your portal.\r\n\r\nSee you soon,\r\n%site\r\n%link\r\n\r\n%unsubscribe' WHERE id = 4;
UPDATE adm_mail SET message = 'Bonjour,\r\n\r\nSuite à votre demande, nous avons réinitialisé votre mot de passe. \r\n\r\nVoici vos identifiants:\r\nmail : %email\r\npassword : %password\r\n\r\nCordialement,\r\n%site\r\n%link\r\n\r\n\r\n%unsubscribe' WHERE id = 5;
UPDATE adm_mail SET message = 'Hello,\r\n\r\nYour password has been reset as requested. Here is your new account informations :\r\n\r\nemail:%email\r\npassword:%password\r\n\r\nSee you soon,\r\n%site\r\n%link\r\n\r\n%unsubscribe' WHERE id = 6;
UPDATE adm_mail SET message = 'Bonjour,\r\n\r\nNous avons bien enregistré vos paramètres personnels mais votre compte n`est pas encore activé.\r\nPour valider votre compte, veuillez cliquer sur le lien suivant : %linkportal/login.php?id=%id&chk=%key\r\n\r\nMerci et à bientôt sur %site.\r\n%link\r\n\r\n%unsubscribe' WHERE id = 8;
UPDATE adm_mail SET message = 'Hello,\r\n\r\nWe have take in account your personal parameters but your account is not yet validated.\r\nTo validate your account, please click on the following link : %linkportal/login.php?id=%id&chk=%key\r\n\r\nSee you soon on %site.\r\n%link\r\n\r\n%unsubscribe' WHERE id = 9;
UPDATE adm_mail SET message = 'Bonjour,\r\n\r\nSuite à votre demande, nous vous envoyons ce lien pour réinitialiser votre mot de passe.\r\n%setnewpwd\r\n\r\nCordialement\r\n%link\n%site\r\n\r\n%unsubscribe' WHERE id = 10;
UPDATE adm_mail SET message = 'Hello,\r\n\r\nFollowing your request\r\n\r\nWe send you this link to change your password.\r\n\r\n%setnewpwd\r\n\r\nBest regards\n%link\r\n%site\r\n\r\n%unsubscribe' WHERE id = 11;
UPDATE adm_mail SET message = 'Hello,\r\n\r\nFollowing your request\r\n\r\nWe send you this link to change your password.\r\n\r\n%setnewpwd\r\n\r\nBest regards\n%link\r\n%site\r\n\r\n%unsubscribe' WHERE id = 12;
UPDATE adm_mail SET message = 'Hello,\r\n\r\nFollowing your request\r\n\r\nWe send you this link to change your password.\r\n\r\n%setnewpwd\r\n\r\nBest regards\n%link\r\n%site\r\n\r\n%unsubscribe' WHERE id = 13;
UPDATE adm_mail SET message = 'Hello,\r\n\r\nFollowing your request\r\n\r\nWe send you this link to change your password.\r\n\r\n%setnewpwd\r\n\r\nBest regards\n%link\r\n%site\r\n\r\n%unsubscribe' WHERE id = 14;
DELETE FROM adm_config WHERE parameter='apname';
ALTER TABLE dir_item ADD icon VARCHAR( 255 );
ALTER TABLE temp_dir_item_external ADD type CHAR(1);
ALTER TABLE dir_item_external ADD type CHAR(1);
ALTER TABLE dir_item_external_language ADD viewtype VARCHAR(255);
CREATE TABLE temp_dir_item_external_language ( item_id INT NOT NULL,  lang varchar(3) NOT NULL,  url varchar(255) NOT NULL,  source text NOT NULL,  viewtype varchar(255) ,  "view" varchar(255) NOT NULL,  last_updated datetime NOT NULL);
ALTER TABLE dir_item  ADD l10n varchar(255);
ALTER TABLE temp_dir_item  ADD l10n varchar(255);
UPDATE adm_config SET desttype='A' WHERE parameter='debugmode';
ALTER TABLE temp_dir_item ADD id_dir_item int;
ALTER TABLE temp_dir_item_external ADD id_dir_item int;
UPDATE dir_item SET views = 'home,canvas' WHERE id =112;

> 2.1.0rc;

INSERT INTO adm_config (parameter ,value ,datatype ,desttype ) VALUES ('useRating', 'false', 'int', 'J');
ALTER TABLE feed_articles_read ADD article_rating int ;
ALTER TABLE feed_articles_read ADD rating_timestamp INT ;
ALTER TABLE dir_item_external_language ADD "view" VARCHAR( 255 );
ALTER TABLE dir_item_external_language ADD CONSTRAINT uniq_dir_item_external_language UNIQUE ( item_id , lang , "view" );
ALTER TABLE temp_dir_item_external_language ADD CONSTRAINT uniq_temp_dir_item_external_language UNIQUE ( item_id , lang , "view" );
INSERT INTO adm_config (parameter ,value ,datatype ,desttype ) VALUES ('allowGetWidgetOnMySite', 'true', 'int', 'J');
DELETE FROM adm_headlinks WHERE uniq_id='lab_hello';
ALTER TABLE dir_item_external_language ALTER COLUMN lang VARCHAR(6);
INSERT INTO adm_config (parameter ,value ,datatype ,desttype ) VALUES ('inactiveAccountsDelay', '90', 'int', 'P');
ALTER TABLE temp_dir_item_external_language ALTER COLUMN  lang VARCHAR(6);
ALTER TABLE temp_dir_item_external_language ADD params TEXT;
ALTER TABLE dir_item_external_language ADD params TEXT;
ALTER TABLE users_mail ALTER COLUMN pass TEXT ;
ALTER TABLE temp_dir_item ALTER COLUMN name VARCHAR( 75 );
ALTER TABLE dir_item ALTER COLUMN name VARCHAR( 75 );
ALTER TABLE translation ALTER COLUMN lang VARCHAR(5);
ALTER TABLE adm_mail ALTER COLUMN lang VARCHAR(5);

> 2.1.0;

ALTER TABLE dir_category ADD secured_quantity SMALLINT NULL ;
ALTER TABLE temp_category ADD secured TINYINT ;
ALTER TABLE dir_item ALTER COLUMN defvar TEXT;
ALTER TABLE temp_dir_item ALTER COLUMN defvar TEXT;

> 2.1.1;

UPDATE adm_config SET value='"en","fr","de"' WHERE parameter='AVLANGS';
INSERT INTO dir_category (name,parent_id,typ,path,quantity,updated,lang,secured_quantity,secured) VALUES('Widgets -de',0,'O','',1,'Y','de',0,0);
ALTER TABLE dir_rss ADD http_last_modified VARCHAR( 50 );

> 2.1.2;

ALTER TABLE temp_dir_item ALTER COLUMN website varchar(255) ;
ALTER TABLE dir_item ALTER COLUMN website varchar(255) ;
ALTER TABLE users ALTER COLUMN statdate DATE NULL ;

> 2.2.0b1;

UPDATE adm_headlinks SET seq = seq + 20 WHERE seq >= 10;
UPDATE adm_headlinks SET seq = '15', position='right' WHERE uniq_id='link_menu';
UPDATE adm_headlinks SET seq = '16', position='right' WHERE uniq_id='lab_sep10';
UPDATE adm_headlinks SET seq = '20', position='right' WHERE uniq_id='link_widgets';
UPDATE adm_headlinks SET seq = '29', position='right'  WHERE uniq_id='lab_sep3';
UPDATE adm_tabs SET label='communication' WHERE name='comtab';
ALTER TABLE users ADD creation_date DATE;
ALTER TABLE users ADD expiration_date int;
UPDATE adm_mail SET subject='Mot de passe mis à jour sur %site' WHERE id=5 AND lang='fr';
INSERT INTO adm_tabs_fct ( tabname , fctname , label , link , description ) VALUES ('configstab', 'DisplayTagPage', 'DisplayTagPage', 'admin/displaytagpage.php', 'displaytagpageDesc');
ALTER TABLE dir_item ADD hidden TINYINT  NULL ;

> 2.2.0rc;

ALTER TABLE pages ADD showwidgetbar TINYINT DEFAULT '1' NOT NULL ;
ALTER TABLE profile ADD showwidgetbar TINYINT DEFAULT '1' NOT NULL ;
ALTER TABLE pages ALTER COLUMN name VARCHAR( 100 );
ALTER TABLE profile ALTER COLUMN name VARCHAR( 100 );
ALTER TABLE users_notes ADD shared VARCHAR( 33 );
ALTER TABLE users_calendar_id ADD shared VARCHAR( 33 );
ALTER TABLE users_favorites_id ADD shared VARCHAR( 33 );
ALTER TABLE users_tasks_id ADD shared VARCHAR( 33 );
ALTER TABLE widget_addressbook_id ADD shared VARCHAR( 33 );
ALTER TABLE module ALTER COLUMN shared VARCHAR( 33 ) NULL ;

> 2.2.0;

ALTER TABLE users ADD firstname VARCHAR( 64 ) ;
ALTER TABLE users_tasks_id ADD tasklistname varchar(255);
ALTER TABLE widget_addressbook_id ADD bookname VARCHAR(150);
ALTER TABLE users_calendar_id ADD calendarname VARCHAR(150);
ALTER TABLE users_favorites_id ADD favoritesname VARCHAR(150);
ALTER TABLE adm_headlinks ALTER COLUMN fct TEXT;
ALTER TABLE pages_module ALTER COLUMN variables TEXT;
INSERT INTO adm_config VALUES ('WIDGET404', 'widget404.html', 'str', 'A','theModules');
ALTER TABLE users_notes ADD date_updated INT ;

> 2.2.1;

INSERT INTO adm_config (parameter,value,datatype,desttype) VALUES ('DEFAULT_THEME_FOR_NEW_PAGES', '0', 'int', 'J');
INSERT INTO adm_config (parameter,value,datatype,desttype) VALUES ('MENU_HIDDEN_IN_ANONYMOUS_PAGES', 'false', 'int', 'J');
INSERT INTO adm_config (parameter,value,datatype,desttype) VALUES ('ANONYMOUS_PAGES_ARE_BLOCKED', 'false', 'int', 'J');

> 2.2.2;

> 2.2.3;

INSERT INTO adm_config (parameter,value,datatype,desttype) VALUES ('NBWIDGETBYCOL', '0', 'int', 'J');
UPDATE adm_headlinks SET comment = '', seq = 50 WHERE uniq_id = 'link_logout';
UPDATE adm_headlinks SET label = '|', seq = 49 WHERE uniq_id = 'lab_par1';
DELETE FROM adm_headlinks WHERE uniq_id = 'lab_par2';
ALTER TABLE adm_plugins ADD forced TINYINT  ;
ALTER TABLE adm_config ADD editable TINYINT DEFAULT '1' NOT NULL ;

> 2.2.4;

INSERT INTO adm_config (parameter,value,datatype,desttype,category) VALUES ('PROXY_EXCLUSION', '', 'str', 'P','dbConnection');
CREATE TABLE users_group_widget_map (item_id INT NOT NULL,group_id INT NOT NULL,
CONSTRAINT pk_users_group_widget_map PRIMARY KEY CLUSTERED  (item_id,group_id));
INSERT INTO adm_config (parameter,value,datatype,desttype) VALUES ('GROUP_RESTRICTION_ON_SINGLE_WIDGET', 'false', 'int', 'A');
ALTER TABLE dir_item ADD group_access VARCHAR(150) NULL ;

> 2.3.0a1;

INSERT INTO adm_config (parameter,value,datatype,desttype) VALUES ('EMAIL_ADRESS_ARE_SHOWN', 'true', 'int', 'J');
INSERT INTO adm_config ( parameter , value , datatype , desttype, category  ) VALUES ('SAVE_ANONYMOUS_PORTAL', 'false', 'int', 'A', 'thePortals');
INSERT INTO adm_config ( parameter , value , datatype , desttype, category  ) VALUES ('DELAY_COOKIES_ANONYMOUS_USER', '12', 'int', 'A', 'thePortals');
ALTER TABLE pages ADD directories varchar(255) ;
ALTER TABLE users ADD email VARCHAR( 150 ) ;
UPDATE users SET email = username;
INSERT INTO adm_config ( parameter , value , datatype , desttype, category  ) VALUES ('USE_EVENTS_CSS', 'false', 'int', 'A', 'thePortals');
ALTER TABLE users_group_map ADD CONSTRAINT pk_users_group_map PRIMARY KEY ( user_id , group_id );
INSERT INTO adm_config ( parameter , value , datatype , desttype, category  ) VALUES ('USE_WIDGET_NOTATION', 'false', 'int', 'A', 'thePortals');
ALTER TABLE dir_item ADD average_rating  FLOAT( 2 ) ;
ALTER TABLE dir_item ADD total_rating  INT ;
ALTER TABLE dir_item ADD sum_rating  INT ;
CREATE TABLE dir_item_notation_user_map (id INT IDENTITY(1,1) NOT NULL,item_id INT NOT NULL ,user_id INT NOT NULL ,
CONSTRAINT pk_dir_item_notation PRIMARY KEY CLUSTERED ( id )) ;
ALTER TABLE dir_item_notation_user_map ADD rating INT;
UPDATE adm_config SET value='"en","fr","de","it"' WHERE parameter='AVLANGS';
INSERT INTO dir_category (name,parent_id,typ,path,quantity,updated,lang,secured_quantity, secured) VALUES('Widgets -it',0,'O','',1,'Y','it',0, 0);

> 2.3.0a2;
INSERT INTO adm_config ( parameter , value , datatype , desttype ) VALUES ('ENCRYPT_USERPREF', 'false', 'int', 'A');
INSERT INTO adm_config ( parameter , value , datatype , desttype, category  ) VALUES ('OPEN_TAB_BASED_ON_SUBDOMAIN', 'true', 'int', 'A','thePortals');
ALTER TABLE adm_log ADD admin_id INT ;
CREATE TABLE pages_widget_category_map (id INT IDENTITY(1,1) NOT NULL,dir_id INT NOT NULL,page_id INT NOT NULL,
CONSTRAINT pk_pages_widget_category_map PRIMARY KEY CLUSTERED (id)) ;
INSERT INTO adm_config ( parameter , value , datatype , desttype ) VALUES ('OPEN_ALL_WIDGET_LIBRARIES_IN_MENU_BY_DEFAULT', 'false', 'int', 'J');
ALTER TABLE temp_dir_item_external ALTER COLUMN source text ;
ALTER TABLE temp_dir_item_external ALTER COLUMN xmlmodule text ;
ALTER TABLE dir_item_external ALTER COLUMN source TEXT ;
ALTER TABLE dir_item_external ALTER COLUMN xmlmodule TEXT ;
INSERT INTO adm_config ( parameter , value , datatype , desttype, category  ) VALUES ('NETWORK_TYPE', 'R', 'str', 'A','network');
INSERT INTO adm_config ( parameter , value , datatype , desttype ) VALUES ('USE_OPENSOCIAL', 'false', 'int', 'A');
CREATE TABLE users_password_history (user_id INT NOT NULL,md5pass varchar(32) ,date_creating datetime NOT NULL DEFAULT '0000-00-00 00:00:00') ;
CREATE CLUSTERED INDEX indcl_users_password_history_userid ON users_password_history (user_id);
INSERT INTO adm_config ( parameter , value , datatype , desttype, category  ) VALUES ('PASSWORD_CHANGE_DELAY', '2', 'int', 'A', 'thePortals');
INSERT INTO adm_config ( parameter , value , datatype , desttype) VALUES ('IDLE_CONNECTIONS_EXPIRATION_DELAY', '3', 'int', 'A');
INSERT INTO adm_config ( parameter , value , datatype , desttype) VALUES ('CONNECTION_SECURITY_LEVEL', '1', 'int', 'A');
ALTER TABLE users ADD password_change_date DATE NOT NULL;
ALTER TABLE users ADD force_user_change_password TINYINT ;
ALTER TABLE adm_log ALTER COLUMN logdate DATETIME ;

> 2.3.0b1;
INSERT INTO adm_config ( parameter , value , datatype , desttype) VALUES ('USE_WIDGET_PAGE_TEMPLATE', 'true', 'int', 'J');
ALTER TABLE profile ADD template SMALLINT ;
ALTER TABLE pages ADD template SMALLINT ;

> 3.0.0a1;

ALTER TABLE adm_group_map ALTER COLUMN user_id INT ;
ALTER TABLE adm_group_map ALTER COLUMN group_id INT ;
UPDATE adm_config SET desttype = 'A' WHERE parameter = 'useNetwork';
UPDATE adm_config SET desttype = 'A' WHERE parameter = 'useGroup';
UPDATE adm_config SET desttype = 'A' WHERE parameter = 'useNotebook';

> 3.0.0b1;

UPDATE adm_config SET desttype = 'A' WHERE parameter = 'passwordChangePermission';
ALTER TABLE users ALTER COLUMN statdate DATETIME NULL;

> 3.0.0;

> 3.0.1;

> 3.0.2;

ALTER TABLE log ALTER COLUMN pubdate DATETIME ;