<?php
# ************** LICENCE ****************
/*
	Copyright (c) PORTANEO.

	This file is part of POSH (Portaneo Open Source Homepage) http://sourceforge.net/projects/posh/.

	POSH is free software: you can redistribute it and/or modify
	it under the terms of the GNU General Public License as published by
	the Free Software Foundation, either version 3 of the License, or
	(at your option) any later version

	POSH is distributed in the hope that it will be useful,
	but WITHOUT ANY WARRANTY; without even the implied warranty of
	MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
	GNU General Public License for more details.

	You should have received a copy of the GNU General Public License
	along with Posh.  If not, see <http://www.gnu.org/licenses/>.
*/
/**************************************
# Opensocial modules - Display an opensocial module
#
# !! be careful, this file must be saved under uft8 format, and display an e accentuated here : é
# ***************************************/

$pagename="modules/xml_getopensocialwidget.php";
$folder="";
$not_access=0;
$isScript=true;
$isPortal=false;
$granted='I';

require_once('includes.php');
require_once('../db_layer/'.__DBTYPE.'/widget.php');
require_once('../l10n/'.__LANG.'/lang.php');
require_once('../includes/modules_tools.php');
require_once('../includes/file.inc.php');
require_once('../includes/xml.inc.php');
if (!__USE_OPENSOCIAL || !isset($_GET['opensocial'])) exit();
/*
if (!isset($_SESSION['user_id'])) { 
    echo "<br /><center>".lg('msgNeedToBeConnectedPage')."</center>"; 
    exit(); 
}
*/
require_once('../tools/opensocial/config.php');
require_once('../tools/opensocial/library/PortaneoConfig.php');
require_once('../tools/opensocial/library/SecurityToken.php');
require_once('../tools/opensocial/library/Crypto.php');
require_once('../tools/opensocial/library/BlobCrypter.php');
require_once('../tools/opensocial/library/BasicBlobCrypter.php');
require_once('../tools/opensocial/library/BasicSecurityToken.php');
require_once('../tools/opensocial/library/SecurityTokenDecoder.php');

$toredirect    = isset($_GET['toredirect']) ? $_GET['toredirect'] : exit();
$url           = isset($_GET['url'])        ? $_GET['url']        : exit();
$opensocial    = $_GET['opensocial'];
$container     = isset($_GET['container'])  ? $_GET['container']  : "default";
$dir_item_id   = isset($_GET['pitem'])      ? $_GET['pitem']      : '';
$format        = isset($_GET['format'])     ? $_GET['format']     : 'G';
$getView       = isset($_GET['view'])       ? $_GET['view']       : 'home';
$uniq          = isset($_GET['p'])          ? $_GET['p']          : 0;
$rpctoken      = rand(0, getrandmax());
$baseurl       = $url;
$finalurl      = __LOCALFOLDER."modules/xml_getopensocialwidget.php?toredirect=".$toredirect;
$finalurl     .= "&opensocial=".$opensocial."&container=".$container."&url=".$url;
$vars          = "";

foreach ($_GET as $cle => $val) {
    if (substr($cle, 0, 3)=='up_') {
        $vars .= "&".$cle."=".$val;
    }   
}

$securityToken = BasicSecurityToken::createFromValues(
                       isset($_SESSION['user_id']) ? $_SESSION['user_id'] : SecurityToken::$ANONYMOUS, // viewer
                       isset($_SESSION['user_id']) ? $_SESSION['user_id'] : SecurityToken::$ANONYMOUS, // owner
                       //isset($vars['person']['id']) ? $vars['person']['id'] : SecurityToken::$ANONYMOUS, // owner
                       0,  // app id
                       "default", // domain key, shindig will check for php/config/<domain>.php for container specific configuration
                       urlencode($finalurl), // app url
                       $dir_item_id // mod id
            );
                                   
$finalurl = $config['gadget_server']."/gadgets/ifr?synd=default&container=".$container."&nocache=1"
          . "&viewer="   . (isset($_SESSION['user_id']) ? $_SESSION['user_id'] : '0')
          . "&owner="    . (isset($vars['person']['id']) ? $vars['person']['id'] : '0')
          . "&aid=0"
          . "&st="       . urlencode(base64_encode($securityToken->toSerialForm()))
          . "&view="     . $getView
          . $vars
          . "&url="      . urlencode($baseurl)
          . "&uniq="     . $uniq
          . "#rpctoken=" . $rpctoken;     

?>
<html>
<head>
  <script type="text/javascript" src="../tools/opensocial/shindig_util.js"></script>
  <script type="text/javascript" src="../tools/opensocial/shindig_frame.js"></script>
  <script type="text/javascript" src="../includes/modules.js"></script>
</head>
<body>
  <iframe name="serverContent" width="100%" height="100%" frameborder="no" border="0" id="baseiframe" src="<?php echo $finalurl;?>"></iframe>
</body>
</html>