<?php
# ************** LICENCE ****************
/*
	Copyright (c) PORTANEO.

	This file is part of COLLABORATION SUITE of POSH http://sourceforge.net/projects/posh/.

	POSH is free software: you can redistribute it and/or modify
	it under the terms of the GNU General Public License as published by
	the Free Software Foundation, either version 3 of the License, or
	(at your option) any later version

	POSH is distributed in the hope that it will be useful,
	but WITHOUT ANY WARRANTY; without even the implied warranty of
	MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
	GNU General Public License for more details.

	You should have received a copy of the GNU General Public License
	along with Posh.  If not, see <http://www.gnu.org/licenses/>.
*/
# ***************************************
# User notebook
# !! be careful, this file must be saved under uft8 format, and display an e accentuated here : éàèù
# ***************************************

$folder="../notebook/";
$not_access=0;
$pagename="notebook/xml_group_articles.php";
//includes
require_once('includes.php');
require_once('../l10n/'.__LANG.'/lang.php');
require_once('../l10n/'.__LANG.'/enterprise.php');
require_once('../db_layer/'.__DBTYPE.'/enterprise.php');
require_once('../includes/xml.inc.php');

$id = $DB->escape($_GET["id"]);
$page = isset($_GET["page"])?$_GET["page"]:0;
$user_id = isset($_SESSION['user_id'])?$_SESSION['user_id']:0;

launch_hook('groupbook_header',$pagename);

include_once('groupsecurity.inc.php');

$search=(isset($_GET["search"]) ? $_GET["search"] : "");

$file = new xmlFile();

$file->header("groupbook");

echo '<groupOwner>' . $groupOwner . '</groupOwner>';
echo '<private>' . $groupType . '</private>';

if ($search=="")
{
	$DB->getResults($index_getGroupbookArticles,
					$DB->escape($id),
					$groupbookAccessLevel,
					$DB->escape($_SESSION['user_id']),
					$DB->escape($page*10));

}
else
{
	//search by tag or plaintxt
	if ($_GET["type"]=="plaintxt")
	{		
		$DB->getResults($index_getGroupbookSearchedArticles,
						$DB->escape($id),
						$groupbookAccessLevel,
						$DB->escape($_SESSION['user_id']),
						$DB->quote("%".$search."%"),
						$DB->quote("%".$search."%"),
						$DB->escape($page*10));
	}
	else
	{
		$DB->getResults($index_getGroupbookSearchedArticlesTags,
						$DB->escape($id),
						$groupbookAccessLevel,
						$DB->escape($_SESSION['user_id']),
						$DB->quote($_GET["searchid"]),
						$DB->escape($page*10));
	}
}
$articles = array();
$inc = 0;
while ($row = $DB->fetch(0))
{
    $articles[$inc] = array();
    $articles[$inc]['id'] = $row["id"];
    $articles[$inc]['type'] = $row["type"];
    $articles[$inc]['title'] = $row["title"];
    $articles[$inc]['description'] = $row["description"];
    $articles[$inc]['long_name'] = $row["long_name"];
    $articles[$inc]['picture'] = $row["picture"];
    $articles[$inc]['status'] = $row["status"];
    $articles[$inc]['pubdate'] = $row["pubdate"];
    $articles[$inc]['owner_id'] = $row["owner_id"];
    $articles[$inc]['linked_id'] = $row["linked_id"];
    $articles[$inc]['trackbacknb'] = $row["trackbacknb"];
    $articles[$inc]['commentsnb'] = $row["commentsnb"];
    $articles[$inc]['keywords'] = $row["keywords"];
	$articles[$inc]['is_copy'] = $row["is_copy"];
    $inc ++;
}
$DB->freeResults();

foreach ($articles AS $article)
{
	echo '
<article>
	<id>'.$article["id"].'</id>
	<type>'.$article["type"].'</type>
	<title><![CDATA['.$article["title"].']]></title>
	<description><![CDATA['.$article["description"].']]></description>
	<longname><![CDATA['.$article["long_name"].']]></longname>
	<picture><![CDATA['.$article["picture"].']]></picture>
	<status>'.$article["status"].'</status>
	<pubdate>'.$article["pubdate"].'</pubdate>
	<ownerid>'.$article["owner_id"].'</ownerid>
	<linkedid>'.$article["linked_id"].'</linkedid>
	<trackbacknb>'.$article["trackbacknb"].'</trackbacknb>
	<commentnb>'.$article["commentsnb"].'</commentnb>
	<tags><![CDATA['.$article["keywords"].']]></tags>
	<is_copy>'.$article["is_copy"].'</is_copy>';
	//get article latest comments
    if ($article["commentsnb"] != 0)
    {
        $DB->getResults($xml_articles_get_comments, $article["id"]);
        while ($row = $DB->fetch(0))
        {
            echo '<comment>
                    <id>' . $row['id'] . '</id>
                    <picture><![CDATA['.$row["picture"].']]></picture>
                    <userid>'.$row["user_id"].'</userid>
                    <longname><![CDATA['.$row["long_name"].']]></longname>
                    <pubdate>'.$row["pubdate"].'</pubdate>
                    <message><![CDATA['.$row["message"].']]></message>
                  </comment>';
        }
        $DB->freeResults();
    }
echo '</article>';
}
$DB->freeResults();

$file->footer();

$DB->close();
?>