<?php
# ************** LICENCE ****************
/*
	Copyright (c) PORTANEO.

	This file is part of POSH (Portaneo Open Source Homepage) http://sourceforge.net/projects/posh/.

	POSH is free software: you can redistribute it and/or modify
	it under the terms of the GNU General Public License as published by
	the Free Software Foundation, either version 3 of the License, or
	(at your option) any later version

	POSH is distributed in the hope that it will be useful,
	but WITHOUT ANY WARRANTY; without even the implied warranty of
	MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
	GNU General Public License for more details.

	You should have received a copy of the GNU General Public License
	along with Posh.  If not, see <http://www.gnu.org/licenses/>.
*/
# ***************************************
# STATS - count the modules open actions
#
# !! be careful, this file must be saved under uft8 format, and display an e accentuated here : é
# ***************************************

/**
*
* \brief create and initialise anonymous account
*
*
*   return void
*
*  \relatesalso
*   portal/index.php
*
* !! be careful, this file must be saved under uft8 format, and display an e accentuated here : é
*
**/

$folder="";
$not_access=1;
$granted="N";
$pagename="portal/scr_createandinitanonymousaccount.php";

if( isset($DB) ) {
	if(isset($_SERVER['HTTP_ACCEPT_LANGUAGE'])){
	  $lang = explode(",",$_SERVER['HTTP_ACCEPT_LANGUAGE']);
	  $lang = strtolower(substr(chop($lang[0]),0,2));
	}

	if ( __SAVE_ANONYMOUS_PORTAL )
	{
		if (empty($DB2))
			$DB2 = new connection(__SERVER,__LOGIN,__PASS,__DB);
		// create anonymous user
		$name = 'anomymous';
		$user = 'anomymous';
		$md5pass = '';
		$md5user = md5(uniqid(rand(), true));
		$DB->execute($scranonymous_addUser2,$DB->noHTML($user),$DB->quote($md5user),$DB->quote($lang));
		$id=$DB->getId();
		if( $id>0 ) {
			$_SESSION['user_id'] = $id;
			$_SESSION['longname'] = $name;
			$_SESSION['type'] = 'N';
			$_SESSION['availability'] = 'x';
			$_SESSION['picture'] = '';
			$_SESSION['username'] = $user;
			$_SESSION['lang'] = $lang;
			
			// add pages to profile
			$DB->getResults($users_getPublicAndGroupPages,$DB->escape(0));
			$temp_id = 0;
			while ($row = $DB->fetch(0))
			{	
				$DB->execute($user_addProfilePages,
									$DB->escape($id),
									$DB->quote($row['name']),
									$DB->escape($row['nbcol']),
									$DB->escape($row['style']),
									$DB->quote($row['controls']),
									$DB->quote($row['showtype']),
									$DB->escape($row['seq']),
									$DB->quote($row['icon']),
									$DB->quote($row['modulealign']),
									$DB->quote($row['type']),
									$DB->quote($row['param']),
									$DB->escape($row['id']),
									$DB->escape($row['removable']),
									$DB->escape($row['showwidgetbar'])
							 );
				$profid=$DB->getId();
				//must check the modules
				$temp_id=$row['id'];
				// add modules
				if ($row['type'] == 1) {
					$DB2->getResults($page_getPagesModule,$temp_id);
					while ($rows = $DB2->fetch(0))
					{
						 $DB2->execute($modules_addNewMod,
									$DB2->escape($rows['item_id']),
									$DB2->escape($rows['posx']),
									$DB2->escape($rows['posy']),
									$DB2->escape($rows['posj']),
									$DB2->escape($rows['x']),
									$DB2->escape($rows['y']),
									$DB2->quote($rows['variables']),
									$DB2->quote($rows['uniq']),
									$DB2->escape($rows['blocked']),
									$DB2->escape($rows['minimized']),
									$DB2->escape($id),
									$DB2->escape($temp_id)   
						);
					}
					$DB2->freeResults();
				}
			}
			$DB->freeResults(); // End add pages

			set_cookie('idanonym', $id, (time() + (60*60*24*30*__DELAY_COOKIES_ANONYMOUS_USER) ));
			set_cookie('md5anonym', $md5user, (time() + (60*60*24*30*__DELAY_COOKIES_ANONYMOUS_USER) ));
			
			if (__ENCRYPT_USERPREF) {
				$_SESSION['encrypt_key'] = uniqid(strval(mt_rand()));
				set_cookie('encrypt_key', $_SESSION['encrypt_key']);
			}
			
			init_session($id,$user,'N',$lang,$name,"x");
			
		}

	}
	$DB->close();
}
?>