#!/bin/bash



apacheuser=apache
apachegroup=apache

while getopts ":u:g:d:h" optname
  do
    case "$optname" in
      "u")
        apacheuser=$OPTARG
        ;;
      "g")
        apachegroup=$OPTARG
        ;;
      "d")
        dir=$OPTARG
        ;;
      "h")
        echo 
        echo shell script to give rights to apache user on some directories and set them to 775
        echo "default user and group: apache (centos,redhat and fedora httpd user)"
        echo "parameters: -u <apacheuser> -g <apachegroup>"
        echo 
        exit;
        ;;
      "?")
        echo 
        echo shell script to give rights to apache user on some directories and set them to 775
        echo "default user and group: apache (centos,redhat and fedora httpd user)"
        echo "parameters : -u <apacheuser> -g <apachegroup>"
        exit;
        ;;
    esac
  done

if [[ -n $dir  ]] 
then
    echo  directory $dir
else 
    echo  directory needed : -d directory
    exit;
fi



for rep in cache includes modules "install" styles portal modules/cache modules/external modules/pictures modules/quarantine portal/selections styles l10n
do
    echo ${dir}${rep};
    chmod 775 ${dir}${rep}
    chown ${apacheuser}:${apachegroup} ${dir}${rep}
done

for subdir in ${dir}l10n/*
do
    if [[ -d $subdir ]]
    then
        echo $subdir
        chmod 775 $subdir
        chmod 766  $subdir/*.php
        chmod 766  $subdir/*.js
        chmod 766  $subdir/*.properties
        chown ${apacheuser}:${apachegroup} $subdir/*.php
        chown ${apacheuser}:${apachegroup} $subdir/*.js
        chown ${apacheuser}:${apachegroup} $subdir/*.properties
    fi
done


for file in includes/config.js includes/config.inc.php includes/plugins.inc.php
do
    if [[ -e ${dir}${file} ]]
    then
        echo ${dir}${file} existe
        chmod 775 ${dir}${file}
        chown ${apacheuser}:${apachegroup} ${dir}${file}
    else
        echo $dir$file does not exist, created during setup process
    fi
done


exit;
