<?php
/**
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */

$config = array(
                    // Language to use, used for gettext / setenv LC_ALL
                    'language' => 'en_US',

                    // prefix of where portaneo lives, empty means it's /
                    'web_prefix' => '',

                    // Container (formaly known as syndicator) to pass in the iframe (defaults to 'default')
                    // Note: your shindig config/container.js needs to match this key, so if you changed this to 'portaneo'
                    // you need to edit container.js and change the container key there like:
                    // {"gadgets.container" : ["portaneo"],
                    'container' => 'default',

                    // gadget server url
                    'gadget_server' => 'http://shindig',

                    // The url of this portaneo instalation, including the (optional) web_prefix
                    'portaneo_url' => 'http://127.0.0.1/poshTrunk',

                    // Max age of a security token, defaults to one hour
                    'st_max_age' => 60 * 60,

                    // Allow plain text tokens, disable this on live systems
                    'allow_plaintext_token' => true,

                    // Security token keys, this is a shared secret between shindig and portaneo so make sure you set them to the same value in both
                    'token_cipher_key' => 'INSECURE_DEFAULT_KEY',
                    'token_hmac_key' => 'INSECURE_DEFAULT_KEY',
                    
                    // MySql server settings
                    'db_host' => 'localhost',
                    'db_user' => 'root',
                    'db_passwd' => '',
                    'db_database' => 'poshTrunk',
                    'db_port' => '3306',
                    'data_cache' => 'CacheStorageFile',
                    'cache_host' => 'localhost',
                    'cache_port' => 11211,
                    'cache_time' => 24 * 60 * 60,
                    'cache_root' => '/tmp/shindig',
                    'upload_quota' => 50 * 1024 * 1024,
                    
                    'site_root' => realpath(dirname(__FILE__)),
                    'library_root' => realpath(dirname(__FILE__) . "/library"),
);
?>