<?php
/**
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */


class PortaneoOAuthLookupService extends OAuthLookupService {

  /**
   * Portaneo's implementation of the OAuth Lookup service. Portaneo supports all currently existing forms of
   * OAuth signatures: 3 legged, 2 legged and body_hash's
   *
   * @param RequestItem $oauthRequest
   * @param string $appUrl
   * @param string $userId
   * @return SecurityToken or null
   */
  public function getSecurityToken($oauthRequest, $appUrl, $userId, $contentType) {
  }

  /**
   * Verfies the oauth_body_hash signature, for more information on this oauth spec extension see:
   * http://oauth.googlecode.com/svn/spec/ext/body_hash/1.0/drafts/4/spec.html
   */
  private function verifyBodyHash($postBody, $oauthBodyHash) {
  }

  /**
   * Verfies a 2 legged OAuth signature. 2 legged OAuth means the security context is of the application,
   * and no specific user is associated with it. Most of the logic is done manually and not through the OAuth
   * library, since it has no knowledge of- / support for 2 legged OAuth.
   */
  private function verify2LeggedOAuth($oauthRequest, $userId, $appUrl, $dataStore) {
  }

  /**
   * The 'clasic' 3 legged OAuth, where the user went through the OAuth dance and granted the remote app
   * access to his/her data.
   */
  private function verify3LeggedOAuth($oauthRequest, $userId, $appUrl, $dataStore) {
    }
