<?php
# ************** LICENCE ****************
/*
	Copyright (c) PORTANEO.

	This file is part of POSH (Portaneo Open Source Homepage) http://sourceforge.net/projects/posh/.

	POSH is free software: you can redistribute it and/or modify
	it under the terms of the GNU General Public License as published by
	the Free Software Foundation, either version 3 of the License, or
	(at your option) any later version

	POSH is distributed in the hope that it will be useful,
	but WITHOUT ANY WARRANTY; without even the implied warranty of
	MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
	GNU General Public License for more details.

	You should have received a copy of the GNU General Public License
	along with Posh.  If not, see <http://www.gnu.org/licenses/>.
*/
/**************************************
* POSH Pages management - Apply tabs changes
* 
* @file
*    scr_pages_modify_add - save tabs change create by admin
*
* @param act post - value : upd or anything
*
* @param type - value : 1
*
* !! be careful, this file must be saved under uft8 format, and display an e accentuated here : é
**/

require_once('../includes/xml.inc.php');
include_once('../includes/pagegeneration.inc.php');
require_once('../includes/log.inc.php');

launch_hook('admin_scr_pages_modify_add');

$tabUsers = Array(); 

$pageid=$_POST["id"];
$seldir = isset($_POST['seldir'])?$_POST['seldir']:'';
$pageIcon= (isset($_POST['hiddenIconValue']))       ?       $_POST['hiddenIconValue']
                                                    :       "";
$template = isset($_POST['tpl']) ? $_POST['tpl'] : 0;

if(isset($_POST['formaction'])) {
    $formaction=$_POST['formaction'];
}

//Save page information
if ($_POST["act"] == "upd") {

	//update page information in table "pages"
	$DB->execute($pages_updatePages, $DB->escape($_POST["group"]),
                                $DB->quote($_POST["name"]),
                                $DB->quote($_POST["desc"]),
                                $DB->escape($_POST["mode"]),
                                $DB->escape($_POST["type"]),
                                //$DB->quote(urlencode($_POST["param"])),
                                $DB->quote($_POST["param"]),
                                $DB->quote($pageIcon),
                                $DB->escape($_POST["removable"]),
								$DB->quote($seldir),
								$DB->escape($template),
                                $DB->escape($pageid));

	// remove old category for the page
	$DB->execute($pages_deleteCategory, $DB->escape($pageid));
	// update into pages/widget category map
	$idsDir = explode(',',substr($seldir,0,-1) );
	foreach($idsDir as $value) {
		if($value>0) {
			$DB->execute($pages_insertNewCategory,
							$DB->escape($value),
							$DB->escape($pageid)
						 );
		}
	}
	
	//create an XML file for selected categories menu
	$script_file=$template_folder."xml_cache_directory.php";
	$cache_file="../cache/cat_".$pageid.".xml";
	cacheDataInFile($script_file, $cache_file, $__AVLANGS, $seldir);

    $DB->execute($pages_updateSubProperties,
        $DB->escape($_POST['nbcol']),
        $DB->escape($_POST['showtype']),
        $DB->escape($_POST['npnb']),
        $DB->escape($_POST['style']),
        $DB->quote($_POST['modulealign']),
        $DB->quote($_POST['controls']),
        $DB->quote($_POST['showwidgetbar']),
        $DB->escape($pageid)
    );
    
    //delete entries from "pages_modules"
    $DB->execute($pages_removeModules,$DB->escape($pageid));
    
	//if checkbox checked, replace previous tab version .
	if(isset($formaction) && $formaction == 3) {	
    
		// removed by EMA on 08/12/09 -> Simplification
		// $DB->getResults($users_getProfileId,$DB->escape($pageid));
		// while ($row = $DB->fetch(0))
		// {
			// $profile_id=$row["id"];
			// array_push($tabProfileId,$profile_id);
		// }
		// $DB->freeResults();
		// for ($i=0;$i<sizeof($tabProfileId);$i++)
		// {
            // //delete tries in "modules" table
			// $DB->execute($users_deleteProfileModules,$DB->escape($tabProfileId[$i]));
     	// }
		$DB->execute($users_deleteProfileModules,$DB->escape($pageid));
        
		//get the id of the users of the current group  
		if ($_POST["group"] !=0 ) {
			
			//retrieve the id of the users of the current group
			$DB->getResults($users_getIdGroup,
                    $DB->escape($_POST["group"]));
					
			while ($row=$DB->fetch(0))
			{
				$user_id = $row['user_id'];
				if (!in_array($user_id,$tabUsers))
					array_push($tabUsers,$user_id);
			}
			$DB->freeResults();	
			
			//retrieve the id of the users of the sub groups
			$DB->getResults($users_getIdSubGroup,
                    $DB->escape($_POST["group"]));
					
			while ($row=$DB->fetch(0))
			{
				$user_id = $row['user_id'];
				if (!in_array($user_id,$tabUsers))
					array_push($tabUsers,$user_id);
			}
			$DB->freeResults();	
			
			//retrieve the id of the users of the sub-sub groups
			$DB->getResults($users_getIdSubSubGroup,
                    $DB->escape($_POST["group"]));
					
			while ($row=$DB->fetch(0))
			{
				$user_id = $row['user_id'];
				if (!in_array($user_id,$tabUsers))
					array_push($tabUsers,$user_id);
			}
			$DB->freeResults();	
			
			// add page for users that suppressed it
			$tabUsersList = implode(',',$tabUsers);
			$DB->getResults($users_getRemovedPages,
								$DB->escape($pageid),
								$tabUsersList);

			if ($DB->nbResults() > 0)
			{
				$missingTabUsers = array();
				while ($row = $DB->fetch(0))
				{
					$user_id = $row['id'];
					array_push($missingTabUsers,$user_id);
				}
				
				$missingTabUsersList = implode(',',$missingTabUsers);
				
				$DB->execute($profile_addPage,
							$DB->quote($_POST['name']),
							$DB->escape($_POST['nbcol']),
							$DB->escape($_POST['style']),
							$DB->quote($_POST['controls']),
							$DB->escape($_POST['showtype']),
							$DB->quote($pageIcon),
							$DB->quote($_POST['modulealign']),
							$DB->escape($_POST["type"]),
							$DB->quote($_POST["param"]),
							$DB->escape($pageid),
							1,
							$DB->escape($_POST['removable']),
							$DB->escape($_POST['showwidgetbar']),
							$DB->escape($template),
							$missingTabUsersList
						);
			}
			$DB->freeResults();	
		}
		//get all users id
		else {
			$DB->getResults($users_getId);
			while ($row=$DB->fetch(0))
			{
				$user_id=$row['id'];
				array_push($tabUsers,$user_id);
			}
			$DB->freeResults();	
		}
         
        //update page/tab
        $DB->execute($profile_updatePage,
                            $DB->quote($_POST['name']),
                            $DB->escape($_POST['nbcol']),
                            $DB->escape($_POST['style']),
                            $DB->quote($_POST['controls']),
                            $DB->escape($_POST['showtype']),
                            $DB->quote($pageIcon),
                            $DB->quote($_POST['modulealign']),
                            $DB->escape($_POST["type"]),
                            $DB->quote($_POST["param"]),
                            $DB->escape($_POST["removable"]),
                            $DB->escape($_POST["showwidgetbar"]),
							$DB->escape($template),
                            $DB->escape($pageid)
                      );                       
	}
	
	launch_hook('admin_scr_pages_modify_add_after_usertabs_update',$pageid);

	//save the modules information for portal creation
	if ($_POST["type"]==1) {
		$inc=0;		
		while (isset($_POST["i".$inc])) {
			$DB->execute($pages_addModules,
										$DB->escape($_POST["i".$inc]),
										$DB->escape($pageid),
										$DB->escape($_POST["c".$inc]),
										$DB->escape($_POST["p".$inc]),
										$DB->escape($_POST["pj".$inc]),
										$DB->escape($_POST["x".$inc]),
										$DB->escape($_POST["y".$inc]),
										$DB->quote($_POST["v".$inc]),
										($inc+1),
										$DB->escape($_POST["b".$inc]),
										$DB->escape($_POST["m".$inc])
						);
			if (isset($formaction) && $formaction == 3) {
                //for ($j=0;$j<sizeof($tabUsers);$j++)
                //{
				$tabUsersList = implode(',',$tabUsers);
				$DB->execute($modules_addPageModules,
										$DB->escape($_POST["i".$inc]),
										$DB->escape($_POST["c".$inc]),
										$DB->escape($_POST["p".$inc]),
										$DB->escape($_POST["pj".$inc]),
										$DB->escape($_POST["x".$inc]),
										$DB->escape($_POST["y".$inc]),
										$DB->quote($_POST["v".$inc]),
										($inc+1),
										$DB->escape($_POST["b".$inc]),
										$DB->escape($_POST["m".$inc]),
										$tabUsersList,
										$DB->escape($pageid)
							);
                //}
			}
			
			$inc++;
		}
	}
	$log=new log();
	$log->addLog($DB,'Page modification (NAME:'.$_POST['name'].';ID:'.$pageid.')');
}
//creation page
else
{
	//retrieve the incremented seq number
	$DB->getResults($pages_getMaxSeq,$DB->escape($_POST["group"]));
	$row = $DB->fetch(0);
	$seq = $row["nseq"]==""?1:$row["nseq"];
	
	$DB->freeResults();

	$DB->execute($pages_addNewPages,
                    $DB->escape($_POST["group"]),
                    $DB->quote($_POST["name"]),
                    $DB->quote($_POST["desc"]),
                    $DB->escape($_POST["mode"]),
                    $DB->escape($_POST["type"]),
                    $DB->quote($_POST["param"]),
                    $DB->escape($seq),
                    $DB->quote($pageIcon),
                    $DB->escape($_POST["removable"]),
					$DB->quote($seldir),
					$DB->escape($template)
                 );
	$pageid = $DB->getId();

	
	// insert into pages/widget category map
	$idsDir = explode(',',substr($seldir,0,-1) );
	foreach($idsDir as $value) {
		if($value>0) {
			$DB->execute($pages_insertNewCategory,
							$DB->escape($value),
							$DB->escape($pageid)
						 );
		}
	}
	
	
	//create xml file for menu
	$script_file=$template_folder."xml_cache_directory.php";
	$cache_file="../cache/cat_".$pageid.".xml";
	cacheDataInFile($script_file, $cache_file, $__AVLANGS, $seldir);
	
	//if 'apply to all portals' is checked
	if ( (isset($formaction)) && ($formaction==2) && ($_POST['mode']==1) )
	{
		$tabUsers = Array(); 
		
		if ($_POST["group"] != 0)
		{
			//retrieve the id of the users of the current group
			$DB->getResults($users_getIdGroup,
                    $DB->escape($_POST["group"]));
					
			while ($row=$DB->fetch(0))
			{
				$user_id = $row['user_id'];
				if (!in_array($user_id,$tabUsers))
					array_push($tabUsers,$user_id);
			}
			$DB->freeResults();	
			
			//retrieve the id of the users of the sub groups
			$DB->getResults($users_getIdSubGroup,
                    $DB->escape($_POST["group"]));
					
			while ($row=$DB->fetch(0))
			{
				$user_id = $row['user_id'];
				if (!in_array($user_id,$tabUsers))
					array_push($tabUsers,$user_id);
			}
			$DB->freeResults();	
			
			//retrieve the id of the users of the sub-sub groups
			$DB->getResults($users_getIdSubSubGroup,
                    $DB->escape($_POST["group"]));
					
			while ($row=$DB->fetch(0))
			{
				$user_id = $row['user_id'];
				if (!in_array($user_id,$tabUsers))
					array_push($tabUsers,$user_id);
			}
			$DB->freeResults();	
		}
		//retrieve all users id
		else
		{
			$DB->getResults($users_getId);
			while ($row=$DB->fetch(0))
			{
				$user_id=$row['id'];
				array_push($tabUsers,$user_id);
			}
			$DB->freeResults();	
		}

		// for ($i=0;$i<sizeof($tabUsers);$i++)
		// {
		$tabUsersList = implode(',',$tabUsers);
		
		// $seq_profile=0;
		// $DB->getResults($profile_getMaxSeq,$DB->escape($tabUsers[$i]));
		// if ($DB->nbResults()>0) 
		// {
			// $curs = $DB->fetch(0);
			// if ($curs["nseq"]!=NULL)
				// $seq_profile=$curs["nseq"];
		// }
		//add the page in profile
		$DB->execute($profile_addPage,
						$DB->quote($_POST['name']),
						$DB->escape($_POST['nbcol']),
						$DB->escape($_POST['style']),
						$DB->quote($_POST['controls']),
						$DB->escape($_POST['showtype']),
						$DB->quote($pageIcon),
						$DB->quote($_POST['modulealign']),
						$DB->escape($_POST["type"]),
						$DB->quote($_POST["param"]),
						$DB->escape($pageid),
						1,
						$DB->escape($_POST['removable']),
						$DB->escape($_POST['showwidgetbar']),
						$DB->escape($template),
						$tabUsersList
					);

		//$profileid=$DB->getId();
		//array_push($tabProfile,$profileid);
		//$DB->freeResults();
		//} 
	}
    
    // page configuration
    $DB->execute($pages_updateSubProperties,
                    $DB->escape($_POST['nbcol']),
                    $DB->escape($_POST['showtype']),
                    $DB->escape($_POST['npnb']),
                    $DB->escape($_POST['style']),
                    $DB->quote($_POST['modulealign']),
                    $DB->quote($_POST['controls']),
                    $DB->quote($_POST['showwidgetbar']),
                    $DB->escape($pageid)
                );
	//save the modules information for portal creation
	if ($_POST["type"]==1)
	{
		// suppress the previous modules selection
		$DB->execute($pages_removeModules,
                            $DB->escape($pageid)
                    );
        
		// create the new modules selection
		$inc=0;
		while (isset($_POST["i".$inc]))
		{
			$mod_id = $_POST["i".$inc];
			$item_id = "";
			$label_item = "";
            $variables = $_POST["v".$inc];     
            
            /*
            
			preg_match('/noteid=[0-9]{1,4}/xmsi', $_POST["v".$inc],$item_id);
			$item_id =  explode("=", $item_id[0]);
			$label_item = $item_id[0];
			$item_id = $item_id[1];
			$sharedkey = "";
			if( $label_item == "noteid" ) {
				$mod_id = 84;
			}			
			switch($mod_id){
				case 84 :
					$DB->getResults($admin_getUsersNotesSharedmd5key,$DB->escape($item_id));
					$row=$DB->fetch(0);
					$sharedkey =  $row['shared'];
					$DB->freeResults();
					break;
						
				default: break;
			}
            */
		//	$variables = (!empty($sharedkey))?($_POST["v".$inc]."&sharedkey=".$sharedkey):$_POST["v".$inc];
			$DB->execute($pages_addModules,
                            $DB->escape($_POST["i".$inc]),
                            $DB->escape($pageid),
                            $DB->escape($_POST["c".$inc]),
                            $DB->escape($_POST["p".$inc]),
                            $DB->escape($_POST["pj".$inc]),
                            $DB->escape($_POST["x".$inc]),
                            $DB->escape($_POST["y".$inc]),
                            $DB->quote($variables),
                            ($inc+1),
                            $DB->escape($_POST["b".$inc]),
                            $DB->escape($_POST["m".$inc])
                        );

			if (isset($formaction) && $formaction==2)
			{
				// for ($j=0;$j<sizeof($tabUsers);$j++)
				// {
				$tabUsersList = implode(',',$tabUsers);
				$DB->execute($modules_addPageModules,
										$DB->escape($_POST["i".$inc]),
										$DB->escape($_POST["c".$inc]),
										$DB->escape($_POST["p".$inc]),
										$DB->escape($_POST["pj".$inc]),
										$DB->escape($_POST["x".$inc]),
										$DB->escape($_POST["y".$inc]),
										$DB->quote($_POST["v".$inc]),
										($inc+1),
										$DB->escape($_POST["b".$inc]),
										$DB->escape($_POST["m".$inc]),
										$tabUsersList,
										$DB->escape($pageid)
							);
				//}
			}	
			$inc++;
		}
	}
	$log=new log();
	$log->addLog($DB,'Page creation (NAME:'.$_POST['name'].';ID:'.$pageid.')');
}

$file=new xmlFile();
$file->header("pagemodifadd");
$file->status(1);
$file->footer();

?>