<?php
# ************** LICENCE ****************
/*
	Copyright (c) PORTANEO.

	This file is part of POSH (Portaneo Open Source Homepage) http://sourceforge.net/projects/posh/.

	POSH is free software: you can redistribute it and/or modify
	it under the terms of the GNU General Public License as published by
	the Free Software Foundation, either version 3 of the License, or
	(at your option) any later version

	POSH is distributed in the hope that it will be useful,
	but WITHOUT ANY WARRANTY; without even the implied warranty of
	MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
	GNU General Public License for more details.

	You should have received a copy of the GNU General Public License
	along with Posh.  If not, see <http://www.gnu.org/licenses/>.
*/
# ***************************************
# SQL AZURE classes
#
# !! be careful, this file must be saved under uft8 format, and display an e accentuated here : é
# ***************************************

define('FETCH_OBJECT',1);
define('FETCH_ARRAY',2);

class connection
{
	var $id;
	var $sql;
	var $result;
	/*
		connection : Ctor
		Inputs:
			$server (string) : SQL Azure server (e.g : tcp:g9kexdqojs.database.windows.net,1433)
			$usernamedb (string) : database login (UID) (e.g : monlogin@g2kexdqojs
			$passworddb (string) : database password
			$dbname (string) : database name
		output :
	*/
	function connection($server,$usernamedb,$passworddb,$dbname)
	{
		$connectionInfo = array(
            "UID" => $usernamedb,
            "pwd" => $passworddb,
            "Database" => $dbname
        );
        $this->id = sqlsrv_connect($server, $connectionInfo);
		
		if ($this->id)
		{
			//$this->selectDB($dbname);
			//$this->setUtf8();
		}
		else
		{
			$this->warning();
		}
	}
	/*
		selectDB : select a database
		inputs:
			$name (string) : database name
		output :
			true or error number
	*/
	function selectDB($name)
	{
		//return mysql_select_db($name);
        return true;
	}
	/*
		close : close the server connexion
	*/
	function close()
	{
		if ($this->id)
		{
			sqlsrv_close( $this->id);
		}
		else
		{
			$this->warning();
		}
	}
	/*
		getResults : build array with query results
		Inputs :
			$sql (string) : SQL query
	*/
	function getResults($sql)
	{
		if (func_num_args()>1)
		{
			$args = func_get_args();
			array_shift($args);
			$this->sql=vsprintf($sql,$args);
		}
		else
		{
			$this->sql=$sql;
		}
		$this->result = sqlsrv_query($this->id, $this->sql, array(), array( "Scrollable" => SQLSRV_CURSOR_STATIC ));
		if (!$this->result) $this->warning();
	}
	/*
		nbResults : return last query results number
		Output : number of rows
	*/
	function nbResults()
	{
		return sqlsrv_num_rows($this->result);
	}
	/*
		fetch : return a row of sqlserver query results
		Inputs :
			$type (integer) : result type
		Output : array
	*/
	function fetch($type)
	{
		$l_type= ($type==0)
            ? SQLSRV_FETCH_ASSOC 
            : SQLSRV_FETCH_NUMERIC;

		return sqlsrv_fetch_array($this->result, $l_type);
	}
	/*
		freeResults : Free all memory associated with last query
	*/
	function freeResults()
	{
		if (is_resource($this->result)) {
			sqlsrv_free_stmt($this->result);
		}
	}
	/*
		execute : execute a SQL query
		Inputs :
			$sql (string) :  SQL query
		Output : true or error number
	*/
	function execute($sql)
	{
		if (func_num_args()>1)
		{
			$args = func_get_args();
			array_shift($args);
			$this->sql=vsprintf($sql,$args);
		}
		else
		{
			$this->sql=$sql;
		}
        	

		$this->result = sqlsrv_query($this->id, $this->sql);
		if ($this->result === false) {
			$this->warning();
			//return mysql_errno($this->id);
			return 0;
		}
		return $this->result;
	}
	/*
		getId : get new record ID for last SQL query
		Output : integer, new record ID
	*/
	function getId()
	{
        //return mysql_insert_id($this->id);
        $this->getResults('SELECT @@IDENTITY');
        $rowAzureClass = $this->fetch(1);
        $newIdentity = $rowAzureClass[0];
        $this->freeResults();
        //return sqlsrv_get_field( $this->result, 0);
        return (empty($newIdentity) ? '0' : $newIdentity);
	}
	/*
		nbAffected : return number of rows affected by last query
		Output : integer
	*/
	function nbAffected()
	{
		//return sqlsrv_rows_affected($this->id);
		return sqlsrv_rows_affected($this->result);
	}
	/*
		showError : Return SQL Server error message for last query
		output : string
	*/
	function showError()
	{
        $errorMsg = "";
        if( ($errors = sqlsrv_errors() ) != null)
        {
            foreach( $errors as $error)
            {
                $errorMsg .= "SQLSTATE: ".$error[ 'SQLSTATE']."\n"
                    . "code: ".$error[ 'code']."\n"
                    . "message: ".$error[ 'message']."\n";
            }
        }

		return $errorMsg;
	}
	/*
		warning : display latest SQL SERVER error message
		Output : string, error message
	*/
	function warning()
	{
		Global $pagename;
		$errormsg = $this->showError();
        if (empty($errormsg))
            $errormsg = 'Unknown error';
		echo $errormsg;
		error_log("WARNING SQL : ".$this->sql." SET AN ERROR => ".$errormsg." FROM PAGE ".$pagename);
        sqlsrv_query($this->id, 'INSERT INTO adm_log (log,logdate,typ) VALUES ("'.$pagename.' : '.$errormsg.'",CURRENT_DATE,"O") ');
        
	}
	function noSqlInjection($str,$type)
	{
		/*	$type=1 : numeric value
			$type=2 : string value with no " or ' or /or \ or ? or = ... ex: password, login
			$type=3 : string that can contain " or ' but no = or # or -- */
		if ($type==1 && !is_numeric($str)) return "";
		if ($type==2) $str=$str;
		if ($type==3){
			$str=str_replace("--","",$str);
			$str=strtr($str,"=#","  ");
		}
		return $str;
	}
	/*
	 * Prevent SQL injection
	 * Input :
	 *	$str (string) : string to escape
	 *	$force (boolean) : escape even if magic_quotes are on
	 * Return :
	 *	$str escaped
	 */
	function escape($str,$force=false)
	{
		// If we need to escape the string
		if (get_magic_quotes_gpc() && !$force)
		{
			$str = stripslashes($str);
		}
		$str = $str;
		return $str;
	}
	
	/*
	 * Quotes a string for a query
	 * Input :
	 * 	$str (string) : string to quote
	 *	$force (bool) : take a look at $this->escape
	 * Returns :
	 *	$str quoted and escaped
	 */
	function quote($str,$force=false)
	{
		return "'".$this->escape($str,$force)."'";
	}
	/*
	 * Avoid javascript injection 
	 * Input :
	 * 	$str (string) : string to check
	 * Returns :
	 *	$str with javascript removed, quoted and escaped
	 */
	function noJavascript($str,$force=false)
	{
        //remove script balise
        $str = preg_replace('
                            /<[^<]*script[^\>]*>
                            .*?
                            <\/script>
                            /xmsi',"",$str);

		//remove events on tags
		$str = str_ireplace('onabort','',$str);
		$str = str_ireplace('onblur','',$str);
		$str = str_ireplace('onclick','',$str);
		$str = str_ireplace('ondblclick','',$str);
		$str = str_ireplace('ondragdrop','',$str);
		$str = str_ireplace('onerror','',$str);
		$str = str_ireplace('onfocus','',$str);
		$str = str_ireplace('onkeydown','',$str);
		$str = str_ireplace('onkeypress','',$str);
		$str = str_ireplace('onkeyup','',$str);
		$str = str_ireplace('onload','',$str);
		$str = str_ireplace('onmouseover','',$str);
		$str = str_ireplace('onreset','',$str);
		$str = str_ireplace('onresize','',$str);
		$str = str_ireplace('onselect','',$str);
		$str = str_ireplace('onsubmit','',$str);
		$str = str_ireplace('onunload','',$str);

        // // remove javascript added inside tag with on* command and with " delimiter                    
        // $str = preg_replace('/
                                // <[^<]*
                                    // on[a-z]*\s*=
                                    // [^>]*>
                                    // .*?
                                    // <\s*\/[^>]*>
                            // /xmsi',"",
                            // $str);

        // // remove javascript added inside simple tag with on* command and with " delimiter                       
        // $str = preg_replace('/
                                // <   [^<]*
                                    // on[a-z]*\s*=
                                    // [^>]*
                                // >
                            // /xmsi',"",
                            // $str);
       return $this->quote($str);
	}
	function noHTML($str,$force=false)
	{
		return $this->quote(strip_tags($str),$force);
	}
	function setUtf8()
	{
		$this->execute("SET NAMES 'utf8' ");
		$this->execute("SET CHARACTER SET 'utf8' ");
	}
	
	/*
	 * Select
	 * Input :
	 *	$type (int) : FETCH_OBJECT or FETCH_ARRAY
	 *	args : sql select with parameters
	 * Returns :
	 *	(array of objects) if $type==FETCH_OBJECT 
	 *	(array of arrays) if $type==FETCH_ARRAY
	 */
	function select($type=FETCH_OBJECT)
	{
		if (func_num_args()>1)
		{
			$args = func_get_args();
			array_shift($args);
			$sql=array_shift($args);
			if (count($args)!=0) $sql=vsprintf($sql,$args);
		}
		else
		{
			$sql = $this->sql;
		}
		$this->getResults($sql);
		// Get the result
		$last_result = array();
		if ($type == FETCH_ARRAY)
		{
			while($r = sqlsrv_fetch_array($this->result, SQLSRV_FETCH_ASSOC))
			{
				$last_result[] = $r;
			}
		}
		else
		{
			while($r = sqlsrv_fetch_object($this->result))
			{
				$last_result[] = $r;
			}
		}
		
		// VOT : ajout de la libération mémoire
		//$this->freeResults();
		
		return $last_result;
	}
	
	function get_row()
	{
		$r = $this->select();
		if (count($r)>=1)
			return $r[0];
		return array();
	}
}
?>