<?php
/*
	Copyright (c) PORTANEO.

	This file is part of POSH (Portaneo Open Source Homepage) http://sourceforge.net/projects/posh/.

	POSH is free software: you can redistribute it and/or modify
	it under the terms of the GNU General Public License as published by
	the Free Software Foundation, either version 3 of the License, or
	(at your option) any later version

	POSH is distributed in the hope that it will be useful,
	but WITHOUT ANY WARRANTY; without even the implied warranty of
	MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
	GNU General Public License for more details.

	You should have received a copy of the GNU General Public License
	along with Posh.  If not, see <http://www.gnu.org/licenses/>.
*/
# !! be careful, this file must be saved under uft8 format, and display an e accentuated here : é
function suppress_accent($str) 
{ 
    if (function_exists('mb_strtolower'))
	{
		$str= mb_strtolower($str, 'UTF-8');
	}
	else
	{
		$str= strtolower($str);
	}
    $str = str_replace( 
        array( 
            'à', 'â', 'ä', 'á', 'ã', 'å', 
            'î', 'ï', 'ì', 'í', 
            'ô', 'ö', 'ò', 'ó', 'õ', 'ø', 
            'ù', 'û', 'ü', 'ú', 
            'é', 'è', 'ê', 'ë', 
            'ç', 'ÿ', 'ñ', 
        ), 
        array( 
            'a', 'a', 'a', 'a', 'a', 'a', 
            'i', 'i', 'i', 'i', 
            'o', 'o', 'o', 'o', 'o', 'o', 
            'u', 'u', 'u', 'u', 
            'e', 'e', 'e', 'e', 
            'c', 'y', 'n', 
        ), 
        $str 
    ); 
    
    return $str;        
}

/*
 * verifies if the email is in a good format
 * Input:
 *	$email (string) : string to test
 * Returns :
 *	True if the input is in the good format
 */
function is_email($email)
{
	$search = "/^[a-z0-9\.\-_]+@[a-z0-9\.\-_]+\.[a-z]{2,3}$/i";
	
	return (preg_match($search,$email) !=0);
}
/*
 * Returns true if $string is valid UTF-8 and false otherwise.
 * since 1.14
 * WARNING: Use this function instead of isUTF8 because isUTF8 requires mb_convert_encoding PHP library
 * Input:
 *	$string (string) : string to test
 * Returns :
 *	True if the input is in UTF8 format
 */
function is_utf8($string) {
	// From http://w3.org/International/questions/qa-forms-utf-8.html
	// This crashed apache when get page source code from http://www.deezer.com
	/*
	return preg_match('%^(?:
		  [\x09\x0A\x0D\x20-\x7E]            
		| [\xC2-\xDF][\x80-\xBF]             
		|  \xE0[\xA0-\xBF][\x80-\xBF]        
		| [\xE1-\xEC\xEE\xEF][\x80-\xBF]{2}  
		|  \xED[\x80-\x9F][\x80-\xBF]        
		|  \xF0[\x90-\xBF][\x80-\xBF]{2}     
		| [\xF1-\xF3][\x80-\xBF]{3}         
		|  \xF4[\x80-\x8F][\x80-\xBF]{2}
	)*$%xs', $string);
	*/
	
   return preg_match('/\A(
			[\x20-\x7E]                         # ASCII
		   | [\xC2-\xDF][\x80-\xBF]             # non-overlong 2-byte
		   |  \xE0[\xA0-\xBF][\x80-\xBF]        # excluding overlongs
		   | [\xE1-\xEC\xEE\xEF][\x80-\xBF]{2}  # straight 3-byte
		   |  \xED[\x80-\x9F][\x80-\xBF]        # excluding surrogates
		   |  \xF0[\x90-\xBF][\x80-\xBF]{2}     # planes 1-3
		   | [\xF1-\xF3][\x80-\xBF]{3}          # planes 4-15
		   |  \xF4[\x80-\x8F][\x80-\xBF]{2}     # plane 16
		)*\z/x', $string);
} 
/*
 * Returns true if $string is valid UTF-8 and false otherwise.
 * WARNING: Use is_utf8 instead because isUTF8 require mb_convert_encoding PHP library
 * Input:
 *	$string (string) : string to test
 * Returns :
 *	True if the input is in UTF8 format
 */
function isUTF8($str) {
	if ($str === mb_convert_encoding(mb_convert_encoding($str, "UTF-32", "UTF-8"), "UTF-8", "UTF-32")) {
		return true;
	} else {
		return false;
	}
}
/*
 * Returns random MD5 key
 * Input:
 *	non
 * Returns :
 *	random string
 */
function randomKey() {
	return md5(uniqid(rand(), true));
}

/*
 * verifies if the password has a mix of letters, numbers and symbols
 * Input:
 *	$password (string) : password
 * Returns :
 *	String if the password is in the good format
 */
function isMixPassword($password) {
	$error = '';
	if(__CONNECTION_SECURITY_LEVEL>=3) {
		if(
			!preg_match('/[_<>.*!:;,§\/?µ%&“”„\'"()=+{}~#|`^\\]$£€¤^¨]|[\\\\]|[-]/',$password) 
			|| !preg_match('/[a-zA-Z]+/',$password) 
			|| !preg_match('/[0-9]+/',$password)
		) {
			$error = lg("msgErrPasswordMix").".<br />";
		}
	}
	return $error;
}
 
/*
 * convert an RFC date to something like yyyy-mm-jj hh-mm-ss
 * Input:
 *	$rfc_date (date) : RFC date
 * Returns :
 *	String like yyyy-mm-jj hh-mm-ss
 */
function convertRFC_date($rfc_date) {
    $days = array("Mon","Tue","Wed","Thu","Fri","Sat","Sun");
    $artDay = substr($rfc_date, 0, 3);
    if (in_array($artDay, $days)) {
        $rfc_date = date("Y-m-d H:i:s",strtotime((string)($rfc_date)));
    }
    return $rfc_date;
} 
 
?>