<?php
# *********************** LICENSE *****************************************************	#
#	This file is part of CAS plugin.													#
#																						#
#	CAS plugin is free software; you can redistribute it and/or modify					#
#	it under the terms of the GNU General Public License as published by				#
#	the Free Software Foundation; either version 2 of the License, or					#
#	(at your option) any later version.													#
#																						#
#	CAS plugin is distributed in the hope that it will be useful,						#
#	but WITHOUT ANY WARRANTY; without even the implied warranty of						#
#	MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the						#
#	GNU General Public License for more details.										#
#																						#
#	You should have received a copy of the GNU General Public License					#
#	along with Foobar; if not, write to the Free Software								#
#	Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA			#
# *************************************************************************************	#


/************************************************
*	CAS plugin file								*
*	file: plugin_cas.php						*
*	version: 2.10                           	*
*	date: 03/06/2008                          	*
*	author: Jean-francois Rey               	*
*	email: jean-francois.rey@univ-avignon.fr  	*
************************************************/

/*
 * name: plugin CAS
 * description: CAS plugin
 * dependencies: no
 * author: Jean-François REY
 * url: http://gpl.univ-avignon.fr
 */
 
 define("CAS_NAME","plugin CAS"); 

include_once("cas.inc.php");
include_once("plugcas_tools.php");
include_once('CAS/CAS.php');

/*
  * Registers the action in order to install and uninstall the plugin
  */
 register_hook('install_plugin_cas/plugin_cas','plugcas_install');
 register_hook('uninstall_plugin_cas/plugin_cas','plugcas_uninstall');

// show configuration
 register_hook("display_plugin","plugcas_display",10,1);
 
 register_hook("iframe_plugin","iframe_plugcas",10,1);
 
// save configuration in DB
 register_hook("admin_scr_config_plugins","plugcas_save_config");
// save configuration in file
 register_hook("admin_scr_generate_configfiles","plugcas_save_file");
// how to login
 register_hook("userinterface_header","plugcas_userinterface_header",1,1);
// how to redirect after cas
 register_hook("userinterface_end","plugcas_userinterface_end",1,1);
// logout from cas server
 register_hook("logout","plugcas_logout");
// Admin logout
 register_hook("admin_header","plugcas_admin_header");
// login form
 register_hook("display_login_form","plugcas_display_login_form",1);

 
 function getUserLang() {
    //get navigator language to translate the cas login page
    $navlang = explode(',',$_SERVER['HTTP_ACCEPT_LANGUAGE']);
    $avLangs = array('fr','en');
    $locale = "&locale=fr";
    if (in_array($navlang[0],$avLangs)) {
        $locale = "&locale=".$navlang[0];
    }
    return $locale;
 } 
 
 // show configuration
 function plugcas_display($info)
 {
	if ($info['name'] == CAS_NAME) {
        if ( isset($info["ajaxplug"]) && $info["ajaxplug"] == 1) {
            echo '<iframe frameborder="0" marginwidth="1%" height="250px" width="80%" src="../admin/scr_plugin.php?plugname=iframe_plugcas"></iframe>';
        } else {
            require_once("plugin_cas_config.php");
        }
    }
 } 
 
 function iframe_plugcas ($name) {
    if($name == "iframe_plugcas" ) {
        if( isset($_POST['enregistrer']) ) {
            require_once("../includes/plugins/plugin_cas/scr_plugin_cas_config.php");
        }
        require_once("../includes/plugins/plugin_cas/plugin_cas_config.php");
    }
 }

/*
  * Install function
  */
function plugcas_install()
{
	$inc=0;
	while ( isset($_POST["plugi".$inc]) )
	{
		if($_POST["name".$inc] == CAS_NAME && $_POST["plugi".$inc] == 0)
		{
			global $DB;
			// create table adm_config_ldap
			$sql = "DROP TABLE IF EXISTS `adm_config_cas`;";
			$DB->execute($sql);
			$sql = "CREATE TABLE `adm_config_cas` (`parameter` varchar(16) character set utf8 collate utf8_unicode_ci NOT NULL default '', `value` text character set utf8 collate utf8_unicode_ci NOT NULL, `datatype` char(3) NOT NULL default '', `desttype` char(1) NOT NULL default '', PRIMARY KEY  (`parameter`)) TYPE=MyISAM DEFAULT CHARSET=utf8 COMMENT='CAS plugin configuration parameters';";
			$DB->execute($sql);
			//a user cannot switch account or change his password
            $sql = "UPDATE adm_config SET value='false' WHERE parameter = 'passwordChangePermission'";
            $DB->execute($sql);
            $sql = "UPDATE adm_config SET value='false' WHERE parameter = 'userChangePermission'";
            $DB->execute($sql);
            
            break;  
		}
		$inc++;
	}
}

/*
  * Uninstall function
  */
function plugcas_uninstall()
{
	global $DB;
	$sql = "DROP TABLE IF EXISTS `adm_config_cas`;";
	$DB->execute($sql);
    $sql = "UPDATE adm_config SET value='true' WHERE parameter = 'passwordChangePermission'";
    $DB->execute($sql);
    $sql = "UPDATE adm_config SET value='true' WHERE parameter = 'userChangePermission'";
    $DB->execute($sql);
}

/*
 * Save plugin configuration in Data Base
 */
 function plugcas_save_config()
{
	$inc=0;
	while ( isset($_POST["plugi".$inc]) )
	{
		if($_POST["name".$inc] == CAS_NAME)
		{
			if(isset($_POST["modifCas_plugin"]) && $_POST["modifCas_plugin"] == 1)
			{
				require_once("scr_plugin_cas_config.php");
			}
			break;
		}
		$inc++;
	}
}

// save configuration in file cas.inc.php
 function plugcas_save_file()
{
global $DB;

// save on file
$contentcas="<?php".chr(13).chr(10);

// read config from DB
$sql = "SELECT parameter,value,datatype,desttype FROM adm_config_cas ";
$DB->getResults($sql);
while ($row = $DB->fetch(0)){
	if ($row["desttype"]=="C"){
                switch($row["datatype"]){
                        case "int":
                                $contentcas.='define("__'.$row["parameter"].'",'.$row["value"].');'.chr(13).chr(10);
                                break;
                        case "str":
                                $contentcas.='define("__'.$row["parameter"].'","'.addslashes($row["value"]).'");'.chr(13).chr(10);
                                break;
                        case "arr":
                                $contentcas.='$'.'__'.$row["parameter"].'='.$row["value"].';'.chr(13).chr(10);
                                break;
                }
        }
}
$DB->freeResults();

// create and/or create the file cas.inc.php
if (!$handle = fopen("../includes/plugins/plugin_cas/cas.inc.php", 'w+'))
{
	echo "Can\'t open cas.inc.php file";
        exit;
}

if (fwrite($handle, $contentcas."?>") === FALSE) {
	echo "Can't write in cas.inc.php file";
        exit;
}
fclose($handle);

}

// userinterface : first things are do! -> login
function plugcas_userinterface_header($page)
{
$locale = getUserLang();
echo "<script type='text/javascript'>";
// log to cas server
if( __defaultAuthen=="cas" && $page=="portal/index.php" )
{

    $redirect_to = "";
	// first connected
	// go to cas if not already went to cas
	if(__defaultmode=="connected" && !isset($_REQUEST['ticket']) )
	{
		echo "\$"."p.navigator.openLink('".__CAS_PROTO."://".__CAS_SERVER.":".__CAS_PORT.__CAS_FOLDER."/login".__CAS_RETURN."/login.php".$locale."');";	
	}
	// default
	// login send to cas
	else
	{
		//login menu
		echo "function \$"."p.app.connection.menu(){\$"."p.navigator.openLink('".__CAS_PROTO."://".__CAS_SERVER.":".__CAS_PORT.__CAS_FOLDER."/login".__CAS_RETURN."/login.php".$locale."');}";
		// Save menu!!
		echo 	"function \$"."p.app.connection.saveMenu(){\n",
			"if (showBoxStatus){hideBox();}\n",
			"var l_s=\"<table><tr>\";\n",
			"l_s+=\"<td valign=top width='400'><div class='bottomhr'><b>\"+lg(\"lblAccountCreation\")+\" \"+__apname+\" :</b></div><br />\";\n",
			"l_s+=\"<form name='form1' method='post' onsubmit=\\\"return link('".__CAS_PROTO."://".__CAS_SERVER.":".__CAS_PORT.__CAS_FOLDER."/login".__CAS_RETURN."/index.php?connect=firstsave".$locale."');\\\">\";\n",
			"l_s+=\"<table cellspacing='0' cellpadding='0' border='0'>\"\n",
			"l_s+=\"<center><input class='btn' type='submit' name='\"+lg(\"lblOk\")+\"' style='width:250px' value='\"+lg(\"lblSavePage\")+\"' /></center>\"\n",
			"l_s+=\"</table></form><br />\";\n",
		
			"l_s+=\"</td><td width='50'></td><td valign='top' width='400'><div class='bottomhr'><b>\"+lg(\"lblAlreadyMember\")+\" ?</b></div>\";",
			"l_s+=\"<form name='form2' method='post' onsubmit=\\\" return link('".__CAS_PROTO."://".__CAS_SERVER.":".__CAS_PORT.__CAS_FOLDER."/login".__CAS_RETURN."/index.php?connect=save".$locale."');\\\">\";",
			"l_s+=\"<table cellspacing='0' cellpadding='0' border='0'>\";",
			"l_s+=\"<tr><td colspan='2' align='center'><br /><input class='btn' type='submit' value='\"+lg(\"lblSavePage\")+\"' style='width:250px' /></td></tr>\";",
			"l_s+=\"</table></form>\";",
			"l_s+=\"</td></tr></table>\";",
			"\$"."p.print(\"box\",box(0,img(\"ico_menu_disk.gif\",16,16,\"\",\"imgmid\")+\" \"+lg(\"lblSavePage\"),\"hideBox()\",l_s));\n",
			"\$"."p.show(\"box\",\"block\");",
			"showBoxStatus=true;\n",
			"return false;",
			"}";
	}
}
elseif(__defaultAuthen == "cas" && $page == "portal/login.php" && !isset($_REQUEST['ticket']) ) 
{
echo "\$"."p.navigator.openLink('".__CAS_PROTO."://".__CAS_SERVER.":".__CAS_PORT.__CAS_FOLDER."/login".__CAS_RETURN."/login.php".$locale."');";
}
// my profile menu when change user
//echo "p_network.changeProfile = new Function(\"$"."p.navigator.openLink('".__LOCALFOLDER."portal/scr_authentif.php?act=logout&from=change');\");";

echo "</script>";
}

// login.php
function plugcas_display_login_form(){
    $locale = getUserLang();
	echo "<script type='text/javascript'>";
	phpCAS::client(__CAS_VERSION,__CAS_SERVER,__CAS_PORT,__CAS_FOLDER,false);

	if(__LANG=="fr") phpCAS::setLang(PHPCAS_LANG_FRENCH);
	else phpCAS::setLang(PHPCAS_LANG_ENGLISH);

	//phpCAS::forceAuthentication();
	if(phpCAS::checkAuthentication())
	{	
		// ok go to user page
		$user = phpCAS::getUser();
		echo "var fcas = new Array(); fcas.password = new Array(); fcas.password.value=".random_number().";";
		echo "fcas.username = new Array(); fcas.username.value='".$user."';";
		echo "\$"."p.app.connection.set(fcas,\$p.app.pages.isPageExisting);";
	}
	else echo "\$"."p.navigator.openLink('".__CAS_PROTO."://".__CAS_SERVER.":".__CAS_PORT.__CAS_FOLDER."/login".__CAS_RETURN."/login.php".$locale."');";
	echo "</script>";
}

// page index end
function plugcas_userinterface_end($page)
{
// if went to cas server, got a ticket -> check it
if( __defaultAuthen=="cas" && $page=="portal/index.php" && isset($_REQUEST['ticket']))
{
	phpCAS::client(__CAS_VERSION,__CAS_SERVER,__CAS_PORT,__CAS_FOLDER,false);

	if(__LANG=="fr") phpCAS::setLang(PHPCAS_LANG_FRENCH);
	else phpCAS::setLang(PHPCAS_LANG_ENGLISH);

	//phpCAS::forceAuthentication();
	if(phpCAS::checkAuthentication())
	{	
		// ok go to user page
		$user = phpCAS::getUser();
		echo "<script type='text/javascript'>";
		echo "var fcas = new Array(); fcas.password = new Array(); fcas.password.value=".random_number().";";
		echo "fcas.username = new Array(); fcas.username.value='".$user."';";
		echo "fcas.longname = new Array(); fcas.longname.value='';";

		// link save
		if(isset($_REQUEST['connect']))
		{
			//first connection
			if( $_REQUEST['connect'] == "firstsave")
			{
				$numpwd = random_number();
				echo "fcas.pass = new Array(); fcas.pass.value=".$numpwd.";fcas.confpass = new Array(); fcas.confpass.value=".$numpwd.";",
				"fcas.autoconn = new Array();";
				echo "$"."p.app.connection.subscribe(fcas,savePage);";
			}
			// already connected
			else echo "$"."p.connection.set(fcas,savePage);";
		}
		// login
		else
		{	
			echo "window.stop();";
			echo "$"."p.connection.set(fcas,link,true);";
		}
		echo "</script>";
	}
}
}

// check authentication cas
if (defined("__defaultAuthen")
    && __defaultAuthen=="cas" 
    && !function_exists('user_login_form') ):
// call by user_login
function user_login_form($username,$password,&$user,&$errormsg)
{
	global $DB,$authentif_getUserByName;
	launch_hook('user_login_form',$username,$password);
	//Check the password
	$DB->getResults($authentif_getUserByName,$DB->quote($username));
	if ($DB->nbResults()<=0)
	{
		$errormsg.=lg("incorrectLogin");
	} else
	{
		$row=$DB->fetch(0);
		if ($row["typ"]=="N" OR $row["typ"]=="M")
		{
			$errormsg.=lg("userNotValidated");
		}
		else
		{
			if( $row["typ"]=="A" )
			{ 
				if( $row["password"]<>md5($password) )
				{
					$errormsg.=lg("incorrectLogin");
				}
			}
			else
			{
				phpCAS::client(__CAS_VERSION,__CAS_SERVER,__CAS_PORT,__CAS_FOLDER,false);
                
				if(__LANG=="fr") phpCAS::setLang(PHPCAS_LANG_FRENCH);
				else phpCAS::setLang(PHPCAS_LANG_ENGLISH);

				//phpCAS::forceAuthentication();
				if(phpCAS::checkAuthentication() && phpCAS::getUser() == $username)
				{
					// ok go to user page
					$usercas = phpCAS::getUser();
				}
				else
				{
					$errormsg.=lg("incorrectLogin");
				}	
			}
		}
		if( $errormsg == "" )
		{
			$user->id=$row["id"];
			$user->username=$username;
			$user->type=$row["typ"];
			$user->lang=$row["lang"];
			$user->longname=$row["long_name"]==""?$username:$row["long_name"];
			$user->activity = $row["activity"];
			$user->picture = $row["picture"];
			$user->pass = md5($password);
			$DB->freeResults();
			return true;
		}
	}
	$DB->freeResults();
	return false;
}
endif;

// logout
function plugcas_logout()
{
$locale = getUserLang();
if (__defaultAuthen=="cas"){
    $from = (isset($_GET["from"]))  ?   $_GET["from"]   :   '';
	if(isset($_GET["act"]) && $_GET["act"]=="logout" && $from != "A") { // not admin
		// initialize phpCAS
		phpCAS::client(__CAS_VERSION,__CAS_SERVER,__CAS_PORT,__CAS_FOLDER,false);
		if(__LANG=="fr") phpCAS::setLang(PHPCAS_LANG_FRENCH);
		else phpCAS::setLang(PHPCAS_LANG_ENGLISH);
		if(phpCAS::checkAuthentication()) {
			// change user
			if( $from == "change") phpCAS::logout(__CAS_PROTO."://".__CAS_SERVER.":".__CAS_PORT.__CAS_FOLDER."/login".__CAS_RETURN.$locale);
			// just logout
			else phpCAS::logout(__LOCALFOLDER.$locale);
		}
	}
}
}

// admin logout
function plugcas_admin_header()
{
    $locale = getUserLang();
	echo "<script type='text/javascript'>\n",
	"function $"."p.app.logout () {\$"."p.navigator.openLink('".__LOCALFOLDER."portal/scr_authentif.php?act=logout&from=A".$locale."');}\n",
	"</script>\n";
}
?>