<?php
/*
 * name: Plugin Lasso
 * description: This plugin add a login connection to a Lasso server (pratic/authentic from Entrouvert)
 * dependencies: no
 * author: http://www.portaneo.com
 * url: 
 */
 
 // Your lib
 //require_once('Lasso_lib.php');
 
 /*
  * Registers the action in order to install the plugin
  * replace install_plugin test 2.0/plugin by install_fileNameWithout.Php
  */
 
require_once("../includes/users_tools.php"); 
  
 register_hook('lasso_plugin_install/plugin_lasso','lasso_plugin_install');
 register_hook('lasso_plugin_uninstall/plugin_lasso','lasso_plugin_uninstall');
 
 /*
  * Do something really useless
  */
register_hook("display_plugin","plugin_lasso_display",10,1);

register_hook("iframe_plugin","iframe_pluglasso",10,1);
 
register_hook("logout","pluglasso_logout");
  
register_hook("userinterface_header","pluglasso_userinterface_header",1,1);
 
register_hook("display_login_form","pluglasso_display_login_form",1);
 
 //register_admin_tab('myplug2_tab','Your plugin 2.0','myplug2_admin_display');
 
 function myplug2_admin_display()
 {
	echo "<h2>Plugin Lasso to Authentic/Pratic sso server </h2>";
   
 }
  
 // Something really useless
 function plugin_lasso_display($infos)
 {
    if ($infos['name'] == 'Plugin Lasso') {
        echo '<iframe frameborder="0" marginwidth="1%" height="150px" width="80%" src="../admin/scr_plugin.php?plugname=iframe_pluglasso"></iframe>';       
    }
 }
 /*
 *   \brief iframe_pluglasso
 * 
 *  open ifr ame to configure plugin in admon 2.1 and +
 */
 function iframe_pluglasso ($name) {
    if($name == "iframe_pluglasso" ) {
        require_once("../includes/xmldom_tool.php"); 
        $lasso_lang_file = "l10n/lasso_".__LANG.".xml";
        $filepath = __FILE__;
        $cpl_lasso_lang_file =  preg_replace('/plugin_lasso.php/',$lasso_lang_file,$filepath);
        if ( file_exists($cpl_lasso_lang_file) ) {
            $datas = posh_getMsgDatas($cpl_lasso_lang_file);
            echo "<script>\n".$datas['js']."\n</script>";
        }
        //spkitlasso and lassospkit must exist
        if (!@include('../spkitlasso/lassospkit_public_api.inc.php') ) {
            echo '<p id="lassoconfiguremsg">Configure yourkit lasso</p>';
            echo "<script>\$('lassoconfiguremsg').innerHTML = lg('LassoConfigureMsg');</script>";
        } else {
            echo '<p class="warning" id="lassoalert">lassospkit doesn\'t exist.</p>';
            echo "<script>\$('lassoalert').innerHTML = lg('spkitlassoNeeded');</script>";
        }
    }
 }
 /*
 * \brief pluglasso_userinterface_header
 *
 *  check connection in header of login page
 * if user is connected : send to portal without display login page
 *
 * @param[in]
 *      $page parameter send by each script wihic contains hook
 */
 function pluglasso_userinterface_header ($page) {
    if ( !isset($_GET['logout']) && $page=="portal/login.php") {
        echo "<script>";
        echo 'window.location.href=__LOCALFOLDER+"includes/plugins/plugin_lasso/login.php";';
        echo "</script>";
    }
 }
 
 /*
    pluglasso_display_login_form
    
    \brief    while login display, check if user is connected
        
        If connected: 
            get attributes, check data about user
          if not connected
            redirect to portal
                redirect to lasso login page
 
 */
 function pluglasso_display_login_form () {
    if (isset($_GET['logout'])) {  
        echo "<script>";
        echo "var url = __LOCALFOLDER+ 'includes/plugins/plugin_lasso/login.php';";
        echo '$("displayPart").innerHTML = \'<a href="\'+url+\'">\'+lg(\'lblConnectToYourPortal\')+"</a>";';
        echo '$("displayPart").style.height="150px";';
        echo "</script>";
    } else {
        echo "<script>";
        echo 'window.location.href=__LOCALFOLDER+"includes/plugins/plugin_lasso/login.php";';
        echo "</script>";    
    }
 }
 
function pluglasso_logout () {
    if(isset($_GET["act"]) && $_GET["act"]=="logout" && $_GET["from"] != "A") {
        require_once('spkitlasso/lassospkit_public_api.inc.php');
        lassospkit_soap_defederate();
        lassospkit_soap_logout();
        lassospkit_clean();
        //posh deconnection
        //cancel autoconnexion
        setcookie('laststate','',time()-31536000);
        setcookie('autoi','',time()-31536000);
        setcookie('autop','',time()-31536000);
        header('Location: '.__LOCALFOLDER.'portal/login.php?logout=1');
        exit;
    }
}
 
 /*
  * Install function
  */
 function lasso_plugin_install()
 {
    //check if rights are set on files and directories
 
 }
 
 /*
  * Uninstall function
  */
  function lasso_plugin_uninstall()
 {

 }

?>