<?php
# *********************** LICENSE *****************************************************	#
#	This file is part of LDAP plugin.													#
#																						#
#	LDAP plugin is free software; you can redistribute it and/or modify					#
#	it under the terms of the GNU General  License as published by				#
#	the Free Software Foundation; either version 2 of the License, or					#
#	(at your option) any later version.													#
#																						#
#	LDAP plugin is distributed in the hope that it will be useful,						#
#	but WITHOUT ANY WARRANTY; without even the implied warranty of						#
#	MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the						#
#	GNU General  License for more details.										#
#																						#
#	You should have received a copy of the GNU General  License					#
#	along with Foobar; if not, write to the Free Software								#
#	Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA			#
# *************************************************************************************	#

/************************************************
*	class ldap									*
*	file: plugin_ldap_lib.php					*
*	version: 2.20								*
*	date: 21/05/2008							*
*	author: Jean-francois Rey					*
*	email: jean-francois.rey@univ-avignon.fr	*
************************************************/

if( file_exists("../includes/plugins/plugin_ldap/ldap.inc.php") ) require_once("../includes/plugins/plugin_ldap/ldap.inc.php");
include("plugldap_tools.php");

/**
*  ldap class
*
*
**/

class ldap
{
	var $id_connect_ldap;	// id connect
	var $server_ldap;		// server ldap
	var $server_ldap_port;// server port
	var $version_ldap;	// ldap version to use
	var $connect_type;	// read (r) or write (w)
	var $dn_connect;		// dn for authenticated user
	var $dn_connect_pass;	// password for authenticated user
	var $bind;			// id bind
	var $error;			// error log

/**
* Constructor
*
* @param variable $mode  r (read)  / w (write) / ur / uw (default r)
* @param variable  $uid uid of user (dn is build with  __LDAP_uid.'='.$uid.",".__LDAP_DN )
* @prarm variable $pwd
* @param variable 	$dn complete dn of user 
**/
	 function ldap($mode = 'r', $uid = "", $pwd = "", $dn = ''){
		if($mode == 'r')
		{
			$this->server_ldap = $this->get_serveur('r');
			$this->server_ldap_port = __LDAP_SERVER_PORT;
			$this->version_ldap = __LDAP_VERSION;
			if(__LDAP_connect == "read")
			{
				$this->connect_type = 'N';
				$this->dn_connect = __LDAP_DNREAD;
				$this->dn_connect_pass = base64_decode(__LDAP_PASSREAD);
			}
			else 
            {
                $this->connect_type = 'A';
            }
		}
		elseif($mode == 'w')
		{
			$this->server_ldap = $this->get_serveur('w');
			$this->version_ldap = __LDAP_VERSION;
			$this->connect_type = 'N';
			$this->dn_connect = __LDAP_DNWRITE;
			$this->dn_connect_pass = base64_decode(__LDAP_PASSWRITE);
		}
		elseif($mode == "ur")
		{
			$this->server_ldap = $this->get_serveur('r');
			$this->server_ldap_port = __LDAP_SERVER_PORT;
			$this->version_ldap = __LDAP_VERSION;
			$this->connect_type = 'N';
            if ($dn != "") {
                $this->dn_connect = $dn;
            }
			if($uid != "") $this->dn_connect = __LDAP_uid.'='.$uid.",".__LDAP_DN;
			if($pwd != "") $this->dn_connect_pass = $pwd;
		}
		elseif($mode == "uw")
		{
			$this->server_ldap = $this->get_serveur('w');
			$this->version_ldap = __LDAP_VERSION;
			$this->connect_type = 'N';
            if ($dn != "") {
                $this->dn_connect = $dn;
            }            
			if($uid != "") $this->dn_connect = __LDAP_uid.'='.$uid.",".__LDAP_DN;
			if($pwd != "") $this->dn_connect_pass = $pwd;
		}
		else $this->error = "mode connecting not specify";
	}
	
/***********************************************************************
* FONCTION SET_DN_CONNECT
* @param variable $dn dn of user
**********************************************************************/
	 function set_dn_connect($dn)
	{
		$this->dn_connect = $dn;
	}

/***********************************************************************
* FONCTION SET_LDAP_PASS
* @param variable  $pwd password
**********************************************************************/
	 function set_ldap_pass($pwd)
	{
		$this->dn_connect_pass = $pwd;
	}

/***********************************************************************
* FONCTION SET_LDAP_PORT
* @param variable $port  server default port
***********************************************************************/
	 function set_ldap_port($port)
	{
		$this->server_ldap_port = $port;
	}

/***********************************************************************
* FONCTION CONNECT
* connection au serveur ldap
***********************************************************************/
	 function connect()
	{
		if($this->id_connect_ldap =@ldap_connect($this->server_ldap,$this->server_ldap_port))
		{
			@ldap_set_option($this->id_connect_ldap, LDAP_OPT_PROTOCOL_VERSION, $this->version_ldap);
			if( 
                    ($this->connect_type == 'A' && $this->bind=@ldap_bind($this->id_connect_ldap) ) 
                    || 
                    (
                        $this->connect_type == 'N' && $this->bind=@ldap_bind($this->id_connect_ldap, 
                                                                            $this->dn_connect, 
                                                                            $this->dn_connect_pass) 
                    )
               )
			{
				return true;
			}
			else
			{
				$this->error = "Can't bind ldap server !";
				return false;
			}	
		}
		else
		{
			$this->error = "Can't Connect to ldap server !";
			return false;
		}
	}
/**
*   close
*
* close connection to server
*
**/
    
	 function close()
	{
		if($this->id_connect_ldap)
		{
			@ldap_close($this->id_connect_ldap);
			$this->id_connect_ldap = 0;
			$this->error = "";
		}
	}
/**
*	
*    return last error
*
**/    
	 function get_error()
	{	
		if($this->id_connect_ldap) $this->error .= "<br />".ldap_error($this->id_connect_ldap);
		if($this->error) return $this->error;
		else return "";
	}

	/************************************************************************/
	/* FONCTION GET_SERVEUR
	/* return a server from the list
	/* @param  mode 'r' pour les serveurs en lecture, 'w' pour ceux en ecriture
	/* @return  server
	/************************************************************************/
  	 function get_serveur($mode='r')
  	{
		if($mode == 'w') $_LDAPSERVERS =array(__LDAP_SERVERWRITE);
		else $_LDAPSERVERS =array(__LDAP_SERVER);

		srand((double)microtime()*1000000);
    		$num_serv = rand(0,count($_LDAPSERVERS)-1);

		return $_LDAPSERVERS[$num_serv];
	}

/************************************************************************
* FONCTION LDAP_CHECKUSER : verifie l'authentification LDAP d'un USER 
* in : dn du user, password
* out: true | false
* $user is an array
* *rs is a hash
************************************************************************/
	function ldap_checkuser($user,$password,&$rs)
	{
        if (  is_array($user) ) {
            $user = $user[0];
        }
       
        //si le filtre existes, effectue une recherche sur l'uid pour trouver le dn
        // et ne peut pas faire de recherche sur le dn
        //mais le groupe n'existe pas ncessairement, donc rcupre le dn et match ensuite le dn
        //if (defined('__LDAP_search_uid') && (__LDAP_search_uid)  ) {
		if (defined('__LDAP_filter') && (__LDAP_filter!='')  ) {
            //recherche l'uid, mais doit filtrer plus tard
            if ($this->connect()) {
                if( $rs = $this->get_uid("(".__LDAP_uid."=".$user.")") ) {
                    $user = $rs[__LDAP_uid];
                    if (!isset($rs['dn'])) {
                        error_log("When using the Filter for LDAP plugin, specify 'dn' in 'Attributs spars par une virgule:' ");
                        return false;
                    }
                    $dn = $rs['dn'];
                    if ( !$this->checkFilter($rs['dn']) ) {
                        $this->error = "User unauthorized";
                        return false;
                    }
                } 
            }
            else {
                return false;
            }
        }
        if (isset($rs['dn'])) {
            $dn = $rs['dn'];
        } else {
            $dn = __LDAP_uid."=".$user.",".__LDAP_DN;
        }

		if($connect=@ldap_connect($this->get_serveur('r'),$this->server_ldap_port))
		{
			@ldap_set_option($connect, LDAP_OPT_PROTOCOL_VERSION, $this->version_ldap);
			if($bind=@ldap_bind($connect, $dn, $password))
			{
				@ldap_close($connect);
				return(true);
			}
			else
			{
				@ldap_close($connect);
				$this->error = "User unknow and/or pwd !";
			}
		}
		else 
        {
            $this->error = "can't connect ldap server !";
        }
		return(false);
	}

    function checkFilter ($dn) {
        $accept = false;
        if (defined('__LDAP_filter')) {
//            error_log("LDAP: Filtering the DN...");
            //filter exists, check it
            //$filters = split(",",__LDAP_filter);
            $filters = preg_split("/[\s,]+/",__LDAP_filter);
            foreach ($filters as $filter) {
                if (preg_match("/$filter/i",$dn)) {
                    $accept = true;
                    break;
                }
            }
        } else {
            //no filter accept all user
            $accept = true;
        }
        return $accept;
    }
    
/********************************************************************************************
* FONCTION LDAP_CHECKUSERMAIL : verifie l'authentification LDAP d'un USER par son MAIL 
* @param variable $user user mail
*  @param variable $password   
*    
* @return bool true or false  
********************************************************************************************/
	 function ldap_checkusermail($mail,$password)
	 {
        global $rs;
		if ($this->connect()) {
    		if( $rs = $this->get_uid("(".__LDAP_mail."=".$mail.")") )
    		{
//                error_log("LDAP: User $mail exists in the LDAP");
    			$this->close();
    			return $this->ldap_checkuser($rs[__LDAP_uid],$password,$rs);
    		}
//            error_log("LDAP: User $mail does not exist in the LDAP");
    		$this->close();
    		return(false);
        }
        else {
//            error_log("LDAP: Connection failed");
            return false;
        }
	}

/************************************************************************
* FONCTION GET_INFOS : retourne 
* in : uid du user, infos : attributs LDAP sous formes d'un array
*        mode = 0 une valeur par attribut : = 1 toutes les valeur
*                                                    de chaque attribut
* out:
* array : infos voulues ou false en cas d'erreur
* mode 0: tableau associatif ['attribut']
* mode 1: tableau associatif + indexe ['attribut'][nb] nb>=0
************************************************************************/
  	 function get_infos($uid, $infos,$mode = 0)
  	{
  	      $dn=__LDAP_uid.'='.$uid.",".__LDAP_DN;
  	      $filter='(objectclass=*)';

  	      	if ($sr=@ldap_read($this->id_connect_ldap, $dn, $filter,$infos))
  	      	{
  	        	if($mode == 0)
  	        	{
				if( ($entry = @ldap_get_entries($this->id_connect_ldap, $sr)) != FALSE)
				{
  	          			$retour=array();
  	          			for ($i=0; $i<count($infos); $i++) {
                            if (isset($entry[0][$infos[$i]][0])) {
                                $retour[$infos[$i]]=$entry[0][$infos[$i]][0];
                            }
                        }
					return $retour;
				}
				else
				{
					$this->error = "Can't get entries on get_infos !";
    					return false;
				}
          		}
          		// mode == 1
          		else
          		{
            		if( ($entry = @ldap_get_entries($this->id_connect_ldap, $sr)) != FALSE)
					{
            			$retour=array();
            			for ($i=0; $i<count($infos); $i++)
              				for($j=0;$j<$entry[0][$infos[$i]]['count'];$j++)
                				$retour[$infos[$i]][$j]=$entry[0][$infos[$i]][$j];
            			return $retour;
					}
					else
					{
						$this->error = "Can't get entries on get_infos !";
    					return false;
					}
          		}
        	}
		else
		{
			$this->error = "Can't read info on user !";
    			return false;
		}
	}

	/************************************************************************/
	/* FONCTION CREATE_IMG : create img from jpegPhoto 
	/* in : uid du user, path file path to copy jpegphoto
	/* out:
	/* False: an error
	/* $path: OK
	/************************************************************************/
	 function create_img($uid,$path)
  	{
		$dn=__LDAP_uid.'='.$uid.",".__LDAP_DN;
  	    $filter='(objectclass=*)';

  	    if ($sr=@ldap_search($this->id_connect_ldap, $dn, $filter,array("jpegphoto")))
  	    {
			$entry1 = @ldap_first_entry($this->id_connect_ldap,$sr);
			if( ($entry = @ldap_get_values_len($this->id_connect_ldap, $entry1,"jpegphoto")) != FALSE)
			{
  	    		$retour = array();
				if( !$outjpeg = fopen($path, "wb"))
				{
					$this->error = "Can't open file $path !";
					return false;
				}
				if( fwrite($outjpeg, $entry[0]) === false)
				{
					fclose ($outjpeg);
					$this->error = "Can't write on file $path !";
					return false;
				}
				fclose ($outjpeg);
				return $path;
			}
			else
			{
				$this->error = "Can't get entries on get_infos_bin !";
    			return false;
			}
        }
		else
		{
			$this->error = "Can't read bin info on user !";
    		return false;
		}
	}

/************************************************************************/
/* FONCTION GET_UID : 
* if 
*
* @param variable $filtre : search filter
*  @param variable $mode    0  a value by attribute (default) 
                                            1 all values of each attribute
* 
* @return array 
* mode 0: tableau associatif ['attribut']
* mode 1: tableau associatif + indexe ['attribut'][nb] nb>=0
* @return bool
* array : infos voulues ou false en cas d'erreur
*
************************************************************************/
  	 function get_uid($filtre,$mode=0)
  	{
  		$dn=__LDAP_DN;
		//add other attributes to retrieve
        $att = array(__LDAP_uid);
        if ( defined('__LDAP_userattr') ) {
            //$allattrs = split(",", __LDAP_userattr );
            $allattrs = preg_split("/[\s,]+/",__LDAP_userattr);
            foreach ($allattrs as $c) {
                $c = trim($c);
                array_push($att,$c);
            }
        }

  	    if ( $sr=@ldap_search($this->id_connect_ldap, $dn, $filtre, $att) )
  	    {
          if ($mode==0) {
			if( ($entry = @ldap_get_entries($this->id_connect_ldap, $sr)) != FALSE)
			{
				$k=0;
				$retour=array();
				foreach ($att as $attkey) {
                        if (  $attkey == "preferredlanguage" && !isset($entry[$k][$attkey][0]) ) {
                            $retour[$attkey] = __LANG;
                        } 
                        elseif ($attkey == "ou" && isset($entry[$k][$attkey]) && is_array($entry[$k][$attkey])) {                           
                            $ouTab = array();
                            for ($cpt=0;$cpt<count($entry[$k][$attkey]);$cpt++) {
                                if (isset($entry[$k][$attkey][$cpt])) {
                                    array_push($ouTab, $entry[$k][$attkey][$cpt]);                                     
                                }
                            }
                            $retour[$attkey] = $ouTab;
                        }
                        else {
                            if (isset( $entry[$k][$attkey][0] ) && is_array($entry[$k][$attkey]) ) {
                                $retour[$attkey]=$entry[$k][$attkey][0];
                            } else {
                                if (isset($entry[$k][$attkey]))
                                    $retour[$attkey]=$entry[$k][$attkey];
                            }
                        }
                }
                
                //return array
				return $retour;
			}
			else
			{
				$this->error = "Can't get entries on get_uid !";
				return false;
			}
          }
          else    {
                //return uid
                if( ($entry = @ldap_get_entries($this->id_connect_ldap, $sr)) != FALSE)
                {
                    $retour=array();
                    for ($i=0; $i<count($att); $i++)
                        for($j=0;$j<$entry[0][$att[$i]]['count'];$j++)
                            $retour[$att[$i]][$j]=$entry[0][$att[$i]][$j];
                    return $retour;               
    			}
    			else    {
    				$this->error = "Can't get entries on get_uid !";
    				return false;
    			}            
            }
		}
		else
		{
			$this->error = "Can't search attributs on get_uid !";
    		return false;
		}
	}

  /***********************************************************************/
  /* FONCTION LDAP_MODIFPASS : modify password USER						 */
  /* in : user, old password, new password								 */
  /* out: true | false | error msg                                       */
  /***********************************************************************/
	 function ldap_modifpass($user, $newpwd)
	{
		// chiffrage du mot de pass
		$salt=make_salt();
		$data['userPassword'] = '{crypt}'.crypt($newpwd, $salt);

		// connection serveur ldap
		if($this->dn_connect == "") return "DN not specify for user ".$user;
		if($this->dn_connect_pass == "") return "OLDPASSWORD not specify for user ".$user;

		// modifie les mot de pass de l'utilisateur
		if( $this->bind && @ldap_modify($this->id_connect_ldap,$this->dn_connect,$data) ) return true;
		else $this->error = @ldap_error($this->id_connect_ldap);

		return false;
	}

	/************************************************************************/
	/* FONCTION LDAP_GET_GROUPS : get CN and description of ldap groups		*/
	/* in : DN group, filter												*/
	/* out: array[$i]["cn"] | false											*/
	/*               ["description"]										*/
	/************************************************************************/
	 function ldap_get_groups($dngroup,$filter)
	{
		if( $sr=@ldap_search($this->id_connect_ldap,$dngroup,$filter, array("cn","description")) )
		{
			if( ($entry = @ldap_get_entries($this->id_connect_ldap, $sr)) != FALSE)
			{
				$retour=array();
				for ($i=0; $i<$entry["count"] ; $i++)
				{
					$retour[$i]["cn"]=$entry[$i]["cn"][0];
					$retour[$i]["description"]=$entry[$i]["description"][0];
				}
				return $retour;
			}
			else
			{
				$this->error = "Can't get entries on ldap_get_groups !";
				return false;
			}
		}
		else
		{
			$this->error = "Can't search groups on ldap_get_groups !";
    		return false;
		}
	}

}
?>
