<?php



/*
   class to  get data from xml with xml dom library
    
*/

class PoshTutorialDom extends DOMDocument {
    var $file = '';
    /*
        getFile
        
        \brief get xml file content
    
    */
    function getFile ($file) {
        if (file_exists($file)) {
            $this->load($file);    
        } else {
            
            $opts = array(
                    'http' => array(
                        'user_agent' => 'PHP Posh libxml agent',
                        )
                );
            $context = stream_context_create($opts);
            libxml_set_streams_context($context);
            ;
            
            if ( !@$this->load($file) ) { 

                return array('res' => 'nok','msg' => "unknown file");
            } else {
                return array('res' => 'ok');
            }
            
        }
        return array('res' => 'ok');
    }
    /*
        getModulesPrefs
        
        get modules prefs from xml file
        
        @param hash reference
        
        Add entry
        $datas['widget']
            which contains akey for each attribute
            $datas['widget']['title']
            ...
    */
    function getModulesPrefs (&$datas) {
        $modprefs_list = $this->getElementsByTagName('ModulePrefs');
        $modprefs = $modprefs_list->item(0);
        $datas['widget']['title'] = $modprefs->getAttribute('title');
        $datas['widget']['description'] = $modprefs->getAttribute('description');
        $datas['widget']['height'] = $modprefs->getAttribute('height');
        $datas['widget']['iconid'] = $modprefs->getAttribute('iconid');
        $datas['widget']['category'] = $modprefs->getAttribute('category');
        $datas['widget']['keywords'] = $modprefs->getAttribute('keywords');
        $datas['widget']['lang'] = $modprefs->getAttribute('lang');
        $datas['widget']['author_affiliation'] = $modprefs->getAttribute('author_affiliation');
    }
    /*
        getContent
        
        get widget content from xml file
        
        @param hahs reference
        
        add one entry by view
        $datas['widget']['contents'][$view] = array(
                                                'content' => $content->nodeValue,
                                                'href' => $href,
                                                'type' => $type
                                                );
                    }
        Add main entry for all views
        
        $datas['widget']['views']
    */
    function getContent (&$datas) {
        $content_list = $this->getElementsByTagName('Content');
        $views = array();
        foreach ($content_list as $content) {
            $view = $content->getAttribute('view');
            $type = $content->getAttribute('type');
            $href = $content->getAttribute('href');
            $views[$view] = 1;
            $datas['widget']['contents'][$view] = array(
                                                'content' => $content->nodeValue,
                                                'href' => $href,
                                                'type' => $type
                                                );
        }
        
        $datas['widget']['views'] = implode(",",array_keys($views));
    }
    /*
        getUserPrefs
        
        get userpref from xml file
        
        @param hash reference
    
        $datas['widget']['userpref'][$name]
        one entry by userpref
        for each entry add attributes
        
        and two entries for defvar and nbvariables add to widget
        $datas['widget']['defvar']
        $datas['widget']['nbvariables']
        
    */
    function getUserPrefs (&$datas) {
        $user_prefs_list = $this->getElementsByTagName('UserPref');
        $nbvar = 0;
        $datas['widget']['defvar'] = '';
        foreach ($user_prefs_list as $userpref) {
            $name = $userpref->getAttribute('name');
            $datas['widget']['userpref'][$name]['display_name'] = $userpref->getAttribute('display_name');
            $datas['widget']['userpref'][$name]['datatype'] = $userpref->getAttribute('datatype');
            $datas['widget']['userpref'][$name]['default_value'] = $userpref->getAttribute('default_value');
            //build variables if userpref exists
            $datas['widget']['defvar'] .= "$name=".$datas['widget']['userpref'][$name]['default_value']."&";
            $nbvar++;
        }
        $datas['widget']['nbvariables'] = $nbvar;
    }
    /*
        getLocales
        
        \brief get url of language files containing labels
        
        @param hash reference
        
        fill
        $datas['widget']['locales']
        
        one entry by language
        one 'default' entry
    */
    function getLocales (&$datas) {
        $lang_list = $this->getElementsByTagName('Locale');
        foreach ($lang_list as $langnode) {
            $lang = $langnode->getAttribute('lang');
            $url = $langnode->getAttribute('messages');
            if (isset($lang)) {
                $datas['widget']['locales'][$lang] = $url;
            } else {
                $datas['widget']['locales']['default'] = $url;
            }
        }
    }
    /*
        \def getRequired

        \brief get Require tag from xml file
        
        @param hash reference to data in xml
        
        $datas['widget']['requires']
        
        a entry foreach require
    
    */
    function getRequired (&$datas) {
        $require_list = $this->getElementsByTagName('Require');
        foreach ($require_list as $requirenode) {
            $datas['widget']['requires'][$requirenode->getAttribute('feature')] = 1;
        }
    }
    
    
}


?>