<?php
# ************** LICENCE ****************
/*
	Copyright (c) PORTANEO.

	This file is part of POSH (Portaneo Open Source Homepage) http://sourceforge.net/projects/posh/.

	POSH is free software: you can redistribute it and/or modify
	it under the terms of the GNU General Public License as published by
	the Free Software Foundation, either version 3 of the License, or
	(at your option) any later version

	POSH is distributed in the hope that it will be useful,
	but WITHOUT ANY WARRANTY; without even the implied warranty of
	MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
	GNU General Public License for more details.

	You should have received a copy of the GNU General Public License
	along with Posh.  If not, see <http://www.gnu.org/licenses/>.
*/
# ***************************************
# Missing password form
#
# !! be careful, this file must be saved under uft8 format, and display an e accentuated here : é
# ***************************************


$folder="";
$not_access=0;
$isScript=false;
$isPortal=false;
$pagename="portal/password_missing.php";
//includes
require_once('includes.php');
require_once('../l10n/'.__LANG.'/lang.php');
require_once('../includes/mail.inc.php');
require_once('../includes/misc.inc.php');
launch_hook('password_missing_php');

$error = '';
$message='';
$pass_error = true;

//display form to change password
if (isset($_POST['update'])) {
    $mdp = $_POST['mdp'];
    
    $password = $_POST['newpassword'];
    $email = $_POST['email'];
    $passwd_length =  strlen($password);
    $username = '';
    $long_name = '';
	$user_id = 0;
   	$DB->getResults($scrchangepwd_getUserInfo,
					$DB->quote($mdp),
					$DB->quote($email)
					);
	$row = $DB->fetch(0);
	$user_id = $row['id'];
	$username = $row['username'];
	$long_name = $row['long_name'];
    $DB->freeResults();
	if($user_id<=0)
		exit();
	//check that the username is not in password
	if ( preg_match('/'.$username.'/',$password) && !empty($username) && __CONNECTION_SECURITY_LEVEL>=2 ){
		$error.=lg("msgLoginInPass").".<br />";
	}
	//check that the long name is not in password
	if ( preg_match('/'.$long_name.'/',$password) && !empty($long_name) && __CONNECTION_SECURITY_LEVEL>=2 ){
		$error.=lg("msgNameInPass").".<br />";
	}

	$error.= isMixPassword($password);
	if(__CONNECTION_SECURITY_LEVEL>=3) {
		// Check if password is used
		$DB->getResults($user_getUserOldPass,
						$DB->escape($user_id)
						);
		
		while($row = $DB->fetch(0)) {
			if($row['md5pass']==md5($password)) {
				$pass_error = true;
				$error.=lg("msgErrPasswordUsed").".<br />";
				break;
			}
		}
	$DB->freeResults();
	}

   if ($mdp && ($passwd_length>= 8) && ($password == $_POST['newpassword2']) && empty($error)) {
        
        $chk = $DB->execute($scrchangepwd_changePassMd5,
                                $DB->quote($password),
                                $DB->quote($mdp),
                                $DB->quote($DB->escape($email))
                            );        
        if ($chk != 0) {
			$DB->execute($scr_insertPortalPass,
							$DB->escape($user_id),
							$DB->quote($password));
            header("Location: " . __LOCALFOLDER . "portal/login.php?passwdupdated=ok");
            exit;
           // $message = '<p class="warningok" style="margin-right:50%;margin-left:10%;">'. lg('passwordModified').'</p>';
        }
   } else {
        if (!$mdp && empty($error)) $error = "MD5 is missing! Are you really sure of what you want doing";
        if ( $password != $_POST['newpassword2'] && empty($error)) $error = lg('msgSubPassDiff'); 
        if ($passwd_length < 8 && empty($error) && __CONNECTION_SECURITY_LEVEL>=2) {
			$error = lg('msgSubPassToShort8');
		} elseif(__CONNECTION_SECURITY_LEVEL<2)  {
			$error = lg('msgSubPassToShort');
		}
        $message = $error;
   }
}
?>

<!DOCTYPE html PUBLIC "-//W3C//DTD XHTML 1.0 Strict//EN" "http://www.w3.org/TR/xhtml1/DTD/xhtml1-strict.dtd">
<html xmlns="http://www.w3.org/1999/xhtml" xml:lang="en" lang="en">
<head>
	<title>PORTANEO :: Missing password</title>
	<link rel="stylesheet" href="../styles/main.css" type="text/css" />
	<link rel="stylesheet" href="../styles/main1.css" type="text/css" />
	<meta http-equiv="Content-Type" content="text/html; charset=UTF-8" />
	<script type="text/javascript" src="../l10n/<?php echo __LANG;?>/lang.js?v=<?php echo __POSHVERSION;?>"></script>
	<script type="text/javascript" src="../includes/config.js?v=<?php echo __rand;?>"></script>
	<script type="text/javascript" src="../tools/mootools.js?v=1.2.1"></script>
    <script type="text/javascript" src="../includes/php/ajax-urls.js?v=<?php echo __POSHVERSION;?>"></script>
	<script type="text/javascript" src="../includes/ajax.js?v=<?php echo __POSHVERSION;?>"></script>
<?php 
	launch_hook('userinterface_header',$pagename);
?>
</head>
<body>
<div class="noportal">
<?php
	if (!empty($message))
	{
?>
<script type="text/javascript">
 document.write('<p class="warning" style="margin-right:50%;margin-left:10%;">' + lg('<?php echo $message; ?>') + '</p>');
</script>
<?php
	}
?>
<table cellpadding="10" cellspacing="0" border="0" width="100%">
	<tr>
	<td align="left" valign="top" style="padding-top:30px">
<?php
if (isset($_REQUEST['mdp']) && isset($_REQUEST['email']))
{
	$mdp = $_REQUEST['mdp'];
	$email = $_REQUEST['email'];
?>
		<form name="help" method="post" action="password_missing.php">
		<input type="hidden" name="mdp" value="<?php echo $mdp; ?>">
		<input type="hidden" name="email" value="<?php echo $email; ?>">
		<br/>
		<table>
			<tr>
			<td><label><?php echo lg('lblNewPassword'); ?></label>: </td><td><input type="password" name="newpassword" /></td>
			</tr>
			<tr>
			<td><label><?php echo lg('confirmPassword'); ?></label>: </td><td><input type="password" name="newpassword2" /></td>
			</tr>
		</table>
		<br />
		<input type="submit" class="btn" name="update" value="<?php  echo lg('lblBtnSend');?>" />
<?php
}
else 
{
?>
		<form name="help" method="post" action="scr_sendmd5.php">
		<script type="text/javascript">document.write(lg('lblsetNewPasswordMissing'));</script><br /><br />
		<label><?php echo lg('yourEmail'); ?></label>: <input type="text" name="username" />
		<input type="hidden" name="redirect" value="password_missing.php?emailsent=1" />
		<input type="submit" class="btn" name="update" value="<?php  echo lg('lblBtnSend');?>" />
<?php
}
if (isset($_GET['emailsent']))
{
	echo lg("emailSent");
}
?>
		</form>
		<br />

	</td>
	</tr>
</table>
</div>

</body>
</html>