<?php
# ************** LICENCE ****************
/*
	Copyright (c) PORTANEO.

	This file is part of COLLABORATION SUITE of POSH http://sourceforge.net/projects/posh/.

	POSH is free software: you can redistribute it and/or modify
	it under the terms of the GNU General Public License as published by
	the Free Software Foundation, either version 3 of the License, or
	(at your option) any later version

	POSH is distributed in the hope that it will be useful,
	but WITHOUT ANY WARRANTY; without even the implied warranty of
	MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
	GNU General Public License for more details.

	You should have received a copy of the GNU General Public License
	along with Posh.  If not, see <http://www.gnu.org/licenses/>.
*/
/**
* Add a new notebook group
*
*   @param[in]
*
*
*
*
*
* !! be careful, this file must be saved under uft8 format, and display an e accentuated here : éàèù
**/

require_once('../db_layer/'.__DBTYPE.'/enterprise.php');
require_once('../db_layer/'.__DBTYPE.'/widget.php'); // for group widget creation
require_once('../includes/xml.inc.php');
require_once('../includes/misc.inc.php');

$file=new xmlFile();

$file->header();

$id = isset($_POST["id"]) ? $_POST["id"] : -1;
$act = isset($_POST["act"]) ? $_POST["act"] : "";
if (  isset($_POST["name"])  )
{
    $name = $_POST["name"];
} else if ($act == 'add') {
    $file->error("group name not defined");
    $file->status(-1);
    $file->footer();
    exit;
}

if ($act == "add")
{
    $desc = isset($_POST["desc"]) ? $_POST["desc"] : "";
    $pv = isset($_POST["pv"]) ? $_POST["pv"] : 0;
    $exist = 0;
	$DB->getResults($xmlgroupbook_exists, strtoupper($DB->quote($name)));

	$row = $DB->fetch(0);
    if (isset($row["exist"])) {
        $exist = $row["exist"];
    }
	$DB->freeResults();
	if ($exist == 0) {

		$key = randomKey();
		$allowUnsubscribe = isset($_POST["allowunsubscribe"]) ? $_POST["allowunsubscribe"] : 1;
		//add the group
		$DB->execute($scrgroupbook_add,
                        $DB->quote($name),
                        $DB->quote($desc),
                        $DB->escape($_SESSION['user_id']),
                        $DB->escape($pv),
						$DB->escape($allowUnsubscribe),
						$DB->quote($key)
						);

        //error control missing here
		$id = $DB->getId();

		// add user in the group
		$DB->execute($scrgroupbook_map_add,
                        $DB->escape($_SESSION['user_id']),
                        $DB->escape($id),
                        $DB->quote("O"));

		// add group shared widgets
		//		Create note
		$DB->execute($widnote_newNote,	$DB->escape($_SESSION['user_id']),
										"''",
										$DB->quote($key));
		$note_id = $DB->getId();
		$DB->execute($scrgroupbook_add_widget,$id,84,$DB->quote('noteid='.$note_id.'&acceptwriteshare=yes&ownerallowwriting=yes'));

		//		Create agenda widget
		$DB->execute($widcal_newModuleId2,	$DB->escape($_SESSION['user_id']),
											$DB->quote($key));
		$cal_id = $DB->getId();
		$DB->execute($scrgroupbook_add_widget,$id,112,$DB->quote('calid='.$cal_id.'&acceptwriteshare=yes&ownerallowwriting=yes'));

		//		Create link widget
		$DB->execute($widlink_addNewLinkId2,	$DB->escape($_SESSION['user_id']),
												$DB->quote($key));
		$link_id = $DB->getId();
		$DB->execute($scrgroupbook_add_widget,$id,85,$DB->quote('linkid='.$link_id.'&acceptwriteshare=yes&ownerallowwriting=yes'));

		// 		Create contact widget
		$DB->execute($widAddr_addNewContactId2,	$DB->escape($_SESSION['user_id']),
											$DB->quote($key));
		$contact_id = $DB->getId();
		$DB->execute($scrgroupbook_add_widget,$id,401,$DB->quote('addid='.$contact_id.'&acceptwriteshare=yes&ownerallowwriting=yes'));

		// 		create task widget
		$DB->execute($widtask_addNewTaskId2,	$DB->escape($_SESSION['user_id']),
												$DB->quote($key));
		$task_id = $DB->getId();
		$DB->execute($scrgroupbook_add_widget,$id,295,$DB->quote('taskid='.$task_id.'&acceptwriteshare=yes&ownerallowwriting=yes'));

	}
    echo "<name><![CDATA[$name]]></name>"
		. "<id>" . $id . "</id>";
}
else if ($act=="del" || $act == 'quit') {
	$DB->execute($scrgroupbook_map_remove,
                    $DB->escape($_SESSION['user_id']),
                    $DB->escape($id));
}
else if ($act == "join") {
    //update group status for a user
	$DB->execute($scrgroupbook_map_update,
                    $DB->quote("O"),
                    $DB->escape($_SESSION['user_id']),
                    $DB->escape($id));
    if ($DB->nbAffected()==0)   {          
        $DB->execute($scrgroupadd_join,
                    $DB->escape($_SESSION['user_id']),
                    $DB->quote("O"),
                    $DB->escape($id));
	}
    
	// send email notification to the person that invited the user
	$DB->getResults($scrgroupbook_getInvitator,
						$DB->escape($_SESSION['user_id']),
						$DB->escape($id));

	if ($DB->nbResults() != 0)
	{
		require_once('../l10n/'.__LANG.'/lang.php');
		require_once('../l10n/'.__LANG.'/enterprise.php');
		require_once('../includes/mail.inc.php');
		
		$row = $DB->fetch(0);
		$groupName = $row['name'];

		$notif_subject = lg('notificationGroupInivitationAccept',$_SESSION['longname'],$groupName);
		$notif_message = lg('notificationGroupInivitationAcceptBody',$_SESSION['longname'],$groupName,__APPNAME,__LOCALFOLDER);
		$s_mail = new mail();
		$s_mail->addSender(__SUPPORTEMAIL);
		$s_mail->addSubject($notif_subject);
		$s_mail->addMessage($notif_message);
		$s_mail->configArray($row['email'],'2');
		$s_mail->sendMail(); 
	}
	$DB->freeResults();
}
else if ($act=="selectnjoin") {
    $DB->getResults($scrgroup_countuser, $DB->escape($_SESSION['user_id']), $DB->escape($id));
    $userExistingInGroup = $DB->nbResults();
	$DB->freeResults();

    if ($userExistingInGroup == 0)
    {
        if (isset($from_api)){
            if ($from_api){
                $DB->execute($scrgroupbook_map_add,
                        $DB->escape($_SESSION['user_id']),
                        $DB->escape($id),
                        $DB->quote("O"));

            }
        }else{
            //add user in group
        	$DB->execute($scrgroupadd_join,
                        $DB->escape($_SESSION['user_id']),
                        $DB->quote("O"),
                        $DB->escape($id));
        }
    }
}
//else if ($act=="quit") {
//	$DB->execute($scrgroupbook_map_update, $DB->quote("X"), $DB->escape($_SESSION['user_id']), $DB->escape($id));
//}

$DB->close();

$file->status(1);

$file->returnData($id);

$file->footer();
?>
