<?php
# ************** LICENCE ****************
/*
	Copyright (c) PORTANEO.

	This file is part of POSH (Portaneo Open Source Homepage) http://sourceforge.net/projects/posh/.

	POSH is free software: you can redistribute it and/or modify
	it under the terms of the GNU General Public License as published by
	the Free Software Foundation, either version 3 of the License, or
	(at your option) any later version

	POSH is distributed in the hope that it will be useful,
	but WITHOUT ANY WARRANTY; without even the implied warranty of
	MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
	GNU General Public License for more details.

	You should have received a copy of the GNU General Public License
	along with Posh.  If not, see <http://www.gnu.org/licenses/>.
*/
/**
* \brief Check feed and add new in DB
*
*   return xml file
*
* @param [in]  url (POST)
*               id (POST)
*
*   Need to improve error xml to get different messages on failure
*
* \relates
*   php xmlcheckfeedproxy;php
*
*  \relatesalso
*   ajax.js
*   $p.app.widgets.rss.getFeed 
*
* !! be careful, this file must be saved under uft8 format, and display an e accentuated here : é
*
**/

$folder     = "";
$not_access = 0;
$pagename   = "portal/xmlcheckfeed.php";
//includes

require_once('includes.php');
//require_once('../includes/feed.inc.php');
require_once('../includes/http.inc.php');
require_once('../includes/feed.inc.php');
require_once('../includes/xml.inc.php');

$file = new xmlFile();
$file->header("checks");
$url = '';
$useproxy = (isset($_POST['useproxy']) ? $_POST['useproxy'] : 0);

if ( isset($_REQUEST["url"]) )
{
    $url = $_REQUEST["url"];
} else {
	$file->error("urlundefined");
    $file->footer("checks");
    exit;
}

/*
// get proxy information
if ($useproxy == 1)
{
    if (isset($_POST["proxy"]))
    {
        $proxy=$_POST["proxy"];
        $pos=strpos($proxy,":");
        $proxyserver=substr($proxy,0,$pos);
        $proxyport=substr($proxy,$pos+1);
    }
    else
    {
        $proxyserver=__PROXYSERVER;
        $proxyport=__PROXYPORT;
    }
}
*/
//icon information
$moduleIcon = "../modules/quarantine/rss";
$imgType =  ".ico";
if(isset($_REQUEST["id"])) {
	$moduleIcon = "../modules/quarantine/icon".$_REQUEST["id"];
}

// Check if the RSS file is already existing in DB
$DB->getResults($xmlcheckfeed_getIconId,$DB->quote($url));
if ($DB->nbResults() == 0)
{

	//check if rss page exists
    /*
    if ($useproxy == 1)
    {
        $check = fsockopen($proxyserver,$proxyport);
        fputs($check, "GET $url HTTP/1.0\r\n");
        fputs($check, "Proxy-Authorization: Basic ".__PROXYCONNECTION."\r\n\r\n");
    }
    */
   // else
   // {
        $h = new feed($url);
        $content = $h->load();
        $check = !empty($content);
   // }

	if (!$check)
	{
		echo "<error>1</error>";
	}
	else
	{
		//get icon
		$pos = strpos($url,"/",10);
		$icon = substr($url,0,$pos)."/favicon.ico";
        $hi = new http($icon);
        $iconfile = $hi->get();
        $imgType = $hi->getImageType($icon);
      
		//if iconfile empty or http error code return
		if (empty($iconfile) || strlen($iconfile)<4 || substr($iconfile,0,1)==" " || substr($iconfile,0,1)=="<")
		{
			//$moduleIcon="../modules/quarantine/icon".$feedid;
			$imgType = ".gif";
			copy("../modules/pictures/rss.gif",$moduleIcon.$imgType);
		}
		else
		{
			if ($f_w = fopen($moduleIcon.$imgType,'w+'))
			{
				fwrite($f_w,$iconfile);
				fclose($f_w);
			}
		}
        //add feed in dir_rss
        //if ($useproxy == 1)
        if (__useproxy)
        {
            $proxyserver=__PROXYSERVER;
            $proxyport=__PROXYPORT;
            $DB->execute($xmlcheckfeedproxy_addFeed,    $DB->quote($url),$DB->quote($moduleIcon.$imgType),
                                                        $DB->quote($proxyserver.":".$proxyport));
        }
        else
        {
            $DB->execute($xmlcheckfeed_setUrlAndIcon,$DB->quote($url),$DB->quote($moduleIcon.$imgType));
        }
        $feedid = $DB->getId();
        
        if(!isset($_REQUEST["id"]) && file_exists($moduleIcon.$imgType)) {
            copy($moduleIcon.$imgType,$moduleIcon.$feedid.$imgType);
            $moduleIcon .= $feedid;
            $DB->execute($xmlfeeds_setIconId,$DB->quote($moduleIcon.$imgType),$DB->escape($feedid));
        }
        echo "<id>".$feedid."</id>";
        echo "<icon><![CDATA[".$moduleIcon.$imgType."]]></icon>";
    }
}
else
{	
	$row = $DB->fetch(0);
	$extensionlogo = strrchr($row["iconid"],'.');
	echo "<id>".$row["id"]."</id>";
	
	if( isset($row["iconid"]) && !empty($row["iconid"]) ) {
		if( !isset($_REQUEST["id"]) ) {
			echo "<icon><![CDATA[".$row["iconid"]."]]></icon>";
		} else {
			copy($row["iconid"],$moduleIcon.$extensionlogo);
			echo "<icon><![CDATA[".$moduleIcon.$extensionlogo."]]></icon>";
		}
		
	}
}
$DB->freeResults();

$file->footer("checks");

$DB->close();
?>