-- Update systématique des éléments de la base posh

-- création du user de la base
grant all privileges on posh.* to posh@%%adresse_ip_web identified by 'posh';
grant all privileges on posh.* to posh@%%adresse_ip_br0 identified by 'posh';
flush privileges ;


\r posh
SET character_set_client = utf8;


-- MODIFICATION DE STRUCTURE --------------------------------------------------------------------------------------------------------------------------

-- Agrandir le champ pass en lien avec poshprofil
ALTER TABLE  `profile` CHANGE  `pass`  `pass` VARCHAR( 80 ) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL;
ALTER TABLE `users` CHANGE `lang` `lang` VARCHAR( 50 ) CHARACTER SET utf8 COLLATE utf8_unicode_ci NOT NULL DEFAULT 'en';
ALTER TABLE  `pages` CHANGE  `param`  `param` VARCHAR( 255 ) CHARACTER SET utf8 COLLATE utf8_unicode_ci NOT NULL DEFAULT  '';
ALTER TABLE  `profile` CHANGE  `param`  `param` VARCHAR( 255 ) CHARACTER SET utf8 COLLATE utf8_unicode_ci NULL DEFAULT NULL;

-- Recalculer l'auto-increment
ALTER TABLE users_group AUTO_INCREMENT = 1; 

DROP PROCEDURE IF EXISTS ModifStructure;
DELIMITER |
CREATE PROCEDURE ModifStructure()
BEGIN
	DECLARE nbindex INT DEFAULT 0;
	
	SELECT DISTINCT count(*) INTO nbindex
		FROM information_schema.statistics 
        WHERE table_schema = 'posh' 
        AND table_name = 'profile'
        AND index_name like 'user_id';
	IF nbindex = 0 THEN
		ALTER TABLE  posh.profile ADD INDEX  `user_id` (  `user_id` );
	END IF;
END|
DELIMITER ;

CALL ModifStructure();
DROP PROCEDURE ModifStructure;

-- CONFIGURATION DE POSH ------------------------------------------------------------------------------------------------------------------------------

-- L'adresse de l'application
UPDATE `adm_config`
    SET `value`="https://%%web_url/envole/", `editable`='0'
    WHERE `parameter`='LOCALFOLDER'
    AND `category`='yourApplication';

UPDATE `adm_config`
    SET `value`="%%web_url", `editable`='0'
    WHERE `parameter`='APPNAME'
    AND `category`='yourApplication';

-- La définition du proxy
%if %%activer_proxy_client == 'oui'
    UPDATE `adm_config` SET `value`='true', `editable`='0' WHERE `parameter`='useproxy' AND `category`='dbConnection';
    UPDATE `adm_config` SET `value`='%%proxy_client_adresse', `editable`='0' WHERE `parameter`='PROXYSERVER' AND `category`='dbConnection';
    UPDATE `adm_config` SET `value`='%%proxy_client_port', `editable`='0' WHERE `parameter`='PROXYPORT' AND `category`='dbConnection';
    UPDATE `adm_config` SET `value`='../includes/proxy.pac', `editable`='0' WHERE `parameter`='proxypacfile' AND `category`='dbConnection';
%else
    UPDATE `adm_config` SET `value`='false', `editable`='0' WHERE `parameter`='useproxy' AND `category`='dbConnection';
    UPDATE `adm_config` SET `value`='', `editable`='0' WHERE `parameter`='PROXYSERVER' AND `category`='dbConnection';
    UPDATE `adm_config` SET `value`='', `editable`='0' WHERE `parameter`='PROXYPORT' AND `category`='dbConnection';
    UPDATE `adm_config` SET `value`='', `editable`='0' WHERE `parameter`='proxypacfile' AND `category`='dbConnection';
%end if


-- Utilisation d'un proxy pour les inclusions http
INSERT IGNORE INTO `adm_config` (`parameter`, `value`, `datatype`, `desttype`, `category`, `editable`) VALUES ('include_proxy', "", 'str', 'A', 'yourApplication', '0');
%if %%is_defined('posh_proxy_http') and %%posh_proxy_http == "oui"
    UPDATE `adm_config` SET `value`="%%posh_proxy_value" WHERE `parameter`="include_proxy";
%else
    UPDATE `adm_config` SET `value`="" WHERE `parameter`="include_proxy";

%end if


-- Nom etablissement dans le bandeau posh
INSERT IGNORE INTO `adm_config` (`parameter`, `value`, `datatype`, `desttype`, `category`, `editable`) VALUES ('ETABNAME', "%%libelle_etab", 'str', 'A', 'yourApplication', '0');

UPDATE `adm_config` SET `value`="%%libelle_etab", `editable`='0' WHERE `parameter`='ETABNAME' AND `category`='yourApplication';

-- Version Envole
INSERT IGNORE INTO `adm_config` (`parameter`, `value`, `datatype`, `desttype`, `category`, `editable`) VALUES ('application_version', '%%version_envole', 'str', 'A', '', '0');

UPDATE `adm_config` SET `value`='%%version_envole', `editable`='0' WHERE `parameter`='application_version';

-- L'adresse du serveur mysql
UPDATE `adm_config` SET `value`='%%adresse_ip_mysql', `editable`='0' WHERE `parameter`='SERVER' AND `category`='dbConnection';


-- GESTION DES PLUGINS -------------------------------------------------------------------------------------------------------------------------------

-- Plugin CAS
%if %%is_defined('eolesso_adresse') and %%is_defined('eolesso_port')
    UPDATE `adm_config_cas` SET `value`='%%eolesso_adresse' WHERE `parameter`='CAS_SERVER';
    UPDATE `adm_config_cas` SET `value`='%%eolesso_port' WHERE `parameter`='CAS_PORT';
%end if

UPDATE `adm_config_cas` SET `value`='%%web_url/envole/portal' WHERE `parameter`='CAS_RETURN';


-- Forcer l'activation des plugins
DROP PROCEDURE IF EXISTS ActivePlugin;
delimiter |
CREATE PROCEDURE ActivePlugin(_name VARCHAR( 32 ), _link VARCHAR( 60 ))
BEGIN
	DECLARE _nblignue INTEGER;

	SET @_name = _name collate utf8_unicode_ci;
	SET @_link = _link collate utf8_unicode_ci;

	SELECT COUNT(*) INTO _nblignue FROM adm_plugins WHERE name=@_name;
	IF _nblignue = 0 THEN
		INSERT INTO adm_plugins (name, link, dependency, status, forced) VALUES(@_name,_link,'no','O','1');
	ELSE
		UPDATE adm_plugins SET name=@_name, link=@_link, dependency='no', status='O', forced=1 WHERE name=@_name;
	END IF;
END|
delimiter ;

-- Supprimer l'ancien plugin Piwik
DELETE FROM adm_plugins WHERE name='Piwik';
DELETE FROM adm_plugins WHERE name='plugin piwik';

%if %%is_defined('activer_piwik') and %%activer_piwik == 'oui'
CALL ActivePlugin('plugin piwik','plugin_piwik/plugin_piwik.php');
DROP PROCEDURE ActivePlugin;
%end if


-- GESTION DES WIDGETS --------------------------------------------------------------------------------------------------------------------------------

-- Création de la catégorie Envole
INSERT IGNORE INTO `dir_category` (`id`, `name`, `parent_id`, `typ`, `path`, `quantity`, `updated`, `lang`, `secured`, `secured_quantity`) VALUES
(2500, 'Envole', 2, 'O', NULL, 0, 'Y', 'fr', 0, 0);


-- Creation de Widget Avancées
--  @id
--  @name
--  @description
--  @height
--  @url
--  @iconid
--  @idcat

DROP PROCEDURE IF EXISTS ActiveWidget;
delimiter |
CREATE PROCEDURE ActiveWidget(_id INTEGER,_name VARCHAR(250),_description VARCHAR(250),_height INTEGER(5),_url VARCHAR(250),_iconid VARCHAR(60),_idcat INTEGER(5))
BEGIN
	DECLARE _myname VARCHAR(250);
	DECLARE _myheight INTEGER(5);

	SELECT name INTO _myname FROM dir_item WHERE dir_item.id=_id;
	IF(_myname!="") THEN
		SET _name = _myname;
	END IF;

	SELECT height INTO _myheight FROM dir_item WHERE dir_item.id=_id;
	IF(_myheight!="") THEN
		SET _height = _myheight;
	END IF;

	DELETE FROM dir_item WHERE id=_id;
	DELETE FROM dir_item_external WHERE item_id=_id;
	DELETE FROM dir_cat_item WHERE item_id=_id;

	INSERT INTO `dir_item` (`id`, `url`, `defvar`, `name`, `description`, `typ`, `status`, `format`, `height`, `minwidth`, `sizable`, `website`, `editor_id`, `nbvariables`, `creation_date`, `lastmodif_date`, `notation`, `voter_nb`, `updated`, `nbusers`, `sorting`, `lang`, `usereader`, `autorefresh`, `views`, `icon`, `l10n`, `hidden`, `group_access`, `average_rating`, `total_rating`, `sum_rating`) VALUES
	(_id, CONCAT("../modules/xml_getwidget.php?getxml=1?format=M&pitem=",_id,'&'), '', _name, _description, 'U', 'O', 'M', _height, 200, '1', '', 1, 0, '0000-00-00', '0000-00-00', 0, 0, 'Y', 0, 0, 'fr', 1, 1, 'home', _iconid, '', 0, '0', 0, 0, 0);

	INSERT INTO `dir_item_external` (`item_id`, `source`, `xmlmodule`, `url`, `last_updated`, `status`, `view`, `type`) VALUES
	(_id, '', CONCAT('<?xml version="1.0" encoding="UTF-8" ?>\n<Module>\n <ModulePrefs title="',_name,'" description="',_description,'" height="',_height,'" >\n</ModulePrefs>\n <Content type="html" view="home" ><![CDATA[\n<iframe src="',_url,'" width=''100%'' height=''',_height,'px'' frameborder=0></iframe>\n<script type="text/javascript">\n</script>\n]]>\n</Content>\n</Module>'), '', '2013-06-04 00:00:00', 'validated', 'home', 'I');

	INSERT INTO `dir_cat_item` (`item_id`, `category_id`, `first`) VALUES
	(_id, _idcat, 'Y');

END|
delimiter ;

%if %%is_defined('activer_wordpress') and %%activer_wordpress == 'oui'
CALL ActiveWidget(500,'Wordpress','Affichage des derniers articles Wordpress',200,'/wordpress/wp-content/plugins/poshwidget/wordpresswidget.php?format=light','../modules/pictures/box0_10001.gif',2500);
%end if

%if %%is_defined('activer_fluxbb') and %%activer_fluxbb == 'oui'
CALL ActiveWidget(510,'Fluxbb','Affichage des derniers articles Fluxbb',200,'/fluxbb/extern.php?posh=true','../modules/pictures/box0_10001.gif',2500);
%end if

%if %%is_defined('activer_piwigo') and %%activer_piwigo == 'oui'
CALL ActiveWidget(520,'Piwigo','Affichage des dernieres photos Pwigo',200,'/piwigo/feedhtml.php','../modules/pictures/box0_10001.gif',2500);
%end if

%if %%is_defined('activer_spip') and %%activer_spip == 'oui'
CALL ActiveWidget(530,'Spip','Affichage des derniers articles de Spip',200,'/spip/index.php?page=widget','../modules/pictures/box0_10001.gif',2500);
%end if

CALL ActiveWidget(540,'Bureau','Affichage des items du Bureau',460,'/envole/includes/plugins/plugin_alert/user-desktop.php','../modules/pictures/box0_10001.gif',2500);

%if %%is_defined('activer_roundcube') and %%activer_roundcube == 'oui'
CALL ActiveWidget(550,'Roundcube','Affichage des derniers emails',460,'/roundcube/?_task=envole&_action=mini','../modules/pictures/box0_10001.gif',2500);
%end if

CALL ActiveWidget(560,'Favoris','Affichage des Favoris',460,'/posh-profil/user-bookmark.php','../modules/pictures/box0_10001.gif',2500);

%if %%is_defined('activer_webcalendar') and %%activer_webcalendar == 'oui'
CALL ActiveWidget(570,'Webcalendar','Affichage de votre calendrier',200,'/webcalendar/rss.php?format=html&max=4','../modules/pictures/box0_10001.gif',2500);
%end if

CALL ActiveWidget(580,'Articles','Affichage des Articles',460,'/envole/includes/plugins/plugin_alert/user-alert.php','../modules/pictures/box0_10001.gif',2500);

%if %%is_defined('activer_calendrier') and %%activer_calendrier == 'oui'
CALL ActiveWidget(590,'Evènements','Affichage des Evènements',200,'/calendrier/widgetcalendrier.php','../modules/pictures/box0_10001.gif',2500);
%end if

%if %%is_defined('activer_dokuwiki') and %%activer_dokuwiki == 'oui'
CALL ActiveWidget(610,'Dokuwiki','Index Dokuwiki',200,'/dokuwiki/widgetdokuwiki.php','../modules/pictures/box0_10001.gif',2500);
%end if

%if %%is_defined('activer_cdt') and %%activer_cdt == 'oui'
CALL ActiveWidget(630,'Cahier de texte','Travail à faire dans le cahier de texte',200,'/cdt/widgetCDT.php','../modules/pictures/box0_10001.gif',2500);
%end if

DROP PROCEDURE IF EXISTS ActiveWidget;


-- creation widget actualites des groupes du réseau social
DELETE FROM dir_item WHERE id=600;
DELETE FROM dir_cat_item WHERE item_id=600;

INSERT INTO `dir_item` (`id`, `url`, `defvar`, `name`, `description`, `typ`, `status`, `format`, `height`, `minwidth`, `sizable`, `website`, `editor_id`, `nbvariables`, `creation_date`, `lastmodif_date`, `notation`, `voter_nb`, `updated`, `nbusers`, `sorting`, `lang`, `usereader`, `autorefresh`, `views`, `icon`, `l10n`, `hidden`, `group_access`, `average_rating`, `total_rating`, `sum_rating`) VALUES
(600, '../modules/p_social_updates_def.php?', '', 'Les actualités des groupes ', 'les actualités des groupes', 'P', 'O', 'M', 246, 280, '1', 'portaneo.net/', 4, 0, '2005-09-29', '2013-10-03', 0, 0, 'Y', 0, 0, 'fr', 0, 0, '0', '../modules/pictures/box0_10001.gif', NULL, 0, '0', 0, 0, 0);

INSERT INTO `dir_cat_item` (`item_id`, `category_id`, `first`) VALUES (600, 2500, 'Y');



-- 2 ADMIN --------------------------------------------------------------------------------------------------------------------------------------------

%if %%is_defined('activer_addadmin') and %%activer_addadmin == 'oui'

DROP PROCEDURE IF EXISTS AddAdminPosh;
delimiter |
CREATE PROCEDURE AddAdminPosh(_adminuser VARCHAR( 32 ))
BEGIN
    
    DECLARE keyexit INT DEFAULT 0;
    SET @_adminuser = _adminuser collate utf8_unicode_ci;

    SELECT id INTO keyexit FROM users WHERE username = @_adminuser;
    IF keyexit = 0 THEN
        INSERT INTO `users` (`username`, `pass`, `long_name`, `typ`, `expiration_date`, `creation_date`, `lastconnect_date`, `md5pass`, `md5user`, `email`, `lang`, `description`, `picture`, `stat`, `statdate`, `activity`, `extra`, `keywords`, `firstname`, `password_change_date`, `force_user_change_password`) VALUES
        (@_adminuser, '', '_adminuser', 'A', NULL, '2010-01-01', '', '', '', '', 'fr', '', '', 'Administrateur Envole', '', 'x', NULL, '', NULL, '', 0);
    END IF;	

    UPDATE users SET typ = 'A' WHERE username = @_adminuser;

    SELECT id INTO keyexit FROM users WHERE username = @_adminuser;
    
    INSERT IGNORE INTO adm_tabs_map (user_id,tab_id) VALUES
        (keyexit,1),
        (keyexit,2),
        (keyexit,3),
        (keyexit,4),
        (keyexit,5),
        (keyexit,6),
        (keyexit,7),
        (keyexit,8);
END|
DELIMITER ;

CALL AddAdminPosh('%%uid_addadmin');

%end if

-- RESEAU SOCIAL --------------------------------------------------------------------------------------------------------------------------------------------

%if %%is_defined('activer_reseausocial')

DROP PROCEDURE IF EXISTS GestionReseauSocial;
delimiter |
CREATE PROCEDURE GestionReseauSocial()
BEGIN
    -- Gestion des parametres pour activer/desactiver le reseau social
    %if %%activer_reseausocial == 'oui'
        UPDATE `adm_config` SET `value`='true' WHERE `parameter`='useNetwork';
        UPDATE `adm_config` SET `value`='true' WHERE `parameter`='useSharing';
        UPDATE `adm_config` SET `value`='true' WHERE `parameter`='useNotebook';
        UPDATE `adm_config` SET `value`='true' WHERE `parameter`='useGroup';
        UPDATE `adm_config` SET `value`='' WHERE `parameter`='homeDivs';
    %else
        UPDATE `adm_config` SET `value`='false' WHERE `parameter`='useNetwork';
        UPDATE `adm_config` SET `value`='false' WHERE `parameter`='useSharing';
        UPDATE `adm_config` SET `value`='false' WHERE `parameter`='useNotebook';
        UPDATE `adm_config` SET `value`='false' WHERE `parameter`='useGroup';
        UPDATE `adm_config` SET `value`='' WHERE `parameter`='homeDivs';
    %end if
END|
DELIMITER ;

CALL GestionReseauSocial();

%end if