#!/usr/bin/php
<?php
// CLEON : 11/07/2013, v1
// Script de création des categories a partir de l'ancienne nomenclature
// avant le nom de l'item était de la forme <categorie>/<nom>
// maintenant il y a une table dans poshprofile permettant de gérer la catégorie
include_once("/var/www/html/posh-profil/include/envole.php");
include_once("/var/www/html/posh/includes/config.inc.php");
include_once("/var/www/html/posh/includes/connection_mysql.inc.php");

global $DB2;
$DB2 = new connection(__SERVER,$config['dblogin'],$config['dbpassword'],$config['dbname']);

$arrDesCategories=array();
$arrDesktopItem=array();

// Récupération des catégories de l'ancienne 'nomenclature'
// Avant: la catégorie était contenu dans le nom (Exemple: <categorie>/libelle)
$DB2->getResults("SELECT * FROM desktopitem");
while ($row = $DB2->fetch(0)) {
    if (strpos($row['name'],"/")!==false)
    {
        $arr=explode("/",$row['name']);
        array_push($arrDesCategories,$arr[0]);
        $arrDesktopItem[$row['desktopid']]=array("name"=>$arr[1],"categorie"=>$arr[0],"indice"=>$row['indice']);
    }
}

// Unicité des catégories
$arrDesCategories=array_unique($arrDesCategories);

// Tableaux des catégories deja dans la base
$arrCategoriesExistantes=array();
$DB2->getResults("SELECT * FROM catitem");
while ($row = $DB2->fetch(0)) {
    array_push($arrCategoriesExistantes,$row['name']);
}

// On créer les categories manquantes
foreach ($arrDesCategories as $categorie)
{
    if (!in_array($categorie,$arrCategoriesExistantes))
    {
        echo "Création de la categorie '$categorie'\n";
        $DB2->getResults("INSERT INTO catitem (name) VALUES('$categorie')");
    }
}

// Tableaux des catégories dans la base avec les ID
$arrCategoriesExistantes=array();
$DB2->getResults("SELECT * FROM catitem");
while ($row = $DB2->fetch(0)) {
    $arrCategoriesExistantes[$row['name']]=$row['id'];
}

// On va maintenant changer le nom des items et affecter a la bonne categorie
foreach($arrDesktopItem as $id=>$item)
{
    $catid=$arrCategoriesExistantes[$item["categorie"]];
    $name=$item['categorie']."_".$item['name'];
    $indice=$item["indice"];
    if ($indice==null)
    {
        $indice=0;
    }

    //echo "$id=>" . $item['name'] . " categorie=". $item['categorie'] . " (id= ".$catid . ")\n";
    $DB2->getResults("UPDATE desktopitem SET name='$name', categorie=$catid, indice=$indice WHERE desktopid=$id");
}

?>
