#!/bin/bash
. ParseDico
. /etc/eole/containers.conf

if [ $activer_envole != "oui" ]
then
    echo "Veuillez activer envole avant toute chose"
    exit 1
fi

function usage(){ echo "        Utilitaire permettant d'installer rapidement une charte d'utilisation pour le portail Envole";
echo "";
echo "        Usage : install_charte.sh [FICHIER]";
echo "";
echo "        Installe FICHIER comme charte d'utilisation du portail";
echo "        NB : pour désactiver la charte, aller dans Interface d'administration et désactiver le plugin associé";
echo "        (Configuration->Configuration des plugins)";}

if [ -z "$1" ]; then
    usage
    exit 1
fi

echo "Installation de la charte d'utilisation du portail"
if [ "$1" == '-h' ]
then
    usage
    exit 0
fi
if [ -f "$1" ]
then
    /bin/cp -f "$1" $container_path_web/var/www/html/posh/includes/plugins/plugin_charte/charte/charte.html
    /bin/chown root:www-data $container_path_web/var/www/html/posh/includes/plugins/plugin_charte/charte/charte.html
    /bin/chmod 660 $container_path_web/var/www/html/posh/includes/plugins/plugin_charte/charte/charte.html
    /usr/bin/touch $container_path_web/var/www/html/posh/includes/plugins/plugin_charte/charte/active
    echo "Le fichier a bien été copié"
    echo " + Inscription du plugin + "
    echo "INSERT INTO posh.adm_plugins  (name, link, dependency, status, forced) VALUES ('plugin CHARTE', 'plugin_charte/plugin_charte.php', 'no', 'O', 0)" | mysql --defaults-file=$container_path_mysql/etc/mysql/debian.cnf -h$container_ip_mysql posh &> /dev/null
    if [ $? != 0 ]
    then
        #Le plugin a déjà été inscrit dans la base de données, il suffit en fait de le mettre à jour
        echo "UPDATE posh.adm_plugins SET status='O', forced=0 WHERE name='plugin CHARTE' AND link='plugin_charte/plugin_charte.php'" | mysql --defaults-file=$container_path_mysql/etc/mysql/debian.cnf -h$container_ip_mysql posh &> /dev/null
        if [ $? != 0 ]
        then
            echo "!!! ERREUR : Une erreur est survenue à l'activation du plugin CHARTE !!!"
            echo "(vous pouvez tenter de l'activer depuis l'interface d'administration)"
            exit 1
        else
            echo "Le plugin de charte d'utilisation a bien été activé."
        fi
    else
        echo "Le plugin de charte d'utilisation a bien été activé."
    fi
    echo " + Installation du plugin +" # Création d'une table sql et copie d'un fichier php
    echo "CREATE TABLE IF NOT EXISTS validated_chartes (username varchar(32) collate utf8_unicode_ci NOT NULL, PRIMARY KEY  (username))ENGINE=MyISAM DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci COMMENT='validated use-license';" | mysql --defaults-file=$container_path_mysql/etc/mysql/debian.cnf -h$container_ip_mysql posh &> /dev/null
    if [ $? != 0 ]
    then
        echo "!!! ERREUR : Une erreur est survenue à l'initialisation de la table !!!"
        exit 1
    fi
    /bin/cp -f $container_path_web/var/www/html/posh/includes/plugins/plugin_charte/valid_charte.php $container_path_web/var/www/html/posh/portal/valid_charte.php

    echo "Génération des fichiers de configuration"
    # Mise en place des plugins
    POSHKEY=`/usr/share/envole/scripts/parse_key.py $container_path_web`
    wget -q "http://$container_ip_web$alias_envole/api/scr_config_plugins.php?adminkey=$POSHKEY" --delete-after
    if [ $? != 0 ]
    then
        echo "Erreur à la configuration des plugins du portail."
        exit 1
    else
        echo "Le plugin est désormais activé."
        exit 0
    fi
else
    echo "!!! Le fichier n'existe pas : "$1" !!!"
    exit 1
fi
