/*
	Copyright (c) PORTANEO.
*/
///////////////////////////////////////////////////////////////////////////////////////////////////////////////////
// Portaneo javascript functions
// é à è ù 
//////////////////////////////////////////////////////////////////////////////////////////////////////////////////////

$p.mobile = {
    /*
                     Function: $p.mobile.initMenus
         
                     Build the subTabs
         */ 
    initMenus:function() {
        var l_s="";
        $p.admin.tools.emptyContent();
        l_s+='<div class="box tabsfunctions">\
                 <h3><img src="../images/puce.gif" /><a href="#" onclick="$p.mobile.users.usersmgmt();return false;">'+lg("userMgmt")+'</a></h3>\
                 <p>'+lg("userMgmtDesc")+'</p>\
              </div>';
        l_s+='<div class="box tabsfunctions">\
                 <h3><img src="../images/puce.gif" /><a href="#" onclick="$p.mobile.widgets.widgetsMgmt();return false;">'+lg("widgetsMgmt")+'</a></h3>\
                 <p>'+lg("widgetsMgmtDesc")+'</p>\
              </div>';
              
        $('content').innerHTML+=l_s;
    }
}


$p.mobile.users = {
    /*
                 Function: $p.mobile.users.usersmgmt
                 
                             Build the HTML for the users submenu
         */ 
    usersmgmt:function() 
    {
        var l_s = '';
        $p.admin.tools.emptyContent();
        parent.window.scrollTo(0,0);
        parent.$p.admin.fillBreadCrumbs($p.html.breadCrumbs(
			[
				{'label':lg('Accueil'),'link':'','fct':'$p.admin.setState();$p.app.tabs.open(0);return false;'},
				{'label':lg('Mobile'),'link':'','fct':'$p.mobile.initMenus();return false;'},
				{'label':lg('userMgmt'),'link':'','fct':''}	
			]
		));

        l_s+= '<div id="optmod"></div>\
                <div class="bottomhr"></div>\
                <div id="listmod" class="greydiv"></div>\
                <div class="greydiv" id="directory" style="height:20px"></div>\
                <div class="tophr" id="newmod"></div>';   
                
        $p.print('content',l_s);        
        $p.mobile.users.loadAll(1);
        $p.mobile.users.displayOptions();
    },
    /*
                     Function: $p.mobile.users.loadAll
                     
                                 Load all users information
                                
                     Parameters:
                     
                                v_page - page number
                                v_keepframe - ?
         */ 
	loadAll:function(v_page,v_keepframe)
	{
		$p.setClass("dirlink","optlist");
		$p.setClass("listlink","sellist");
		$p.admin.users.currLevel=0;
		if (v_keepframe==indef || !v_keepframe) $p.admin.users.hideFrame();
		getXml(pmobile["xml_all_users"]+"?p="+v_page,$p.mobile.users.displayAll,v_page);
		$p.admin.users.hideGroupOptions();
        $p.app.error.displayLastError('admin');
	},    
    /*
                 Function: $p.mobile.users.getSearch
                 
                             Load the search results
                            
                 Parameters:
                 
                            v_s - keyword to search
                            v_page - page number
         */ 
	getSearch:function(v_s,v_page)
	{
		// Open the search results
		$p.setClass("dirlink","optlist");
		$p.setClass("listlink","optlist");
		$p.admin.users.hideGroupOptions();
		$p.admin.users.currLevel=0;
		$p.admin.users.hideFrame();
		v_s=$p.string.formatForSearch(v_s);
		$p.print("listmod","Recherche en cours ...");
		getXml(pmobile["xml_search_user"]+"?searchtxt="+$p.string.esc(v_s)+"&p="+v_page,$p.mobile.users.displaySearch,new Array(v_s,v_page));
	},
    /*
                 Function: $p.mobile.users.displaySearch
                 
                             Display the search results
                            
                 Parameters:
                 
                            response - XML object
                            vars - hash
         */ 
	displaySearch:function(response,vars)
	{
		var l_s="",l_result;
		l_s+=$p.mobile.users.userBar();
		l_s+="<table cellpadding='0' cellspacing='0'>";
		if (response.getElementsByTagName("nbres")[0]) {
			var l_id;
			l_s+="<tr><td><br /><b>"+lg("searchUser")+" : "+vars[0]+"</b> <a href='#' onclick='return $p.mobile.users.loadAll(1)'>"+lg("returnWholeUsersList")+"</a><br /></td></tr>";
			l_s+="<tr><td><table width='960'>";
			l_s+="<tr><td valign='top' class='dirdiva'><table cellpadding='0' cellspacing='0' width='900'><tr><td valign='top'><table cellpadding='1' cellspacing='1' width='300'>";
			var i=0;
			while (response.getElementsByTagName("user")[i]) {
				l_result=response.getElementsByTagName("user")[i];
                var available=$p.ajax.getVal(l_result,"available","int",false,0);
                    var style = (available==0)  ?   'style=color:#c6c3c6;'
                                                :   '';
				l_s+="<tr><td style='border-bottom:1px solid #c6c3c6'>"
                        +$p.img("ico_user_"+$p.ajax.getVal(l_result,"typ","str",false,"I")+".gif",11,9)
                        +" <a class='menul' href='#' "+style+" onclick='$p.mobile.users.displayUserForm("+$p.ajax.getVal(l_result,"id","int",false,0)+",\""+$p.ajax.getVal(l_result,"username","str",false,"???")+"\","+available+");return false;'>"
                        +$p.ajax.getVal(l_result,"name","str",false,$p.ajax.getVal(l_result,"username","str",false,"???"))
                        +"</a></td></tr>";
				i++;
				if (i%7==0&&i<21) l_s+="</table></td><td valign='top'><table cellpadding='1' cellspacing='1' width='300'>"
			}
			if (i==0) l_s+="<tr><td>"+lg("lblSrchNoUser")+"</td></tr>";
			l_s+="</table></td></tr>";
			l_s+="</table><br /><table width='100%'><tr>";
			if (vars[1]!=0){l_s+="<td><a href='#' onclick=\"$p.mobile.users.getSearch('"+vars[0]+"',"+(parseInt(vars[1])-1)+");return false;\">"+$p.img("ico_previous2.gif",12,11,lg("lblPrevUsers"))+" "+lg("lblPrevUsers")+"</a></td>";}
			if (i==21){l_s+="<td align='right'><a href='#' onclick=\"$p.mobile.users.getSearch('"+vars[0]+"',"+(parseInt(vars[1])+1)+");return false;\">"+lg("lblNextUsers")+" "+$p.img("ico_next2.gif",12,11,lg("lblNextUsers"))+"</a></td>";}
			l_s+="</tr></table></td></tr></table>";
			l_s+="<br />";
		}
		else {
			l_s+="<tr><td><table><tr><td style='color:#ff0000'>"+lg("lblSrch3car");
		}
		l_s+="</td></tr></table></td></tr></table>";
		$p.show("listmod","block");
		$p.print("listmod",l_s);
	},
    /*
                 Function: $p.mobile.users.userBar
                 
                             Display the user bar (search form and users/admin caption) 
                            
                 Returns:
                 
                            HTML code
         */ 
    userBar:function()
	{
		var l_s="<div style='padding:5px;'><form name='search' onsubmit='$p.mobile.users.getSearch(document.search.searchtxt.value,0);return false;'>"+$p.img("ico_search.gif",13,13)+" "+lg("searchUser")+" : <input class='thinbox' name='searchtxt' type='text' size='20' style='height:20px' value='' /><INPUT type='submit' name='buts' class='btn' value='Go' />";
		l_s+="&nbsp; | &nbsp; "+$p.img("ico_user_I.gif",11,9)+" "+lg("users")+" . "+$p.img("ico_user_A.gif",11,9)+" "+lg("administrators");
		l_s+="</form></div>";
		return l_s;
	},
    /*
                 Function: $p.mobile.users.displayAll
                 
                             Display all users
                            
                 Parameters:
                 
                            response - XML object
                            vars - hash
         */     
	displayAll:function(response,vars)
	{
		var l_s="";
		l_s+=$p.mobile.users.userBar();
		l_s+="<table cellpadding='0' cellspacing='0'>";
		if (response.getElementsByTagName("page")[0]) {
			var l_id;
			l_s+="<tr><td><table width='960'>";
			l_s+="<tr><td valign='top' class='dirdiva'><table cellpadding='0' cellspacing='0' width='900'><tr><td valign='top'><table cellpadding='1' cellspacing='1' width='300'>";
			var lastvalid=0;
			for (var i=0;i<21;i++) {
				if (response.getElementsByTagName("user")[i]) {
					l_result=response.getElementsByTagName("user")[i];
                    var available=$p.ajax.getVal(l_result,"available","int",false,0);
                    var style = (available==0)  ?   'style=color:#c6c3c6;'
                                                :   '';
                    var l_type=$p.ajax.getVal(l_result,"typ","str",false,"I");
					l_s+="<tr><td style='border-bottom:1px solid #c6c3c6'>"
                            +$p.img("ico_user_"+l_type+".gif",11,9)
                            +" <a class='menul' href='#' "+style+" onclick='$p.mobile.users.displayUserForm("+$p.ajax.getVal(l_result,"id","int",false,0)+",\""+$p.ajax.getVal(l_result,"username","str",false,"???")+"\","+available+");return false;'>"
                            +$p.ajax.getVal(l_result,"name","str",false,$p.ajax.getVal(l_result,"username","str",false,"???"))
                            +"</a></td></tr>";
                    lastvalid=i;
				}
				else {
					l_s+="<tr><td></td></tr>";
				}
				if (i%7==6&&i<20) l_s+="</table></td><td valign='top'><table cellpadding='1' cellspacing='1' width='300'>"
			}
			if (lastvalid==0) l_s+="<tr><td>"+lg("lblNoUser")+"</td></tr>";
			l_s+="</table></td></tr></table>";
			l_s+="<br /><table width='100%'><tr>";
			if (vars>1){l_s+="<td><a href='#' onclick='$p.mobile.users.loadAll("+(vars-1)+");return false;'>"+$p.img("ico_previous2.gif",12,11,lg("lblPrevUsers"))+" "+lg("lblPrevUsers")+"</a></td>";}
			if (lastvalid==20){l_s+="<td align='right'><a href='#' onclick='$p.mobile.users.loadAll("+(vars+1)+");return false;'>"+lg("lblNextUsers")+" "+$p.img("ico_next2.gif",12,11,lg("lblNextUsers"))+"</a></td>";}
			l_s+="</tr></table>";
		}
		else
			l_s+=lg("lblDisplayErr");
		
		l_s+="</td></tr></table>";
		$p.show("listmod","block");
       
		$p.print("listmod",l_s);
	},
    /*
                 Function: $p.mobile.users.displayUserForm
                 
                             Display the user access to mobile form
                            
                 Parameters:
                 
                            id - user id
                            username - user name
                            available - is th euser available (0 = no / other =yes)
         */     
    displayUserForm:function(id,username,available) 
    {
        var l_s='';
        var ischecked = (available==0)  ?   ''   :   'CHECKED';
        l_s+='<p><b>'+lg("lbl_mobileMgmtaccess")+'</b></p><hr width="100%">\
              <table cellpadding="10">\
                    <tr><td valign="top">\
                        <table cellpadding="2">\
                        <tr><td colspan="2"><div id="username"></div></td></tr>\
                        <tr><td></td></tr>\
                        <tr><td colspan="2"><input type="checkbox" '+ischecked+' id="mob_access">'+lg("lbl_mobileaccess")+'</td></tr>\
                        <tr><td></td></tr>\
                        <tr><td colspan="2"><input type="button" class="btn" value="'+lg("lblBtnValid")+'" onclick="$p.mobile.users.activateUser('+id+');return false;" /></div></td></tr>\
                        </table>\
                        </td>\
                     </tr>\
              </table>';
        
        $p.print("newmod",l_s);
        $('username').innerHTML = "<strong>"+username+"</strong>";
    },
    /*
                 Function: $p.mobile.users.displayOptions
                 
                             Display the user access to mobile options
         */      
    displayOptions:function() 
    {
        var l_s='&nbsp;';
        l_s+='<a href="#" onclick="$p.mobile.users.activateAll();return false;" >'+lang["lbl_activateAll"]+'</a> | \
              <a href="#" onclick="$p.mobile.users.blockAll();return false;" >'+lang["lbl_blockAll"]+'</a>';      
        $p.print("directory",l_s);
    },
    /*
                 Function: $p.mobile.users.activateUser
                 
                             Give access to the mobile version for all users
                 
                 Parameters:
                 
                             id - user id
         */   
    activateUser:function(id)
    {
        var access = ($('mob_access').checked)  ?    1    :    0;
        $p.ajax.call(pmobile["scr_update_user_access"],
            {
                'type':'execute',
                'variables':'action=grant&id='+id+'&access='+access,
                'alarm':false,
                'forceExecution':true,
                'callback':
                {
                    'function':$p.mobile.users.usersmgmt
                }
            }
        );
        return false;
    },    
    /*
                 Function: $p.mobile.users.activateAll
                 
                             Give access to the mobile version for all users
         */   
    activateAll:function()
    {
        if (confirm(lg('msg_allowall'))) {
			$p.ajax.call(pmobile["scr_update_user_access"],
				{
					'type':'execute',
					'variables':'action=grantall',
					'alarm':false,
					'forceExecution':true,
					'callback':
					{
						'function':$p.mobile.users.usersmgmt
					}
				}
			);
        }
        return false;
    },
    /*
                 Function: $p.mobile.users.blockAll
                 
                             Remove access to the mobile version for all users
         */    
    blockAll:function()
    {   
        if (confirm(lg('msg_blockall'))) {
			$p.ajax.call(pmobile["scr_update_user_access"],
				{
					'type':'execute',
					'variables':'action=blockall',
					'alarm':false,
					'forceExecution':true,
					'callback':
					{
						'function':$p.mobile.users.usersmgmt
					}
				}
			);
        }
        return false;
    }
}








$p.mobile.widgets = {
    /*
                Function: $p.mobile.widgets.widgetsMgmt
                
                                Build the widgets management page   
         */
    widgetsMgmt:function()
    {
        $p.admin.tools.emptyContent();
        parent.window.scrollTo(0,0);
		parent.$p.admin.fillBreadCrumbs($p.html.breadCrumbs(
			[
				{'label':lg('Accueil'),'link':'','fct':'$p.admin.setState();$p.app.tabs.open(0);return false;'},
				{'label':lg('mobile'),'link':'','fct':'$p.mobile.initMenus();'},
				{'label':lg('modMgmt'),'link':'','fct':''}
			]
		));
		var l_s = $p.admin.widgets.getOptModDiv();
        $p.print($('content'),l_s);
        $p.mobile.widgets.init();
    },
    /*
                  Function: $p.mobile.widgets.init
                  
                                   Initialise the widgets management menu
         */
	init:function(v_reload)
	{
        $p.admin.widgets.loadWidgetsInfos();
		$p.mobile.widgets.getList(1,0);
	},
    /*
                Function: $p.mobile.widgets.getList
                
                 Parameters: 
                 
                    v_page - page number
                    
                    v_type - 
        */
	getList:function(v_page,v_type)
	{
		$p.admin.widgets.hideFrame();
		getXml(pmobile["xml_allservices"]+"?p="+v_page,$p.mobile.widgets.displayList,new Array(v_page,v_type));
		$p.admin.widgets.hideDirOptions();
		return false;
	},
    /*
                Function: $p.mobile.widgets.displayList
                
                 Parameters: 
                 
                    response - XML object
                    
                    vars -  hash
        */
	displayList:function(response,vars)
	{
		var l_s="";
		l_s+=$p.mobile.widgets.moduleBar();
		l_s+="<table cellpadding='0' cellspacing='0'>";
		if (response.getElementsByTagName("page")[0]) {
			var l_id;
			l_s+="<tr><td><table style='width:760px'>";
			l_s+="<tr><td valign='top' class='dirdiva'><table cellpadding='0' cellspacing='0'><tr><td valign='top'><table cellpadding='0' cellspacing='1' style='width:233px'>";
			var i=0;
			while (response.getElementsByTagName("item")[i]) {
				result=response.getElementsByTagName("item")[i];
				v_icon = $p.ajax.getVal(result,"icon","str",false,"--");
				l_id = $p.ajax.getVal(result,"id","int",false,0);
				available = $p.ajax.getVal(result,"available","int",false,0);
                var style = (available==0)  ?   'style=color:#c6c3c6;'
                                            :   '';                
				if( v_icon!="--" ) {
					if( v_icon.substr(0,1)=="_" ) {
						v_icon = $p.img("../modules/pictures/"+v_icon+"?rand="+rand,16,16,indef,indef,l_id);
					} else {
						v_icon = $p.img(v_icon+"?rand="+rand,16,16,indef,indef,l_id);
					}
				} else {
						v_icon = $p.img("../modules/pictures/box0_"+l_id+"?rand="+rand,16,16,indef,indef,l_id);
				}
				l_s+="<tr><td width='20'>"+v_icon+"</td><td style='border-bottom:1px solid #c6c3c6'><a class='menul' "+style+" href='#' onclick='$p.mobile.widgets.loadMod("+l_id+")'"+(($p.ajax.getVal(result,"status","str",false,"")=='O')?"":" style='color:#c6c3c6;text-decoration: line-through;'")+">"+$p.ajax.getVal(result,"name","str",false,"--")+"</a></td></tr>";
				i++;
				if (i%7==0&&i<21) l_s+="</table></td><td valign='top'><table cellpadding='0' cellspacing='1' style='width:233px'>";
			}
			if (i==0) l_s+="<tr><td>"+lg("lblNoModule")+"</td></tr>";
			l_s+="</table></td></tr>";
			l_s+="<br /><table width='100%'><tr>";
			if (vars[0]>1){l_s+="<td><a href='#' onclick='$p.mobile.widgets.getList("+(vars[0]-1)+","+vars[1]+");return false;'>"+$p.img("ico_previous2.gif",12,11,lg("lblPrevMods"))+" "+lg("lblPrevMods")+"</a></td>";}
			if (i==21){l_s+="<td align='right'><a href='#' onclick='$p.mobile.widgets.getList("+(vars[0]+1)+","+vars[1]+");return false;'>"+lg("lblNextMods")+" "+$p.img("ico_next2.gif",12,11,lg("lblNextMods"))+"</a></td>";}
			l_s+="</tr></table>";
		}
		else {
			l_s+=lg("lblDisplayErr");
		}
		l_s+="</td></tr></table>";
		$p.show("listmod","block");
		$p.print("listmod",l_s);
	},
    /*
                 Function: $p.mobile.widgets.moduleBar
                 
                             Display the module bar (search form)

                 Return:
                            
                             HTML code
         */   
	moduleBar:function()
	{
		var l_s="<div style='padding:5px;'>\
                    <form name='search' onsubmit='$p.mobile.widgets.getSearch(document.search.searchtxt.value,0);return false;'>"+lg("searchMod")+" : <input class='thinbox' name='searchtxt' type='text' size='20' style='height:20px' value='' />\
                    <input type='submit' name='buts' class='btn' value='Go' />\
                    </form>\
                 </div>";
                 
		return l_s;
	},
    /*
                 Function: $p.mobile.widgets.getSearch
                 
                             Load results for the keyword searched
                 
                 Parameters:
                 
                             v_s - keyword
                             v_page -
         */   
    getSearch:function(v_s,v_page)
	{
		// Open the search results
		v_s=$p.string.formatForSearch(v_s);
		$p.admin.widgets.hideFrame();
		$p.admin.widgets.hideDirOptions();
		$p.print("listmod","Recherche en cours ...");
		getXml(padmin["xmlsearchadmin"]+"?searchtxt="+$p.string.esc(v_s)+"&p="+v_page,$p.mobile.widgets.displaySearch,new Array(v_s,v_page));
	},
    /*
                 Function: $p.mobile.widgets.displaySearch
                 
                             Display the search result
                 
                 Parameters:
                 
                             response- XML object
                             vars - hash
         */   
	displaySearch:function(response,vars)
	{
		var l_s="",l_result;
		l_s+=$p.mobile.widgets.moduleBar();
		l_s+="<table cellpadding='0' cellspacing='0'>";
		if (response.getElementsByTagName("nbres")[0])
		{
			var l_id;
			l_s+="<tr><td><table style='width:760px'>";
            l_s+="<tr><td><br /><b>"+lg("searchUser")+" : "+vars[0]+"</b> <a href='#' onclick='return $p.mobile.widgets.getList(1,0)'>"+lg("returnWholeUsersList")+"</a><br /></td></tr>";
			l_s+="<tr><td valign='top' class='dirdiva'><table cellpadding='0' cellspacing='0'><tr><td valign='top'><table cellpadding='0' cellspacing='1' style='width:230px'>";
			var i=0;
			while (response.getElementsByTagName("item")[i])
			{
				l_result=response.getElementsByTagName("item")[i];
				var l_id=$p.ajax.getVal(l_result,"id","int",false,0);
				var v_icon = $p.ajax.getVal(l_result,"icon","str",false,"--");
				if( v_icon!="--" ) {
					l_s+="<tr><td width='20'>"+$p.img(""+v_icon,16,16)+"</td><td style='border-bottom:1px solid #c6c3c6'> <a class='menul' href='#' onclick='$p.mobile.widgets.loadMod("+l_id+")'>"+$p.ajax.getVal(l_result,"name","str",false,"...")+"</a></td></tr>";
				} else {
					l_s+="<tr><td width='20'>"+$p.img("../modules/pictures/box0_"+l_id,16,16)+"</td><td style='border-bottom:1px solid #c6c3c6'> <a class='menul' href='#' onclick='$p.mobile.widgets.loadMod("+l_id+")'>"+$p.ajax.getVal(l_result,"name","str",false,"...")+"</a></td></tr>";
				}
				i++;
				if (i%7==0&&i<21) l_s+="</table></td><td valign='top'><table cellpadding='0' cellspacing='1' style='width:230px'>"
			}
			if (i==0) l_s+="<tr><td>"+lg("lblSrchNoMod")+"</td></tr>";
			l_s+="</table></td></tr>";
			l_s+="<br /><table width='100%'><tr>";
			if (vars[1]!=0){l_s+="<td><a href='#' onclick=\"$p.mobile.widgets.getSearch('"+vars[0]+"',"+(parseInt(vars[1])-1)+");return false;\">"+$p.img("ico_previous2.gif",12,11,lg("lblPrevMods"))+" "+lg("lblPrevMods")+"</a></td>";}
			if (i==21){l_s+="<td align='right'><a href='#' onclick=\"$p.mobile.widgets.getSearch('"+vars[0]+"',"+(parseInt(vars[1])+1)+");return false;\">"+lg("lblNextMods")+" "+$p.img("ico_next2.gif",12,11,lg("lblNextMods"))+"</a></td>";}
			l_s+="</tr></table>";
		}
		else
		{
			l_s+="<tr><td><table><tr><td style='color:#ff0000'>"+lg("lblSrch3car");
		}
		l_s+="</td></tr></table></td></tr></table>";
		$p.show("listmod","block");
		$p.print("listmod",l_s);
	},
    /*
                 Function: $p.mobile.widgets.loadMod
                 
                             Load the widget mobile informations
                 
                 Parameters:
                 
                             id- widget id
         */   
    loadMod:function(id) 
    {
        $p.ajax.call(pmobile["xml_loadwidget"]+"?id="+id,
            {
                'type':'load',
                'callback':
                {
                    'function':$p.mobile.widgets.displayMod,
                    'variables':
                    {
                        'id':id
                    }
                }
            }	
        );
		return false;
    },
    /*
                 Function: $p.mobile.widgets.displayMod
                 
                             Display the module detailed informations
                 
                 Parameters:
                 
                             response- XML object
                             vars - hash
         */   
    displayMod:function(response,vars)
    {
        var l_s='';
        var id = vars['id'];
        l_result = response.getElementsByTagName("widget")[0];
		var name=$p.ajax.getVal(l_result,"name","str",false,"");
		var title=$p.ajax.getVal(l_result,"title","str",false,"");
		var picture=$p.ajax.getVal(l_result,"picture","str",false,"mob_ico_1.png");
		var available=$p.ajax.getVal(l_result,"available","int",false,0);
		var nbicons=$p.ajax.getVal(l_result,"nbicons","int",false,33);
        var ischecked = (available==0)  ?   ''   :   'CHECKED';
        
        l_s+='<p><strong>'+lg("lbl_mobileMgmtaccessWidget")+'</strong></p><hr width="100%">\
              <table cellpadding="10">\
                <tbody>\
                <tr><td valign="top">\
                    <table cellpadding="2">\
                    <tbody>\
                    <tr><td colspan="2"><strong>'+name+'</strong></td></tr>\
                    <tr><td></td></tr>\
                    <tr><td colspan="2"><input type="checkbox" '+ischecked+' id="mob_access"> '+lg("lbl_mobileaccess")+'</td></tr>\
                    <tr><td></td></tr>\
                    <tr><td>'+lg("title")+'</td><td>&nbsp;<input type="text" id="mob_title" value="" size="20" maxlength="15" /></td></tr>\
                    <tr><td></td></tr>\
                    <tr><td valign="top">'+lg("icon")+'</td><td><input type="hidden" id="mob_sel_icon" value="'+picture+'"><div id="mob_icons" style="width:70%;"></div></td></tr>\
                    <tr><td></td></tr>\
                    <tr><td></td><td><div id="uploadmsg"></div></td></tr>\
                    <tr><td><td><div>'+lg("lbl_uploadIcon")+'</div>\
                    <div><iframe height="55" frameborder="0" width="400" src="../includes/plugins/mobile/admin/upload_icon.php?nbicons='+nbicons+'&modid='+id+'"></iframe></div></td></tr>\
                    <tr><td></td></tr>\
                    <tr><td></td><td><input type="button" class="btn" onclick="$p.mobile.widgets.validForm('+id+');return false;" value="'+lg("lblBtnValid")+'"/></div></td></tr>\
                    </tbody>\
                    </table>\
                    </td>\
                 </tr>\
                 </tbody>\
              </table>';
        
        $("newmod").innerHTML = l_s;
        $p.mobile.widgets.displayIcons(nbicons,picture);
        $('mob_title').value = title;
        
    },
    /*
                 Function: $p.mobile.widgets.displayIcons
                 
                             Display the widgets available icons
                 
                 Parameters:
                 
                             nbicons- nbicons available
                             picture - current widget picture
                             
                 Return:
                            
                             HTML code
         */   
    displayIcons:function(nbicons,currpict)
    {
        var l_s='';
        var iconStyle = 'style="border: 2px solid black"';
        var path = "../includes/plugins/mobile/images/icons/";
        l_s+='<a href="#" style="padding:3px;" onclick="return false;"><img src="'+path+currpict+'" id="currentpic" width="48" height="48" style="border: 2px solid green"></a><div></div>';
    	for (var i=1;i<=nbicons;i++) {
            var filename = "mob_ico_"+i+".png";
     		l_s+='<a href="#" onclick="return false;" style="padding:3px;"><img src="'+path+filename+'" id="mob_ico_'+i+'.png" width="48" onclick="$p.mobile.widgets.changeIconFont('+nbicons+',\'mob_ico_'+i+'.png\');return false;" height="48" '+iconStyle+'></a>';
    	}
        $("mob_icons").innerHTML+=l_s;
    },
    /*
                 Function: $p.mobile.widgets.changeIconFront
                 
                             Change the selected icon font color
                 
                 Parameters:
                 
                             nbicons- numbers of icons available
                             iconId - selected icon id
         */   
    changeIconFont:function(nbicons,iconId)
    {
    	for (var i=1;i<=nbicons;i++) {
    		$("mob_ico_"+i+".png").style.border = "2px solid black";
    	}
        $(iconId).style.border = "2px solid red";
        $("mob_sel_icon").value = iconId;
    },
    /*
                 Function: $p.mobile.widgets.validForm
                 
                             Update the widget properties
         */   
    validForm:function(id)
    {
        if ($('mob_title').value == "") {
            alert(lg["msgSpecifyTitle"]);
            return false;
        }
        var title = $p.string.esc($('mob_title').value);
        var available = ($('mob_access').checked)  ?    1    :    0;
        var picture = $('mob_sel_icon').value;
        $p.ajax.call(pmobile["scr_update_widget_properties"],
            {
                'type':'execute',
                'variables':'modid='+id+'&available='+available+'&picture='+picture+'&title='+title,
                'alarm':false,
                'forceExecution':true,
                'callback':
                {
                    'function':$p.mobile.widgets.widgetsMgmt
                }
            }
        );
        return false;        
    },
    /*
                 Function: $p.mobile.widgets.refreshAfterUpload
                 
                             Refresh after upload
                 
                 Parameters:
                 
                             id - id of the widget currently displayed
         */   
    refreshAfterUpload:function(id) 
    {
        if (id == 0) {
            $p.mobile.widgets.getList(1,0);
        }
        else {
            $p.mobile.widgets.loadMod(id);
        }
    },
    /*
                 Function: $p.mobile.widgets.errorUploading
                 
                             Display error message when icon upload fails
                 
                 Parameters:
                 
                             error - error message
         */   
    errorUploading:function(error)
    {
        $p.print('uploadmsg',"<span class='warning'>"+lg(error)+"</span>");
        return false;
    }
}