<?php
# *********************** LICENSE *****************************************************
#	This file is part of AutoCreat plugin.
#
#	AutoCreat plugin is free software; you can redistribute it and/or modify
#	it under the terms of the GNU General Public License as published by
#	the Free Software Foundation; either version 2 of the License, or
#	(at your option) any later version.
#
#	CAS plugin is distributed in the hope that it will be useful,
#	but WITHOUT ANY WARRANTY; without even the implied warranty of
#	MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
#	GNU General Public License for more details.
#
#	You should have received a copy of the GNU General Public License
#	along with Foobar; if not, write to the Free Software
#	Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
# *************************************************************************************


/************************************************
 *   AutoCreat plugin file	        	        *
 *   file: plugin_AC.php				            *
 *   version: 1.00                           	*
 *   date: 07/11/07                          	*
 *   author: Jean-francois Rey               	*
 *   email: jean-francois.rey@univ-avignon.fr  	*
 ************************************************/

/*
 * name: Plugin Auto Create
 * description: Plugin EOLE - Création automatique de l'utilisateur à la connexion. Attention !! Ce plugin n'est pas désactivable.
 * display:  style="font-weight:bolder;"
 * dependencies: no
 * author: Jean-François REY
 * url: http://gpl.univ-avignon.fr
 */

define("AC_NAME","AutoCreat plugin");


/*
 * Registers the action in order to uninstall the plugin
 */
// Crée le compte à la première connexion
register_hook("user_login_form","plugac_user_login_form",1,2);

define("__LOG_EOLEAC", false);
function logEoleac($msg){
  if (__LOG_EOLEAC){
    //error_log("LOG_EOLEAC (plugin eoleac / paquet eole-posh) : ".$data); // apache error.log
    error_log($data."\n", 3, "/var/log/posh/eoleac.log");
  }
}

function plugac_user_login_form($username,$password){
    global $DB, $scrsubscribe_log;
    $is_user_query = "SELECT id FROM users WHERE username=%s";
    // On teste si l'utilisateur est déjà dans la base
    $DB->getResults($is_user_query,$DB->quote($username));
    if ($username!=""){
        if(EolephpCAS::isAuthenticated()){
            $details = EolephpCAS::getDetails();
            $userfullname = isset($details['infos']['displayName'][0]) ? $details['infos']['displayName'][0] : $username;
            //TODO : gestion des mails (manque le champ dans la bdd)
            $usermail = isset($details['infos']['mail'][0]) ? $details['infos']['mail'][0] : "email@non_renseignee";
            $usermail = strtolower($usermail);


            if ($DB->nbResults()<=0){
                logEoleac("Ajout de l'utilisateur " . $username . " : " . $userfullname . " dans la base Posh.");
                //add the new user
                $insert_user_qery = "INSERT INTO users (username,pass,long_name,typ,lastconnect_date,md5pass,md5user,lang,email)";
                $insert_user_qery .= "VALUES (%s,'',%s,%s,NOW(),MD5(%s),%s,'fr',%s)";
                $DB->execute($insert_user_qery,
                    $DB->quote($username),
                    $DB->quote($userfullname),
                    $DB->quote("I"),
                    $DB->quote($password),
                    $DB->quote(md5($username)),
                    $DB->quote($usermail));
                // new user_id
                $userid=$DB->getId();
                //add to log
                $DB->execute($scrsubscribe_log,$DB->escape($id));
                $DB->freeResults();
            }else{
                $update_user_query = "UPDATE `users` SET `long_name`=%s, `md5user`=%s, email=%s, lastconnect_date=NOW() WHERE username=%s";
                $DB->execute($update_user_query,
                    $DB->quote($userfullname),
		    $DB->quote(md5($username)),
		    $DB->quote($usermail),
		    	$DB->quote($username));
                $DB->freeResults();
            }
        }
    }
}

?>
