<?php
# *********************** LICENSE ***************************************************** #
#   This file is part of EoleCAS plugin.
#
#   Copyright Pole de Competence Eole  (Ministere Education - Academie Dijon)
#   Licence CeCill  cf /root/LicenceEole.txt
#   eole@ac-dijon.fr
# ************************************************************************************* #

/************************************************
 *   EoleCAS plugin file                        *
 *   Extension of CAS plugin file               *
 *   from Jean-francois Rey                     *
 *   jean-francois.rey@univ-avignon.fr          *
 *   file: plugin_eolecas.php                   *
 *   version: 2.00                              *
 *   date: 07/11/07                             *
 *   author : Gaston TJEBBES                    *
 *   email: g.tjebbes@ac-dijon.fr               *
 ************************************************/

/************************************************
 *  Ajout prise en compte des smartphones      	*
 * 	En lien avec le plugin mobile				*
 *  michel.rein@ac-besancon.fr					*
 ************************************************/
 
/*
 * name: Plugin CAS
 * description: Plugin EOLE - Gestion de la connexion SSO avec eoleCAS. Attention !! Ce plugin n'est pas désactivable.
 * display:  style="font-weight:bolder;"
 * dependencies: no
 * author: Gaston TJEBBES
 * url: http://eole.orion.education.fr
 */
 
 
define("CAS_NAME","plugin EOLECAS");

// Librairies et fichiers de configuration CAS
include_once("configCAS/cas.inc.php");
include_once("cas.inc.php");
//retour si problème include_once("CAS/eoleCAS.php");
include_once("CAS-1.3.1/eoleCAS.php");

// Fonction utiles
include_once("plugcas_tools.php");

if (__CAS_DEBUG){
    EolephpCAS::setDebug("/var/log/phpcas/phpcas-posh.log");
}

// portal/index.php
register_hook("index_php", "plugcas_userindex",1,1);

// index.php admin et portal
register_hook("userinterface_header","plugcas_userinterface_header",1,1);
register_hook("userinterface_header_mobile","plugcas_userinterface_header_mobile",1,1);//MR
register_hook("admininterface_header","plugcas_userinterface_header",1,1);

// portal/login.php
register_hook("login_php","loginPageHook",1,1);
register_hook("login_mobile_php","loginPageHook_mobile",1,1);

// logout function
register_hook("logout","eoleLogoutHook");
register_hook("logout_mobile","eoleLogoutHook_Mobile");//MR
// init session
register_hook("scr_connect_session_initialized", "addAvatarInSession", 1,1);

function plugcas_userindex(){
    /*
     * Hook à l'initialisation de la page d'index 'utilisateur'
     */
    if( __defaultAuthen=="cas"){
        // Going to Cas login page if not done
        if(__defaultmode=="connected" && !isset($_REQUEST['ticket']) ){
            header("location:" . login_link());
            exit();
        }
    }
}
function addAvatarInSession($user){
    /*
     * Ajoute les informations eole dans l'objet user de la session
     * $user: objet utilisateur créé dans la fonction user_login_form (cf en bas)
     */
    $_SESSION['avatar'] = $user;
}
function buildAvatar(){
    /*
     * Construit l'avatar eole
     */
    echo "<script type='text/javascript'>";
    foreach ($_SESSION['avatar'] as $key=>$value){
        echo "$" . "p.app.user.set('" . $key . "', '" . $value . "');";
    }
    echo "</script>";
}
function plugcas_userinterface_header($page)
{
    /*
     * Envoyé à chaque initialisation de page (admininterface également)
     */
    echo "<link type='image/xicon' href='../styles/themes/eole/eole_icone.ico' rel='shortcut icon' />";
    if( __defaultAuthen=="cas"){
		if( !$_SESSION["initCAS"] ) 
			initCasProxy();
					
        //if ( __CAS_LOGOUT == false){
            setLogoutHook(); // Ajout d'un hook javascript pour le logout centralisé
        //}
        setAvatarLibHook();

        if (($page == "portal/login.php" || $page == "admin/login.php") && !EolephpCAS::isAuthenticated()){
            setLoginRedirectHook();
        }elseif ( $page != "portal/login.php" && $page !="admin/login.php"){
            buildAvatar();
        }
        setChangeUserHook();
    }
}

function plugcas_userinterface_header_mobile($page)
{
    /*
     * Envoyé à chaque initialisation de page (admininterface également)
     */
    echo "<link type='image/xicon' href='../styles/themes/eole/eole_icone.ico' rel='shortcut icon' />";
    if( __defaultAuthen=="cas"){
		if( !$_SESSION["initCAS"] ) 
			initCasProxy();
					
        //if ( __CAS_LOGOUT == false){
            setLogoutHook(); // Ajout d'un hook javascript pour le logout centralisé
        //}
        setAvatarLibHook_Mobile();

        if (($page == "portal/login.php" || $page == "admin/login.php") && !EolephpCAS::isAuthenticated()){
            setLoginRedirectHook();
        }elseif ( $page != "portal/login.php" && $page !="admin/login.php"){
            if(isset($_SESSION['avatar'])) buildAvatar();
        }
        setChangeUserHook();
    }
}
/************************* login.php */
// HEADER
function loginPageHook(){
    /*
     * Lance la vérification cas avant d'afficher la page de login
     * Permet au client CAS de renvoyer une page d'erreur en cas de ticket invalide
     * Cache le formulaire d'authentification de l'appli et le rempli pour passer à l'étape suivante
     * (il faut le laisser (pas le vider) : on ne coupe pas la branche sur laquelle on est assis)
     * Initialise la session de l'utilisateur
     */
    initCasProxy();
    EolephpCAS::checkAuthentication();
    if(!EolephpCAS::isAuthenticated()){
        header("location:".__LOCALFOLDER."portal/index.php");
        exit();
    }
    $user = EolephpCAS::getUser();
    echo "<script type='text/javascript'>";
    echo "var fcas = new Array();";
    echo "fcas.password = new Array();";
    echo "fcas.password.value=".random_number().";";
    echo "fcas.username = new Array();";
    echo "fcas.username.value='".$user."';";
    echo "function cacheForm(){\$p.app.connection.set(fcas,\$p.app.pages.isPageExisting);";
    echo "}";
    echo "window.onload = cacheForm;";
    echo "</script>";
}
function loginPageHook_Mobile(){
    /*
     * Lance la vérification cas avant d'afficher la page de login
     * Permet au client CAS de renvoyer une page d'erreur en cas de ticket invalide
     * Cache le formulaire d'authentification de l'appli et le rempli pour passer à l'étape suivante
     * (il faut le laisser (pas le vider) : on ne coupe pas la branche sur laquelle on est assis)
     * Initialise la session de l'utilisateur
     */
     
	session_start();
	$user = $_SESSION['phpCAS']['user'];
    echo "<script type='text/javascript'>";
	echo "var fcas = new Array();";
    echo "fcas.password = new Array();";
    echo "fcas.password.value=".random_number().";";
    echo "fcas.username = new Array();";
    echo "fcas.username.value='".$user."';";
	echo "function cacheForm(){window.document.forms['fcas'].submit();";
    echo "}";
    echo "window.onload = cacheForm;";
    echo "</script>";
}

//**************************************
if ( __defaultAuthen=="cas" && !function_exists('user_login_form') ):
    /*
     * On redéfinit la fonction de vérification de login, on est déjà authentifié
     * Donc on renvoie true et on construit l'objet $user qui sera utilisé plus tard
     */
    function user_login_form($username,$password,&$user,&$errormsg)
    {
        global $DB,$authentif_getUserByName,$authentication_updateConnectDate;
        initCasProxy();

        // Pour empécher qu'on se loggue avec un autre compte
        if(EolephpCAS::isAuthenticated()){
            $username = EolephpCAS::getUser();
        }

        launch_hook('user_login_form',$username,$password);
        // On récupère le user dans la base
        $DB->getResults($authentif_getUserByName,$DB->quote($username));
        if ($DB->nbResults()<=0)
        {
            $errormsg.=lg("incorrectLogin");
        }else{
            $row=$DB->fetch(0);
            if ($row["typ"]=="N" OR $row["typ"]=="M"){
                $errormsg.=lg("userNotValidated");
            }else{
                if(EolephpCAS::isAuthenticated()){
                    // ok go to user page
                    $username = EolephpCAS::getUser();
                }else{
                    $errormsg.=lg("incorrectLogin");
                }
            }
            if( $errormsg == "" ){
                /*
                 * Récupération des infos utilisateurs
                 */
				 
                $user_details = EolephpCAS::getDetails();
                $rne = $user_details['infos']['rne'][0];
                $group = "";
                $groups = $user_details['infos']['user_groups'];
                for ($i=0;$i<count($groups);$i++){
                    switch ( $groups[$i] ){
                        case "eleves" :
                            $group =  $groups[$i];
                            break;
                        case "professeurs" :
                            $group =  $groups[$i];
                            break;
                        case "domainadmins" :
                            $group =  $groups[$i];
                            break;
                        case "responsables" :
                            $group =  $groups[$i];
                            break;
                        case "administratifs" :
                            $group =  $groups[$i];
                            break;
                    }
                }
                $pass = md5($password);
                $uid = $row["id"];

                $user->id = $uid;
                $user->username = $username;
                $user->type = $row["typ"];
                $user->pass = $pass;
                $user->lang = $row["lang"];
                $user->longname = $row["long_name"] == "" ? $username:$row["long_name"];
                $user->picture = $row['picture'];

                $DB->freeResults();
                $DB->execute($authentication_updateConnectDate,$user->id);
                return true;
            }
        }
        $DB->freeResults();
        return false;
    }
endif;
function eoleLogoutHook(){
    /*
     * Fonction de logout
     */
    if (__defaultAuthen=="cas"){
        if(isset($_GET["act"]) && $_GET["act"]=="logout" && $_GET["from"] != "A") { // not admin
            initCasProxy();
            // Logout effectif
            EolephpCAS::logout(array('url'=>cas_return()));

            /* if (method_exists(phpCAS, 'logoutWithUrl')){ */
            /*     EolephpCAS::logoutWithUrl(cas_return()); */
            /* }else{ */
            /*     EolephpCAS::logout(cas_return()); */
            /* } */

        }
    }
}
function eoleLogoutHook_Mobile(){
    /*
     * Fonction de logout
     */
    if (__defaultAuthen=="cas"){
        //if(isset($_GET["act"]) && $_GET["act"]=="logout" && $_GET["from"] != "A") { // not admin
		if(1){//fixme
            initCasProxy();
            // Logout effectif
            EolephpCAS::logout(array('url'=>cas_return().'?mob=1'));

            /* if (method_exists(phpCAS, 'logoutWithUrl')){ */
            /*     EolephpCAS::logoutWithUrl(cas_return()); */
            /* }else{ */
            /*     EolephpCAS::logout(cas_return()); */
            /* } */

        }
    }
	exit;
}//MR
?>
