<?php

session_name("xdesktop");
session_start();

include_once('inc.php');



?>
<!DOCTYPE html PUBLIC "-//W3C//DTD XHTML 1.0 Strict//EN" "http://www.w3.org/TR/xhtml1/DTD/xhtml1-strict.dtd">
<html xmlns="http://www.w3.org/1999/xhtml" xml:lang="fr" lang="fr">
<head>
    <META HTTP-EQUIV="Content-Type" CONTENT="text/html; charset=utf-8" />
    <title>Bureau d'accès rapide à vos applications</title>
    <link type='text/css' rel='stylesheet' href='<?php echo(__LOCALPATH); ?>includes/plugins/plugin_xdesktop/themes/<?php echo $theme;?>/main.css' media='screen' />
    <link type="text/css" rel="stylesheet" href="themes/<?php echo $theme;?>/toolbar.css" />

    <?php include_once("/var/www/html/posh/includes/plugins/plugin_xdesktop/inc_js.php"); ?>

    <script type="text/javascript">

	function OnContentLoaded()
	{
		$('loading').fade("out");
		$('loading').style.top='-100px';
	}

	function ToggleApplicationsList()
	{

		l=$('btnApplications').getPosition().x;
		w=$('btnApplications').getSize().x;
		$('buttonList').style.left=(l-w-5*2+16-4)+"px"; // 5*2, on enleve le padding

		var pageHeight = Window.getHeight();
		var height=$('buttonList').getSize().y	;
		if ( height>pageHeight)
		{
			$('buttonList').style.height=(pageHeight-100)+"px";
		}

		xtoggle('buttonList');

		if (!xIsVisible('buttonList'))
			$('btnApplications').set("class","toolbuttonSelected");
		else
			$('btnApplications').set("class","toolbutton");

	}

	// CloseApp : Permet de clore une application
	function CloseApp(app)
	{
		$('loading').fade("out");
		$envole.xdesktop.mapApp.remove(app);
		$('task_'+app).destroy();

		if (_gel(app)!=null) _gel(app).src="blank.php";

		if ($envole.xdesktop.currentApp ==  app && $envole.xdesktop.mapApp.size()!=0 )
		{
			xhide(app);
			$envole.xdesktop.currentApp="";
			ActiveApp($envole.xdesktop.mapApp.keys()[0]);
		}
		if ($envole.xdesktop.mapApp.size()==0)
		{
			OnClickAction("index.php","default","default","");
			$envole.xdesktop.lastApp="";
			$envole.xdesktop.currentApp="";
		}
	}

	function ActiveApp(app)
	{

		// Si c'est l'application courante, on ne fait rien
		if ($envole.xdesktop.currentApp ==  app) return;

		// Si il y a une appli en cours, on unselect le boutton dans la toolbar
		if ($envole.xdesktop.currentApp!="")
		{
			xhide($envole.xdesktop.currentApp);
			if ($('task_'+$envole.xdesktop.currentApp))
				$('task_'+$envole.xdesktop.currentApp).set("class","buttontask");
		}

		// Différent de la frame par défaut, on selectionne le boutton et cache la frame par défaut
		if (app != "default")
		{
			selectButton(app);
			xhide('default');
		}

		// Affiche la frame de l'application
		xshow(app);

		task=$envole.xdesktop.mapApp.get(app);

		// Unselect le bouton "Mes applications"
   		$('btnApplications').set("class","toolbutton");

		// Mémorise l'application courrante
		$envole.xdesktop.currentApp=app;

	}

	// OnClickAction : appelé lors du click sur le menu "mes applications"
	function OnClickAction(url,libelle,description,icon)
	{
		xhide('buttonList');

		// Normalise le nom de l'appli
		var app=Xnormalizer(description);
		task={id:app,url:url,libelle:libelle,description:description,icon:icon};

		// Pas de app défini , on en créé une
		if ( $envole.xdesktop.mapApp.get(app) == null)
		{
			// Si il y a une icône de définie, création du bouton dans la toolbar
			if ( icon != "" ) {
				$p.print('tasks',
				'<div name="task_'+app+'" id="task_'+app
				+'" class="buttontask" align="left">'
				+"<img width='16px' height='16px' style='vertical-align: middle;' src='"+icon+"'>&nbsp;&nbsp;"
				+'<div class="libelletask"  onclick="javascript:ActiveApp(\''+app+'\')">'+description+'</div>'
				+'<div class="close" onclick="javascript:CloseApp(\''+app+'\')"></div>'
				+'</div>',"bottom");
			}


			// Récupération de la frame de l'appli et modification de l'attribut src
			// afin de charger la page
			var contentframe = _gel(app);
			if ( contentframe.src.indexOf(url) == -1 )
			{
				contentframe.src=url;

				// Positionne et affiche la div <loading>
				var pageWidth = Window.getWidth();
				var pageHeight = Window.getHeight();
				$('loading').style.left= Math.round((pageWidth-$('loading').getSize().x)/2)+'px';
				$('loading').style.top='100px';
				$('loading').fade("in");
			} else
			{
				// Sinon on enleve la div <loading> de l'écran
				$('loading').style.top='-100px';
			}
			// Sous FF nécessaire de fixer une hauteur par défaut
			// Sera modifié par la fonction OnContentLoaded
			var pageHeight = Window.getHeight();
            		if ($p.navigator.FF)  { contentframe.style.height = ((pageHeight!=0)?pageHeight:700)+'px';}

			// Si il y a une icône de définie, on mémorise l'appli.
			if ( icon != "" ) { $envole.xdesktop.mapApp.put(app,task); }
		}

		// Activation de l'appli (affichage)
		ActiveApp(app);

	}

	function OnFrameClick()
	{
		alert("hh");
	}

	function Logout()
	{
		window.location="https://<?php echo __CAS_SERVER.":". __CAS_PORT . __CAS_FOLDER; ?>/logout?service=http://"+$envole.xdesktop.portail;
	}

	function ShowHelp(id,message)
	{
		$('help').style.left= ($(id).getPosition().x - 80)+"px";
		$('help').style.top= ( $(id).getPosition().top + $(id).getSize().y +1 )+"px";
		$p.print('help',message);
		xshow('help');
	}

	function HideHelp() {xhide('help');}

	function Help()
	{
		OnClickAction("themes/" + theme + "/help.php","Site Internet/Aide_en_ligne","Aide en ligne","images/help_icon.png");
	}

	function FullWithApp(url,libelle,description,icon)
	{
		xhide('fullscreen');
		xshow('toolbar');
		xhide('default');
		xhide('xposh');
		OnClickAction(url,libelle,description,icon);
	}

	function Full()
	{
		xhide('fullscreen');
		xshow('toolbar');
		xhide('default');
		xhide('xposh');

		if ($envole.xdesktop.lastApp!="")
		{
			var app = $envole.xdesktop.lastApp;
			selectButton(app);
			xshow(app);
			$envole.xdesktop.currentApp=app;
		}
		if ($envole.xdesktop.mapApp.size()==0)
		{
			$envole.xdesktop.currentApp=""; // Force le reload de la frame
			OnClickAction("index.php","default","default","");
		}
	}

	function selectButton(app)
	{
		if ($('task_'+app)==null) return;
		$('task_'+app).set("class","buttontaskSelected");
	}

	function Home()
	{
		// Si il y a une appli en cours, on unselect le boutton dans la toolbar
		/*if ($envole.xdesktop.currentApp!="")
		{
			xhide($envole.xdesktop.currentApp);
			if ($('task_'+$envole.xdesktop.currentApp))
				$('task_'+$envole.xdesktop.currentApp).set("class","buttontask");
		}*/

		OnClickAction("index.php","default","default","");
		$envole.xdesktop.lastApp="";
		$envole.xdesktop.currentApp="";


	}

	function Restore()
	{
		xhide('help');
		xhide('toolbar');

		xhide('default');
		xhide('conditions');

		xshow('fullscreen');
		var pageWidth = Window.getWidth();
		$('fullscreen').style.left = (pageWidth - $('fullscreen').getSize().x - 9)+"px";
		$('fullscreen').style.top  = "5px";

		if ($envole.xdesktop.currentApp!="")
		{
			xhide($envole.xdesktop.currentApp);
		}
		$envole.xdesktop.lastApp = $envole.xdesktop.currentApp;
        <?php  if (isset($_GET['origin'])) { ?>
	        OnClickAction("<?php echo $_GET['origin']; ?>","xposh","xposh","");
        <?php } else { ?>
            OnClickAction("https://"+$envole.xdesktop.portail+"<?php echo(__LOCALPATH); ?>/index.php","xposh","xposh","");    
        <?php } ?> 
		

	}

   </script>

</head>

<body>

<div class='toolbar' id='toolbar'>
<!--
	<div align='left' class='topbar_icon'  id='topbar_icon'></div>
	<div align='left' class='topbar_title' id='topbar_title'></div>
-->
	<div id="bQuit" class='toolbutton' align='right' onclick='javascript:Logout()' onmousemove="ShowHelp('bQuit','Se déconnecter de l\'ENT')" onmouseout="HideHelp()">
	<img width='16px' height='16px' style='vertical-align: middle;' src='themes/<?php echo $theme;?>/images/quit_red.png' >
	</div>

	<div class='toolbutton' align='right' onclick='javascript:Restore()' onmousemove="ShowHelp('bQuit','Sortir du mode plein écran')" onmouseout="HideHelp()">
	<img width='16px' height='16px' style='vertical-align: middle;' src='themes/<?php echo $theme;?>/images/reduce.png' alt='Revenir au mode standard'>
	</div>

	<div class='toolbutton' align='right' onclick='javascript:Home()' onmousemove="ShowHelp('bQuit','Afficher l\'ensenble des applications')" onmouseout="HideHelp()">
	<img width='16px' height='16px' style='vertical-align: middle;' src='themes/<?php echo $theme;?>/images/home.png' alt='Liste des applications'>
	</div>

<?php
// méthode pour afficher ou non le bouton d'aide
if (file_exists("themes/".$theme."/help.php")) {
	echo "<div class='toolbutton' align='right' onclick='javascript:Help()' onmousemove=\"ShowHelp('bQuit','Aide en ligne')\" onmouseout=\"HideHelp()\" style='width:16px;'>";
	echo "<img width='8px' height='16px' style='vertical-align: middle;' src='themes/".$theme."/images/help.png' >";
	echo "</div>";
}
?>

	<div id='btnApplications' class='toolbutton' align='right' onclick='javascript:ToggleApplicationsList()' >
	<img width='16px' height='16px' style='vertical-align: middle;' src='themes/<?php echo $theme;?>/images/logo_desktop.png'>
		Mes Applications
	</div>

	<div align='left' class='topbar_task' id='tasks'>
	</div>

</div>

<div id='buttonList' class='buttonList'></div>
<div id='loading' class='loading'>
<img src="themes/<?php echo $theme;?>/images/loading52.gif" style="vertical-align: middle;"> Chargement en cours...
</div>

<div id='help' class='help'></div>
<div id='fullscreen' class='fullscreen'  onclick='javascript:Full()' onmousemove="ShowHelp('fullscreen','Acceder à vos applications')" onmouseout="HideHelp()" >
<img width='16px' height='16px' style='vertical-align: middle;' src='themes/<?php echo $theme;?>/images/full.png'>
</div>


<div id="containerApp" style="margin:0px;  width: 100%; height: 95%;">

<iframe  onload="javascript:OnContentLoaded()" name ="default" id ="default"   width="100%" height="100%"  style="display:none; width: 100%; height: 100%;" marginheight=0 marginwidth=0 src="" frameborder=0></iframe>

<iframe  onload="javascript:OnContentLoaded()" name ="aideenligne" id ="aideenligne"   width="100%" height="100%"  style="display:none; width: 100%; height: 100%;" marginheight=0 marginwidth=0 src="" frameborder=0></iframe>

<iframe  onload="javascript:OnContentLoaded()" name ="conditions" id ="conditions"   width="100%" height="100%"  style="display:none; width: 100%; height: 100%;" marginheight=0 marginwidth=0 src="" frameborder=0></iframe>

<iframe  onload="javascript:OnContentLoaded()" name ="xposh" id ="xposh"   width="100%" height="100%"  style="display:none; width: 100%; height: 100%;" marginheight=0 marginwidth=0 src="" frameborder=0></iframe>


</div>

</div>
<iframe style='display:none;' id='ac-notification'></iframe>

<script>

    $envole.xdesktop.mapApp = new Hashtable();
    $envole.xdesktop.currentApp="";
    $envole.xdesktop.portail = "<?php echo $_SERVER["SERVER_NAME"]; ?>";

<?php

include_once("/var/www/html/posh/includes/plugins/plugin_xdesktop/inc_profil.php");

$charte=isEnabled()?hasValidated($user):true;
$URL="default";
if (isset($_GET['url']))
{
	$URL=urldecode($_GET['url']);
}


echo "$" . 'envole.xdesktop.currenturl="' . $URL .'";';
echo "\n";

// Si l'url qu'on tente de charger par défaut est les 'conditions d'utilisation' et que la charte est valide
// On redirige directement vers la page par défaut
if  ( (strpos($URL,"plugin_xdesktop/conditions.php")!==false)  && ($charte))
{
	echo "$" . 'envole.xdesktop.currenturl="' . 'default' .'";';
}

echo "$" . 'envole.xdesktop.catmin=100;';
echo "\n";
echo "$" . 'envole.xdesktop.build("' . $ret_str . '","OnClickAction");';
echo "\n";
echo "$" . 'envole.xdesktop.charte = ' . ($charte?'true':'false') . ';';



?>

// 2 Toggle pour fixer, une scrollbar vertical,
// A corriger
ToggleApplicationsList();
ToggleApplicationsList();

xhide('buttonList');
$('btnApplications').set("class","toolbutton");

</script>

</body>
</html>

