<?php

session_name("xdesktop");
session_start();

$NO_USERDATA=true;

include_once('inc.php');

$NO_USERPROFIL=true;
include_once('inc_profil.php');

$format=$_GET["format"];

function BuildInfos($type,$value)
{
    global $postit_flags,$DB,$format;

    $GROUPEPLUS="";
    if ($type == "groupe")
    {
        $GROUPEPLUS=" OR ( type = 'groupe' AND valeur  like '%%,".$value.",%%')";
    }

    $sql = "SELECT * FROM xdesktop_postit WHERE ( type = %s AND valeur = %s ) $GROUPEPLUS ";
    $DB->getResults($sql, $DB->quote($type), $DB->quote($value));
    if ($DB->nbResults()==0) {$DB->freeResults();return "";}

    $sRet="";
    while ($row = $DB->fetch(0)){
        $row["id"];
        $message=$row["message"];
        $flag=strtolower($row["flag"]);
		
		if($format=="widget") {
			$sRet.=$message."<br><br><hr><br>";
		}
		else {
			if ( $flag != "" ) {
				$sRet.="<div class='".$flag."'><br>";
			}
			else {
				$sRet.="<div>";
			}

			$sRet.=$message."<br><br>";
			$sRet.="</div>";
		}
    }
    
    $DB->freeResults();
    return $sRet;
}


function BuildInfos_user($uid='')
{
    if ($uid=='') $uid=$_SESSION["username"];
    return BuildInfos("uid",$uid);
}

function  BuildInfos_groupes($groupes='')
{
    if ($groupes=='') $groupes=$_SESSION["groupes"];
    else $groupes=explode(",",$groupes);

    if (!is_array($groupes)) return "";

    $r="";
    foreach ( $groupes as $grp)
    {
        $r.=BuildInfos("groupe",trim(strtolower($grp)));
    }
    return $r;
}

function BuildInfos_profils($profil='')
{
    if ($profil=='') $profil=GetGroupFromSDETProfil($_SESSION["profil"]);
    return BuildInfos("profil",$profil);
}

function BuildInfos_all()
{
    return BuildInfos("aucun","TOUS");
}


function BuildInfosForUid($uid)
{
    require_once('configCAS/ldap.inc.php');
    $ds=ldap_connect(__LDAP_HOST);
    $infos=array("dn");
    $sr=ldap_search($ds,"ou=education,o=gouv,c=fr", "uid=".$uid);
    $attrs = ldap_get_entries($ds, $sr);

    $infos=Array();
    $infos['uid']=$uid;

    $infos['displayname']="Utilisateur $uid inconnu";
    $infos['profil']="--";

    $count= $attrs['count'];
    if ($count==0) return $infos;

    if (in_array("Eleves",$attrs[0]['objectclass'])) $infos['profil']="National_1";
    if (in_array("responsable",$attrs[0]['objectclass'])) $infos['profil']="National_2";
    if (in_array("ENTAuxEnseignant",$attrs[0]['objectclass'])) $infos['profil']="National_3";
    if (in_array("administratif",$attrs[0]['objectclass'])) $infos['profil']="National_6";

    $infos['profil']=GetGroupFromSDETProfil($infos['profil']);
    $infos['displayname']=$attrs[0]['displayname'][0];
    $infos['groupes']=GetGroupesForUser($uid);

    return $infos;

}

function GetGroupesForUser($uid){
    require_once('configCAS/ldap.inc.php');
    $ds=ldap_connect(__LDAP_HOST);
    $sr=ldap_search($ds, "ou=local,ou=groupes,".__LDAP_BASE_DN_EXTENSION.",".__LDAP_BASE_DN, "(&(objectclass=sambaGroupMapping)(objectclass=posixGroup)(memberUid=$uid))", array("cn"));
    $attrs = ldap_get_entries($ds, $sr);

    $tt = array();
    for ($n=0 ; $n < $attrs["count"] ; $n++){
        $tt[]=$attrs[$n]["cn"][0];
    }

    return implode(",", $tt);
}

$return_dict = Array();
$postit_flags=Array();

if($format=="widget") {
	$message="<div class='itemTitle'><a>Informations</a></div>";
	$message.="<div class='itemContent'><br>";
}
else {
	$message="<div class='note simple-sticker'>";
	$message.="<div class='note-title'>Informations</div>";
}

$s="";

if (!isset($_GET['uid']))
{
    $s.=BuildInfos_user();
    $s.=BuildInfos_groupes();
    $s.=BuildInfos_profils();
    $s.=BuildInfos_all();
}
else {
    $infos=BuildInfosForUid($_GET['uid']);
    $return_dict["infos"]=$infos;

    $s.=BuildInfos_user($infos['uid']);
    $s.=BuildInfos_groupes($infos['groupes']);
    $s.=BuildInfos_profils($infos['profil']);
    $s.=BuildInfos_all();
}


if (isset($_GET['test']))
{
    print_r($_SESSION["groupes"]);
}

if ($s == "" ) {
    $message="";
} else
{
    $message.=$s."</div>";
}

$return_dict["message"]=$message;

if($format=="widget")
	echo $return_dict["message"];
else
	echo str_replace("\/","/",json_encode($return_dict));

?>
