<?php
/************************************************
 *  Plugin Charte graphique                     *
 *  Propose une charte graphique à la connexion *
 *  d'un utilisateur                            *
 *  gaston.tjebbes@ac-dijon.fr                  *
 *  file: plugin_charte.php                     *
 *  version: 1.0                                *
 *  date: 29/03/2010                            *
 *  author : Gaston TJEBBES                     *
 ***********************************************/

/*
 * name: Plugin Charte
 * description: Plugin EOLE - Gestion d'une Charte d'utilisation du portail.
 * display:  style="font-weight:bolder;"
 * dependencies: no
 * author: Gaston TJEBBES
 * url: http://eole.orion.education.fr
 */

define("CHARTE_PLUGIN_NAME", "plugin CHARTE");

// Installation du plugin charte
register_hook("install_plugin_charte/plugin_charte", "plug_install");
register_hook("uninstall_plugin_charte/plugin_charte", "plug_uninstall");

// Import de la fonction d'affichage de l'onglet de charte utilisateur
register_hook("admininterface_header","plugcharte_admininterface_header",1,1);

// Téléchargement de la charte
register_admin_tab('charte_tab', "Charte informatique", 'charte_tab_display', 'jscharte_display();');


// Le plugin en lui-même
register_hook("userinterface_header","show_charte",1,1);

include_once('utils.php');

function plug_install()
{
    // Ajout de la table contenant les users ayant validés la charte
    $sql = "CREATE TABLE IF NOT EXISTS `validated_chartes` (
 `username` varchar(32) collate utf8_unicode_ci NOT NULL,
 PRIMARY KEY  (`username`)
)ENGINE=MyISAM DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci COMMENT='validated use-license';";
    global $DB;
    $DB->execute($sql);

    // Création du fichier charte.html s'il n'existe pas #5664
    $charte_path = '../upload/charte/charte.html';
	if(!file_exists($charte_path)){
		$fp = fopen($charte_path, 'w');
		fputs($fp, "Contenu du fichier charte.html");
		fclose($fp);
	}
}
function plug_uninstall()
{
    $sql = "DROP TABLE validated_chartes;";
    global $DB;
    $DB->execute($sql);
    //Suppression du fichier "charte" #5126 #4190
    disable();
}
function plugcharte_admininterface_header(){
    /* Importe une fonction javascript pour rajouter un resize sur la frame et éviter le fenêtrage */
    echo "<script type='text/javascript' src='../includes/plugins/plugin_charte/display_charte.js'></script>";
}

function charte_tab_display()
{
    logCharte("On appelle la fonction display");

    require_once('charte_tab.inc.php');
}
function show_charte()
{
    logCharte(" # Entrée du plugin charte ");
    if (isEnabled()){
    	$username = $_SESSION['username'];
        if (! hasValidated($username)){
    	    echo '<script type="text/javascript" src="../includes/plugins/plugin_charte/charte.js"></script>';
    	    echo "<script>";
    	    echo "$" . "p.plugin.hook.register('app.home.start', '" . "$" . "envole.charte.loadCharte()', '1');";
	    echo "$" . "p.plugin.hook.register('app.tabs.create.end', '" . "$" . "envole.charte.loadCharte()', '1');";
    	    echo "</script>";
            logCharte("La charte n'a pas encore été validée : " . $username);
        }else{
            logCharte("La charte a déjà été validée par " . $username);
        }
    }
}
?>
