<?php
# ************** LICENCE ****************
/*
	Copyright (c) PORTANEO.

	This file is part of COLLABORATION SUITE of POSH http://sourceforge.net/projects/posh/.

	POSH is free software: you can redistribute it and/or modify
	it under the terms of the GNU General Public License as published by
	the Free Software Foundation, either version 3 of the License, or
	(at your option) any later version

	POSH is distributed in the hope that it will be useful,
	but WITHOUT ANY WARRANTY; without even the implied warranty of
	MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
	GNU General Public License for more details.

	You should have received a copy of the GNU General Public License
	along with Posh.  If not, see <http://www.gnu.org/licenses/>.
*/
# ***************************************
# Get users search result
# !! be careful, this file must be saved under uft8 format, and display an e accentuated here : éàèù
# ***************************************
/**
    script : xmlnetwork_search
    
    search users by tags
    
    @params type            m (default), t (tags)
    
    @params search          string to find
    

**/
$search=(isset($_GET["search"]))?$_GET["search"]:exit();

$folder="";
$not_access=1;
$granted="I";
$pagename="portal/xmlmanager_search.php";
//includes
require_once('includes.php');
require_once('../db_layer/'.__DBTYPE.'/organigram.php');
require_once('../../../xml.inc.php');

$file=new xmlFile();

$file->header("results");

$p = isset($_GET["p"])?$_GET["p"]:0;

//search people with name or tag
$allkeywords = explode(" ", $search);
$arraywords = array();
$arraylikewords = array();
$searchbyemail = "";
foreach ($allkeywords as $word) {
	$searchbyemail .= " u.email LIKE '%".$word."%' OR ";
    array_push($arraywords, $DB->quote($word) );
    array_push($arraylikewords, " sk.label_simplified like '%$word%'");
}
$likeliste = ' OR ( ';
$likeliste .= implode(" OR ", $arraylikewords );
$likeliste .= ' ) ';    
$keyword = implode( "," , $arraywords);
	$searchbyemail .= " 0 ";

//get current user managers
$managersList = array();
$DB->getResults($xmlmanagersearch_getUserManagers,
                                        $DB->escape($_SESSION['user_id'])
                                );
while($row=$DB->fetch(0)) {
    $manager_id = $row['id'];
    array_push($managersList,$manager_id);
}
$DB->freeResults();

$DB->getResults($xmlnetworksearch_getUserByKeywordsAndEmail,
                $keyword,
                $likeliste,
                $DB->escape($_SESSION['user_id']),
				$searchbyemail,
				$DB->escape($_SESSION['user_id']),
                $DB->escape($p*10)
                );

                                
//if no result with tag, try the name
if ($DB->nbResults()==0) {
    $DB->freeResults();
    $DB->getResults($xmlorganigramnetworksearch_getUserByNamePart,
        $DB->quote("%".$search."%"),
        $DB->escape($_SESSION['user_id']),
        $DB->escape($p*10)
    );
}

if ($DB->nbResults()!=0) {
    while($row=$DB->fetch(0)) {
        if (!in_array ($row["id"], $managersList)) { 
            echo "<user>";
            echo "<id>".$row["id"]."</id>";
            echo "<longname><![CDATA[".$row["long_name"]."]]></longname>";
            echo "<username><![CDATA[".$row["username"]."]]></username>";
            echo "<email><![CDATA[".$row["email"]."]]></email>";
            echo "<description><![CDATA[".$row["description"]."]]></description>";
            echo "<stat>".$row["stat"]."</stat>";
            echo "<statdate>".$row["statdate"]."</statdate>";
            echo "<activity>".$row["activity"]."</activity>";
            echo "<lastconndate>".$row["lastconnect_date"]."</lastconndate>";
            echo "<dbdate>".$row["dbdate"]."</dbdate>";
            echo "<picture><![CDATA[".$row["picture"]."]]></picture>";
            echo "</user>";
        }
    }
    $DB->freeResults();
}

$file->footer("results");

$DB->close();
?>