<?php

session_name("xdesktop");
session_start();

$NO_USERDATA=true;

include_once('inc.php');


require 'themes/'.$theme.'/datagrid/class.eyemysqladap.inc.php';
require 'themes/'.$theme.'/datagrid/class.eyedatagrid.inc.php';

if (!isAdminMessages())
{
    die("Vous n'avez pas les droits pour accéder à cette page");
    return;
}

if (isset($_GET["id"]))
{
    $sql = "SELECT * FROM xdesktop_postit WHERE id = %d";
    $DB->getResults($sql, $_GET["id"]);
    $row = $DB->fetch(0);

    $row["flag"]=strtolower($row["flag"]);
    $row["type"]=strtolower($row["type"]);
    $row["valeur"]=strtolower($row["valeur"]);
    $row["nouveau"]=isset($_GET["nouveau"])?$_GET["nouveau"]:"false";

    echo json_encode($row);
    return;

}


// Load the database adapter
$db = new EyeMySQLAdap(__SERVER,__LOGIN,__PASS,__DB);

// Load the datagrid class
$x = new EyeDataGrid($db,$theme."/datagrid/images/");
$x->setQuery("*", "xdesktop_postit");
$x->addRowSelect("show(%id%,false)");
$x->setResultsPerPage(10000);

function formatMessage($message)
{
    if ( substr(trim($message),0,1)== "<" )
        return "<div class='simple-sticker-table'>$message</div>";
    else
        return (htmlentities($message));
}
$x->setColumnType('message', EyeDataGrid::TYPE_FUNCTION, 'formatMessage', '%message%');


function formatCachet($cachet)
{
    return "<div class='cell_$cachet'></div>";
}
$x->setColumnType('flag', EyeDataGrid::TYPE_FUNCTION, 'formatCachet', '%flag%');

function formatValeur($valeur)
{
    if (substr($valeur,0,1)==",")
        $valeur=substr($valeur,1,strlen($valeur)-2);

    return $valeur;
}
$x->setColumnType('valeur', EyeDataGrid::TYPE_FUNCTION, 'formatValeur', '%valeur%');




$x->hideColumn("id");
$x->hideColumn("actif");
$x->hideColumn("start");
$x->hideColumn("end");
$x->hideColumn("contexte");
$x->hideColumn("accuse");
$x->hideColumn("extra1");
$x->hideColumn("extra2");
$x->hideColumn("extra3");
$x->hideColumn("extra4");

$x->hideFooter();

$x->setColumnHeader('type', 'Filtre');
$x->setColumnHeader('valeur', 'Valeur');
$x->setColumnHeader('flag', 'Cachet');
$x->setColumnHeader('message', 'Message');
$x->setColumnHeader('start', 'Début');
$x->setColumnHeader('end', 'Fin');


if (isset($_POST["new"]))
{
    $sql="INSERT INTO xdesktop_postit (message) VALUES ('Un nouveau message');";
    $DB->execute($sql);

    $arr=Array();
    $arr["status"]="OK";
    $arr["id"]=$DB->getId();

    ob_start();
    $x->printTable();
    $contents = ob_get_contents();
    ob_end_clean();

    $arr["message"]=$contents;
    echo json_encode($arr);
    return ;

}

if (isset($_POST["delete"]))
{

    $id=PostVar("id");
    $sql="DELETE FROM  xdesktop_postit  WHERE  id=$id";
    $DB->execute($sql);

    $arr=Array();
    $arr["status"]="OK";

    ob_start();
    $x->printTable();
    $contents = ob_get_contents();
    ob_end_clean();

    $arr["message"]=$contents;
    echo json_encode($arr);
    return ;

}

if (isset($_POST["save"]))
{

    $id=PostVar("id");
    $type=PostVar("type");
    $valeur=PostVar("valeur");
    $flag=PostVar("flag");
    $message=addslashes(PostVar("message"));

    $sql="UPDATE xdesktop_postit SET type='$type',valeur='$valeur',
                     flag='$flag',
                     message='$message' WHERE id=$id";
    $DB->execute($sql);

    $arr=Array();
    $arr["status"]="OK";

    ob_start();
    $x->printTable();
    $contents = ob_get_contents();
    ob_end_clean();

    $arr["message"]=$contents;
    echo json_encode($arr);
    return ;



}

function GetAllGroupes(){
    require_once('configCAS/ldap.inc.php');
    $ds=ldap_connect(__LDAP_HOST);
    $gr_types = array('Classe', 'Option', 'Groupe','Matiere', 'Equipe');
    $chaine="";
    foreach ($gr_types as $type) {
        $lds = ldap_search($ds, "ou=local,ou=groupes,".__LDAP_BASE_DN_EXTENSION.",".__LDAP_BASE_DN, "(&(objectclass=sambaGroupMapping)(objectclass=posixGroup)(type=$type))", array("cn"));
        $ldge = ldap_get_entries ($ds, $lds);

        $chaine.="<OPTGROUP LABEL='$type'>";
        for ($n=0 ; $n < $ldge["count"] ; $n++){
            $chaine.="<OPTION value='".$ldge[$n]["cn"][0]."'>".$ldge[$n]["cn"][0]."</OPTION>";
        }
        $chaine.="</OPTGROUP>";
    }
    echo $chaine;
}

?>
<html>
<head>
<title>Gestion des messages</title>
<META HTTP-EQUIV="Content-Type" CONTENT="text/html; charset=utf-8" />

<link rel="stylesheet" type="text/css" href="https://fonts.googleapis.com/css?family=Rock+Salt">
<?php include_once("/var/www/html/posh/includes/plugins/plugin_xdesktop/inc_js.php"); ?>
<script type="text/javascript" src="<?php echo(__LOCALPATH); ?>includes/config.js"></script>
<script type='text/javascript' src='<?php echo(__LOCALPATH); ?>tools/fckeditor/fckeditor.js'></script>

<link type="text/css" rel="stylesheet" href="themes/<?php echo $theme;?>/postit.css?qq=<?php echo __rand;?>" />
<link href="themes/<?php echo $theme;?>/datagrid/table.css?qq=<?php echo __rand;?>" rel="stylesheet" type="text/css">

<script type="text/javascript">

var bNewRecord=false;

function Reload(jsvar, vars)
{
    //alert(jsvar.message);
    if (jsvar.status="OK")
    {
        $p.print("content",jsvar.message);
        BuildInfos();
    }
}

function Supprimer()
{
    id=$("id").get("value");
    $p.ajax.call( '<?php echo(__LOCALPATH); ?>includes/plugins/plugin_xdesktop/postit_liste.php',
                {'type':'load',
                'source':'json',
                'method':'POST',
                'variables':"delete=1&id="+id,
                'callback':{'function':Reload},'escape':Echec
                });
}

function Modifier()
{
    xhide("record");
    xhide("marker");

    //mesg=$("message").get("value");
    var oEditor = FCKeditorAPI.GetInstance('message') ;
    mesg=encodeURIComponent(oEditor.GetHTML());


    flag=$("flag").get("value");
    type=$("type").get("value");
    valeur=$("valeur")!=null?$("valeur").get("value"):"TOUS";
    if (type=="groupe")
    {
        valeur="";
        for (i=0;i<$('valeur').length;i++)
        {
            var oSelect=$('valeur').options[i];
            valeur+=","+oSelect.value;
        }

        valeur+=","
    }


    id=$("id").get("value");

    $p.ajax.call( '<?php echo(__LOCALPATH); ?>includes/plugins/plugin_xdesktop/postit_liste.php',
                {'type':'load',
                'source':'json',
                'method':'POST',
                'variables':"save=1&id="+id+"&message="+mesg+"&type="+type+"&flag="+flag+"&valeur="+valeur,
                'callback':{'function':Reload},'escape':Echec
                });

}


function Edit(jsvar, vars)
{

    //$("message").set("value",jsvar.message);
    var oEditor = FCKeditorAPI.GetInstance('message') ;
    oEditor.SetHTML(jsvar.message);

    $("flag").set("value",jsvar.flag);
    $("type").set("value",jsvar.type);
    $("id").set("value",jsvar.id);
    $("nouveau").set("value",jsvar.nouveau);

    bNouveau=eval(jsvar.nouveau);
    if ( bNouveau )
    {
        xhide("btnSupprimer");
        $("btnModifier").set("value","Ajouter");
    } else
    {
        $("btnSupprimer").style.display = "inline";
        $("btnModifier").set("value","Modifier");
    }

    RefreshContentValeur();

    if ($("valeur")!=null)
         $("valeur").set("value",jsvar.valeur);

    if (jsvar.type=="groupe")
    {
        var s=jsvar.valeur+"";
        //if (jsvar.valeur.indexOf(",")==-1) s=","+jsvar.valeur+","; // Compatibilité avec le 1er format
        var arr=s.split(",");
        for (i=0;i<arr.length;i++)
        {
            if (arr[i]=="") continue;
            var opt = new Option(arr[i], arr[i]);
            $('valeur').appendChild(opt);
        }

        /*for (i=0;i<$('valeur').length;i++)
        {
            if (s.indexOf(","+$('valeur').options[i].value.toLowerCase()+",")!=-1)
                $('valeur').options[i].setProperty('selected', 'selected');
        }*/
    }


    xshow("record");
    xshow("marker");


    var top=$('row_'+jsvar.id).getPosition().y-Math.round($('record').getSize().y/2);
    var left=$('tbl').getPosition().x+$('tbl').getSize().x+10-50;

    var pageWidth = Window.getWidth()-30;
    if (left+$('record').getSize().x > pageWidth )
    {
        left=pageWidth-($('record').getSize().x);
    }


    if (top<20) top=40;

    $('record').style.top=top+"px";
    $('record').style.left=left+"px";

    var color=$('row_'+jsvar.id).getStyle("background-color");
    //$('marker').setStyle("background-color",color);
    //$('record').setStyle("background-color",color);

    $('marker').style.top=($('row_'+jsvar.id).getPosition().y)+"px";
    //$('marker').style.left=(left-15)+"px";

    $('marker').style.left=(left-$('marker').getSize().x-2)+"px";

    $('marker').style.height=($('row_'+jsvar.id).getSize().y)+"px";



}

function Echec()
{
}

function OnRecordAdded(jsvar, vars)
{
    bNewRecord=true;
    $p.print("content",jsvar.message);
    show(jsvar.id,true);

}


function show(id,bNew)
{
    //xhide("example");

    $p.ajax.call( '<?php echo(__LOCALPATH); ?>includes/plugins/plugin_xdesktop/postit_liste.php?id='+id+'&nouveau='+bNew,
                {'type':'load',
                'source':'json',
                'method':'get',
                'variables':'',
                'callback':{
                    'function':Edit
                },
                    'escape':Echec
                });



}

function BuildInfosEchec()
{

}

function BuildInfosReponse(jsvar, vars)
{

    $p.print('postit_example', jsvar.message);

    var sInfos="";

    sInfos+="<b><u>"+jsvar.infos.displayname+"</u></b>  ";
    sInfos+="&nbsp;&nbsp;&nbsp;["+jsvar.infos.profil+"]<br>";
    sInfos+="<u><b>Membre des groupes:</b></u><small> "+jsvar.infos.groupes+"</small><br>";

    $p.print('profil_infos', sInfos);

    //alert(jsvar.infos.profil);
    xshow("example");
}

function Annuler()
{
    var nouveau=eval($("nouveau").get("value"));
    if ( nouveau )
    {
        Supprimer();
    } else
    {
        BuildInfos();
    }
}


function BuildInfos()
{

        xhide("record");
        xhide("marker");


        var sInfos="";

        $p.ajax.call( '<?php echo(__LOCALPATH); ?>includes/plugins/plugin_xdesktop/postit_message.php?uid='+$('uidtest').get("value"),
                {'type':'load',
                'source':'json',
                'method':'get',
                'variables':'',
                'callback':{
                    'function':BuildInfosReponse
                },
                    'escape':BuildInfosEchec
                });


}


function NewRecord()
{
    $p.ajax.call( '<?php echo(__LOCALPATH); ?>includes/plugins/plugin_xdesktop/postit_liste.php',
                {'type':'load',
                'source':'json',
                'method':'POST',
                'variables':"new=1",
                'callback':{'function':OnRecordAdded},'escape':Echec
                });

}

function testeruid()
{
    BuildInfos();
}

function AddGroupes()
{
    for (i=0;i<$('valeur_available').length;i++)
    {
        var oSelect=$('valeur_available').options[i];
        if ( oSelect.selected )
        {
            var b=true;
            for (z=0;z<$('valeur').length;z++)
            {
                if ( $('valeur').options[z].value.toLowerCase() == oSelect.value.toLowerCase() )  b=false;
            }
            if (!b) continue;
            var opt = new Option(oSelect.value, oSelect.value);
            $('valeur').appendChild(opt);
        }
    }
}

function RemoveGroupes()
{
    var arr=new Array();

    for (i=0;i<$('valeur').length;i++)
    {
        var oSelect=$('valeur').options[i];
        if ( oSelect.selected )
        {
            arr.push(oSelect);
        }
    }

    for (i=0;i<arr.length;i++)
    {
        $('valeur').removeChild(arr[i]);
    }
}

function RefreshContentValeur()
{
    var content="";
    var type=$("type").get("value");

    if (type=="profil")
    {
        content='<select id="valeur">'
            +'<option value="professeurs">Professeurs</option>'
            +'<option value="eleves">Eleves</option>'
            +'<option value="responsables">Responsables</option>'
            /*+'<option value="direction">Direction</option>'
            +'<option value="viescolaire">Vie Scolaire</option>'*/
            +'<option value="administratifs">Administratifs</option>'
        +'</select>';
    }

    else if (type=="aucun")
    {
        content='';
    }


    else if (type=="groupe")
    {
        content='<table><tr>';
        content+='<td width="50%"><small>Groupes Disponibles<br></small>';
        content+='<select id="valeur_available" multiple="multiple" size="10" style="width:150;">'+
        "<?php
            GetAllGroupes();
        ?>"
        +'</select>';
        content+='</td>';
        content+='<td width="30px">';
        content+='<div onclick="AddGroupes()" style="cursor:pointer;"> >> </div>';
        content+='<br>';
        content+='<div onclick="RemoveGroupes()" style="cursor:pointer;"> << </div>';

        content+='</td>';
        content+='<td width="50%"><small>Groupes Sélectionnés<br></small>';
        content+='<select id="valeur" multiple="multiple" size="10" style="width:150;">';
        content+='</select>';
        content+='</td>';
        content+='</tr></table>';

    }

    else if (type=="uid")
    {
        content='<input type="text"   id="valeur" value="">';
    }



    $p.print('content_valeur', content);

}

</script>

</head>
<body>

<table width="90%">
<tr><td>
    <h1>Gestion des messages</h1>
</td>
<td  align="right">
    <?php //fixes: #8468, si on arrive via mxdesktop (/xdesktop) le lien proposé pour le retour est /xdesktop ?>
    <?php if (!isset($_GET["mxdesktop"])) { ?>
    	<a href='<?php echo(__LOCALPATH); ?>includes/plugins/plugin_xdesktop/index.php'>[ Revenir à la liste des applications ] </a>
    <?php } else { ?>
	 <a href='/xdesktop'>[ Revenir à la liste des applications ] </a>
    <?php } ?>
</td>
</tr>
</table>

<a onClick="NewRecord()" href="#">+ Ajouter un message</a>

<table>
<tr>
<td VALIGN="TOP" width="750px"  id="content" style="overflow: auto;vetical-align:top;">

<?php $x->printTable(); ?>

</td>
<td VALIGN="TOP">

<div id="example" class="example">

<div class="uidtester">
Tester avec l'uid : <input type="text" onKeyPress="if (event.keyCode == 13) testeruid()"  id="uidtest" value="<?php echo $_SESSION['username']; ?>">
</div>

<div id="profil_infos" name="profil_infos" class="profil_infos"> </div>

<div id="postit_example" name="postit_example" class="informations"><br></div>

</div>



</td>
</tr>
<tr>


</tr>

</table>


<div id="record"  class="record" >
<table>

<tr>
   <input type="hidden" id="id">
   <input type="hidden" id="nouveau">
   <td width="80px">Filtre</td>
   <td>
    <select id="type" onchange="RefreshContentValeur();">
        <option value="aucun">aucun</option>
        <option value="uid">uid</option>
        <option value="profil">Profil</option>
        <option value="groupe">Groupe</option>
    </select>
    </td>
</tr>

<tr>
   <td width="80px">Valeur</td>
   <td id="content_valeur">

    </td>
</tr>

<tr>
  <td>Cachet</td>
  <td>
    <select id="flag">
        <option value="aucun">Aucun</option>
        <option value="important">Important</option>
        <option value="rappel">Rappel</option>
        <option value="recycle">Recycle</option>
        <option value="attention">Attention</option>
        <option value="mail">Mail</option>
    </select>
  </td>

</tr>
   <td>Message</td>
    <td><textarea id="message"></textarea>

    </td>
</tr>
<tr style="text-align:right;">

    <td colspan=2>
        <input type="button" value="Annuler"   id="btnAnnuler"      onClick="Annuler()">
        <input type="button" value="Supprimer" id="btnSupprimer"    onClick="Supprimer()">
        <input type="button" value="Modifier"  id="btnModifier"     onClick="Modifier()">
    </td>



</tr>
</table>
</div>
<div id="marker"  class="marker" ></div>

<script type="text/javascript">
    xhide("record");
    xhide("marker");
    BuildInfos();


    var oFCKeditor=new FCKeditor("message");
    var sBasePath="<?php echo(__LOCALPATH); ?>";
    oFCKeditor.BasePath=sBasePath+'tools/fckeditor/';
    oFCKeditor.Config['CustomConfigurationsPath']='<?php echo(__LOCALPATH); ?>includes/plugins/plugin_xdesktop/postit_fckconfig.js';
    oFCKeditor.Config['SkinPath'] = '<?php echo(__LOCALPATH); ?>includes/plugins/plugin_xdesktop/themes/'+theme+'/datagrid/famfam/' ;
    oFCKeditor.width= "400";
    oFCKeditor.ToolbarSet =  "postit";
        oFCKeditor.ReplaceTextarea();



</script>

</body>
</html>
