<?php
# ************** LICENCE ****************
/*
	Copyright (c) PORTANEO.

	This file is part of POSH (Portaneo Open Source Homepage) http://sourceforge.net/projects/posh/.

	POSH is free software: you can redistribute it and/or modify
	it under the terms of the GNU General Public License as published by
	the Free Software Foundation, either version 3 of the License, or
	(at your option) any later version

	POSH is distributed in the hope that it will be useful,
	but WITHOUT ANY WARRANTY; without even the implied warranty of
	MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
	GNU General Public License for more details.

	You should have received a copy of the GNU General Public License
	along with Posh.  If not, see <http://www.gnu.org/licenses/>.
*/
# ***************************************
# POSH Configuration - set theme
#
# !! be careful, this file must be saved under uft8 format, and display an e accentuated here : é
# ***************************************

require_once('../l10n/'.__LANG.'/admin.lang.php');
require_once('../includes/file.inc.php');
require_once('../includes/xml.inc.php');

global $query;
global $fieldVal;
global $types;
global $queryfilter;
global $group_id;

$query = "UPDATE users ";
$querySet = " SET ";
$queryfilter = " WHERE 1=1 ";

//Available types
$types = Array("A","I","J");
//Available filters                         
$queryFilters = Array( 'group', 'typ', 'subscription', 'lastconnection', 'lang' );      

$updateableFields = Array( 
                            'username' => 'checkUsername();',
                            'long_name' => 'checkLongname();',
                            'typ' => 'checkType();',
                            'expiration_date' => 'checkExpiration_date();',
                            'lang' => 'checkLang();'
                         );
                    
$field    = ( isset( $_GET["update"] ) )               ?  $_GET["update"]            :   exit("Parametre update non renseigné");
$fieldVal = ( isset( $_GET["updatevalue"] ) )          ?  $_GET["updatevalue"]       :   exit("Paramètre updatevalue non renseigné");

//First control (field to update) : error this field is not recognize as an updateable fields, try username,long_name,typ,expiration_date,lang. exit() if not recognized
controlField($field,$updateableFields);

//Second control (field to update value) : Verify that the value is correct for the field to update. exit() if one value is not correct
eval($updateableFields[$field]);

$group =          ( isset( $_GET["group"] ) )          ?  $_GET["group"]            :   '';
$type =           ( isset( $_GET["typ"] ) )            ?  $_GET["typ"]              :   '';
$subscription =   ( isset( $_GET["subscription"] ) )   ?  $_GET["subscription"]     :   '';
$lastconnection = ( isset( $_GET["lastconnection"] ) ) ?  $_GET["lastconnection"]   :   '';
$lang =           ( isset( $_GET["lang"] ) )           ?  $_GET["lang"]             :   '';

//Thrid control (filters control): check that there is at least one filter. If not, exit();
if ($group.$type.$subscription.$lastconnection.$lang == '') {
    $file=new xmlFile();
    $file->header();
    echo "<err>".lg("msgNoFilterSpecified")."</err>";
    $file->status(0);
    $file->footer();
    exit();
}

if ( $group!='' ) { 
    checkGroupFilter($group);
    $query .= " ,users_group_map ";
    $queryfilter .= " AND users_group_map.user_id = users.id AND users_group_map.group_id = ".escape($group_id);
}
if ( $type!='' )  { 
    checkTypeFilter($type); 
    $queryfilter .= " AND typ = ".quote($type); 
}
if ( $subscription!='' )  { 
    checkSubscriptionFilter($subscription); 
    $queryfilter .= " AND creation_date = ".quote($subscription);
}
if ( $lastconnection!='' ) { 
    checkLastconnectionFilter($lastconnection); 
    $queryfilter .= " AND lastconnect_date LIKE '%$lastconnection%'";
}
if ( $lang!='' )           { 
    checkLangFilter($lang); 
    $queryfilter .= " AND lang = ".quote($lang);
}


$file=new xmlFile();
$file->header();
$fullquery = $query.$querySet.$queryfilter;
$DB->execute($fullquery);
if ($DB->nbAffected()==0)   {
    echo "<err>".lg("msgUpdateFailed")."</err>";
    $file->status(0);
}
else {
    echo "<succes>".lg("modificationApplied")."</succes>";
    $file->status(1);
}
$file->footer();


function checkUsername() {
    global $fieldVal;
    global $querySet;
    if ( strlen($fieldVal)>64 ) {
        $file=new xmlFile();
        $file->header();
        echo "<err>".lg("msgFieldTooLong","username",64)."</err>";
        $file->status(0);
        $file->footer();
        exit();
    }
    $querySet .= "username = ".quote($fieldVal);
}

function checkLongname() {
    global $fieldVal;
    global $querySet;
    if ( strlen($fieldVal)>100 ) {
        $file=new xmlFile();
        $file->header();
        echo "<err>".lg("msgFieldTooLong","long_name",100)."</err>";
        $file->status(0);
        $file->footer();
        exit();
    }
    $querySet .= "long_name = ".quote($fieldVal);
}

function checkType() {
    global $fieldVal;
    global $querySet;
    checkTypeFilter($fieldVal);
    $querySet .= "typ = ".quote($fieldVal);
}

function checkExpiration_date() {
    global $fieldVal;   
    global $querySet;
    if (!preg_match('#\d{4}[\-]\b\d{2}[/-]\d{2}\b#', $fieldVal) ) {
        $file=new xmlFile();
        $file->header();
        echo "<err>".lg("msgErrDateFormat","expiration_date")."</err>";
        $file->status(0);
        $file->footer();
        exit();    
    }
    $year = substr($fieldVal,0,4);
    $month = substr($fieldVal,5,2);
    $day = substr($fieldVal,6,2);
    if ($day > 31 || $month>12 || $year<=1901 || $year>=2038) {
        $file=new xmlFile();
        $file->header();
        echo "<err>".lg("msgErrDateFormat","expiration_date")."</err>";
        $file->status(0);
        $file->footer();
        exit(); 
    }
    $fieldVal = mktime(0,0,0,$month,$day,$year);
    $querySet .= "expiration_date = ".escape($fieldVal);
}

function checkLang() {   
    global $fieldVal;
    global $querySet;
    checkLangFilter($fieldVal);
    $querySet .= "lang = ".quote($fieldVal);
}








function checkGroupFilter($group) {
    global $DB;
    global $group_id;
    $DB->getResults("SELECT id FROM users_group WHERE name = ".$DB->quote($group) );
    if ($DB->nbResults()==0) {
        $file=new xmlFile();
        $file->header();
        echo "<err>".lg("nogroupid")."</err>";
        $file->status(0);
        $file->footer();
        exit();    
    }
    else {
        $row = $DB->fetch(0);
        $group_id = $row['id'];
        $DB->freeResults();
    }
}

function checkTypeFilter ($type) {
    global $types;
    global $queryfilter;
    //Put the value in upper case
    $type = strtoupper($type);
    //A one character value
    if ( strlen($type)!=1 ) {
        $file=new xmlFile();
        $file->header();
        echo "<err>".lg("msgJustOneChar")."</err>";
        $file->status(0);
        $file->footer();
        exit();
    }
    //Is type format ok
    elseif ( !in_array($type,$types) ) {
        $file=new xmlFile();
        $file->header();
        echo "<err>".lg("msgErrTypeFormat")."</err>";
        $file->status(0);
        $file->footer();
        exit();
    }    
}

function checkSubscriptionFilter($subscription) {
    if (!preg_match('#\d{4}[\-]\b\d{2}[/-]\d{2}\b#', $subscription) ) {
        $file=new xmlFile();
        $file->header();
        echo "<err>".lg("msgErrDateFormat","subscription")."</err>";
        $file->status(0);
        $file->footer();
        exit();    
    }
}

function checkLastconnectionFilter($lastconnection) {
    if (!preg_match('#\d{4}[\-]\b\d{2}[/-]\d{2}\b#', $lastconnection) ) {
        $file=new xmlFile();
        $file->header();
        echo "<err>".lg("msgErrDateFormat","lastconnection")."</err>";
        $file->status(0);
        $file->footer();
        exit();    
    }    
}

function checkLangFilter($lang) {
    $lang = strtolower($lang);
    if ( strlen($lang)!=2 ) {
        $file=new xmlFile();
        $file->header();
        echo "<err>".lg("msgLangAtLeast2Char")."</err>";
        $file->status(0);
        $file->footer();
        exit();
    }
}

function controlField($field,$updateableFields ) {
    if ( !isset($updateableFields[$field]) ) { 
        $file=new xmlFile();
        $file->header();
        echo "<err>".lg("msgErrSpecifiedField")."</err>";
        $file->status(0);
        $file->footer();
        exit();
    }
}







function escape($str,$force=false) {
    // If we need to escape the string
    if (get_magic_quotes_gpc() && !$force) {
        $str = stripslashes($str);
    }
    $str = mysql_real_escape_string($str);
    return $str;
}
	
function quote($str,$force=false) {
		return "'".escape($str,$force)."'";
	}


?>