<?php
# ************** LICENCE ****************
/*
	Copyright (c) PORTANEO.

	This file is part of POSH (Portaneo Open Source Homepage) http://sourceforge.net/projects/posh/.

	POSH is free software: you can redistribute it and/or modify
	it under the terms of the GNU General Public License as published by
	the Free Software Foundation, either version 3 of the License, or
	(at your option) any later version

	POSH is distributed in the hope that it will be useful,
	but WITHOUT ANY WARRANTY; without even the implied warranty of
	MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
	GNU General Public License for more details.

	You should have received a copy of the GNU General Public License
	along with Posh.  If not, see <http://www.gnu.org/licenses/>.
*/
/***************************************
* \brief xml_getuser_infos.php
* 
* POSH user  management - get user datas from email
*
* !! be careful, this file must be saved under uft8 format, and display an e accentuated here : é
**/

require_once('../includes/xml.inc.php');

$file=new xmlFile();
if (!isset($_REQUEST['username'])) {
    echo "<error><code>1</code><label>emailMissing</label></error>";
    exit;
}
$username = $_REQUEST['username'];

$DB->getResults($users_getuserInfoFromUsername,
                        $DB->quote($username)
                );
                
$row = $DB->fetch(0);
if ( isset( $row['id'] )) {
    $file->header("user");
    $id = $row['id'];
    $long_name = $row['long_name'];
    $type = $row['typ'];
    $userlang = $row['lang'];
    
    echo "<userid>$id</userid>
<long_name>$long_name</long_name>
<typ>$type</typ>    
<lang>$userlang</lang>    
";
    $DB->freeResults();
    if (isset($_REQUEST['getgroup'])) {
        $DB->getResults($users_getUserGroup,
                            $DB->escape($id)
                        );
        if ( $DB->nbResults()>0 ) {
            echo "<groups>\n";
            while ($row = $DB->fetch(0))
            {
                $groupid    = $row['id']; 
                $groupename = $row['name'];
                echo "<group><id>$groupid</id><name>$groupename</name></group>";
            }
            echo "</groups>\n";
        }
        $DB->freeResults();
    }    
    
    $file->footer();
} else {
    echo "<error><code>1</code><label>nouser</label></error>";
    exit;
}
$DB->freeResults();

?>