<?php
# ************** LICENCE ****************
/*
	Copyright (c) PORTANEO.

	This file is part of POSH (Portaneo Open Source Homepage) http://sourceforge.net/projects/posh/.

	POSH is free software: you can redistribute it and/or modify
	it under the terms of the GNU General Public License as published by
	the Free Software Foundation, either version 3 of the License, or
	(at your option) any later version

	POSH is distributed in the hope that it will be useful,
	but WITHOUT ANY WARRANTY; without even the implied warranty of
	MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
	GNU General Public License for more details.

	You should have received a copy of the GNU General Public License
	along with Posh.  If not, see <http://www.gnu.org/licenses/>.
*/
/**
* \brief POSH widget management - get widgets list for export to a distant posh
*
* !! be careful, this file must be saved under uft8 format, and display an e accentuated here : é
**/

require_once("includes_api.php");
//MR DESACTIVE authentification sur __KEY
//require_once("authentication.php");
//la recrée avec __COW_KEY
$adminkey = isset($_REQUEST['adminkey']) ? $_REQUEST['adminkey'] : exit('You are not authorized to access this file');

require_once('../includes/config.inc.php');
if (isset($adminkey) && $adminkey != __COW_KEY) {
    require_once('../includes/xml.inc.php');
    $file=new xmlFile();
    $file->header("loginfailed");
    $file->status(0);
    $file->footer();
    exit;    
}
//RM----------------------------------------------------------------------
require_once('../includes/xml.inc.php');

global $DB1;
global $DB2;
$DB1 = new connection(__SERVER,__LOGIN,__PASS,__DB);
$DB2 = new connection(__SERVER,__LOGIN,__PASS,__DB);

$file = new xmlFile();

echo "<widgets>";

$sql = "
    SELECT  id, url, defvar, name, description,
            typ, status, format, height, minwidth, 
            sizable, website, editor_id, nbvariables, creation_date,
            lastmodif_date, lang, views, icon, l10n, hidden
    FROM    dir_item
    WHERE   typ = 'U' AND format = 'I'
";
$DB1->getResults($sql);

while ($row = $DB1->fetch(0)) {
    echo "
<widget>
<id>" . $row['id'] . "</id>
<url><![CDATA[" . $row['url'] . "]]></url>
<defvar><![CDATA[" . $row['defvar'] . "]]></defvar>
<name><![CDATA[" . $row['name'] . "]]></name>
<description><![CDATA[" . $row['description'] . "]]></description>
<typ>" . $row['typ'] . "</typ>
<status>" . $row['status'] . "</status>
<format>" . $row['format'] . "</format>
<height>" . $row['height'] . "</height>
<minwidth>" . $row['minwidth'] . "</minwidth>
<sizable>" . $row['sizable'] . "</sizable>
<website>" . $row['website'] . "</website>
<editor_id>" . $row['editor_id'] . "</editor_id>
<nbvariables>" . $row['nbvariables'] . "</nbvariables>
<creation_date>" . $row['creation_date'] . "</creation_date>
<lastmodif_date>" . $row['lastmodif_date'] . "</lastmodif_date>
<lang>" . $row['lang'] . "</lang>
<views><![CDATA[" . $row['views'] . "]]></views>
<icon>" . $row['icon'] . "</icon>
<l10n>" . $row['l10n'] . "</l10n>
<hidden>" . $row['hidden'] . "</hidden>
</widget>";
}

$sql = "
    SELECT  item_id, category_id, first
    FROM    dir_cat_item, dir_item
    WHERE   item_id=id AND typ='U' AND format='I'
";
$DB1->getResults($sql);

while ($row = $DB1->fetch(0)){
    echo "<dircat>
<item_id>" . $row['item_id'] . "</item_id>
<category_id>" . $row['category_id'] . "</category_id>
<first>" . $row['first'] . "</first>
</dircat>";
}

$sql = "
    SELECT  id, name, parent_id, typ, path,
            quantity, updated, lang, secured
    FROM    dir_category";
    //WHERE   id >= 10000

$DB1->getResults($sql);
while ($row = $DB1->fetch(0)) {
    echo "
<category>
<id>" . $row['id'] . "</id>
<name><![CDATA[" . $row['name'] . "]]></name>
<parent_id>" . $row['parent_id'] . "</parent_id>
<typ>" . $row['typ'] . "</typ>
<path><![CDATA[" . $row['path'] . "]]></path>
<quantity>" . $row['quantity'] . "</quantity>
<updated>" . $row['updated'] . "</updated>
<lang>" . $row['lang'] . "</lang>
<secured>" . $row['secured'] . "</secured>
</category>";
}

echo "</widgets>";

?>
