<?php
# ************** LICENCE ****************
/*
	Copyright (c) PORTANEO.

	This file is part of POSH (Portaneo Open Source Homepage) http://sourceforge.net/projects/posh/.

	POSH is free software: you can redistribute it and/or modify
	it under the terms of the GNU General Public License as published by
	the Free Software Foundation, either version 3 of the License, or
	(at your option) any later version

	POSH is distributed in the hope that it will be useful,
	but WITHOUT ANY WARRANTY; without even the implied warranty of
	MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
	GNU General Public License for more details.

	You should have received a copy of the GNU General Public License
	along with Posh.  If not, see <http://www.gnu.org/licenses/>.
*/
# ***************************************
# Favorites module PHP scripts
#
# !! be careful, this file must be saved under uft8 format, and display an e accentuated here : é
# ***************************************

header("content-type: application/xml");
$folder="";
$not_access=0;
$pagename="modules/wid_calendar.php";
$disconnected_mode_allowed='yes';
$granted="I,N";
//includes

require_once('includes.php');
require_once('../includes/xml.inc.php');

$file=new xmlFile();

$file->header("channel");

$calid = isset($_POST["modid"]) ? $_POST["modid"] : 0;
$act=isset($_POST["act"])?$_POST["act"]:"";
$acceptwriteshare = isset($_POST["acceptwriteshare"])?$_POST["acceptwriteshare"]:"";
$shareditemkey = isset($_POST["shareditemkey"])?$_POST["shareditemkey"]:"";

if ($act=="sup")
{
	$userid_owner = $_SESSION['user_id'];
	if ($acceptwriteshare && $acceptwriteshare == 'yes') {
	        $DB->getResults($widCalendar_getinfo, $DB->escape($calid) );
	        $oldjsonacl = '';
	        if ($DB->nbResults()>0) {
				while ($row = $DB->fetch(0)) {
	                $userid_owner = $row['user_id'];
	            }
	            $DB->freeResults();
	        }
	}
	$DB->execute($widcal_removeEvent,$DB->escape($_POST["calid"]),$DB->escape($userid_owner));
	if ($DB->nbAffected()==0)
	{
        $id=$_POST["modid"];
		$DB->execute($widcal_createNewId,$DB->escape($_SESSION['user_id']));
		$oldid=$calid;
		$calid=$DB->getId();
		$DB->execute($widcal_createNewEventUser,$calid,$DB->escape($oldid),$DB->escape($_POST["calid"]),$DB->escape($_SESSION['user_id']));
		echo '<ret>'.$calid.'_'.($DB->getId()).'</ret>';
	}
	echo '<sharedkey>'.$shareditemkey.'</sharedkey>';
    echo '<calid>'.$calid.'</calid>';
}
if ($act=="add")
{
	$id=$calid;
	if ($id==0)
	{
		$sharedMD5 = md5(uniqid(rand(), true));
		$DB->execute($widcal_newModuleId2,$DB->escape($_SESSION['user_id']),$DB->quote($sharedMD5));
		$id=$DB->getId();
		$DB->execute($widcal_newModuleEvent,
                    $DB->escape($id),
                    $DB->noHTML($_POST["t"]),
                    $DB->noHTML($_POST["c"]),
                    $DB->noHTML($_POST["d"]),
                    $DB->noHTML($_POST["h"]),
                    $DB->noHTML($_POST["end"])
                    );
	}
	else
	{
		$userid_owner = $_SESSION['user_id'];
		$sharedMD5 = md5(uniqid(rand(), true));

		if ($acceptwriteshare && $acceptwriteshare == 'yes') {
	        $DB->getResults($widCalendar_getinfo, $DB->escape($calid) );
	        $oldjsonacl = '';
	        if ($DB->nbResults()>0) {
				$sharedMD5 = $shareditemkey;
				while ($row = $DB->fetch(0)) {
	                $userid_owner = $row['user_id'];
	            }
	            $DB->freeResults();
	        }
	        if ($userid_owner != $_SESSION['user_id']) {
	            echo "<createdby>another</createdby>";
	        } else {
				echo "<createdby>myself</createdby>";
			}
	    }

		$DB->execute($widcal_addEvent,$DB->escape($id),
                    $DB->noHTML($_POST["t"]),
                    $DB->noHTML($_POST["c"]),
                    $DB->noHTML($_POST["d"]),
                    $DB->noHTML($_POST["h"]),
                    $DB->noHTML($_POST["end"]),
                    $DB->escape($id),
                    $DB->escape($userid_owner)
                    );

		if ($DB->nbAffected()==0)
		{
			$DB->execute($widcal_newModuleId2,$DB->escape($_SESSION['user_id']),$DB->quote($sharedMD5));
			$oldid=$id;
			$id=$DB->getId();
			$DB->execute($widcal_addNewModEvent,$id,$DB->escape($oldid));
			$DB->execute($widcal_addNewModOldEvents,$DB->escape($id),
                        $DB->noHTML($_POST["t"]),
                        $DB->noHTML($_POST["c"]),
                        $DB->noHTML($_POST["d"]),
                        $DB->noHTML($_POST["h"]),
                        $DB->noHTML($_POST["end"])
                        );
		}
	}
	echo '<sharedkey>'.$sharedMD5.'</sharedkey>';
	echo '<ret>'.$id.'_'.($DB->getId()).'</ret>';
    echo '<calid>'.$id.'</calid>';
}
if ($act == 'init')
{
	$sharedMD5 = md5(uniqid(rand(), true));

	//create new entry
	$DB->execute($widcal_newModuleId2,$DB->escape($_SESSION['user_id']),$DB->quote($sharedMD5));

	echo '<sharedkey>' . $sharedMD5 . '</sharedkey>';
    echo '<calid>' . $DB->getId() . '</calid>';
}
if ($act=="get")
{
	$id = $_POST["modid"];
    $widgetid = $_POST["widgetid"];
    if( empty($shareditemkey)
        || (!isset($sharedmd5key))
        || $sharedmd5key=='shareditemkey') {
            #6797 recherche des events sans utiliser la shared key
			$DB->getResults($widcal_getEventsUserNoSharedKey,
                $DB->escape($id),
                $DB->noHTML($_POST["d"])
                );

            /*$DB->getResults($widcal_getEventsUserBySharedKey,
                $DB->escape($id),
                $DB->noHTML($_POST["d"]),
				$DB->quote($shareditemkey)
                );*/
    } else {
        $DB->getResults($widcal_getEventsShared,
                        $DB->quote("%calid=".$DB->escape($id)."%"),
                        $DB->quote($shareditemkey),
                        $DB->escape($_SESSION['user_id']),
                        $DB->escape($widgetid),
                        $DB->escape($id),
                        $DB->noHTML($_POST["d"])
                        );
    }
	while ($row = $DB->fetch(0))
	{
		echo '<event>';
		echo '<id>'.$row["cal_id"].'</id>';
		echo '<title><![CDATA['.$row["title"].']]></title>';
		echo '<comment><![CDATA['.$row["comments"].']]></comment>';
		echo '<time>'.$row["time"].'</time>';
		echo '<endtime>'.$row["endtime"].'</endtime>';
		echo '</event>';
	}
	$DB->freeResults();
}
if ($act=="month")
{
	$icalurl = isset($_POST["icalurl"])?$_POST["icalurl"]:"";
	$icalid = isset($_POST["calid"])?$_POST["calid"]:0;
	$id = isset($_POST["modid"])?$_POST["modid"]:$icalid;
    $widgetid = $_POST["widgetid"];
    $sharedmd5key = isset($_POST["sharedmd5key"])?$_POST["sharedmd5key"]:"";
	if( isset($_SESSION["user_id"]) ) {
	    if( empty($sharedmd5key)
	        || (!isset($sharedmd5key))
	        || $sharedmd5key=='undefined') {
				$DB->getResults($widcal_getMonthEventsUser,
	                        $DB->escape($id),
	                        $DB->noHTML($_POST["m"]),
	                        $DB->noHTML($_POST["y"]),
	                        $DB->escape($_SESSION['user_id'])
	                        );
		        if ($DB->nbResults() == 0) {
					$DB->getResults($widcal_getMonthEventsSharedKey,
						$DB->quote($shareditemkey),
		                $DB->escape($id),
		                $DB->noHTML($_POST["m"]),
		                $DB->noHTML($_POST["y"])
		                );
				}
	    } else {
	        $DB->getResults($widcal_getMonthEventsShared,
	                    $DB->quote("%calid=".$DB->escape($id)."%"),
	                    $DB->quote($sharedmd5key),
	                    $DB->escape($_SESSION['user_id']),
	                    $DB->escape($widgetid),
	                    $DB->escape($id),
	                    $DB->noHTML($_POST["m"]),
	                    $DB->noHTML($_POST["y"])
	                    );
	   }
	   	while ($row = $DB->fetch(0))
		{
			echo '<event>';
			echo '<id>'.$row["cal_id"].'</id>';
			echo '<title><![CDATA['.$row["title"].']]></title>';
			echo '<day>'.$row["day"].'</day>';
			echo '<time>'.$row["time"].'</time>';
			echo '<endtime>'.$row["endtime"].'</endtime>';
			echo '</event>';
		}
	}  elseif( isset($_POST["shareditemkey"]) && $id>0 ) {
		$shareditemkey =  isset($_POST["shareditemkey"])?$_POST["shareditemkey"]:"";
	    $DB->getResults($widcal_getMonthEventsSharedKey,
					$DB->quote($shareditemkey),
	                $DB->escape($id),
	                $DB->noHTML($_POST["m"]),
	                $DB->noHTML($_POST["y"])
	                );
		while ($row = $DB->fetch(0))
		{
			echo '<event>';
			echo '<id>'.$row["cal_id"].'</id>';
			echo '<title><![CDATA['.$row["title"].']]></title>';
			echo '<day>'.$row["day"].'</day>';
			echo '<time>'.$row["time"].'</time>';
			echo '<endtime>'.$row["endtime"].'</endtime>';
			echo '</event>';
		}
	}

	$DB->freeResults();
}
$DB->close();

$file->status("1");

$file->footer();
?>