//aliases
function $(id) { return document.getElementById(id); }
function _IG_AdjustIFrameHeight(opt_height) { mygadgets.resize(opt_height); }

//gadget class
mygadgets = {
    url:'http://opensocial.portaneo.com/',
    /*
     * Function: gadgets.resize
     *
     * Detects the inner dimensions of a frame.
     *
     * Parameters: opt_height (optional): height to apply
     *
     * See also: gadgets.changeHeight
     *
     */
    resize:function(opt_height) {
        var newHeight = parseInt(opt_height, 10);
        if (isNaN(newHeight)) {
            var vh = mygadgets.getViewportDimensions().height;
            var body = document.body;
            var docEl = document.documentElement;
            if (document.compatMode == 'CSS1Compat' && docEl.scrollHeight) {
                newHeight = docEl.scrollHeight != vh ?
                docEl.scrollHeight : docEl.offsetHeight;
            } 
            else {
                var sh = docEl.scrollHeight;
                var oh = docEl.offsetHeight;
                if (docEl.clientHeight != oh) {
                    sh = body.scrollHeight;
                    oh = body.offsetHeight;
                }
                if (sh > vh) {
                    newHeight = sh > oh ? sh : oh;
                } 
                else {
                    newHeight = sh < oh ? sh : oh;
                }
            }
       }
       newHeight = newHeight + 20;
       mygadgets.changeHeight(newHeight);
    },
    /*
     * Function: gadgets.getViewportDimensions
     *
     * Detects the height/width of a frame.
     *
     * Returns: 2 dimensions hash: "width" => frame width
     *                             "height" => frame height
     */
    getViewportDimensions:function() {
        var x,y;
        if (self.innerHeight) {
            // all except Explorer
            x = self.innerWidth;
            y = self.innerHeight;
        } else if (document.documentElement &&
               document.documentElement.clientHeight) {
            // Explorer 6 Strict Mode
            x = document.documentElement.clientWidth;
            y = document.documentElement.clientHeight;
        } else if (document.body) {
            // other Explorers
            x = document.body.clientWidth;
            y = document.body.clientHeight;
        } else {
            x = 0;
            y = 0;
        }
        return {width: x, height: y};
    },
    /*
     * Function: gadgets.changeHeight
     *
     * Dynamically generate an invisible iframe pointing to the portaneo host domain
     *
     * Parameters: new frame height
     *
     */
    changeHeight:function(newHeight,uniq) {
        var serverFront = document.createElement("iframe");
        serverFront.src = mygadgets.url+"tools/opensocial/front.html?height="+newHeight+"&uniq="+uniq;
        serverFront.style.display = "none";
        document.getElementsByTagName('body')[0].appendChild(serverFront);
    }
};
