<?php
# *********************** LICENSE *****************************************************	#
#	This file is part of AutoCreat plugin.												#
#																						#
#	AutoCreat plugin is free software; you can redistribute it and/or modify			#
#	it under the terms of the GNU General Public License as published by				#
#	the Free Software Foundation; either version 2 of the License, or					#
#	(at your option) any later version.													#
#																						#
#	CAS plugin is distributed in the hope that it will be useful,						#
#	but WITHOUT ANY WARRANTY; without even the implied warranty of						#
#	MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the						#
#	GNU General Public License for more details.										#
#																						#
#	You should have received a copy of the GNU General Public License					#
#	along with Foobar; if not, write to the Free Software								#
#	Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA			#
# *************************************************************************************	#


/************************************************
*	AutoCreat plugin file						*
*	file: plugin_AC.php							*
*	version: 1.10								*
*	date: 26/05/2008							*
*	author: Jean-francois Rey					*
*	email: jean-francois.rey@univ-avignon.fr	*
************************************************/

/*
 * name: AutoCreat plugin
 * description: Create automaticaly a posh account at the first login.
 * dependencies: no
 * author: Jean-François REY
 * url: http://gpl.univ-avignon.fr
 */
 
 define("AC_NAME","AutoCreat plugin"); 

/*
  * Registers the action in order to uninstall the plugin
  */
 register_hook('uninstall_plugin_AC/plugin_AC','plugac_uninstall');

	// show configuration
	register_hook("display_plugin","plugac_display",10,1);
    //display iframe
    register_hook("iframe_plugin","iframe_plugAC",10,1);
	// save configuration in DB
	register_hook("admin_scr_config_plugins","plugac_save_config",10,1);
	// create account if not
	register_hook("user_login_form","plugac_user_login_form",1,2);
	// Send mail if necessary
	register_hook("scr_createportal","plugac_createportal",10);
    //remove user account if ldap authentification not valid
    register_hook("remove_user","plugac_remove_user",1,1);
    //complete user information ifldap authentification OK
    register_hook("valid_user_infos","plugac_update_user_account",1,3);

    
 // show configuration
  //added param to allow using AC config on old posh version
 function plugac_display($info)
 {
	if($info['name'] == AC_NAME )
	{
        if ( isset($info["ajaxplug"]) && $info["ajaxplug"] == 1) {
            echo '<iframe frameborder="0" marginwidth="1%" height="130px" width="80%" src="../admin/scr_plugin.php?plugname=iframe_plugAC"></iframe>';
        } else {
            require_once("plugin_AC_config.php");
        }
	}
 }
 
function iframe_plugAC ($name) {

    if($name == "iframe_plugAC" ) {
       /* if( isset($_POST['enregistrer']) ) {
            require_once("../includes/plugins/plugin_AC/scr_plugin_AC_config.php");
        }*/
        require_once("../includes/plugins/plugin_AC/plugin_AC_config.php");
    }
    $modifAC_plugin = isset($_POST["modifAC_plugin"])?$_POST["modifAC_plugin"]:0;
    if( $modifAC_plugin == 1)
        launch_hook('admin_scr_config_plugins',$_POST["modifAC_plugin"]);
 }

/*
  * Uninstall function
  */

function plugac_uninstall()
{
	global $DB;
	$sql = "DELETE FROM `adm_config` WHERE CONVERT(`adm_config`.`parameter` USING utf8)='autoCreat' LIMIT 1;";
	$DB->execute($sql);
	$DB->freeResults();
	$sql = "DELETE FROM `adm_config` WHERE CONVERT(`adm_config`.`parameter` USING utf8)='autoCreatmailad' LIMIT 1;";
	$DB->execute($sql);
	$DB->freeResults();
	$sql = "DELETE FROM `adm_config` WHERE CONVERT(`adm_config`.`parameter` USING utf8)='autoCreatmailu' LIMIT 1;";
	$DB->execute($sql);
	$DB->freeResults();
}


 /*
 * Save plugin configuration in Data Base
 */

 function plugac_save_config( $modif=0 )
{
	//$inc=0;
	/*while ( isset($_POST["plugi".$inc]) )
	{
		if($_POST["name".$inc] == AC_NAME)
		{*/
			//if($_POST["modifAC_plugin"] == 1)
            if($modif == 1)
			{
				global $DB;
                $autoCreat = (isset($_POST["autoCreat"]))?$_POST["autoCreat"]:'';
				$sql = 'UPDATE adm_config SET value="'.$autoCreat.'" WHERE parameter="autoCreat" ';
				$DB->execute($sql);
				if ($DB->nbAffected()==0){
        				$sql = 'INSERT INTO adm_config (parameter,value,datatype,desttype) ';
        				$sql.= 'VALUES ("autoCreat","'.$autoCreat.'","str","P") ';
        				$DB->execute($sql);
				}
                $autoCreatmailad = (isset($_POST["autoCreatmailad"]))?$_POST["autoCreatmailad"]:'';
				$sql = 'UPDATE adm_config SET value="'.$autoCreatmailad.'" WHERE parameter="autoCreatmailad" ';
				$DB->execute($sql);
				if ($DB->nbAffected()==0){
        				$sql = 'INSERT INTO adm_config (parameter,value,datatype,desttype) ';
        				$sql.= 'VALUES ("autoCreatmailad","'.$autoCreatmailad.'","str","P") ';
        				$DB->execute($sql);
				}
                $autoCreatmailu = (isset($_POST["autoCreatmailu"]))?$_POST["autoCreatmailu"]:'';
				$sql = 'UPDATE adm_config SET value="'.$autoCreatmailu.'" WHERE parameter="autoCreatmailu" ';
				$DB->execute($sql);
				if ($DB->nbAffected()==0){
        				$sql = 'INSERT INTO adm_config (parameter,value,datatype,desttype) ';
        				$sql.= 'VALUES ("autoCreatmailu","'.$autoCreatmailu.'","str","P") ';
        				$DB->execute($sql);
				}
			}
	//		break;
	//	}
	//	$inc++;
	//}
}
//TODO: pouvoir effectuer ceci apres login ou faire avant mais si erreur suprrimer utilisateur si premiere connection
// Create account
function plugac_user_login_form($username,$password)
{
	if( __autoCreat == 'Y')
	{
		global $DB;	
		$DB->getResults("SELECT id,md5pass AS password,typ,lang,long_name FROM users WHERE username=%s AND typ NOT IN ('S','D')",$DB->quote($username));
		if ($DB->nbResults()<=0 && $username!=""){
            $DB->freeResults();
			
            //add the new user
			error_log("create new user : " . $username);
			$DB->execute("INSERT INTO users(username,typ,lastconnect_date,md5pass,long_name,md5user,lang) VALUES (%s,'I',CURRENT_DATE,%s,%s,%s,%s)",
            $DB->quote($username),$DB->quote(md5($password)),$DB->quote($username),$DB->quote(md5($username.$password)),$DB->quote(__LANG));	
            
            // new user_id
			$userid = $DB->getId();
            
            //create the user criterias
            $criterias = Array();
            $DB->getResults("SELECT id,type,options,public FROM adm_userinfo");
            if ($DB->nbResults()!=0) {
                while ($row = $DB->fetch(0)) {
                    $id = $row['id'];
                    $type = $row['type'];
                    $public = $row['public'];
                    $options = $row['options'];
                    $criterias[$id] = array( 'type' => $type,
                                             'public' => $public,
                                             'options' => $options
                                           );
                }
                $DB->freeResults();
            }
            
            foreach ($criterias as $cle => $val) {
                $default = "1"; //for type = 2
                $type = $criterias[$cle]['type'];
                if (($type=='1') || ($type=='5') || ($type=='6')) { 
                    $default = "";
                }
                if ( ($type == '3') || ($type == '4') ) {
                    $vals = explode(";", $criterias[$cle]['options']);
                    $default = $vals[0]; 
                }
                $DB->execute("INSERT INTO users_info (info_id,parameters,ispublic,user_id) VALUES (%u,%s,%u,%u)",$DB->escape($cle),$DB->quote($default),$DB->escape($criterias[$cle]['public']),$DB->escape($userid));
            }
            
			//add to log
			$DB->execute("INSERT INTO log (action,pubdate,param1) VALUES (3,CURRENT_DATE,%u) ",$DB->escape($userid));
		}
		else
		{
			$row = $DB->fetch(0);
			if ($row['typ'] == 'B' || $row['typ'] == 'J')
			{
				$userid = $row['id'];
				$newType = ($row['typ'] == 'J' ? 'I' : 'A');
				error_log("activate account ID " . $userid);
				$DB->execute('UPDATE users SET typ = %s WHERE id = %u',$DB->quote($newType),$userid);
			}
            $DB->freeResults();
		}
		
	}
}
/*
       Delete a user from the database if the ldap authentification failed
*/
function plugac_remove_user($username)
{
    global $DB;
	//inactivate users
	error_log("inactivate account " . $username . " because of LDAP connection failure");
    $DB->execute("UPDATE users SET typ='B' WHERE username = %s AND typ='A' ",$DB->quote($username));
	$DB->execute("UPDATE users SET typ='J' WHERE username = %s AND typ='I' ",$DB->quote($username));
}
/*
        Update user information if LDAP authentification OK
*/
function plugac_update_user_account($username,$password,$informations)
{
    global $DB;
    $language=(isset($informations['preferred_language']))?$informations['preferred_language']:__LANG;
    $longname=(isset($informations['cn']))?$informations['cn']:$username;
    $description=(isset($informations['description'][0]))?$informations['description'][0]:'';
    $mail=(isset($informations['mail']))?$informations['mail']:'--';
    
    //update user complementary informations from LDAP datas
    $DB->execute("UPDATE users SET lang=%s,email=%s,long_name=%s,description=%s WHERE username=%s",$DB->quote($language),$DB->quote($mail),$DB->quote($longname),$DB->quote($description),$DB->quote($username));    

    //get user id
    $DB->getResults("SELECT id FROM users WHERE username=%s",$DB->quote($username));
    $row=$DB->fetch(0);
    $userid=$row['id'];
    $DB->freeResults();
}

// Send mail if necessary
function plugac_createportal()
{
	if( __autoCreat == 'Y')
	{
		require_once('../l10n/'.__LANG.'/lang.php');
        
		if( __accountType=="mail" ) $mail = $_SESSION["username"];
		else $mail = (isset($_SESSION['mail']))?$_SESSION['mail']:'';
		$user = $_SESSION['username'];

        error_log("utf8_decode(A new account creation __APPNAME : $user) : ".utf8_decode("A new account creation ".__APPNAME." : ".$user));
        error_log("mail : ".$mail);
		if(__autoCreatmailad == "Y") mail(__SUPPORTEMAIL,utf8_decode("A new account creation ".__APPNAME." : ".$user),"A new account creation\r\n\r\n user: ".$user."\r\n\r\n mail: ".$mail."\r\n\r\n".__LOCALFOLDER,"From: ".$mail."\r\n");
		if(__autoCreatmailu == "Y" ) mail($mail,utf8_decode(lg("subscribeConfirmation").__APPNAME),utf8_decode(lg("subscribeConfirmationBody",lg("yourAccount")." : ".$user."\r\n".lg("password")." : XXXXX\r\n\r\n").__APPNAME. "\r\n".__LOCALFOLDER),"From: ".__SUPPORTEMAIL."\r\n");
	}
}
?>