<?php
# *********************** LICENSE *****************************************************	#
#	This file is part of CAS plugin.													#
#																						#
#	CAS plugin is free software; you can redistribute it and/or modify					#
#	it under the terms of the GNU General Public License as published by				#
#	the Free Software Foundation; either version 2 of the License, or					#
#	(at your option) any later version.													#
#																						#
#	CAS plugin is distributed in the hope that it will be useful,						#
#	but WITHOUT ANY WARRANTY; without even the implied warranty of						#
#	MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the						#
#	GNU General Public License for more details.										#
#																						#
#	You should have received a copy of the GNU General Public License					#
#	along with Foobar; if not, write to the Free Software								#
#	Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA			#
# *************************************************************************************	#

/************************************************
*	CAS plugin configuration file				*
*	file: plugin_cas_config.php					*
*	version: 2.10								*
*	date: 03/06/2008							*
*	author: Jean-francois Rey					*
*	email: jean-francois.rey@univ-avignon.fr	*
************************************************/

if (__LANG=="fr"){
	$GLOBALS['lgMap']['yes']="oui";
	$GLOBALS['lgMap']['no']="non";
	$GLOBALS['lgMap']['casauthen']="Authentification par defaut en mode CAS :";
	$GLOBALS['lgMap']['casversion']="Version du serveur CAS :";
	$GLOBALS['lgMap']['casserver']="Serveur CAS (sans http, sans le port) :";
	$GLOBALS['lgMap']['casfolder']="URI (exemple /cas-server-webapp-3.3.1 ) :";
	$GLOBALS['lgMap']['casport']="Port du serveur:";
	$GLOBALS['lgMap']['casreturn']="URL de retour du serveur CAS:";
	$GLOBALS['lgMap']['casprotocol']="Protocole d'accès au serveur CAS:";
}else {
	$GLOBALS['lgMap']['yes']="yes";
	$GLOBALS['lgMap']['no']="no";
	$GLOBALS['lgMap']['casauthen']="Default CAS mode authentication :";
	$GLOBALS['lgMap']['casversion']="CAS server version :";
	$GLOBALS['lgMap']['casserver']="CAS server (without http, but with 8080 if necessary) :";
	$GLOBALS['lgMap']['casfolder']="URI  (exemple /cas-server-webapp-3.3.1 ) :";
	$GLOBALS['lgMap']['casport']="Server port :";
	$GLOBALS['lgMap']['casreturn']="Return URL from CAS server :";
	$GLOBALS['lgMap']['casprotocol']="CAS server acces protocol:";
}

$not_access=1;
$granted="A";
$pagename="plugin_cas_config.php";

$casversion="2.0";
$casserver="";
$casfolder="";
$casport=443;
$casprotocol="https";
$casreturn=__LOCALFOLDER."portal";
$authenticationmode="N";

global $DB;
$sql = "SELECT parameter,value FROM adm_config_cas ";
$DB->getResults($sql);
while ($row=$DB->fetch(0)){
	if ($row["parameter"]=="CAS_VERSION") $casversion=$row["value"];
	if ($row["parameter"]=="CAS_SERVER") $casserver=$row["value"];
	if ($row["parameter"]=="CAS_PROTO") $casprotocol=$row["value"];
	if ($row["parameter"]=="CAS_FOLDER") $casfolder=$row["value"];
	if ($row["parameter"]=="CAS_PORT") $casport=$row["value"];
	if ($row["parameter"]=="CAS_RETURN") $casreturn= substr($row["value"],9);
	if ($row["parameter"]=="defaultAuthen") $authenticationmode=$row["value"];
}
$DB->freeResults();
$sql = "SELECT parameter,value FROM adm_config WHERE parameter='defaultAuthen';";
$DB->getResults($sql);
while ($row=$DB->fetch(0)){
	if ($row["parameter"]=="defaultAuthen") $authenticationmode=$row["value"];
}
$DB->freeResults();
?>
<!-- CAS mode -->
<tr><td colspan="3">
<input type="hidden" value="0" name="modifCas_plugin" />
<table cellpadding="0" cellspacing="0" width="100%">
	<tr>
		<td class="label"><img src="../images/ico_right_arrow.gif" /> <?php echo lg("casauthen");?></td>
		<td>
		<input type="checkbox" name="authenticationmode" value="cas" <?php if($authenticationmode == "cas") echo " checked='checked'";?> onChange="form.modifCas_plugin.value=1;"/>
		</td>
	</tr>
	<tr>
		<td class="label"><img src="../images/ico_right_arrow.gif" /> <?php echo lg("casversion");?></td>
		<td>
		<select name="casversion" onChange="form.modifCas_plugin.value=1;">
			<option value="1.0" <?php if ($casversion=="1.0") echo " selected='selected'";?> >1</option>
			<option value="2.0" <?php if ($casversion=="2.0") echo " selected='selected'";?> >2</option>
			<option value="3.0" <?php if ($casversion=="3.0") echo " selected='selected'";?> >3</option>
		</select>
		</td>
	</tr>
        <tr>
		<td class="label"><img src="../images/ico_right_arrow.gif" /> <?php echo lg("casserver");?></td><td><input type="text" name="casserver" value="<?php echo $casserver;?>" size="40" onChange="form.modifCas_plugin.value=1;" />
		</td>
	</tr>
        <tr>
		<td class="label"><img src="../images/ico_right_arrow.gif" /> <?php echo lg("casfolder");?></td><td><input type="text" name="casfolder" value="<?php echo $casfolder;?>" onChange="form.modifCas_plugin.value=1;" />
		</td>
	</tr>
        <tr>
		<td class="label"><img src="../images/ico_right_arrow.gif" /> <?php echo lg("casport");?></td><td><input type="text" name="casport" value="<?php echo $casport;?>" size="5" onChange="form.modifCas_plugin.value=1;" />
		</td>
	</tr>
	<tr>
		<td class="label"><img src="../images/ico_right_arrow.gif" /> <?php echo lg("casprotocol");?></td>
		<td>
		<select name="casprotocol" onChange="form.modifCas_plugin.value=1;">
			<option value="http" <?php if ($casprotocol=="http") echo " selected='selected'";?> >http</option>
			<option value="https" <?php if ($casprotocol=="https") echo " selected='selected'";?> >https</option>
		</select>
		</td>
	</tr>
	<tr>
		<td class="label"><img src="../images/ico_right_arrow.gif" /> <?php echo lg("casreturn");?></td><td><input type="text" name="casreturn" value="<?php echo $casreturn;?>" size="40" onChange="form.modifCas_plugin.value=1;" />
		</td>
	</tr>
</table>
</td></tr>