<?php
function getMsgError ($ret) {
    $lassoErrors = array();
     if ($ret < 0) {
        $ret = $ret * -1;
     }

/* undefined */
	$lassoErrors['1'] = array('LASSO_ERROR_UNDEFINED','Undefined error case');
	$lassoErrors['2'] = array('LASSO_ERROR_UNIMPLEMENTED','Unimplemented part of Lasso');
	$lassoErrors['3'] = array('LASSO_ERROR_OUT_OF_MEMORY','Out of memory');

/* generic XML */
	$lassoErrors['10'] = array('LASSO_XML_ERROR_NODE_NOT_FOUND','Unable to get child of element.');
	$lassoErrors['11'] = array('LASSO_XML_ERROR_NODE_CONTENT_NOT_FOUND','Unable to get content of element.');
	$lassoErrors['12'] = array('LASSO_XML_ERROR_ATTR_NOT_FOUND','Unable to get attribute of element.');
	$lassoErrors['13'] = array('LASSO_XML_ERROR_ATTR_VALUE_NOT_FOUND','Unable to get attribute value of element.');
	$lassoErrors['14'] = array('LASSO_XML_ERROR_INVALID_FILE','Invalid XML file');
	$lassoErrors['15'] = array('LASSO_XML_ERROR_OBJECT_CONSTRUCTION_FAILED','LASSO_XML_ERROR_OBJECT_CONSTRUCTION_FAILED');
	$lassoErrors['16'] = array('LASSO_XML_ERROR_MISSING_NAMESPACE','LASSO_XML_ERROR_MISSING_NAMESPACE');

/* XMLDSig */
	$lassoErrors['101'] = array('LASSO_DS_ERROR_SIGNATURE_NOT_FOUND','Signature element not found.');
	$lassoErrors['102'] = array('LASSO_DS_ERROR_INVALID_SIGNATURE','Invalid signature.');
	$lassoErrors['103'] = array('LASSO_DS_ERROR_SIGNATURE_TMPL_CREATION_FAILED','LASSO_DS_ERROR_SIGNATURE_TMPL_CREATION_FAILED');
	$lassoErrors['104'] = array('LASSO_DS_ERROR_CONTEXT_CREATION_FAILED','Failed to create signature context.');
	$lassoErrors['105'] = array('LASSO_DS_ERROR_PUBLIC_KEY_LOAD_FAILED','Failed to load public key.');
	$lassoErrors['106'] = array('LASSO_DS_ERROR_PRIVATE_KEY_LOAD_FAILED','Failed to load private key.');
	$lassoErrors['107'] = array('LASSO_DS_ERROR_CERTIFICATE_LOAD_FAILED','Failed to load certificate.');
	$lassoErrors['108'] = array('LASSO_DS_ERROR_SIGNATURE_FAILED','Failed to sign the node.');
	$lassoErrors['109'] = array('LASSO_DS_ERROR_KEYS_MNGR_CREATION_FAILED','Failed to create keys manager.');
	$lassoErrors['110'] = array('LASSO_DS_ERROR_KEYS_MNGR_INIT_FAILED','Failed to initialize keys manager.');
	$lassoErrors['111'] = array('LASSO_DS_ERROR_SIGNATURE_VERIFICATION_FAILED','Failed to verify signature.');
	$lassoErrors['112'] = array('LASSO_DS_ERROR_CA_CERT_CHAIN_LOAD_FAILED','LASSO_DS_ERROR_CA_CERT_CHAIN_LOAD_FAILED');
	$lassoErrors['113'] = array('LASSO_DS_ERROR_INVALID_SIGALG','Invalid signature algorithm.');
	$lassoErrors['114'] = array('LASSO_DS_ERROR_DIGEST_COMPUTE_FAILED','LASSO_DS_ERROR_DIGEST_COMPUTE_FAILED');
	$lassoErrors['115'] = array('LASSO_DS_ERROR_SIGNATURE_TEMPLATE_NOT_FOUND','Signature template has not been found.');
	$lassoErrors['116'] = array('LASSO_DS_ERROR_TOO_MUCH_REFERENCES','SAML signature must contain only one reference');
	$lassoErrors['117'] = array('LASSO_DS_ERROR_INVALID_REFERENCE_FOR_SAML','SAML signature reference must be to a Request, a Reponse or an Assertion ID attribute');
	$lassoErrors['118'] = array('LASSO_DS_ERROR_DECRYPTION_FAILED','Decryption of an encrypted node failed');

/* Server */
	$lassoErrors['201'] = array('LASSO_SERVER_ERROR_PROVIDER_NOT_FOUND','ProviderID unknown to LassoServer.');
	$lassoErrors['202'] = array('LASSO_SERVER_ERROR_ADD_PROVIDER_FAILED','Failed to add new provider.');
	$lassoErrors['203'] = array('LASSO_SERVER_ERROR_ADD_PROVIDER_PROTOCOL_MISMATCH','Failed to add new provider (protocol mismatch).');
	$lassoErrors['204'] = array('LASSO_SERVER_ERROR_SET_ENCRYPTION_PRIVATE_KEY_FAILED','Failed to load encryption private key.');

/* Single Logout */
	$lassoErrors['301'] = array('LASSO_LOGOUT_ERROR_UNSUPPORTED_PROFILE','Unsupported protocol profile');
	$lassoErrors['302'] = array('LASSO_LOGOUT_ERROR_REQUEST_DENIED','Request denied by identity provider');
	$lassoErrors['303'] = array('LASSO_LOGOUT_ERROR_FEDERATION_NOT_FOUND','Federation not found on logout');
	$lassoErrors['304'] = array('LASSO_LOGOUT_ERROR_UNKNOWN_PRINCIPAL','Unknown principal on logout');

/* Profile */
	$lassoErrors['401'] = array('LASSO_PROFILE_ERROR_INVALID_QUERY','Invalid URL query');
	$lassoErrors['402'] = array('LASSO_PROFILE_ERROR_INVALID_POST_MSG','Invalid POST message');
	$lassoErrors['403'] = array('LASSO_PROFILE_ERROR_INVALID_SOAP_MSG','Invalid SOAP message');
	$lassoErrors['404'] = array('LASSO_PROFILE_ERROR_MISSING_REQUEST','Missing request');
	$lassoErrors['405'] = array('LASSO_PROFILE_ERROR_INVALID_HTTP_METHOD','Invalid HTTP method');
	$lassoErrors['406'] = array('LASSO_PROFILE_ERROR_INVALID_PROTOCOLPROFILE','Invalid protocol profile');
	$lassoErrors['407'] = array('LASSO_PROFILE_ERROR_INVALID_MSG','Invalid message');
	$lassoErrors['408'] = array('LASSO_PROFILE_ERROR_MISSING_REMOTE_PROVIDERID','ProviderID not found');
	$lassoErrors['409'] = array('LASSO_PROFILE_ERROR_UNSUPPORTED_PROFILE','Unsupported protocol profile');
	$lassoErrors['410'] = array('LASSO_PROFILE_ERROR_UNKNOWN_PROFILE_URL','Unable to find Profile URL in metadata');
	$lassoErrors['411'] = array('LASSO_PROFILE_ERROR_IDENTITY_NOT_FOUND','Identity not found');
	$lassoErrors['412'] = array('LASSO_PROFILE_ERROR_FEDERATION_NOT_FOUND','Federation not found');
	$lassoErrors['413'] = array('LASSO_PROFILE_ERROR_NAME_IDENTIFIER_NOT_FOUND','Name identifier not found');
	$lassoErrors['414'] = array('LASSO_PROFILE_ERROR_BUILDING_QUERY_FAILED','Error building request QUERY url');
	$lassoErrors['415'] = array('LASSO_PROFILE_ERROR_BUILDING_REQUEST_FAILED','Error building request object');
	$lassoErrors['416'] = array('LASSO_PROFILE_ERROR_BUILDING_MESSAGE_FAILED','Error building request message');
	$lassoErrors['417'] = array('LASSO_PROFILE_ERROR_BUILDING_RESPONSE_FAILED','Error building response object');
	$lassoErrors['418'] = array('LASSO_PROFILE_ERROR_SESSION_NOT_FOUND','Session not found');
	$lassoErrors['419'] = array('LASSO_PROFILE_ERROR_BAD_IDENTITY_DUMP','Failed to create identity from dump');
	$lassoErrors['420'] = array('LASSO_PROFILE_ERROR_BAD_SESSION_DUMP','Failed to create session from dump');
	$lassoErrors['421'] = array('LASSO_PROFILE_ERROR_MISSING_RESPONSE','Missing response');
	$lassoErrors['422'] = array('LASSO_PROFILE_ERROR_MISSING_STATUS_CODE','Missing status code');
	$lassoErrors['423'] = array('LASSO_PROFILE_ERROR_MISSING_ARTIFACT','Missing SAML artifact');
	$lassoErrors['424'] = array('LASSO_PROFILE_ERROR_MISSING_RESOURCE_OFFERING','Missing ressource offering');
	$lassoErrors['425'] = array('LASSO_PROFILE_ERROR_MISSING_SERVICE_DESCRIPTION','Missing service description');
	$lassoErrors['426'] = array('LASSO_PROFILE_ERROR_MISSING_SERVICE_TYPE','Missing service type');
	$lassoErrors['427'] = array('LASSO_PROFILE_ERROR_MISSING_ASSERTION','Missing assertion');
	$lassoErrors['428'] = array('LASSO_PROFILE_ERROR_MISSING_SUBJECT','Missing subject');
	$lassoErrors['429'] = array('LASSO_PROFILE_ERROR_MISSING_NAME_IDENTIFIER','Missing name identifier');
	$lassoErrors['430'] = array('LASSO_PROFILE_ERROR_INVALID_ARTIFACT','Invalid artifact');
	$lassoErrors['431'] = array('LASSO_PROFILE_ERROR_MISSING_ENCRYPTION_PRIVATE_KEY','Found an encrypted element but encryption private key is not set');
	$lassoErrors['432'] = array('LASSO_PROFILE_ERROR_STATUS_NOT_SUCCESS','Status code is not success');
	$lassoErrors['433'] = array('LASSO_PROFILE_ERROR_MISSING_ISSUER','Missing issuer');
	$lassoErrors['434'] = array('LASSO_PROFILE_ERROR_MISSING_SERVICE_INSTANCE','Missing service instance');
	$lassoErrors['435'] = array('LASSO_PROFILE_ERROR_MISSING_ENDPOINT_REFERENCE','Missing endpoint reference');
	$lassoErrors['436'] = array('LASSO_PROFILE_ERROR_MISSING_ENDPOINT_REFERENCE_ADDRESS','Missing endpoint reference address');
	$lassoErrors['437'] = array('LASSO_PROFILE_ERROR_INVALID_ISSUER','Assertion issuer is not the same as the requested issuer');
	$lassoErrors['438'] = array('LASSO_PROFILE_ERROR_MISSING_SERVER','No server object set in the profile');
	$lassoErrors['439'] = array('LASSO_PROFILE_ERROR_UNKNOWN_PROVIDER','The issuer of the message is unknown to us');
	$lassoErrors['440'] = array('LASSO_PROFILE_ERROR_CANNOT_VERIFY_SIGNATURE','The profile cannot verify a signature on the message');
	$lassoErrors['441'] = array('LASSO_PROFILE_ERROR_CANNOT_FIND_A_PROVIDER','Profile was called without a specific provider and we cannot find one');
	$lassoErrors['442'] = array('LASSO_PROFILE_ERROR_RESPONSE_DOES_NOT_MATCH_REQUEST','Received response does not refer to the request sent');

/* functions/methods parameters checking */
	$lassoErrors['501'] = array('LASSO_PARAM_ERROR_BAD_TYPE_OR_NULL_OBJ','An object type provided as parameter ');
	$lassoErrors['502'] = array('LASSO_PARAM_ERROR_INVALID_VALUE','A parameter value is invalid.');
	$lassoErrors['503'] = array('LASSO_PARAM_ERROR_CHECK_FAILED','The error return location should be ');
	$lassoErrors['504'] = array('LASSO_PARAM_ERROR_NON_INITIALIZED_OBJECT','LASSO_PARAM_ERROR_NON_INITIALIZED_OBJECT');

/* Single Sign-On */
	$lassoErrors['601'] = array('LASSO_LOGIN_ERROR_FEDERATION_NOT_FOUND','Federation not found on login');
	$lassoErrors['602'] = array('LASSO_LOGIN_ERROR_CONSENT_NOT_OBTAINED','LASSO_LOGIN_ERROR_CONSENT_NOT_OBTAINED');
	$lassoErrors['603'] = array('LASSO_LOGIN_ERROR_INVALID_NAMEIDPOLICY','Invalid NameIDPolicy in lib:AuthnRequest');
	$lassoErrors['604'] = array('LASSO_LOGIN_ERROR_REQUEST_DENIED','Request denied');
	$lassoErrors['605'] = array('LASSO_LOGIN_ERROR_INVALID_SIGNATURE','LASSO_LOGIN_ERROR_INVALID_SIGNATURE');
	$lassoErrors['606'] = array('LASSO_LOGIN_ERROR_UNSIGNED_AUTHN_REQUEST','LASSO_LOGIN_ERROR_UNSIGNED_AUTHN_REQUEST');
	$lassoErrors['607'] = array('LASSO_LOGIN_ERROR_STATUS_NOT_SUCCESS','Status code is not success');
	$lassoErrors['608'] = array('LASSO_LOGIN_ERROR_UNKNOWN_PRINCIPAL','Unknown principal');
	$lassoErrors['609'] = array('LASSO_LOGIN_ERROR_NO_DEFAULT_ENDPOINT','No default endpoint');
	$lassoErrors['610'] = array('LASSO_LOGIN_ERROR_ASSERTION_REPLAY','Assertion replay');
	$lassoErrors['611'] = array('LASSO_LOGIN_ERROR_ASSERTION_DOES_NOT_MATCH_REQUEST_ID','If inResponseTo attribute is present, a matching request must be present too in the LassoLogin object');
;

/* Federation Termination Notification */
	$lassoErrors['700'] = array('LASSO_DEFEDERATION_ERROR_MISSING_NAME_IDENTIFIER','Name identifier not found in request');

/* Soap */
	$lassoErrors['800'] = array('LASSO_SOAP_FAULT_REDIRECT_REQUEST','Redirect request from Attribute Provider');
	$lassoErrors['801'] = array('LASSO_SOAP_ERROR_MISSING_ENVELOPE','Missing SOAP envelope');
	$lassoErrors['802'] = array('LASSO_SOAP_ERROR_MISSING_HEADER','Missing SOAP header');
	$lassoErrors['803'] = array('LASSO_SOAP_ERROR_MISSING_BODY','Missing SOAP body');
	$lassoErrors['804'] = array('LASSO_SOAP_ERROR_MISSING_SOAP_FAULT_DETAIL','Missing SOAP fault detail');

/* Name Identifier Mapping */
	$lassoErrors['900'] = array('LASSO_NAME_IDENTIFIER_MAPPING_ERROR_MISSING_TARGET_NAMESPACE','Target name space not found');
	$lassoErrors['901'] = array('LASSO_NAME_IDENTIFIER_MAPPING_ERROR_FORBIDDEN_CALL_ON_THIS_SIDE','LASSO_NAME_IDENTIFIER_MAPPING_ERROR_FORBIDDEN_CALL_ON_THIS_SIDE');
	$lassoErrors['902'] = array('LASSO_NAME_IDENTIFIER_MAPPING_ERROR_MISSING_TARGET_IDENTIFIER','LASSO_NAME_IDENTIFIER_MAPPING_ERROR_MISSING_TARGET_IDENTIFIER');

/* Data Service */
	$lassoErrors['1000'] = array('LASSO_DATA_SERVICE_ERROR_UNREGISTERED_DST','LASSO_DATA_SERVICE_ERROR_UNREGISTERED_DST');

/* WSF Profile */
	$lassoErrors['1100'] = array('LASSO_WSF_PROFILE_ERROR_MISSING_CORRELATION','Correlation SOAP Header is missing');
	$lassoErrors['1101'] = array('LASSO_WSF_PROFILE_ERROR_MISSING_SECURITY','Security SOAP Header is missing');
	$lassoErrors['1102'] = array('LASSO_WSF_PROFILE_ERROR_MISSING_ASSERTION_ID','AssertionID attribute is missing');
	$lassoErrors['1103'] = array('LASSO_WSF_PROFILE_ERROR_MISSING_ENDPOINT','Cannot find an WSP endpoint for the ID-WSF service');
	$lassoErrors['1104'] = array('LASSO_WSF_PROFILE_ERROR_SOAP_FAULT','SOAP ID-WSF binding returned a SOAP fault');
	$lassoErrors['1105'] = array('LASSO_WSF_PROFILE_ERROR_UNSUPPORTED_SECURITY_MECHANISM','The specified security mechanism is not supported by lasso ID-WSF library');
	$lassoErrors['1106'] = array('LASSO_WSF_PROFILE_ERROR_MISSING_DESCRIPTION','No ID-WSF web Service description could be found for the current security mechanism');
	$lassoErrors['1107'] = array('LASSO_WSF_PROFILE_ERROR_MISSING_RESOURCE_ID','The necessary ResourceID or EncryptedResourceID for calling an ID-WSF service is missing.');
	$lassoErrors['1108'] = array('LASSO_WSF_PROFILE_ERROR_MISSING_CREDENTIAL_REF','WS-Security SAML Token secmech needs a CredentialRef');

/* ID-WSF 2 Discovery */
	$lassoErrors['1200'] = array('LASSO_DISCOVERY_ERROR_SVC_METADATA_REGISTER_FAILED','Service metadata registration failed');
	$lassoErrors['1201'] = array('LASSO_DISCOVERY_ERROR_SVC_METADATA_ASSOCIATION_ADD_FAILED','Service metadata association failed');
	$lassoErrors['1202'] = array('LASSO_DISCOVERY_ERROR_MISSING_REQUESTED_SERVICE','Missing requested service');
	$lassoErrors['1203'] = array('LASSO_DISCOVERY_ERROR_FAILED_TO_BUILD_ENDPOINT_REFERENCE','Failed to build Endpoint Reference');

/* ID-WSF 2 Data Service */
	$lassoErrors['1300'] = array('LASSO_DST_ERROR_MISSING_SERVICE_DATA','Missing service data');
	$lassoErrors['1301'] = array('LASSO_DST_ERROR_QUERY_FAILED','Query failed');
	$lassoErrors['1302'] = array('LASSO_DST_ERROR_QUERY_PARTIALLY_FAILED','Query partially failed : some items were correctly processed');
	$lassoErrors['1303'] = array('LASSO_DST_ERROR_MODIFY_FAILED','Modify failed');
	$lassoErrors['1304'] = array('LASSO_DST_ERROR_MODIFY_PARTIALLY_FAILED','Modify partially failed : some items were correctly processed');
	$lassoErrors['1305'] = array('LASSO_DST_ERROR_NEW_DATA_MISSING','Missing new data');

/* Lasso registry */
	$lassoErrors['1400'] = array('LASSO_REGISTRY_ERROR_KEY_EXISTS','Key alreadys exists in the registry');

/* Lasso provider */
	$lassoErrors['1500'] = array('LASSO_PROVIDER_ERROR_MISSING_PUBLIC_KEY','The provider has no known public key');

    return $lassoErrors[$ret];
}
?>
