<?php

/*********************** LICENSE *****************************************************	#
#	This file is part of LDAP plugin.													#
#																						#
#	LDAP plugin is free software; you can redistribute it and/or modify					#
#	it under the terms of the GNU General Public License as published by				#
#	the Free Software Foundation; either version 2 of the License, or					#
#	(at your option) any later version.													#
#																						#
#	LDAP plugin is distributed in the hope that it will be useful,						#
#	but WITHOUT ANY WARRANTY; without even the implied warranty of						#
#	MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the						#
#	GNU General Public License for more details.										#
#																						#
#	You should have received a copy of the GNU General Public License					#
#	along with Foobar; if not, write to the Free Software								#
#	Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA			#
************************************************************************************/
/**
 *   
 *  This plugin enables ldap authentication in posh.
 *
 *
 *  Check if user exists in Portaneo first
 *  then check if user exists in LDAP
 *
 * This plugin can check id or email
 * 
 * if id is checked, dn is build from this id and root path toDistinguish Name of user (see dnldapuser in form)
 * then a connection is done to server if successful, user is connected
 *
 * if checking is done with email (see ldap_checkusermail in plugin_ldap_lib.php )
 * a first request is done with manager id or anonymous account
 * a filter is added with email and plugin get datas about user
 *
 * then an array containing datas is send
 * uid is get by default
 * if in configuration attributes, dn is added, so this attribute is saved in array
 *
* then uid is sent to ldap_checkuser where dn is build with uid and root path toDistinguish Name
* if array contains dn key, this one is used for connection
*
 * checking is finished with a connection to ldap server. 
 *
 *  Update datas of user in Portaneo with datas get from LDAP
 *
 **/

/************************************************
*	LDAP plugin file							*
*	file: plugin_ldap.php						*
*	version: 2.20							 	*
*	date: 21/05/2008							*
*	author: Jean-francois Rey					*
*	email: jean-francois.rey@univ-avignon.fr	*
************************************************/

/*
 * name: plugin LDAP
 * description: LDAP authentication, users informations and groups<br><font color='red'><b>Warning:</b> Don't forget to run a 'chown' command to the 'plugin_ldap' directory (needs the web server rights)</font>
 * dependencies: no
 * author: Jean-François REY
 * url: http://gpl.univ-avignon.fr
 */
 
 define("LDAP_NAME","plugin LDAP"); 

 include("plugin_ldap_lib.php");
 
	/**** ADMIN PART ****/

	/*
	* Registers the action in order to install and uninstall the plugin
	*/

	register_hook('install_plugin_LDAP/plugin_ldap','plugldap_install');
	register_hook('uninstall_plugin_LDAP/plugin_ldap','plugldap_uninstall');
  
	// show configuration: call iframe
	register_hook("display_plugin","plugldap_display",10,1);
    
    //display iframe
    register_hook("iframe_plugin","iframe_plugldap",10,1);
	
	// save configuration in DB
	register_hook("admin_scr_config_plugins","plugldap_save_config");
	
	// save configuration in file
	register_hook("admin_scr_generate_configfiles","plugldap_save_file");
 
	// Contact part, send mail, email come from ldap
	register_hook("admin_scr_communication_emailing","plugldap_admin_scr_communication_emailing",10,0);

	// read ldap group and save it in DB
    //appelé de admin/scr_cache_generate_all.php
	register_hook("admin_scr_cache_generate","plugldap_admin_scr_cache_generate",5,0);
	register_hook("admin_scr_cache_update","plugldap_admin_scr_cache_generate",5,0);

	/**** PORTAL PART ****/

	// check ldap login for subcribe
	register_hook("scr_subscribe","plugldap_subcribe",10,2);

	// add long_name to DB from __LDAP_cn
	register_hook("scr_createportal","plugldap_createportal");

	// initialize and update user account
	register_hook("scr_connect_session_initialized","plugldap_scr_connect_session_initialized");

	// change ldap pwd
	register_hook("scr_changepwd","plugldap_changepwd");

	// check pwd for unlock tab
	register_hook("scr_unlock","plugldap_unlock",10,3);

	// check and update personnal informations
	register_hook("scr_defportal","plugldap_scr_connect_session_initialized");
/**
* show configuration
* added param to allow using ldap config on old posh version
 **/
 function plugldap_display($info)
 {
	if ($info['name'] == LDAP_NAME) {
        if ( isset($info["ajaxplug"]) && $info["ajaxplug"] == 1) {
            echo '<iframe frameborder="0" marginwidth="1%" height="400px" width="80%" src="../admin/scr_plugin.php?plugname=iframe_plugldap"></iframe>';
        } else {
            require_once("plugin_ldap_config.php");
        }
    }
 }
 /**
 * function to configure plugin in new Posh interface (full ajax)
 *
 *  @param variable $name name of plugin ("iframe_plugldap")
  *
 **/
 function iframe_plugldap ($name) {
    if($name == "iframe_plugldap" ) {
        if( isset($_POST['enregistrer']) ) {
            require_once("../includes/plugins/plugin_ldap/scr_plugin_ldap_config.php");
        }
        require_once("../includes/plugins/plugin_ldap/plugin_ldap_config.php");
    }
 }
 
 /*
  * Install function
  */
 function plugldap_install()
 {	
	$inc=0;
	while ( isset($_POST["plugi".$inc]) )
	{
		if($_POST["name".$inc] == LDAP_NAME && $_POST["plugi".$inc] == 0)
		{
			global $DB;
			// create table adm_config_ldap
			$sql = "DROP TABLE IF EXISTS `adm_config_ldap`;";
			$DB->execute($sql);
			$sql = "CREATE TABLE `adm_config_ldap` (`parameter` varchar(16) character set utf8 collate utf8_unicode_ci NOT NULL default '', `value` text character set utf8 collate utf8_unicode_ci NOT NULL, `datatype` char(3) NOT NULL default '', `desttype` char(1) NOT NULL default '', PRIMARY KEY  (`parameter`)) TYPE=MyISAM DEFAULT CHARSET=utf8 COMMENT='LDAP plugin configuration parameters';";
			$DB->execute($sql);
            //a user cannot switch account or change his password
            $sql = "UPDATE adm_config SET value='false' WHERE parameter = 'passwordChangePermission'";
            $DB->execute($sql);
            $sql = "UPDATE adm_config SET value='false' WHERE parameter = 'userChangePermission'";
            $DB->execute($sql);
			break;
		}
		$inc++;
	}
}
 /*
  * Uninstall function
  */
  function plugldap_uninstall()
 {
	// delete table adm_config_ldap
	global $DB;
	$sql = "DROP TABLE IF EXISTS `adm_config_ldap`;";
	$DB->execute($sql);
	// delete useLdap parameter
	$sql = "DELETE FROM `adm_config` WHERE CONVERT(`adm_config`,`parameter` USING utf8) = 'useLdap' LIMIT 1;";
	$DB->execute($sql);
	// delete ldap group
	$sql = "SELECT id from users_group where name='LDAP' ";
	$DB->getResults($sql);
	if( $DB->nbResults() > 0 )
	{
		$grid = $DB->fetch(0);
		$sql = "SELECT id from users_group where parent_id=".$grid['id'];
		$DB->getResults($sql);
		if( $DB->nbResults() > 0 )
		{
			while($row = $DB->fetch(0))
			{
				$sql = "DELETE FROM users_group where id=".$row['id'];
				$DB->execute($sql);
			}
		}
		$sql = "DELETE FROM users_group where id=".$grid['id'];
		$DB->execute($sql);
	}
    $sql = "UPDATE adm_config SET value='true' WHERE parameter = 'passwordChangePermission'";
    $DB->execute($sql);
    $sql = "UPDATE adm_config SET value='true' WHERE parameter = 'userChangePermission'";
    $DB->execute($sql);
 }

/*
 * Save plugin configuration in Data Base
 */
 function plugldap_save_config()
{
	$inc=0;
	while ( isset($_POST["plugi".$inc]) )
	{
		if($_POST["name".$inc] == LDAP_NAME)
		{
			if(isset($_POST["modifLDAP_plugin"]) && $_POST["modifLDAP_plugin"] == 1)
			{
				require_once("scr_plugin_ldap_config.php");
			}
			break;
		}
		$inc++;
	}
}
/**
*
* save configuration in file ldap.inc.php
*
* 
*
**/
 function plugldap_save_file()
{
// save on file
$contentldap="<?php".chr(13).chr(10);
global $DB;
$sql = "SELECT parameter,value,datatype,desttype FROM adm_config_ldap ";
$DB->getResults($sql);
while ($row = $DB->fetch(0)){
	if ($row["desttype"]=="L"){
                switch($row["datatype"]){
                        case "int":
                                $contentldap.='define("__'.$row["parameter"].'",'.$row["value"].');'.chr(13).chr(10);
                                break;
                        case "str":
                                $contentldap.='define("__'.$row["parameter"].'","'.addslashes($row["value"]).'");'.chr(13).chr(10);
                                break;
                        case "arr":
                                $contentldap.='$'.'__'.$row["parameter"].'='.$row["value"].';'.chr(13).chr(10);
                                break;
                }
        }
}
$DB->freeResults();

if (!$handle = fopen("../includes/plugins/plugin_ldap/ldap.inc.php", 'w+'))
{
	echo "Can\'t open ldap.inc.php file";
        exit;
}

if (fwrite($handle, $contentldap."?>") === FALSE) {
	echo "Can't write in ldpa.inc.php file";
        exit;
}
fclose($handle);
}
/**
* plugldap_admin_scr_communication_emailing
*
* Contact part, send mail, email come from ldap
*
*   
*
*
**/
function plugldap_admin_scr_communication_emailing()
{
    if( defined('__useLdap') && __accountType!="mail" && $_POST["emailtype"]!="1")
    {
        require("includes.php");	

        // get username (uid) and then get email
        $emaillist=array();
        $ldapread = new ldap('r');
        $ldapread->connect();
        
        // users list
        global $DB;
        $DB->getResults($communication_getUsersList);
        while ($row=$DB->fetch(0))
        {
            // user mail
            if( ($res = $ldapread->get_infos($row["username"],array(__LDAP_mail))) != false)
            {
                array_push($emaillist,$res[__LDAP_mail]);
            }
        }
        $DB->freeResults();
        $ldapread->close();
        
        //send email
        for ($i=0;$i<count($emaillist);$i++)
        {
        
            launch_hook('admin_communication_send_mail',$emaillist[$i],$_POST["subject"],$_POST["message"],$_POST["sender"]);
            
            mail($emaillist[$i],stripslashes(utf8_decode($_POST["subject"])),stripslashes(utf8_decode($_POST["message"])),"From: ".$_POST["sender"]."\r\n");
        }
        
        // save copy
        if (isset($_POST["emailcopy"]))
        {
            $DB->execute($communication_addSentItem,$DB->quote($_POST["sender"]),$DB->quote($_POST["subject"]),$DB->quote($_POST["message"]),$DB->quote($receiver));
            
            launch_hook('admin_communication_save_mail_copy',$_POST["sender"],$_POST["subject"],$_POST["message"],$receiver);
        }
            
        header("location:communication_emailing.php?sent=1");
    }
}
/**
*
* plugldap_admin_scr_cache_generate
*
* read ldap groups and save it in DB
*
*
*
*
**/
function plugldap_admin_scr_cache_generate()
{
	if( defined('__useLdap') && __LDAP_GROUPMODE == "yes" )
	{
		$groupupdate = array();
		$dbgroups = array();

		// get DB groups
		global $DB;
		$DB->getResults("SELECT id,name FROM users_group where parent_id=".__LDAP_GROUPID);
		if( $DB->nbResults() > 0 )
		{
			while ($row = $DB->fetch(0))
			{
				$dbgroups[$row["name"]] = $row["id"];
			}
		}
		$DB->freeResults();
		
		// get ldap groups
		$ldapread = new ldap('r');
		$ldapread->connect();
       
		if( $groups = $ldapread->ldap_get_groups(__LDAP_DNGROUP,__LDAP_FILTERGROUP) )
		{
            
			// keep new ldap groups
			for( $i=0 ; $i < count($groups) ; $i++)
			{
				if( !isset($dbgroups[$groups[$i]["cn"]]) ) 
                {
                    $groupupdate[$groups[$i]["cn"]] = $groups[$i]["description"];
				}
                else 
                {
                    unset( $dbgroups[$groups[$i]["cn"]] );
                }
			}
		} else $ldapread->get_error();
		$ldapread->close();
		
		// remove ldap groups from db
		if( count($dbgroups) > 0)
		{
			foreach ( $dbgroups as $name => $value)
			{
				$DB->execute("DELETE FROM users_group WHERE id=%u",$value);
			}
		}

		// update DB with new ldap groups
		if( count($groupupdate) > 0)
		{
			foreach ( $groupupdate as $name => $value)
			{
				$DB->execute("INSERT INTO users_group (name,parent_id) VALUES (%s,%u) ",$DB->quote($name),__LDAP_GROUPID);
			}
		}
	}
}

	/**** PORTAL PART ****/
/**
* plugldap_subcribe
*
* check authentication at subcribtion
*
* @param variable $user username
*
* @param variable $pwd password
*
**/
function plugldap_subcribe($user,$pwd)
{
 if ( __defaultAuthen=="ldap")
 {
	$ldap = new ldap();
	//check if email login
	if (__accountType=="mail")
	{
		if( !$ldap->ldap_checkusermail($user,$pwd) )
		{
			echo '<'.'?xml version="1.0" encoding="UTF-8"?'.'><channel><status>1</status><err><![CDATA['.lg("incorrectLogin").']]></err></channel>';
			$ldap->close();
			exit(0);
		}
	// check if uid login
	}elseif( !$ldap->ldap_checkuser($user,$pwd) )
	{
		echo '<'.'?xml version="1.0" encoding="UTF-8"?'.'><channel><status>1</status><err><![CDATA['.lg("incorrectLogin").']]></err></channel>';
		$ldap->close();
		exit(0);
	}
	$ldap->close();
 }
}
/**
* plugldap_createportal
*
* add long_name to DB from __LDAP_cn
*
*   depends on type of account
*
*   search for "mail" entry in ldap
*
*   
*
**/
function plugldap_createportal()
{
    global $DB;
    if( defined('__useLdap') )
    {
    	$user = $_SESSION["username"];
    	$ldapread = new ldap('r');
    	$ldapread->connect();
        
    	if( __accountType=="mail" ) { 
            $data_user = $ldapread->get_uid("(".__LDAP_mail."=".$user.")");
            $_SESSION["uid_user"] = (isset($data_user['uid']))?$data_user['uid']:$user;
            $_SESSION["ldap_user"] = $data_user;
            $id_user = (isset($data_user['uid']))?$data_user['uid']:$user;
            $uid_user = (isset($data_user['uid']))?$data_user['uid']:$user;
        }
    	else
        {
            $id_user = $user;
            $uid_user = $user;
            $_SESSION["uid_user"] = $user;
        }
    	
    	$sql = "SELECT id,long_name,picture 
                    FROM users 
                    WHERE username='".$user."' 
                    AND typ NOT IN ('S','D');";
    	$DB->getResults($sql);
    	$row=$DB->fetch(0);
    	$id = $row["id"];

    	if ($DB->nbResults()>0 && ($row['long_name'] == "" || $row['picture'] == "") )
    	{
    		$photo = $row['picture'];
    		
    		if( ($res = $ldapread->get_infos($uid_user,array(__LDAP_mail,__LDAP_cn,"jpegphoto"))) != false)
    		{
    			$DB->freeResults();
    			$sql = "UPDATE users SET long_name=".$DB->quote($res[__LDAP_cn])." WHERE username='".$user."';";
    			$DB->execute($sql);
    			$DB->freeResults();
    			$_SESSION['longname']=$res[__LDAP_cn];

    			if( __enterprise == true 
                    && isset($res["jpegphoto"])
                    && $res["jpegphoto"] != "" 
                    && $photo == "" 
                    && (($photoldap = $ldapread->create_img($id_user,"../cache/photo".$id.".jpg")) != false))
    			{
    				$sql = "UPDATE users SET picture=".$DB->quote($photoldap."?rand=thMRKnrPH2")." WHERE username='".$user."';";
    				$DB->execute($sql);
    				$DB->freeResults();
    			}
    		}
    	}

    	// check ldap group
    	if( __LDAP_GROUPMODE == "yes" )
    	{
    		// get DB user groups
    		$dbgroup = array();
    		$DB->getResults("SELECT group_id FROM users_group_map WHERE user_id=%u ",$id);
    		while($row=$DB->fetch(0)) $dbgroup[$row["group_id"]] = 1;
    		$DB->freeResults();
    		
    		// get ldap user groups
    		if( is_array($groups = $ldapread->ldap_get_groups(__LDAP_DNGROUP,"(&".__LDAP_FILTERGROUP."(member=".__LDAP_uid."=".$uid_user.",".__LDAP_DN."))")) )
    		{
    			// get group_id from DB present in LDAP
    			for ($i=0; $i<count($groups) ; $i++)
    			{
    				$DB->getResults("SELECT id FROM users_group WHERE name=%s and parent_id=%u",$DB->quote($groups[$i]["cn"]),__LDAP_GROUPID);
    				$gp = $DB->fetch(0);
    				$idgroupuser[$i] = $gp["id"];
    				$DB->freeResults();
    			}
    			
    			// update user group in DB
    			for($i=0 ; $i<count($idgroupuser) ; $i++)
    			{
    				if( !isset($dbgroup[$idgroupuser[$i]]) )
    				{
    					$DB->execute("INSERT INTO users_group_map (user_id,group_id) VALUES (%u,%u)",$id,$idgroupuser[$i]);
    					$DB->freeResults();
    				}
    				else unset($dbgroup[$idgroupuser[$i]]); // on vire le groups deja present
    			}

    			
    			
    			// if old group to remove
    			if(count($dbgroup) > 0) {
    				foreach ( $dbgroup as $idgr => $value)
    				{
    					$DB->execute("DELETE FROM users_group_map WHERE user_id=%u and group_id=%u",$id,$idgr);
    					$DB->freeResults();
    				}
                }
    		}
    	}
    	$ldapread->close();
    }
}

/**
* plugldap_changepwd
*
*
* change pwd on ldap
**/
function plugldap_changepwd()
{
if ( __defaultAuthen=="ldap" )
{
	echo '<'.'?xml version="1.0" encoding="UTF-8"?'.'><channel><status>1</status>';
	
	if (!isset($_POST["pass1"])) exit();
	if (!isset($_POST["oldpass"])) exit();
	$pass1=$_POST["pass1"];
	$oldpass=$_POST["oldpass"];
	$test=0;
	
	$ldapuser = new ldap("uw",$_SESSION['uid_user'],$oldpass);
	if($ldapuser->connect()) $test = 1 ;
	else
	{
		echo '<msg><![CDATA['.lg("incorrectPassword").']]></msg></channel>';
		exit(0);
	}
	if($ldapuser->ldap_modifpass($_SESSION['uid_user'],$pass1)) $test = 1;
	else
	{
		echo '<msg><![CDATA['.lg("errorUpdatepassword").']]></msg></channel>';
		exit(0);
	}
	
	echo '<msg><![CDATA[';
	if ($test==0){echo lg("incorrectPassword");} else {echo lg("passwordModified");}
	echo ']]></msg></channel>';
}
}
/**
*
*  plugldap_unlock
*
* check pwd for unlock tab
*
*
*
**/
function plugldap_unlock($id,$pwd,$user_id)
{
if ( __defaultAuthen=="ldap" )
{
	echo '<'.'?xml version="1.0" encoding="UTF-8"?'.'><channel><status>1</status>';
	
	global $DB;
	$sql = "SELECT user_id FROM profile WHERE user_id=".$DB->escape($user_id)." AND id=".$DB->escape($id).";";
	$DB->getResults($sql);
	
	$ldap = new ldap();
	if ($DB->nbResults()>0 && $ldap->ldap_checkuser($_SESSION['uid_user'],$pwd))
	{
		launch_hook('unlock_user',$id,$pwd,$user_id);
		$_SESSION["mdp"]=1;
	} else {
		echo "<err>".lg("incorrectPassword")."</err>";
	}
	$DB->freeResults();
	$ldap->close();
	
	echo '</channel>';
	exit(0);
}
}

/**
* 
*
* check authentication ldap
*
* @param variable $username username
* @param variable $password password
* @param reference $user array containing datas about user
* @param reference $errormsg 
*
**/
if ( defined("__defaultAuthen")
  && __defaultAuthen=="ldap"
  && !function_exists('user_login_form') ):
// call by user_login
function user_login_form($username,$password,&$user,&$errormsg)
{
	global $DB,$authentif_getUserByName,$authentif_getUserDataByName,$rs;
    if ($password=="") {
        $errormsg.=lg("incorrectLogin");
        return false;
    }
	launch_hook('user_login_form',$username,$password);
	//Check the password
	$DB->getResults($authentif_getUserByName,$DB->quote($username));
	if ($DB->nbResults()<=0) {
		$errormsg.=lg("incorrectLogin");
	} 
    else {
		$row=$DB->fetch(0);
		if ($row["typ"]=="N" OR $row["typ"]=="M")
		{
			$errormsg.=lg("userNotValidated");
		}
		else
		{
			if( $row["typ"]=="A" )
			{ 
				if( $row["password"]<>md5($password) )
				{
					$errormsg.=lg("incorrectLogin");
				}
			}
			else
			{
				$ldap = new ldap();
				if (__accountType=="mail") {
                
                        if( !$ldap->ldap_checkusermail($username,$password) )
                        { 
                            launch_hook('remove_user',$username);
                            $errormsg.=lg("incorrectLogin"); 
                            $errormsg.=$ldap->get_error();    
                        } else {
                            launch_hook('valid_user_infos',$username,$password,$rs);
                        }
				}
				else {
                    if( !$ldap->ldap_checkuser($username,$password,$rs) ) {
                        launch_hook('remove_user',$username);
                        $errormsg.=lg("incorrectLogin");
                    }
                    else {
                            launch_hook('valid_user_infos',$username,$password,$rs);
                        }
                }
				$ldap->close();
			}
		}
        $DB->freeResults();
        
		if( $errormsg == "" )
		{
            $DB->getResults($authentif_getUserDataByName,$DB->quote($username));
            $row=$DB->fetch(0);
			$user->id=$row["id"];
			$user->username=$username;
			$user->type=$row["typ"];
			$user->lang=$row["lang"];
			$user->activity=$row["activity"];
			$user->picture=$row["picture"];
			$user->longname=$row["long_name"]==""?$username:$row["long_name"];
			$user->pass = md5($password);
            $user->password = $password;
            $user->email = $row["email"];
            $user->password_change_date = $row["password_change_date"];
            $user->md5user = $row["md5user"];
            $user->lastconnect_date = $row["lastconnect_date"];
            $user->force_user_change_password = $row["force_user_change_password"];            
			$DB->freeResults();
            
			return true;
		}
	}
	return false;
}
endif;
/**
*
*   plugldap_scr_connect_session_initialized
*
*  @see hook 
*       scr_connect_session_initialized
*       scr_defportal
*
*
**/
function plugldap_scr_connect_session_initialized()
{
    global $DB;
    global $rs;
    if( defined('__useLdap')  )
    {
    	$user = $_SESSION["username"];
    	
    	// ldap connect
    	$ldapread = new ldap('r');
    	$ldapread->connect();
        //$uid_user;
    	// get uid
        
    	if( __accountType=="mail" ) {
            $data_user = $ldapread->get_uid("(".__LDAP_mail."=".$user.")");
            $_SESSION["uid_user"] = (isset($data_user['uid']))?$data_user['uid']:$user;
            $_SESSION["ldap_user"] = $data_user;
            $id_user = (isset($data_user['uid']))?$data_user['uid']:$user;
            $uid_user = (isset($data_user['uid']))?$data_user['uid']:$user;
        }
    	else 
        {
            $id_user = $user;
            $uid_user = $user;
            $_SESSION["uid_user"] = $user;
        }

    	
    	$sql = "SELECT id,long_name,picture FROM `users` WHERE `username`='".$user."' AND typ NOT IN ('S','D');";
        
    	$DB->getResults($sql);
    	$row=$DB->fetch(0);
    	$id = $row["id"];
    	
    	// update long_name and picture
    	if ($DB->nbResults()>0 && ($row['long_name'] == "" || $row['picture'] == "") )
    	{
    		$photo = $row['picture'];
            //if( ($res = $ldapread->get_infos($id_user,array(__LDAP_mail,__LDAP_cn,"jpegphoto"))) != false)    
               
    		if( ($res = $ldapread->get_infos($uid_user,array(__LDAP_mail,__LDAP_cn,"jpegphoto"))) != false)
    		{
    			$DB->freeResults();
    			$sql = "UPDATE users SET long_name=".$DB->quote($res[__LDAP_cn])." WHERE username='".$user."';";
    			$DB->execute($sql);
    			$DB->freeResults();
    			$_SESSION['longname']=$res[__LDAP_cn];
    			if( __enterprise == true && isset($res["jpegphoto"]) && $res["jpegphoto"] != "" 
                            && $photo == "" 
                            && (($photoldap = $ldapread->create_img($uid_user,"../cache/photo".$id.".jpg")) != false)
                  )
    			{
    				$sql = "UPDATE users SET picture=".$DB->quote($photoldap."?rand=thMRKnrPH2")." WHERE username='".$user."';";
    				$DB->execute($sql);
    				$DB->freeResults();
    			}	
    		}
    	}

    	// check ldap group
    	if( __LDAP_GROUPMODE == "yes" )
    	{
    		// get DB user groups
    		$dbgroup = array();
    		$DB->getResults("SELECT group_id 
                                FROM 
                                    users_group_map,
                                    users_group 
                                WHERE 
                                    users_group_map.user_id=%u 
                                    AND users_group.id=users_group_map.group_id 
                                    AND users_group.parent_id=%u",$id,__LDAP_GROUPID);
    		while($row=$DB->fetch(0)) {
                $dbgroup[$row["group_id"]] = 1;
            }    
    		$DB->freeResults();
                
    		// get ldap user groups
    		if( is_array($groups = $ldapread->ldap_get_groups(__LDAP_DNGROUP,"(&".__LDAP_FILTERGROUP."(member=".__LDAP_uid."=".$uid_user.",".__LDAP_DN."))")) )
    		{

                $idgroupuser;
    			// get group_id from DB present in LDAP
    			for ($i=0; $i<count($groups) ; $i++)
    			{
                    
    				$DB->getResults("SELECT id FROM users_group 
                                        WHERE 
                                        name=%s 
                                        AND parent_id=%u",$DB->quote($groups[$i]["cn"]),__LDAP_GROUPID);
                                      
    				$gp = $DB->fetch(0);
    				$idgroupuser[$i] = $gp["id"];
    				$DB->freeResults();
    			}
    			
    			// update user group in DB
    			for($i=0 ; $i<count($idgroupuser) ; $i++)
    			{
                    
    				if( !isset($dbgroup[$idgroupuser[$i]]) )
    				{
    					$DB->execute("INSERT INTO users_group_map (user_id,group_id) VALUES (%u,%u)", $id ,$idgroupuser[$i]);
    					
    				 	get_usergroups($id,$idgroupuser[$i]);
    				}
    				else unset($dbgroup[$idgroupuser[$i]]);
    			}

    			// if old group to remove
    			if(count($dbgroup) > 0) {
    				foreach ( $dbgroup as $idgr => $value)
    				{
    					$DB->execute("DELETE FROM users_group_map WHERE user_id=%u and group_id=%u",$id,$idgr);
    				}
                }
                
                //delete group for user without group anymore in LDAP
                if ( count($groups) == 0 ) {
                    $DB->execute("DELETE FROM users_group_map WHERE user_id=%u",$id);
    		    $DB->freeResults();
                }
                
    		} 
            
    	}
    	$ldapread->close();
    } else {
       
        return true;

    }
}
/**
* get_usergroups
*
* @param variable $userid
* @param variable $usergroup
*
**/

function get_usergroups($userid,$usergroup)
{	
	global $DB;	
	$DB2=new connection(__SERVER,__LOGIN,__PASS,__DB);	
	$DB3=new connection(__SERVER,__LOGIN,__PASS,__DB);
	$DB4=new connection(__SERVER,__LOGIN,__PASS,__DB);

	//get user groups
	$DB->getResults("SELECT id,name,description,position,type,param,nbcol,controls,showtype,modulealign,icon FROM pages WHERE group_id=%u",$usergroup);
	
	while ($row  = $DB->fetch(0))
	{	
		$id = $row['id'];	
		$name=$row['name'];
		$nbcol=$row['nbcol'];
		$description=$row['description'];
		$type=$row['type'];
		$param=$row['param'];
		$controls=$row['controls'];
		$showtype=$row['showtype'];
		$modulealign=$row['modulealign'];	
		$icon=$row['icon'];
		$seq=1;

		$DB3->getResults("SELECT seq FROM profile WHERE user_id=%u ORDER BY seq DESC LIMIT 1",$userid);
		while ($row2  = $DB3->fetch(0))
		{
			$seq=$row2['seq'];
			$seq++;
		}
		$DB3->freeResults();

		$DB2->getResults("SELECT id FROM profile WHERE page_id=%u",
                            $id);
		if ($DB2->nbResults()==0)
		{
			$DB3->execute("INSERT INTO profile 
                            (user_id,name,width,height,creation_date,modif_date,
                            controls,showtype,seq,icon,modulealign,type,param,page_id,status) 
                            VALUES 
                            ($userid,'$name',$nbcol,5,CURRENT_DATE(),CURRENT_DATE(),
                                '$controls',$showtype,$seq,'$icon','$modulealign',
                                $type,'$param',$id,1) ");
            $profileid=$DB3->getId();			
            $DB3->freeResults();
			if ($type==1)
			{

			 $DB4->execute("INSERT INTO module 
                                (item_id,user_id,profile_id,posx,posy,posj,
                                x,y,typ,variables,uniq,blocked,minimized) 
                                SELECT item_id,$userid,$profileid,posx,posy,posj,x,y,'P',
                                    variables,uniq,blocked,minimized FROM pages_module 
                                    WHERE page_id=%u ",
                                    $id
                                    );
			}		

		}
		$DB2->freeResults();		
	}
	$DB->freeResults();
}


?>
