<?php
# *********************** LICENSE *****************************************************	#
#	This file is part of LDAP plugin.													#
#																						#
#	LDAP plugin is free software; you can redistribute it and/or modify					#
#	it under the terms of the GNU General Public License as published by				#
#	the Free Software Foundation; either version 2 of the License, or					#
#	(at your option) any later version.													#
#																						#
#	LDAP plugin is distributed in the hope that it will be useful,						#
#	but WITHOUT ANY WARRANTY; without even the implied warranty of						#
#	MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the						#
#	GNU General Public License for more details.										#
#																						#
#	You should have received a copy of the GNU General Public License					#
#	along with Foobar; if not, write to the Free Software								#
#	Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA			#
# *************************************************************************************	#

/************************************************
*	LDAP plugin configuration file				*
*	file: plugin_ldap_config.php				*
*	version: 2.20								*
*	date: 21/05/2008							*
*	author: Jean-francois Rey					*
*	email: jean-francois.rey@univ-avignon.fr	*
************************************************/

    if( file_exists("../includes/plugins/plugin_ldap/l10n/".__LANG."/ldap_admin.lang.php") )
    {
        include("l10n/".__LANG."/ldap_admin.lang.php");	
    } else 
    {
        include("l10n/en/ldap_admin.lang.php");
    }

$not_access=1;
$granted="A";
$pagename="plugin_ldap_config.php";

$ldapreadconnect="anonymous";
$dnldapreader="cn=reader,ou=people,dc=portaneo,dc=com";
$serverldap="192.168.2.52";
$serverldapport="389";
$dnldapuser="ou=people,dc=portaneo,dc=com";
$ldapuid="uid";
$ldapmail="mail";
$ldapcn="cn";
$ldapattribut="givenname,sn";
$dnldapwriter="cn=writer,ou=people,dc=portaneo,dc=com";
$serverldapwriter="ldaps://ldap1.portaneo.com";
$groupmode="no";
$dnldapgroup = "ou=groups,dc=portaneo,dc=com";
$filterldapgroup = "(objectclass=groupofnames)";
$passldapreader='';
$ldapversion=3;
$authenticationmode="";
$useldap=true;
$ldapuserattr="preferredLanguage,dn,cn";
$passldapwriter="";
$ldapfilter="";

global $DB;
$sql = "SELECT parameter,value FROM adm_config_ldap ";
$DB->getResults($sql);
while ($row=$DB->fetch(0)){
	if ($row["parameter"]=="LDAP_connect") $ldapreadconnect=!empty($row["value"])?$row["value"]:$ldapreadconnect;
	if ($row["parameter"]=="LDAP_VERSION") $ldapversion=!empty($row["value"])?$row["value"]:$ldapversion;
	if ($row["parameter"]=="LDAP_DNREAD") $dnldapreader=!empty($row["value"])?$row["value"]:$dnldapreader;
	if ($row["parameter"]=="LDAP_PASSREAD") $passldapreader=!empty($row["value"])?base64_decode($row["value"]):$passldapreader;
	if ($row["parameter"]=="LDAP_SERVER") $serverldap=!empty($row["value"])?$row["value"]:$serverldap;
	if ($row["parameter"]=="LDAP_SERVER_PORT") $serverldapport=!empty($row["value"])?$row["value"]:$serverldapport;
	if ($row["parameter"]=="LDAP_DN") $dnldapuser=!empty($row["value"])?$row["value"]:$dnldapuser;
	if ($row["parameter"]=="LDAP_uid") $ldapuid=!empty($row["value"])?$row["value"]:$ldapuid;
	if ($row["parameter"]=="LDAP_mail") $ldapmail=!empty($row["value"])?$row["value"]:$ldapmail;
    if ($row["parameter"]=="LDAP_lang") $ldaplang=!empty($row["value"])?$row["value"]:$ldaplang;
    if ($row["parameter"]=="LDAP_userattr") $ldapuserattr=!empty($row["value"])?$row["value"]:$ldapuserattr;
	if ($row["parameter"]=="LDAP_cn") $ldapcn=!empty($row["value"])?$row["value"]:$ldapcn;
	if ($row["parameter"]=="LDAP_ATTRIBUT") $ldapattribut=!empty($row["value"])?$row["value"]:$ldapattribut;
	if ($row["parameter"]=="LDAP_DNWRITE") $dnldapwriter=!empty($row["value"])?$row["value"]:$dnldapwriter;
	if ($row["parameter"]=="LDAP_PASSWRITE") $passldapwriter=!empty($row["value"])?base64_decode($row["value"]):$passldapwriter;
	if ($row["parameter"]=="LDAP_SERVERWRITE") $serverldapwriter=!empty($row["value"])?$row["value"]:$serverldapwriter;
	if ($row["parameter"]=="LDAP_GROUPMODE") $groupmode=!empty($row["value"])?$row["value"]:$groupmode;
	if ($row["parameter"]=="LDAP_DNGROUP") $dnldapgroup=!empty($row["value"])?$row["value"]:$dnldapgroup;
	if ($row["parameter"]=="LDAP_FILTERGROUP") $filterldapgroup=!empty($row["value"])?$row["value"]:$filterldapgroup;
	if ($row["parameter"]=="LDAP_filter") $ldapfilter=!empty($row["value"])?$row["value"]:$ldapfilter;
}
$DB->freeResults();
$sql = "SELECT parameter,value FROM adm_config ";
$DB->getResults($sql);
while ($row=$DB->fetch(0)){
	if ($row["parameter"]=="defaultAuthen") $authenticationmode=$row["value"];
	if ($row["parameter"]=="useLdap") $useldap=$row["value"];
}
$DB->freeResults();


if( file_exists("../includes/plugins/plugin_ldap/l10n/".__LANG."/ldap_admin.lang.js") )
{
    echo "<script type='text/javascript' src='../includes/plugins/plugin_ldap/l10n/".__LANG."/ldap_admin.lang.js?v=".__POSHVERSION."' ></script>";
}
?>

<tr><td colspan="3">
<input type="hidden" value="0" name="modifLDAP_plugin"/>
<table cellpadding="0" cellspacing="0" width="100%">
	<tr>
		<!--<td style="display:hidden;" class="label"><img src="../images/ico_right_arrow.gif" /><?php echo lg("ldapauthen");?></td>-->
		<td>
			<input type="hidden" name="authenticationmode" value="ldap" checked="checked" onChange="form.modifLDAP_plugin.value=1;"/>
		</td>
	</tr>
	<tr>
		<td class="label"><img src="../images/ico_right_arrow.gif" /> <?php echo lg("ldapuse");?></td>
		<td>
			<input type="checkbox" name="useldap" value="true" <?php if($useldap == "true") echo " checked='checked'";?> onChange="form.modifLDAP_plugin.value=1;"/>
		</td>
	</tr>
	<tr>
		<td class="label"><img src="../images/ico_right_arrow.gif" /> <?php echo lg("ldapversion");?></td>
		<td>
		<select name="ldapversion" onChange="form.modifLDAP_plugin.value=1;">
			<option value="2" <?php if ($ldapversion=="2") echo " selected='selected'";?> >2</option>
			<option value="3" <?php if ($ldapversion=="3") echo " selected='selected'";?> >3</option>
		</select>
		</td>
	</tr>	
	<tr>
		<td class="label"><img src="../images/ico_right_arrow.gif" /> <?php echo lg("ldapReadConnect");?></td>
		<td><input type="radio" name="ldapreadconnect" value="anonymous" onclick="navShow('ldapread','none');form.modifLDAP_plugin.value=1;"<?php if ($ldapreadconnect == "anonymous") echo " checked='checked'";?> /><?php echo lg("anonymous");?>
		<input type="radio" name="ldapreadconnect" value="read" onclick="navShow('ldapread','block');form.modifLDAP_plugin.value=1;"<?php if ($ldapreadconnect == "read") echo " checked='checked'";?> /><?php echo lg("normal");?></td></tr>
</table>
<div id="ldapread">
<table cellpadding="0" cellspacing="0" width="100%">
	<tr>
		<td class="souslabel"><img src="../images/ico_right_arrow.gif" /> Distinguish Name (DN)</td>
		<td><input type="text" name="dnldapreader" value="<?php echo $dnldapreader;?>" size="60" onChange="form.modifLDAP_plugin.value=1;" /></td>
	</tr>
	<tr>
		<td class="souslabel"><img src="../images/ico_right_arrow.gif" /> <?php echo lg("password");?></td>
		<td><input type="password" name="passldapreader" value="<?php echo $passldapreader;?>" size="60" onChange="form.modifLDAP_plugin.value=1;" /></td>
	</tr>
</table>
</div>
<table cellpadding="0" cellspacing="0" width="100%">
	<tr>
		<td class="label"><img src="../images/ico_right_arrow.gif" /> <?php echo lg("server");?></td>
		<td><input type="text" name="serverldap" value="<?php echo $serverldap;?>" size="60" onChange="form.modifLDAP_plugin.value=1;" /></td>
	</tr>
	<tr>
		<td class="label"><img src="../images/ico_right_arrow.gif" /> <?php echo lg("serverldapport");?></td>
		<td><input type="text" name="serverldapport" value="<?php echo $serverldapport;?>" size="30" onChange="form.modifLDAP_plugin.value=1;" /></td>
	</tr>
	<tr>
		<td class="label"><img src="../images/ico_right_arrow.gif" /> <?php echo lg("dnUser");?></td>
		<td><input type="text" name="dnldapuser" value="<?php echo $dnldapuser;?>" size="60" onChange="form.modifLDAP_plugin.value=1;" /><div style="display:inline;" id="dnUserHelpArea"></div></td>
	</tr>
	<tr>
		<td class="label"><img src="../images/ico_right_arrow.gif" /> <?php echo lg("ldapfilter");?></td>
		<td><input type="text" name="ldapfilter" value="<?php echo $ldapfilter;?>" size="60" onChange="form.modifLDAP_plugin.value=1;" /><div style="display:inline;" id="filterHelpArea"></div></td>
	</tr>
	<tr>
		<td class="label"><img src="../images/ico_right_arrow.gif" /> <?php echo lg("uid");?></td>
		<td><input type="text" name="ldapuid" value="<?php echo $ldapuid;?>" size="10" onChange="form.modifLDAP_plugin.value=1;" /></td>
	</tr>
	<tr>
		<td class="label"><img src="../images/ico_right_arrow.gif" /> <?php echo lg("cn");?></td>
		<td><input type="text" name="ldapcn" value="<?php echo $ldapcn;?>" size="10" onChange="form.modifLDAP_plugin.value=1;" /></td>
	</tr>
	<tr>
		<td class="label"><img src="../images/ico_right_arrow.gif" /> <?php echo lg("ldapmail");?></td>
		<td><input type="text" name="ldapmail" value="<?php echo $ldapmail;?>" size="10" onChange="form.modifLDAP_plugin.value=1;" /></td>
	</tr>
    <tr>
		<td class="label"><img src="../images/ico_right_arrow.gif" /> <?php echo lg("userattr");?></td>
		<td><input type="text" name="userattr" value="<?php echo $ldapuserattr;?>" size="45" onChange="form.modifLDAP_plugin.value=1;" /><div style="display:inline;" id="userAttrHelpArea"></div></td>
	</tr>    
	<!--<tr>
		<td class="label"><img src="../images/ico_right_arrow.gif" /> <?php echo lg("ldapattribut");?></td>
		<td><input type="text" name="ldapattribut" value="<?php echo $ldapattribut;?>" size="80" onChange="form.modifLDAP_plugin.value=1;" /></td>
	</tr>-->
	<!--<tr> <td><br /></td></tr>
	<tr>
		<td class="label"><img src="../images/ico_right_arrow.gif" /> <?php echo lg("ldapwriter");?></td>
	</tr>
	<tr>
		<td class="souslabel"><img src="../images/ico_right_arrow.gif" /> Distinguish Name (DN)</td>
		<td><input type="text" name="dnldapwriter" value="<?php echo $dnldapwriter;?>" size="60" onChange="form.modifLDAP_plugin.value=1;" /></td>
	</tr>
	<tr>
		<td class="souslabel"><img src="../images/ico_right_arrow.gif" /> <?php echo lg("password");?></td>
		<td><input type="password" name="passldapwriter" value="<?php echo $passldapwriter;?>" onChange="form.modifLDAP_plugin.value=1;" /></td>
	</tr>
	<tr>
		<td class="souslabel"><img src="../images/ico_right_arrow.gif" /> <?php echo lg("server");?></td>	<td><input type="text" name="serverldapwriter" value="<?php echo $serverldapwriter;?>" size="60" onChange="form.modifLDAP_plugin.value=1;" /></td>
	</tr>-->

	<td class="label"><img src="../images/ico_right_arrow.gif" /> <?php echo lg("ldapgroup");?></td>
	<td>
		<input type="checkbox" name="groupmode" value="yes" <?php if($groupmode == "yes") echo " checked='checked'";?> onChange="if(this.checked == false) navShow('ldapgroup','none'); else navShow('ldapgroup','block');form.modifLDAP_plugin.value=1;"/>
	</td>
</table>
<div id="ldapgroup">
<table cellpadding="0" cellspacing="0" width="100%">
	<tr>
		<td class="souslabel"><img src="../images/ico_right_arrow.gif" /> Group Distinguish Name (DN)</td>
		<td><input type="text" name="dnldapgroup" value="<?php echo $dnldapgroup;?>" size="60" onChange="form.modifLDAP_plugin.value=1;" /></td>
	</tr>
	<tr>
		<td class="souslabel"><img src="../images/ico_right_arrow.gif" /> Filtre </td>
		<td><input type="text" name="filterldapgroup" value="<?php echo $filterldapgroup;?>" size="60" onChange="form.modifLDAP_plugin.value=1;" /></td>
	</tr>
</table>
</div>
<table cellpadding="0" cellspacing="0" width="100%">
</table>
</td></tr>
<script type="text/javascript">
    var __displayrssdesc=1;
    $('dnUserHelpArea').innerHTML = tooltip('indicateRootIfFilter');
    $('filterHelpArea').innerHTML = tooltip('filterHelpArea');
    $('userAttrHelpArea').innerHTML = tooltip('userAttrFilterHelpArea');    
    <?php
    if($ldapreadconnect == "anonymous") echo "navShow('ldapread','none');\n";
    if($groupmode == "no") echo "navShow('ldapgroup','none');\n";
    ?>
</script>