<?php
# *********************** LICENSE *****************************************************	#
#	This file is part of LDAP plugin.													#
#																						#
#	LDAP plugin is free software; you can redistribute it and/or modify					#
#	it under the terms of the GNU General Public License as published by				#
#	the Free Software Foundation; either version 2 of the License, or					#
#	(at your option) any later version.													#
#																						#
#	LDAP plugin is distributed in the hope that it will be useful,						#
#	but WITHOUT ANY WARRANTY; without even the implied warranty of						#
#	MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the						#
#	GNU General Public License for more details.										#
#																						#
#	You should have received a copy of the GNU General Public License					#
#	along with Foobar; if not, write to the Free Software								#
#	Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA			#
# *************************************************************************************	#

/************************************************
*	LDAP plugin save config in DB				*
*	file: scr_plugin_ldap_config.php			*
*	version: 2.20								*
*	date: 21/05/2008							*
*	author: Jean-francois Rey					*
*	email: jean-francois.rey@univ-avignon.fr	*
************************************************/

$folder="";
$not_access=1;
$granted="A";
$pagename="scr_plugin_ldap_config.php";

global $DB;

// parametre ldapReadConnect
$ldapreadconnect=(isset($_POST["ldapreadconnect"]))?$_POST["ldapreadconnect"]:'anonymous';
$sql = 'UPDATE adm_config_ldap SET value='.$DB->quote($ldapreadconnect).' WHERE parameter="LDAP_connect" ';
$DB->execute($sql);
if ($DB->nbAffected()==0){
	$sql = 'INSERT INTO adm_config_ldap (parameter,value,datatype,desttype) ';
	$sql.= 'VALUES ("LDAP_connect",'.$DB->quote($ldapreadconnect).',"str","L") ';
	$DB->execute($sql);
}

// parametre ldapversion
$ldapversion=(isset($_POST["ldapversion"]))?$_POST["ldapversion"]:'2';
$sql = 'UPDATE adm_config_ldap SET value='.$DB->quote($ldapversion).' WHERE parameter="LDAP_VERSION" ';
$DB->execute($sql);
if ($DB->nbAffected()==0){
	$sql = 'INSERT INTO adm_config_ldap (parameter,value,datatype,desttype) ';
	$sql.= 'VALUES ("LDAP_VERSION",'.$DB->quote($ldapversion).',"str","L") ';
	$DB->execute($sql);
}

// if connect to ldap in normal mode, not anonymous
if(isset($_POST['ldapreadconnect']) && $_POST["ldapreadconnect"] == "read")
{
	// parametre _LDAP_DNREAD
    $dnldapreader=(isset($_POST["dnldapreader"]))?$_POST["dnldapreader"]:'cn=reader,ou=people,dc=univ,dc=fr';
	$sql = 'UPDATE adm_config_ldap SET value='.$DB->quote($dnldapreader).' WHERE parameter="LDAP_DNREAD" ';
	$DB->execute($sql);
	if ($DB->nbAffected()==0){
		$sql = 'INSERT INTO adm_config_ldap (parameter,value,datatype,desttype) ';
		$sql.= 'VALUES ("LDAP_DNREAD",'.$DB->quote($dnldapreader).',"str","L") ';
		$DB->execute($sql);
	}
    
	// parametre _LDAP_PASSREAD
    $passldapreader=(isset($_POST["passldapreader"]))?$_POST["passldapreader"]:'';
	$sql = 'UPDATE adm_config_ldap SET value="'.base64_encode($DB->escape($passldapreader)).'" WHERE parameter="LDAP_PASSREAD" ';
	$DB->execute($sql);
	if ($DB->nbAffected()==0){
		$sql = 'INSERT INTO adm_config_ldap (parameter,value,datatype,desttype) ';
		$sql.= 'VALUES ("LDAP_PASSREAD","'.base64_encode($DB->escape($passldapreader)).'","str","L") ';
		$DB->execute($sql);
	}
}

// parametre _LDAP_SERVER
$serverldap=(isset($_POST["serverldap"]))?$_POST["serverldap"]:'ldap1.univ.fr,ldap2.univ.fr';
$sql = 'UPDATE adm_config_ldap SET value='.$DB->quote($serverldap).' WHERE parameter="LDAP_SERVER" ';
$DB->execute($sql);
if ($DB->nbAffected()==0){
	$sql = 'INSERT INTO adm_config_ldap (parameter,value,datatype,desttype) ';
	$sql.= 'VALUES ("LDAP_SERVER",'.$DB->quote($serverldap).',"str","L") ';
	$DB->execute($sql);
}

// parametre _LDAP_SERVER_PORT
$serverldapport=(isset($_POST["serverldapport"]))?$_POST["serverldapport"]:'389';
$sql = 'UPDATE adm_config_ldap SET value='.$DB->quote($serverldapport).' WHERE parameter="LDAP_SERVER_PORT" ';
$DB->execute($sql);
if ($DB->nbAffected()==0){
	$sql = 'INSERT INTO adm_config_ldap (parameter,value,datatype,desttype) ';
	$sql.= 'VALUES ("LDAP_SERVER_PORT",'.$DB->quote($serverldapport).',"str","L") ';
	$DB->execute($sql);
}

// parametre _LDAP_DN
$dnldapuser=(isset($_POST["dnldapuser"]))?$_POST["dnldapuser"]:'ou=people,dc=univ,dc=fr';
$sql = 'UPDATE adm_config_ldap SET value='.$DB->quote($dnldapuser).' WHERE parameter="LDAP_DN" ';
$DB->execute($sql);
if ($DB->nbAffected()==0){
	$sql = 'INSERT INTO adm_config_ldap (parameter,value,datatype,desttype) ';
	$sql.= 'VALUES ("LDAP_DN",'.$DB->quote($dnldapuser).',"str","L") ';
	$DB->execute($sql);
}

// parametre _LDAP_FILTER
$ldapfilter=(isset($_POST["ldapfilter"]))?$_POST["ldapfilter"]:'';
$sql = 'UPDATE adm_config_ldap SET value='.$DB->quote($ldapfilter).' WHERE parameter="LDAP_filter" ';
$DB->execute($sql);
if ($DB->nbAffected()==0){
	$sql = 'INSERT INTO adm_config_ldap (parameter,value,datatype,desttype) ';
	$sql.= 'VALUES ("LDAP_filter",'.$DB->quote($ldapfilter).',"str","L") ';
	$DB->execute($sql);
}
$search_uid = ($ldapfilter=='') ? 'false' : 'true';
$sql = 'UPDATE adm_config_ldap SET value='.$DB->quote($search_uid).' WHERE parameter="LDAP_search_uid" ';
$DB->execute($sql);
if ($DB->nbAffected()==0){
	$sql = 'INSERT INTO adm_config_ldap (parameter,value,datatype,desttype) ';
	$sql.= 'VALUES ("LDAP_search_uid",'.$DB->quote($search_uid).',"int","L") ';
	$DB->execute($sql);
}
// parametre _LDAP_uid
$ldapuid=(isset($_POST["ldapuid"]))?$_POST["ldapuid"]:'uid';
$sql = 'UPDATE adm_config_ldap SET value='.$DB->quote($ldapuid).' WHERE parameter="LDAP_uid" ';
$DB->execute($sql);
if ($DB->nbAffected()==0){
	$sql = 'INSERT INTO adm_config_ldap (parameter,value,datatype,desttype) ';
	$sql.= 'VALUES ("LDAP_uid",'.$DB->quote($ldapuid).',"str","L") ';
	$DB->execute($sql);
}

// parametre _LDAP_cn
$ldapcn=(isset($_POST["ldapcn"]))?$_POST["ldapcn"]:'cn';
$sql = 'UPDATE adm_config_ldap SET value='.$DB->quote($ldapcn).' WHERE parameter="LDAP_cn" ';
$DB->execute($sql);
if ($DB->nbAffected()==0){
	$sql = 'INSERT INTO adm_config_ldap (parameter,value,datatype,desttype) ';
	$sql.= 'VALUES ("LDAP_cn",'.$DB->quote($ldapcn).',"str","L") ';
	$DB->execute($sql);
}

// parametre _LDAP_mail
$ldapmail=(isset($_POST["ldapmail"]))?$_POST["ldapmail"]:'mail';
$sql = 'UPDATE adm_config_ldap SET value='.$DB->quote($ldapmail).' WHERE parameter="LDAP_mail" ';
$DB->execute($sql);
if ($DB->nbAffected()==0){
	$sql = 'INSERT INTO adm_config_ldap (parameter,value,datatype,desttype) ';
	$sql.= 'VALUES ("LDAP_mail",'.$DB->quote($ldapmail).',"str","L") ';
	$DB->execute($sql);
}

// parametre _LDAP_mail
$ldapattribut=(isset($_POST["ldapattribut"]))?$_POST["ldapattribut"]:'givenname,sn';
$sql = 'UPDATE adm_config_ldap SET value='.$DB->quote($ldapattribut).' WHERE parameter="LDAP_ATTRIBUT" ';
$DB->execute($sql);
if ($DB->nbAffected()==0){
	$sql = 'INSERT INTO adm_config_ldap (parameter,value,datatype,desttype) ';
	$sql.= 'VALUES ("LDAP_ATTRIBUT",'.$DB->quote($ldapattribut).',"str","L") ';
	$DB->execute($sql);
}

// parametre _LDAP_userattr (added by portaneo)
$userattr=(isset($_POST["userattr"]))?$_POST["userattr"]:'preferredLanguage';
$sql = 'UPDATE adm_config_ldap SET value='.$DB->quote($userattr).' WHERE parameter="LDAP_userattr" ';
$DB->execute($sql);
if ($DB->nbAffected()==0){
	$sql = 'INSERT INTO adm_config_ldap (parameter,value,datatype,desttype) ';
	$sql.= 'VALUES ("LDAP_userattr",'.$DB->quote($userattr).',"str","L") ';
	$DB->execute($sql);
}

// parametre _LDAP_DNWRITE
$dnldapwriter=(isset($_POST["dnldapwriter"]))?$_POST["dnldapwriter"]:'cn=writer,ou=people,dc=univ,dc=fr';
$sql = 'UPDATE adm_config_ldap SET value='.$DB->quote($dnldapwriter).' WHERE parameter="LDAP_DNWRITE" ';
$DB->execute($sql);
if ($DB->nbAffected()==0){
	$sql = 'INSERT INTO adm_config_ldap (parameter,value,datatype,desttype) ';
	$sql.= 'VALUES ("LDAP_DNWRITE",'.$DB->quote($dnldapwriter).',"str","L") ';
	$DB->execute($sql);
}

// parametre _LDAP_PASSWRITE
$passldapwriter=(isset($_POST["passldapwriter"]))?$_POST["passldapwriter"]:'';
$sql = 'UPDATE adm_config_ldap SET value="'.base64_encode($DB->escape($passldapwriter)).'" WHERE parameter="LDAP_PASSWRITE" ';
$DB->execute($sql);
if ($DB->nbAffected()==0){
	$sql = 'INSERT INTO adm_config_ldap (parameter,value,datatype,desttype) ';
	$sql.= 'VALUES ("LDAP_PASSWRITE","'.base64_encode($DB->escape($passldapwriter)).'","str","L") ';
	$DB->execute($sql);
}

// parametre _LDAP_SERVER_WRITE
$serverldapwriter=(isset($_POST["serverldapwriter"]))?$_POST["serverldapwriter"]:'ldaps://ldap1.univ.fr';
$sql = 'UPDATE adm_config_ldap SET value='.$DB->quote($serverldapwriter).' WHERE parameter="LDAP_SERVERWRITE" ';
$DB->execute($sql);
if ($DB->nbAffected()==0){
	$sql = 'INSERT INTO adm_config_ldap (parameter,value,datatype,desttype) ';
	$sql.= 'VALUES ("LDAP_SERVERWRITE",'.$DB->quote($serverldapwriter).',"str","L") ';
	$DB->execute($sql);
}

// parametre _LDAP_GROUPMODE
$groupmode=(isset($_POST["groupmode"]))?$_POST["groupmode"]:'no';
$sql = 'UPDATE adm_config_ldap SET value='.$DB->quote($groupmode).' WHERE parameter="LDAP_GROUPMODE" ';
$DB->execute($sql);
if ($DB->nbAffected()==0){
	$sql = 'INSERT INTO adm_config_ldap (parameter,value,datatype,desttype) ';
	$sql.= 'VALUES ("LDAP_GROUPMODE",'.$DB->quote($groupmode).',"str","L") ';
	$DB->execute($sql);
}

// parametre _LDAP_DNGROUP
$dnldapgroup=(isset($_POST["dnldapgroup"]))?$_POST["dnldapgroup"]:'ou=groups,dc=univ,dc=fr';
$sql = 'UPDATE adm_config_ldap SET value='.$DB->quote($dnldapgroup).' WHERE parameter="LDAP_DNGROUP" ';
$DB->execute($sql);
if ($DB->nbAffected()==0){
	$sql = 'INSERT INTO adm_config_ldap (parameter,value,datatype,desttype) ';
	$sql.= 'VALUES ("LDAP_DNGROUP",'.$DB->quote($dnldapgroup).',"str","L") ';
	$DB->execute($sql);
}

// parametre _LDAP_FILLTERGROUP
$filterldapgroup=(isset($_POST["filterldapgroup"]))?$_POST["filterldapgroup"]:'(objectclass=groupofnames)';
$sql = 'UPDATE adm_config_ldap SET value='.$DB->quote($filterldapgroup).' WHERE parameter="LDAP_FILTERGROUP" ';
$DB->execute($sql);
if ($DB->nbAffected()==0){
	$sql = 'INSERT INTO adm_config_ldap (parameter,value,datatype,desttype) ';
	$sql.= 'VALUES ("LDAP_FILTERGROUP",'.$DB->quote($filterldapgroup).',"str","L") ';
	$DB->execute($sql);
}

//Create ldap group in db
if(isset($_POST["groupmode"]) && $_POST["groupmode"]== "yes")
{
	$sql = "SELECT id from users_group where name='LDAP' ";
	$DB->getResults($sql);
	if( $DB->nbResults() == 0 )
	{
		$sql = "INSERT INTO users_group (name,parent_id) VALUES ('LDAP',0) ";
		$DB->execute($sql);
		$sql = "SELECT id from users_group where name='LDAP' ";
		$DB->getResults($sql);
		$row = $DB->fetch(0);
		$sql = 'UPDATE adm_config_ldap SET value='.$row['id'].' WHERE parameter="LDAP_GROUPID" ';
		$DB->execute($sql);
		if ($DB->nbAffected()==0)
		{
			$sql = "INSERT INTO adm_config_ldap (parameter,value,datatype,desttype) VALUES ('LDAP_GROUPID',".$row['id'].",'int','L') ";
			$DB->execute($sql);
		}
	}
}

// --- A modifier --- pouvoir mettre en mode normal//
if( isset($_POST["authenticationmode"]) && $_POST["authenticationmode"] == "ldap")
{
// general parameter defaultAuthen
	$sql = 'UPDATE adm_config SET value='.$DB->quote($_POST["authenticationmode"]).' WHERE parameter="defaultAuthen" ';
	$DB->execute($sql);
	if ($DB->nbAffected()==0){
	        $sql = 'INSERT INTO adm_config (parameter,value,datatype,desttype) ';
	        $sql.= 'VALUES ("defaultAuthen",'.$DB->quote($_POST["authenticationmode"]).',"str","P") ';
	        $DB->execute($sql);
	}
}

if( isset($_POST["useldap"]) && $_POST["useldap"] == true ) $useldap = "true";
else $useldap = "false";
$sql = 'UPDATE adm_config SET value="'.$useldap.'" WHERE parameter="useLdap" ';
$DB->execute($sql);
if ($DB->nbAffected()==0){
        $sql = 'INSERT INTO adm_config (parameter,value,datatype,desttype) ';
        $sql.= 'VALUES ("useLdap","'.$useldap.'","int","P") ';
        $DB->execute($sql);
}

?>