<?php
/**

    class to manage tags in admin
    
    tables concerned in database
    
    search_keywords
        central table where all tags are saved
        
      Tables   for Posh objects which can be linked to tags
      
             network_keywords
             search_index
             users_articles_keywords
             notebook_article_keywords   

**/

include ("misc.inc.php");

class poshtags {

    var $DB = null;
    var $tagid = null;
    
    function poshtags ($DB) {
        $this->DB = $DB;
    }
    
    /*          
                * \brief  add a keyword in database
                *
                * @param [in]  tagname - datas
                *
                *   return  xml as string
                *
                *  \relatesalso
                *   xml_managetags.php
           */ 
    function addTag ($tagname,$datas) {
       global $module_addKeyword;
       $datas = array();     
       $str = "";
       if ($this->existsTag ($tagname,$datas)) {
           $str = "<msg>keywordExists</msg>";
       }
       else {
           //add tag in table search_keywords   
           $simpleTag=strtolower(trim(suppress_accent($tagname)));   
           $this->DB->execute($module_addKeyword,$this->DB->quote($tagname),$this->DB->quote($simpleTag));
           if ($this->DB->nbAffected()>0) {
               $str = "<msg>ok</msg>";
           }
       }
       return $str;
    }
    
    /*          
                * \brief  initialise a hash of keywords associated with id 
                *
                *   return  hash
                *
                *  \relatesalso
                *   xml_managetags.php
           */ 
    function initTagTab () {
        global $admin_getTagsList;
        $datas = array();
        $this->DB->getResults($admin_getTagsList);
        while ($row = $this->DB->fetch(0)) {
            $id = $row['id'];
            $label_simplified = $row['label_simplified'];
            $datas[$label_simplified] = $id;
        }
        $this->DB->freeResults();
        return $datas;
    }
    
    /*          
                * \brief  Get keywords list
                *
                * @param [in]  offset - limit
                *
                *   return xml in a string
                *
                *  \relatesalso
                *   xml_taglist.php
           */ 
    function listTags ($offset,$limit) {
        global $admin_getTagsList,$admin_getTagsListOffset;
        $str = "";
        $this->DB->getResults($admin_getTagsList);
        $str .= "<nbtags>".$this->DB->nbResults()."</nbtags>";
        $this->DB->getResults($admin_getTagsListOffset,$this->DB->escape($offset),$this->DB->escape($limit));
        if ($this->DB->nbResults()>0) {
            while ($row = $this->DB->fetch(0))
            {
                $id=$row['id'];
                $label=$row['label'];
                $label_simplified=$row['label_simplified'];
                $str .= "<tag>";
                $str .= "<id>".$id."</id>";
                $str .= "<label><![CDATA[".$label."]]></label>";
                $str .= "<simplified><![CDATA[".$label_simplified."]]></simplified>";
                $str .= "</tag>";
            }
            $this->DB->freeResults();
        }
        return $str;
    }
    
    /*          
                * \brief  delete tag in tables
                *
                * @param [in]  tagid
                *
                *  \relatesalso
                *   scr_managetags.php
           */ 
    function deleteTag ($tagid) {
        $str = "<msg>ok</msg>";
        $this->deleteTagin_network_keywords ($tagid) ;
        $this->deleteTagin_search_index ($tagid) ;
        $this->deleteTagin_users_articles_keywords ($tagid) ;
        $this->deleteTagin_notebook_article_keywords ($tagid) ;
        $this->deleteTagin_search_keywords ($tagid) ;
        if ($this->DB->nbAffected()==0) {
            $str = "<msg>KeywordDeleteFailure</msg>";
        }
        return $str;
    }

    function deleteTagin_network_keywords ($tagid) {
        global $admin_deleteTagInNetwork_keywords;
        $this->DB->execute($admin_deleteTagInNetwork_keywords,$this->DB->escape($tagid));
    }
    
    function deleteTagin_search_index ($tagid) {
        global $admin_deleteTagInSearch_index;
        $this->DB->execute($admin_deleteTagInSearch_index,$this->DB->escape($tagid));
    }
    
    function deleteTagin_users_articles_keywords ($tagid) {
        global $admin_deleteTagInUsers_articles_keywords;
        $this->DB->execute($admin_deleteTagInUsers_articles_keywords,$this->DB->escape($tagid));
    }
    
    function deleteTagin_notebook_article_keywords ($tagid) {
        global $admin_deleteTagInNotebook_article_keywords;
        $this->DB->execute($admin_deleteTagInNotebook_article_keywords,$this->DB->escape($tagid));
    }

    function deleteTagin_search_keywords ($tagid) {
        global $admin_deleteTagInSearch_keywords;
        $this->DB->execute($admin_deleteTagInSearch_keywords,$this->DB->escape($tagid));
    }
    
    function updateTagName ($tagid,$tagnewname) {
        global $admin_updateTagName;
        $str = "<msg>ok</msg>";
        $simpleTag=strtolower(trim(suppress_accent($tagnewname)));  
        $this->DB->execute($admin_updateTagName,$this->DB->quote($tagnewname),$this->DB->quote($simpleTag),$this->DB->escape($tagid));
        if ($this->DB->nbAffected()==0) {
            $str = "<msg>KeywordUpdateFailure</msg>";
        }
        return $str;
    }
    
    /*          
                * \brief  update a tag
                *
                * @param [in]  tagid -  tagnewname - (datas
                *
                * \relatesalso xml_managetags.php
           */ 
    function updateTag ($tagid,$tagnewname,$datas) {
        global $module_getKeyword;
        $str="<msg>ok</msg>";
        $simpleTag=strtolower(trim(suppress_accent($tagnewname)));   
        $this->DB->getResults($module_getKeyword,$this->DB->quote($simpleTag));
        if ($this->DB->nbResults()>0) {
            $row = $this->DB->fetch(0);
            $existingTagId = $row['id'];
            $this->DB->freeResults();
            $this->updateTagin_network_keywords ($tagid,$existingTagId); 
            $this->updateTagin_search_index ($tagid,$existingTagId); 
            $this->updateTagin_users_articles_keywords ($tagid,$existingTagId); 
            $this->updateTagin_notebook_article_keywords ($tagid,$existingTagId);
            $this->deleteTagin_search_keywords($tagid);
            if ($this->DB->nbAffected()==0) {
                $str = "<msg>KeywordUpdateFailure</msg>";
            }
            return $str;
        }
        else {
            return $this->updateTagName ($tagid,$tagnewname);
        }
    }
    
    function updateTagin_network_keywords ($tagid,$newtagid) {
        global $admin_updateTagInNetwork_keywords;
        $this->DB->execute($admin_updateTagInNetwork_keywords,$this->DB->escape($newtagid),$this->DB->escape($tagid));
    }
           
    function updateTagin_search_index ($tagid,$newtagid) {
        global $admin_updateTagInSearch_index;
        $this->DB->execute($admin_updateTagInSearch_index,$this->DB->escape($newtagid),$this->DB->escape($tagid));
    }
    
    function updateTagin_users_articles_keywords ($tagid,$newtagid) {
        global $admin_updateTagInUsers_articles_keywords;
        $this->DB->execute($admin_updateTagInUsers_articles_keywords,$this->DB->escape($newtagid),$this->DB->escape($tagid));
    }
    
    function updateTagin_notebook_article_keywords ($tagid,$newtagid) {
        global $admin_updateTagInNotebook_article_keywords;
        $this->DB->execute($admin_updateTagInNotebook_article_keywords,$this->DB->escape($newtagid),$this->DB->escape($tagid));
    }
    
    
    /*          
                * \brief  change in database adm_config mode  (restrictOnExistingTags)
                *
                * @param [in]  newmode (true/false)
                *
                * returns true/false
                *
                * \relatesalso xml_savetagmode.php
           */ 
    function updateModeTag ($newmode) {
        global $admin_updateModeTag;     
        $this->DB->execute($admin_updateModeTag,$this->DB->quote($newmode));
        return $newmode;
    }
    /*          
                * \brief  check if tag exists - set tag_id in $datas 
                *
                * @param [in]  tagname - datas ($datas[$tagname] = $tagid;)
                *
                * returns true id exists false if not
                *
           */     
    function existsTag ($tagname,&$datas) {
        global $module_getKeyword;    
        $tagExists = false;
        $simpleTag=strtolower(trim(suppress_accent($tagname)));        
        $this->DB->getResults($module_getKeyword,$this->DB->quote($simpleTag));
        if ($this->DB->nbResults()>0) {
            $tagExists = true;
            $row = $this->DB->fetch(0);
            $tagId = $row['id'];
            $datas[$tagname] = $tagId;
        }               
        return $tagExists;
    }
}
?>