<?php
/*
	Copyright (c) PORTANEO.

	This file is part of POSH (Portaneo Open Source Homepage) http://sourceforge.net/projects/posh/.

	POSH is free software: you can redistribute it and/or modify
	it under the terms of the GNU General Public License as published by
	the Free Software Foundation, either version 3 of the License, or
	(at your option) any later version

	POSH is distributed in the hope that it will be useful,
	but WITHOUT ANY WARRANTY; without even the implied warranty of
	MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
	GNU General Public License for more details.

	You should have received a copy of the GNU General Public License
	along with Posh.  If not, see <http://www.gnu.org/licenses/>.
*/
/* UTF8 encoding : é ô à ù */
$not_access=0;
require_once('includes.php');
require_once('../l10n/'.__LANG.'/install.lang.php');
require_once('../includes/file.inc.php');
require_once('functions.inc.php');

//require('../includes/pagegeneration.inc.php');

$seq = 1;
$col = 1;
$pos = 1;

$dirid=(__LANG=="fr") ? 2 : 3;
$totalAddedCat = 0;

$poshversion=(defined('__POSHVERSION')?__POSHVERSION:"1.0.0");

$installPosh30Home = ((isset($_POST['newhomepage']) || (I_APPLICATION_ID == '2' && __INSTALLTYPE=="2"))
						? true
						: false);

// ===========================  GET WIDGETS CONTEXT ==============================

$DB->getResults($install_getDimension,$DB->quote('dimension'));
$row = $DB->fetch(0);
$dimension = $row['value'];
$DB->freeResults();

$DB->getResults($install_getWidgetCategoryId,$DB->quote(__LANG));
if ($DB->nbResults()>0) {
    $row = $DB->fetch(0);
    $dirid = $row['id'];
    $DB->freeResults();
}

$DB->getResults($install_getMaxSeqProperties);
$row = $DB->fetch(0);
$newSeq = $row["seq"];
$DB->freeResults();

for ($i=0;$i<count($__AVLANGS);$i++)
{
    //get the cateory ID
    $DB->getResults($install_getWidgetCategoryId,$DB->quote($__AVLANGS[$i]));
    $row = $DB->fetch(0);
    $catid = $row['id'];
    $catname = $row['name'];
    $DB->freeResults();    
    //get the SEQ for this category
    $DB->getResults($install_getSeqFromLang,$DB->escape($catid));
    if ($DB->nbResults()==0) {
        $chk = $DB->execute($install_setProperties,$DB->escape($catid),$DB->escape($newSeq));
        $totalAddedCat++;
        if ($chk) {
            //$dimension.=',{"seq":"'.$newSeq.'","name":"'.$catname.'","id":'.$catid.',"lg":"'.$__AVLANGS[$i].'"}';
            $dimension.=',{"seq":"0","name":"'.$catname.'","id":'.$catid.',"lg":"'.$__AVLANGS[$i].'"}';
        }
        $newSeq++;
    } 
}
if ($totalAddedCat!=0) {
    //insert new dimension
    $DB->execute($install_updateDimension,$DB->quote($dimension),$DB->quote('dimension'));
}

$DB->execute($install_beforeWidgetInsert);

// ===========================  TABS CREATION ==============================
$installPosh30Home = ((isset($_POST['newhomepage']) || (I_APPLICATION_ID == '2' && __INSTALLTYPE=="2"))
						? true
						: false);

$homePage = 1;
$standardWidgetsTabId = 1;

// CREATE HOME TAB ONLY IF UPGRADE FROM POSH 2.X OR NEW INSTALL
if ($installPosh30Home)
{
	$sql = "
		UPDATE 	pages
		SET		seq = seq + 1
		WHERE 	group_id = 0
	";
	$DB->execute($sql);

	// CREATE MAIN TAB > Blocked	
	$sql = "
		INSERT INTO pages (group_id, name, description, position,
							type, param, seq, nbcol, showtype,
							npnb, style, modulealign, controls, icon,
							removable, showwidgetbar, directories, template)
		VALUES 				(0, '" . lg('Accueil') . "', 'Homepage example (Blocked)', '1',
							'1', '/', 1, 3, 0,
							20, 1, 'Y', 'Y', NULL,
							0, 1, NULL, 0);
	";
	$DB->execute($sql);
	
	$homePage = $DB->getId();
}

// CREATE SECONDARY TAB > Blocked
if (__INSTALLTYPE == "2"){
	$tabSeq = $installPosh30Home ? 2 : 1;
	$sql = "
		INSERT INTO pages (group_id, name, description, position,
							type, param, seq, nbcol, showtype,
							npnb, style, modulealign, controls, icon,
							removable, showwidgetbar, directories, template)
		VALUES 				(0, '" . lg('modules') . "', 'Widget page example', '1',
							'1', '/', " . $tabSeq . ", 3, 0,
							20, 1, 'Y', 'Y', NULL,
							1, 1, NULL, 7);
	";
	$DB->execute($sql);
	$standardWidgetsTabId = $DB->getId();
}



// ===========================  ADD CORE WIDGETS ==============================

// CREATE NEW WIDGETS WITH POSH 3.0
if (version_compare($poshversion, "3.0.0a1", "<"))
{
	
	if (I_APPLICATION_ID == '2')
	{
		// SOCIAL UPDATES
		$sql = "
			INSERT INTO dir_item (id, url, defvar, name, description, typ, status, format, height, minwidth, sizable, website, editor_id, nbvariables, creation_date, lastmodif_date, notation, voter_nb, updated, nbusers, sorting, lang, usereader, autorefresh, views, icon, l10n, hidden, average_rating, total_rating, sum_rating, group_access) VALUES
			(1001, '../modules/p_social_updates.php?', '', '" . lg('discussions') . "', '', 'P', 'O', 'M', 246, 380, '1', 'portaneo.com/', 1, 1, '2010-07-07', '2010-07-07', 0, 0, 'Y', 0, 0, 'fr', 0, 0, '0', '', NULL, 1, 0, 0, 0, '0');
		";
		$DB->execute($sql);
		$sql = "
			INSERT INTO dir_cat_item (item_id, category_id, first)
			VALUES (1001, 2, 'Y');
		";
		$DB->execute($sql);
	}
	
	// FIRST START
	$sql = "
		INSERT INTO dir_item (id, url, defvar, name, description, typ, status, format, height, minwidth, sizable, website, editor_id, nbvariables, creation_date, lastmodif_date, notation, voter_nb, updated, nbusers, sorting, lang, usereader, autorefresh, views, icon, l10n, hidden, average_rating, total_rating, sum_rating, group_access) VALUES
		(1006, '../modules/p_firststart.php?', '', '" . lg('lblFirstUsage') . "', '', 'P', 'O', 'M', 246, 280, '1', 'portaneo.com/', 1, 1, '2010-07-07', '2010-07-07', 0, 0, 'Y', 0, 0, 'fr', 0, 0, '0', '', NULL, 1, 0, 0, 0, '0');
	";
	$DB->execute($sql);
	$sql = "
		INSERT INTO dir_cat_item (item_id, category_id, first)
		VALUES (1006, 2, 'Y');
	";
	$DB->execute($sql);
	
	if (I_APPLICATION_ID == '2')
	{
		// SOCIAL ALERTS
		$sql = "
			INSERT INTO dir_item (id, url, defvar, name, description, typ, status, format, height, minwidth, sizable, website, editor_id, nbvariables, creation_date, lastmodif_date, notation, voter_nb, updated, nbusers, sorting, lang, usereader, autorefresh, views, icon, l10n, hidden, average_rating, total_rating, sum_rating, group_access) VALUES
			(1002, '../modules/p_social_alerts.php?', '', '" . lg('alerts') . "', '', 'P', 'O', 'M', 246, 280, '1', 'portaneo.com/', 1, 1, '2010-07-07', '2010-07-07', 0, 0, 'Y', 0, 0, 'fr', 0, 0, '0', '', NULL, 1, 0, 0, 0, '0');
		";
		$DB->execute($sql);
		$sql = "
			INSERT INTO dir_cat_item (item_id, category_id, first)
			VALUES (1002, 2, 'Y');
		";
		$DB->execute($sql);
	
		// // SOCIAL MESSAGING
		// $sql = "
			// INSERT INTO dir_item (id, url, defvar, name, description, typ, status, format, height, minwidth, sizable, website, editor_id, nbvariables, creation_date, lastmodif_date, notation, voter_nb, updated, nbusers, sorting, lang, usereader, autorefresh, views, icon, l10n, hidden, average_rating, total_rating, sum_rating, group_access) VALUES
			// (1004, '../modules/p_social_sendmessage.php?', '', '" . lg('communicate') . "', '', 'P', 'O', 'M', 246, 380, '1', 'portaneo.com/', 1, 1, '2010-07-07', '2010-07-07', 0, 0, 'Y', 0, 0, 'fr', 0, 0, '0', '', NULL, 1, 0, 0, 0, '0');
		// ";
		// $DB->execute($sql);
		// $sql = "
			// INSERT INTO dir_cat_item (item_id, category_id, first)
			// VALUES (1004, 2, 'Y');
		// ";
		// $DB->execute($sql);
		// SOCIAL NETWORK
		$sql = "
			INSERT INTO dir_item (id, url, defvar, name, description, typ, status, format, height, minwidth, sizable, website, editor_id, nbvariables, creation_date, lastmodif_date, notation, voter_nb, updated, nbusers, sorting, lang, usereader, autorefresh, views, icon, l10n, hidden, average_rating, total_rating, sum_rating, group_access) VALUES
			(1007, '../modules/p_social_network.php?', '', '" . lg('myNetwork') . "', '', 'P', 'O', 'M', 246, 280, '1', 'portaneo.com/', 1, 1, '2010-07-07', '2010-07-07', 0, 0, 'Y', 0, 0, 'fr', 0, 0, '0', '', NULL, 1, 0, 0, 0, '0');
		";
		$DB->execute($sql);
		$sql = "
			INSERT INTO dir_cat_item (item_id, category_id, first)
			VALUES (1007, 2, 'Y');
		";
		$DB->execute($sql);
	}

	// RSS SUMMARY
	$sql = "
		INSERT INTO dir_item (id, url, defvar, name, description, typ, status, format, height, minwidth, sizable, website, editor_id, nbvariables, creation_date, lastmodif_date, notation, voter_nb, updated, nbusers, sorting, lang, usereader, autorefresh, views, icon, l10n, hidden, average_rating, total_rating, sum_rating, group_access) VALUES
		(1003, '../modules/p_pages_rsssummary.php?', '', '" . lg('youModsRSS') . "', '', 'P', 'O', 'M', 246, 280, '1', 'portaneo.com/', 1, 1, '2010-07-07', '2010-07-07', 0, 0, 'Y', 0, 0, 'fr', 0, 0, '0', '', NULL, 1, 0, 0, 0, '0');
	";
	$DB->execute($sql);
	$sql = "
		INSERT INTO dir_cat_item (item_id, category_id, first)
		VALUES (1003, 2, 'Y');
	";
	$DB->execute($sql);

	// HELP MESSAGE
	$sql = "
		INSERT INTO dir_item (id, url, defvar, name, description, typ, status, format, height, minwidth, sizable, website, editor_id, nbvariables, creation_date, lastmodif_date, notation, voter_nb, updated, nbusers, sorting, lang, usereader, autorefresh, views, icon, l10n, hidden, average_rating, total_rating, sum_rating, group_access) VALUES
		(1005, '../modules/p_helpmessages.php?', '', '" . lg('Tips') . "', '', 'P', 'O', 'M', 246, 280, '1', 'portaneo.com/', 1, 1, '2010-07-07', '2010-07-07', 0, 0, 'Y', 0, 0, 'fr', 0, 0, '0', '', NULL, 1, 0, 0, 0, '0');
	";
	$DB->execute($sql);
	$sql = "
		INSERT INTO dir_cat_item (item_id, category_id, first)
		VALUES (1005, 2, 'Y');
	";
	$DB->execute($sql);
}

// NOTES
if (isset($_POST["notes"])){
	$DB->sql = "INSERT INTO dir_item (id,url,defvar,name,description,typ,status,format,height,minwidth,sizable,website,editor_id,nbvariables,creation_date,lastmodif_date,notation,voter_nb,updated,nbusers,sorting,lang,usereader,autorefresh) VALUES (84, '../modules/p_notes.php?', NULL, '".lg("notes")."', '".lg("notesdesc")."', 'P', 'O', 'M', 246, 280, '1', 'portaneo.net/', 1, 1, '2005-09-29', '2006-04-20', 0, 0, 'Y', 0, 0, '".__LANG."',0,0) ";
	$DB->execute($DB->sql);
	$DB->sql = "INSERT INTO dir_cat_item (item_id,category_id,first) VALUES (84,".$dirid.",'Y') ";
	$DB->execute($DB->sql);
}
// RSS READER
if (isset($_POST["rssreader"])){
	$DB->sql = "INSERT INTO dir_item (id,url,defvar,name,description,typ,status,format,height,minwidth,sizable,website,editor_id,nbvariables,creation_date,lastmodif_date,notation,voter_nb,updated,nbusers,sorting,lang,usereader,autorefresh) VALUES (86, '../modules/p_rss.php?', 'nb=5', '".lg("rssreader")."', '".lg("rssreaderdesc")."', 'P', 'O', 'R', 246, 280, '1', 'portaneo.net/', 1, 2, '2005-10-03', '2006-04-20', 0, 0, 'Y', 0, 0, '".__LANG."',1,1) ";
	$DB->execute($DB->sql);
}



// ===========================  ADD STANDARD WIDGETS ==============================
	
// BOOKMARK WIDGET
if (isset($_POST["favorites"])){
	$DB->sql = "INSERT INTO dir_item (id,url,defvar,name,description,typ,status,format,height,minwidth,sizable,website,editor_id,nbvariables,creation_date,lastmodif_date,notation,voter_nb,updated,nbusers,sorting,lang,usereader,autorefresh) VALUES (85, '../modules/p_links.php?', NULL, '".lg("favorites")."', '".lg("favoritesdesc")."', 'P', 'O', 'M', 246, 280, '1', 'portaneo.net/', 1, 0, '2005-09-29', '2006-04-20', 0, 0, 'Y', 0, 0, '".__LANG."',0,0) ";
	$DB->execute($DB->sql);
	$DB->sql = "INSERT INTO dir_cat_item (item_id,category_id,first) VALUES (85,".$dirid.",'Y') ";
	$DB->execute($DB->sql);
}

// TASKS MANAGEMENT
if (isset($_POST["tasks"])){
	$DB->sql = "INSERT INTO dir_item (id,url,defvar,name,description,typ,status,format,height,minwidth,sizable,website,editor_id,nbvariables,creation_date,lastmodif_date,notation,voter_nb,updated,nbusers,sorting,lang,usereader,autorefresh) VALUES (295, '../modules/p_task.php?', '', '".lg("tasks")."', '".lg("taskdesk")."', 'P', 'O', 'M', 100, 200, '1', 'portaneo.net', 1, 0, '2006-10-27', '2006-10-27', 0, 0, 'Y', 0, 0, '".__LANG."',0,0) ";
	$DB->execute($DB->sql);
	$DB->sql = "INSERT INTO dir_cat_item (item_id,category_id,first) VALUES (295,".$dirid.",'Y') ";
	$DB->execute($DB->sql);
}

// CLOCKS
if (isset($_POST["clock"])){
	$DB->sql = "INSERT INTO dir_item (id,url,defvar,name,description,typ,status,format,height,minwidth,sizable,website,editor_id,nbvariables,creation_date,lastmodif_date,notation,voter_nb,updated,nbusers,sorting,lang,usereader,autorefresh) VALUES (152, '../modules/ptime.html?', NULL, '".lg("clock")."', '".lg("clockdesc")."', 'P', 'O', 'I', 26, 280, '1', 'portaneo.net', 1, 0, '2006-02-08', '2006-07-20', 0, 0, 'Y', 0, 0, '".__LANG."',0,0) ";
	$DB->execute($DB->sql);
	$DB->sql = "INSERT INTO dir_cat_item (item_id,category_id,first) VALUES (152,".$dirid.",'Y') ";
	$DB->execute($DB->sql);
}
if (isset($_POST["analogclock"])){
	$DB->sql = "INSERT INTO dir_item (id,url,defvar,name,description,typ,status,format,height,minwidth,sizable,website,editor_id,nbvariables,creation_date,lastmodif_date,notation,voter_nb,updated,nbusers,sorting,lang,usereader,autorefresh) VALUES (340, '../modules/clock.html?', NULL, '".lg("analogc")."', '".lg("analogcdesc")."', 'P', 'O', 'I', 100, 200, '1', 'portaneo.com', 1, 0, '2007-02-08', '2007-02-08', 0, 0, 'Y', 0, 0, '".__LANG."',0,0) ";
	$DB->execute($DB->sql);
	$DB->sql = "INSERT INTO dir_cat_item (item_id,category_id,first) VALUES (340,".$dirid.",'Y') ";
	$DB->execute($DB->sql);
}

// CALCULATOR
if (isset($_POST["calculator"])){
	$DB->sql = "INSERT INTO dir_item (id,url,defvar,name,description,typ,status,format,height,minwidth,sizable,website,editor_id,nbvariables,creation_date,lastmodif_date,notation,voter_nb,updated,nbusers,sorting,lang,usereader,autorefresh) VALUES (111, '../modules/pcalc.html?', NULL, '".lg("calc")."', '".lg("calcdesc")."', 'P', 'O', 'I', 102, 336, '1', 'portaneo.com', 1, 0, '2006-02-08', '2006-07-20', 0, 0, 'Y', 0, 0, '".__LANG."',0,0) ";
	$DB->execute($DB->sql);
	$DB->sql = "INSERT INTO dir_cat_item (item_id,category_id,first) VALUES (111,".$dirid.",'Y') ";
	$DB->execute($DB->sql);
}

// AGENDA
if (isset($_POST["calendar"])){
	$DB->sql = "INSERT INTO dir_item (id,url,defvar,name,description,typ,status,format,height,minwidth,sizable,website,editor_id,nbvariables,creation_date,lastmodif_date,notation,voter_nb,updated,nbusers,sorting,lang,usereader,autorefresh,views) VALUES (112, '../modules/p_calendar.php?', NULL, '".lg("calendar")."', '".lg("calendardesc")."', 'P', 'O', 'M', 246, 280, '1', 'portaneo.com/', 1, 0, '2007-03-29', '2007-03-29', 0, 0, 'Y', 0, 0, '".__LANG."',0,0,'home,canvas') ";
	$DB->execute($DB->sql);
	$DB->sql = "INSERT INTO dir_cat_item (item_id,category_id,first) VALUES (112,".$dirid.",'Y') ";
	$DB->execute($DB->sql);
}

//EMAIL
if (isset($_POST["email"])){
	$DB->sql = "INSERT INTO dir_item (id,url,defvar,name,description,typ,status,format,height,minwidth,sizable,website,editor_id,nbvariables,creation_date,lastmodif_date,notation,voter_nb,updated,nbusers,sorting,lang,usereader,autorefresh) VALUES (350, '../modules/p_mail.php?', NULL, '".lg("email")."', '".lg("emaildesc")."', 'P', 'O', 'M', 100, 280, '1', 'portaneo.com/', 1, 0, '2007-04-15', '2007-04-15', 0, 0, 'Y', 0, 0, '".__LANG."',0,1) ";
	$DB->execute($DB->sql);
	$DB->sql = "INSERT INTO dir_cat_item (item_id,category_id,first) VALUES (350,".$dirid.",'Y') ";
	$DB->execute($DB->sql);	
}

// ADDRESS BOOK
if (isset($_POST["addressbook"])){
	$DB->sql = 'INSERT INTO dir_item (id,url,defvar,name,description,typ,status,format,height,minwidth,sizable,website,editor_id,nbvariables,creation_date,lastmodif_date,notation,voter_nb,updated,nbusers,sorting,lang,usereader,autorefresh) VALUES (401, "../modules/p_addressbook.php?", NULL, "'.lg("addressbook").'", "", "P", "O", "M", 100, 280, "1", "portaneo.com/", 1, 0, "2008-04-01", "2008-04-01", 0, 0, "Y", 0, 0, "'.__LANG.'",0,0) ';
	$DB->execute($DB->sql);
	$DB->sql = "INSERT INTO dir_cat_item (item_id,category_id,first) VALUES (401,".$dirid.",'Y') ";
	$DB->execute($DB->sql);
}

// HTML ADVERTISEMENT
if (isset($_POST["html"])){
	$DB->sql = 'INSERT INTO dir_item (id,url,defvar,name,description,typ,status,format,height,minwidth,sizable,website,editor_id,nbvariables,creation_date,lastmodif_date,notation,voter_nb,updated,nbusers,sorting,lang,usereader,autorefresh,hidden) VALUES (402, "../modules/p_html.php?", NULL, "'.lg("htmlWidgetTitle").'", "", "P", "O", "M", 100, 280, "1", "portaneo.com/", 1, 0, "2008-07-01", "2008-07-01", 0, 0, "Y", 0, 0, "'.__LANG.'",0,0,1) ';
	$DB->execute($DB->sql);
	$DB->sql = "INSERT INTO dir_cat_item (item_id,category_id,first) VALUES (402,".$dirid.",'Y') ";
	$DB->execute($DB->sql);
}

$DB->execute($install_afterWidgetInsert);

// ===========================  ADD WIDGETS IN PAGES ==============================

if ($installPosh30Home)
{
	$sql = "
		INSERT INTO pages_module (item_id,page_id,posx,posy,posj,variables,uniq,blocked)
		VALUES (1001," . $homePage . ",".$col.",".$pos.",".$seq.",'',".$seq.",2)
	";
	$DB->execute($sql);
	$seq++;
	if ($col==3){$col=1;$pos++;} else {$col++;}
	
	$sql = "
		INSERT INTO pages_module (item_id,page_id,posx,posy,posj,variables,uniq,blocked)
		VALUES (1005," . $homePage . ",".$col.",".$pos.",".$seq.",'',".$seq.",0)
	";
	$DB->execute($sql);
	$seq++;
	if ($col==3){$col=1;$pos++;} else {$col++;}
	$sql = "
		INSERT INTO pages_module (item_id,page_id,posx,posy,posj,variables,uniq,blocked)
		VALUES (1002," . $homePage . ",".$col.",".$pos.",".$seq.",'',".$seq.",2)
	";
	$DB->execute($sql);
	$seq++;
	if ($col==3){$col=1;$pos++;} else {$col++;}
	$sql = "
		INSERT INTO pages_module (item_id,page_id,posx,posy,posj,variables,uniq,blocked)
		VALUES (1007," . $homePage . ",".$col.",".$pos.",".$seq.",'',".$seq.",2)
	";
	$DB->execute($sql);
	$seq++;
	if ($col==3){$col=1;$pos++;} else {$col++;}
	$sql = "
		INSERT INTO pages_module (item_id,page_id,posx,posy,posj,variables,uniq,blocked)
		VALUES (1006," . $homePage . ",".$col.",".$pos.",".$seq.",'',".$seq.",0)
	";
	$DB->execute($sql);
	$seq++;

	if ($col==3){$col=1;$pos++;} else {$col++;}
	$sql = "
		INSERT INTO pages_module (item_id,page_id,posx,posy,posj,variables,uniq,blocked)
		VALUES (1003," . $homePage . ",".$col.",".$pos.",".$seq.",'',".$seq.",0)
	";
	$DB->execute($sql);
	$seq++;
	if ($col==3){$col=1;$pos++;} else {$col++;}
}
if (__INSTALLTYPE=="2"){
	//	Notes always on tab 1
	if (isset($_POST["notes"])){
		$DB->sql = "
			INSERT INTO pages_module (item_id,page_id,posx,posy,posj,variables,uniq) 
			VALUES (84," . $homePage . ",".$col.",".$pos.",".$seq.",'',".$seq.")
		";
		$DB->execute($DB->sql);
		$seq++;
		if ($col==1){$col=1;$pos++;} else {$col++;}
	}

	// if 2 tabs, reinitialize tab information
	if ($homePage != $standardWidgetsTabId)
	{
		$seq = 1;
		$col = 1;
		$pos = 1;
	}
	
	if (isset($_POST["favorites"])){
		$DB->sql = "
			INSERT INTO pages_module (item_id,page_id,posx,posy,posj,variables,uniq)
			VALUES (85," . $standardWidgetsTabId . ",".$col.",".$pos.",".$seq.",'',".$seq.")
		";
		$DB->execute($DB->sql);
		$seq++;
		if ($col==3){$col=1;$pos++;} else {$col++;}
	}
	if (isset($_POST["tasks"])){
		$DB->sql = "
			INSERT INTO pages_module (item_id,page_id,posx,posy,posj,variables,uniq)
			VALUES (295," . $standardWidgetsTabId . ",".$col.",".$pos.",".$seq.",'',".$seq.")
		";
		$DB->execute($DB->sql);
		$seq++;
		if ($col==3){$col=1;$pos++;} else {$col++;}
	}
	if (isset($_POST["clock"])){
		$DB->sql = "
			INSERT INTO pages_module (item_id,page_id,posx,posy,posj,variables,uniq)
			VALUES (152," . $standardWidgetsTabId . ",".$col.",".$pos.",".$seq.",'',".$seq.")
		";
		$DB->execute($DB->sql);
		$seq++;
		if ($col==3){$col=1;$pos++;} else {$col++;}
	}
	if (isset($_POST["analogclock"])){
		$DB->sql = "
			INSERT INTO pages_module (item_id,page_id,posx,posy,posj,variables,uniq)
			VALUES (340," . $standardWidgetsTabId . ",".$col.",".$pos.",".$seq.",'',".$seq.")
		";
		$DB->execute($DB->sql);
		$seq++;
		if ($col==3){$col=1;$pos++;} else {$col++;}
	}
	if (isset($_POST["calculator"])){
		$DB->sql = "
			INSERT INTO pages_module (item_id,page_id,posx,posy,posj,variables,uniq)
			VALUES (111," . $standardWidgetsTabId . ",".$col.",".$pos.",".$seq.",'',".$seq.")
		";
		$DB->execute($DB->sql);
		$seq++;
		if ($col==3){$col=1;$pos++;} else {$col++;}
	}
	if (isset($_POST["calendar"])){
		$DB->sql = "
			INSERT INTO pages_module (item_id,page_id,posx,posy,posj,variables,uniq)
			VALUES (112," . $standardWidgetsTabId . ",".$col.",".$pos.",".$seq.",'',".$seq.")
		";
		$DB->execute($DB->sql);
		$seq++;
		if ($col==3){$col=1;$pos++;} else {$col++;}
	}
	if (isset($_POST["addressbook"])){
		$DB->sql = "
			INSERT INTO pages_module (item_id,page_id,posx,posy,posj,variables,uniq)
			VALUES (401," . $standardWidgetsTabId . ",".$col.",".$pos.",".$seq.",'',".$seq.")
		";
		$DB->execute($DB->sql);
		$seq++;
		if ($col==3){$col=1;$pos++;} else {$col++;}
	}
	if (isset($_POST["email"])){
		$DB->sql = "
			INSERT INTO pages_module (item_id,page_id,posx,posy,posj,variables,uniq)
			VALUES (350," . $standardWidgetsTabId . ",".$col.",".$pos.",".$seq.",'',".$seq.")
		";
		$DB->execute($DB->sql);
		$seq++;
		if ($col==3){$col=1;$pos++;} else {$col++;}
	}
}

// ===========================  APPLY POSH 3.0 TO USERS PROFILES ==============================
if ($installPosh30Home)
{
	//Increase seq in user portal
	$sql = "
		UPDATE 	profile
		SET		seq = seq + 1
	";
	$DB->execute($sql);

	// Apply home tab to all users
	$sql = "
		INSERT INTO profile (user_id, name, type, param, seq,
                        width, showtype, nbnews, style, modulealign,
						controls, icon, removable, showwidgetbar, template,
                        creation_date, modif_date, height, lang, def, refresh,
						md5pass, shared)
		SELECT 		u.id, p.name, p.type, p.param, 1,
					p.nbcol, p.showtype, p.npnb, p.style, p.modulealign,
					p.controls, p.icon, p.removable, p.showwidgetbar, p.template,
					CURRENT_DATE, CURRENT_DATE, 1, '" . __LANG . "', 'N', 0,
					'',''
		FROM		users AS u
			INNER JOIN pages AS p
		WHERE		p.seq = 1
			AND		group_id = 0
	";
	$DB->execute($sql);

	// Apply home widgets to all users
	$sql = "
		INSERT INTO module (item_id, user_id, profile_id, posx, posy,
						posj, x, y, typ, variables,
						uniq, blocked, minimized)
		SELECT	m.item_id, p.user_id, p.id, m.posx, m.posy,
				m.posj, m.x, m.y, 'D', m.variables,
				m.uniq, m.blocked, m.minimized
		FROM	pages_module AS m
			INNER JOIN pages AS pa
				ON pa.id = m.page_id
			INNER JOIN profile AS p
		WHERE	p.seq = 1
			AND pa.seq = 1
			AND pa.group_id = 0
	";
	$DB->execute($sql);
	
	// Remove the old home page
	$sql = "
		UPDATE 	adm_config
		SET		value = ''
		WHERE 	parameter = 'homeDivs'
	";
	$DB->execute($sql);
}




$DB->execute($install_setStep5);



//generate config file
generateConfigFile(false,"","","","");

$DB->close();

header("location:step5.php");
?>