<?php
# ************** LICENCE ****************
/*
	Copyright (c) PORTANEO.

	This file is part of POSH (Portaneo Open Source Homepage) http://sourceforge.net/projects/posh/.

	POSH is free software: you can redistribute it and/or modify
	it under the terms of the GNU General Public License as published by
	the Free Software Foundation, either version 3 of the License, or
	(at your option) any later version

	POSH is distributed in the hope that it will be useful,
	but WITHOUT ANY WARRANTY; without even the implied warranty of
	MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
	GNU General Public License for more details.

	You should have received a copy of the GNU General Public License
	along with Posh.  If not, see <http://www.gnu.org/licenses/>.
*/
# ***************************************
# Notes modules PHP scripts
#
# !! be careful, this file must be saved under uft8 format, and display an e accentuated here : é
# ***************************************

header("content-type: application/xml");
error_reporting(0); // error message make the xml unreadable - do not remove except for debug

$folder     = "";
$not_access = 1;
$pagename   = "modules/wid_mail.php";
$granted    = "I,N";

//includes
require_once('includes.php');
require_once('../includes/xml.inc.php');

//MR ajout à Posh pour améliorer l'aperçu des mails
function decodeMimeStr($string, $charset="UTF-8" )
				{
					  $newString = '';
					  $elements=imap_mime_header_decode($string);
					  for($i=0;$i<count($elements);$i++)
					  {
						if ($elements[$i]->charset == 'default')
						  $elements[$i]->charset = 'iso-8859-1';
						$newString .= iconv($elements[$i]->charset, $charset, $elements[$i]->text);
					  }
					  return $newString;
			}	
function get_mime_type(&$structure) {
   $primary_mime_type = array("TEXT", "MULTIPART","MESSAGE", "APPLICATION", "AUDIO","IMAGE", "VIDEO", "OTHER");
   if($structure->subtype) {
   	return $primary_mime_type[(int) $structure->type] . '/' .$structure->subtype;
   }
   	return "TEXT/PLAIN";
}
function get_part($stream, $msg_number, $mime_type, $structure = false,$part_number    = false) {
   
   	if(!$structure) {
   		$structure = imap_fetchstructure($stream, $msg_number);
   	}
   	if($structure) {
   		if($mime_type == get_mime_type($structure)) {
   			if(!$part_number) {
   				$part_number = "1";
   			}
   			$text = imap_fetchbody($stream, $msg_number, $part_number);
   			if($structure->encoding == 3) {
   				return imap_base64($text);
   			} else if($structure->encoding == 4) {
   				return imap_qprint($text);
   			} else {
   			return $text;
   		}
   	}
   
		if($structure->type == 1) /* multipart */ {
   		while(list($index, $sub_structure) = each($structure->parts)) {
   			if($part_number) {
   				$prefix = $part_number . '.';
   			}
   			$data = get_part($stream, $msg_number, $mime_type, $sub_structure,$prefix .    ($index + 1));
   			if($data) {
   				return $data;
   			}
   		} 
   		} 
   	} 
   	return false;
} 


$xmlfile = new xmlFile();

$xmlfile->header("channel");

$act = $_REQUEST["act"];

/**protocols where /notls is needed or not**/
/**  default port: IMAP **/
$mail_params = array(
                '/pop3'         => array (
                                        'port'  => '110',
                                        'tls'   => "/notls"
                                    ),
                '/imap'              => array ( 
                                        'port'  => '143',
                                        'tls'   => "/notls"                                    
                                   ),
                ''              => array ( 
                                        'port'  => '143',
                                        'tls'   => "/notls"                                    
                                   ),
                '/imap/ssl'   => array(
                                        'port'  => '993',
                                        'tls'   => ""                
                                        ),
                '/pop3/ssl/novalidate-cert'   => array(
                                        'port'  => '995',
                                        'tls'   => ""                
                                                      )
            );


if ($act == "check")
{
	#define ("SQLTEST",1); 
	$DB->getResults($widmail_checkProvider,
                                $DB->quote($_REQUEST["provider"])
                    );
        
    if ($DB->nbResults()!=0)
	{
		$row=$DB->fetch(0);
		echo "<provider>".$row["provider"]."</provider>";
		echo "<webmail>".$row["webmail"]."</webmail>";
		echo "<server>".$row["serveur"]."</server>";
		echo "<port>".$row["port"]."</port>";
		echo "<protocol>".$row["protocole"]."</protocol>";
		echo "<extension>".$row["extension"]."</extension>";
	}
	$DB->freeResults();
}

if ($act == "conf")
{
    /* check if account exists or not before creates it , it would be better use unique index, but cannot be added without risk on old databases **/
  
    //Modification 
	//Supprimer vérification du mot de passe
	//Ne pas tester le pass car KEY a pu changer ( reconfigure )
    $widmail_isExistAccount2 = "
        SELECT  id,
                username
        FROM    users_mail
        WHERE   username = %s
            AND user_id = %u
            AND serveur = %s
            AND port = %s
            ";
	#define ("SQLTEST",1); 
    $DB->getResults($widmail_isExistAccount2,
                      $DB->quote(str_replace( $_POST["extension"],"", $_POST["user"])),
                      $DB->escape($_SESSION['user_id']),
                      $DB->quote($_POST["server"]),
                      $DB->quote(":".$_POST["port"])//MR,
                     //MR $DB->quote($_POST['pass']),
                     //MR __KEY
                ); 
    
    //aucun compte, le creer
    if (  $DB->nbResults() == 0 ) 
    {
        $protocol = $_POST["protocol"];
        if (  empty($_POST["port"]) )
        { 
            $port = $mail_params[$protocol]['port']; 
        } else {
            $port = $_POST["port"];
        }
        $DB->execute($widmail_configure,
                        $DB->escape($_SESSION['user_id']),
                        $DB->quote($_POST["provider"]),
                        $DB->noHTML($_POST["webmail"]),
                        $DB->quote($_POST["server"]),
                        $DB->quote(":".$port),
                        $DB->quote($_POST["protocol"]),
                        $DB->quote(str_replace( $_POST["extension"],"", $_POST["user"])),
                        $DB->quote($_POST["pass"]),
                        __KEY
                );
            
        echo "<id>".$DB->getId()."</id>"; 
    } else {

	//ajout maj mot de passe
	$widmail_update = "
		UPDATE users_mail 
			set pass=AES_ENCRYPT(%s,'%s'),
				webmail = %s,
				provider = %s
		WHERE   username = %s
				AND user_id = %u
				AND serveur = %s
				AND port = %s
            ";

        $row = $DB->fetch(0);
		$DB->freeResults();
		
		$protocol = $_POST["protocol"];
        if (  empty($_POST["port"]) )
        { 
            $port = $mail_params[$protocol]['port']; 
        } else {
            $port = $_POST["port"];
        }
		//ajout maj mot de passe
		#define ("SQLTEST",1); 
		if( $DB->execute($widmail_update,
						$DB->quote($_POST["pass"]),
						__KEY ,
						$DB->quote($_POST["webmail"]),
						$DB->quote($_POST["provider"]),
						$DB->quote(str_replace( $_POST["extension"],"", $_POST["user"])),
                        $DB->escape($_SESSION['user_id']),
                        $DB->quote($_POST["server"]),
                        $DB->quote(":".$port)
                )
			)	
			echo "<id>".$row['id']."</id>" ;
		else  
			echo "<error>erreur au changement de mot de passe</error>" ;
		
    }
	
}

if ($act == "get")
{
	$nbaccount=0;
	$DB->getResults($widmail_getMailInfo,
                            __KEY,
                            $DB->escape($_POST["id"]),
                            $DB->escape($_SESSION['user_id'])
                    ); 
	if ($DB->nbResults()==0)
	{
		echo "<number>-1</number>";
	}
	else
	{
	
		$row = $DB->fetch(0);
		//error_log(__FILE__.__LINE__." get ".print_r($row,1)."\r\n",3,'/tmp/o.log');
		$nbaccount++;
        
        
		//check if imap is configured
		if (!function_exists('imap_open'))
		{
			echo "<number>-1</number><debug><![CDATA[Imap is not configured on your server]]></debug>";
		}
		else
		{
            
            $protocol = $row["protocole"];
            $notls = $mail_params[$protocol]['tls']; 
             
            #error_log(__FILE__."@imap_open({".$row["serveur"].$row["port"].$row["protocole"]."$notls}INBOX". $row["username"].",". $row["dpass"]."\r\n", 3,'/tmp/widmail.log');
			
			if ($mail_cnx = @imap_open ("{".$row["serveur"].$row["port"].$row["protocole"]."$notls}INBOX", $row["username"], $row["dpass"], OP_SILENT) )
			{
				$nbMail=@imap_num_msg($mail_cnx);
				$nbunread=@imap_num_recent($mail_cnx);

				echo "<number>".$nbMail."</number>";
				echo "<unread>".$nbunread."</unread>";
				echo "<webmail><![CDATA[".$row["webmail"]."]]></webmail>";

				$nbToDisplay = (isset($_POST["nb"]) ? $_POST["nb"] : 5) + 1;
                $start = (isset($_POST["start"]) ?$_POST["start"] : 0);
                $lastToGet = $nbMail - $start;
				$firstToGet = $lastToGet > $nbToDisplay ? $lastToGet - $nbToDisplay : 0;

				for ($i = $lastToGet; $i != $firstToGet; $i--)
				{
					if ($entetes = @imap_header($mail_cnx, $i))
					{
						echo "<mail>";
						echo "<id>".$i."</id>";
						echo "<subject><![CDATA[".imap_utf8($entetes->subject)."]]></subject>";
						echo "<sender><![CDATA[".$entetes->fromaddress."]]></sender>";
						echo "<status><![CDATA[".$entetes->Recent."]]></status>";
						echo "</mail>";
					}
				}
			}
			else
			{       
				echo "<error>(".print_r(imap_errors()).")</error><number>-1</number>";
				echo "<debug><![CDATA[Can not initialize connection with server=".$row["serveur"].",port=".$row["port"].",protocol=".$row["protocole"].",username=".$row["username"]." in wid_mail.php. Errors :".print_r(imap_errors())."]]></debug>";
			}
		}
	}
	if ($mail_cnx) @imap_close($mail_cnx);

	$DB->freeResults();
}
// read an email
if ($act=="read")
{
	## Rappel:
	## $widmail_getMailInfo = "
	##     SELECT  serveur,
	##             port,
	##             protocole,
	##             username,
	##             AES_DECRYPT(pass,'%s') AS dpass,
	##             webmail
	##     FROM    users_mail
	##     WHERE   id = %u
	##         AND user_id = %u
	## ";

	$DB->getResults($widmail_getMailInfo,
                        __KEY,
                        $DB->escape($_POST["id"]),
                        $DB->escape($_SESSION['user_id'])
                    );
	if ($DB->nbResults()==0)
	{
		echo "<number>-1</number>";
	}
	else
	{	
		//error_log(__FILE__.__LINE__." read ".print_r($row,1)."\r\n",3,'/tmp/o.log');
		$row = $DB->fetch(0);
        $protocol = $row["protocole"];
        $notls = $mail_params[$protocol]['tls']; 
		if ($mail_cnx = @imap_open ("{".$row["serveur"].$row["port"].$row["protocole"]."$notls}INBOX", $row["username"], $row["dpass"], OP_SILENT) )
		{
			//Améliorer l'affichage minimal des messages
			//$message=@imap_fetchbody($mail_cnx, $_POST["messid"],"1");
			$dataTxt = get_part($mail_cnx, $_POST["messid"], "TEXT/PLAIN");
			$dataHtml = get_part($mail_cnx, $_POST["messid"], "TEXT/HTML");
			
			if ($dataHtml != "") {
				$msgBody = $dataHtml;
				$mailformat = "html";
			} else {
				$msgBody = preg_replace("\n","<br>",$dataTxt);
				$mailformat = "text";
			}
			if ($mailformat == "text") {
				$message= "<html><head><title>Messagebody</title></head><body bgcolor=\"white\">$msgBody</body></html>";
			} else {
				$message= $msgBody; // It contains all HTML HEADER tags so we don't have to make them.
			}
			echo "<webmail><![CDATA[".$row["webmail"]."]]></webmail>";
			echo "<message><![CDATA[<br>". imap_utf8(decodeMimeStr($message))."]]></message>";
			if ( false === $dataHtml ) echo "<error>Can not read this email (".print_r(imap_errors()).")</error><number>-1</number>";
		}
		else
		{
			echo "<error>Can not open this email (".print_r(imap_errors()).")</error><number>-1</number>";
		}
	}
	if ($mail_cnx) @imap_close($mail_cnx);

	$DB->freeResults();
}
$DB->close();

$xmlfile->footer();
?>