<?php
# ************** LICENCE ****************
/*
	Copyright (c) PORTANEO.

	This file is part of COLLABORATION SUITE of POSH http://sourceforge.net/projects/posh/.

	POSH is free software: you can redistribute it and/or modify
	it under the terms of the GNU General Public License as published by
	the Free Software Foundation, either version 3 of the License, or
	(at your option) any later version

	POSH is distributed in the hope that it will be useful,
	but WITHOUT ANY WARRANTY; without even the implied warranty of
	MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
	GNU General Public License for more details.

	You should have received a copy of the GNU General Public License
	along with Posh.  If not, see <http://www.gnu.org/licenses/>.
*/
# ***************************************
# Share items with users
# !! be careful, this file must be saved under uft8 format, and display an e accentuated here : éàèù
# ***************************************
/**
*
* \brief 
* Share a widget with another user
* Share a portal with another user
* Publish a widget
* Publish a portal
*
* @param  
* (Int) secured
* (Int) prof
* (Int) uniq
* (String) obj
* (String) kw
* (String) portname
*
*  return xml file
*
*  \relatesalso
*   application.js
*  $p.friends.shareWidget 
*  $p.friends.sharePortal
*  $p.friends.publishWidget
*  $p.friends.publishPortal
*
* !! be careful, this file must be saved under uft8 format, and display an e accentuated here : é
*
**/

$folder="";
$not_access=1;
$isScript=true;
$isPortal=false;
$pagename="portal/scr_shareitem.php";
$granted="I";
//includes
require_once('includes.php');
require_once('../l10n/'.__LANG.'/lang.php');
require_once('../l10n/'.__LANG.'/enterprise.php');
require_once('../db_layer/'.__DBTYPE.'/enterprise.php');
require_once('../includes/xml.inc.php');

$file=new xmlFile();

$file->header("notification");

$secured = isset($_POST["secured"])?$_POST["secured"]:"0";
$prof = isset($_POST["prof"])?$_POST["prof"]:"";
$uniq = isset($_POST["uniq"])?$_POST["uniq"]:"";
$chk2 = false;

// if shared object is a module
if ($_POST["obj"]=="m")
{
	//add module in shared objects list
	//$DB->execute($scrsendtofriend_shareModule,$DB->quote($chk),$DB->escape($id),$DB->quote($var));
    //get shared item info -> md5
    $DB->getResults($scrsendtofriend_getSharedValue,
                    $DB->escape($_SESSION['user_id']),
					$DB->escape($prof),
					$DB->escape($uniq));
	$chk1 = $DB->nbAffected();
	$row = $DB->fetch(0);
	$shared = $row["shared"];
	$DB->freeResults();
    //if( empty($shared) ) {
    	$DB->execute($scrsendtofriend_shareModule,
    					$DB->quote($secured),
    					$DB->escape($_SESSION['user_id']),
    					$DB->escape($prof),
    					$DB->escape($uniq));
		$chk2 = $DB->nbAffected();
    /*
	} else {
        $secured = $shared;
    }
	*/
}
elseif ($_POST["obj"]=="p")
{
	//share the portal
	$DB->execute($scrsendtofriend_setPortalSharingInfo,
					$DB->quote($secured),
					$DB->escape($_SESSION['user_id']),
					$DB->escape($prof));
	$chk1 = $DB->nbAffected();
	//share the widgets of the shared portal
	$DB->execute($scrsendtofriend_setWidgetsAsShared,
					$DB->quote($secured),
					$DB->escape($_SESSION['user_id']),
					$DB->escape($prof));
	$chk2 = $DB->nbAffected();
	//save tags
	if (isset($_POST["portname"]))
	{
		if ($_POST["kw"]!=""){
			$keyword=explode(",",$_POST["kw"]);
			for ($i=0;$i<count($keyword);$i++){
				$selkw=$keyword[$i];
				$DB->getResults($scrsendtofriend_getKeyword,$DB->quote($selkw));
				if ($DB->nbResults()==0){
					$DB->execute($scrsendtofriend_addNewKeyword,$DB->quote($selkw));
					$kwid=$DB->getId();
				} else {
					$row = $DB->fetch(0);
					$kwid=$row["id"];
				}
				$DB->freeResults();

				//$DB->execute($scrsendtofriend_insertKeyword,$DB->quote($portalid),$DB->quote($kwid));
			}
		}
	}

}

$DB->close();
print("<secured>" . $secured . "</secured>");
$file->status($chk1&&$chk2);

$file->footer();
?>